/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess;

import java.util.List;

import gov.va.med.fw.batchprocess.model.JobConfig;
import gov.va.med.fw.batchprocess.model.JobResult;
import gov.va.med.fw.batchprocess.model.JobStatus;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.scheduling.ScheduledProcessTriggerEvent;
import gov.va.med.fw.service.ServiceException;

/**
 * Initial javadoc for class BatchProcessService.
 * TODO - Add content here
 * 
 * Created Sep 29, 2006 1:42:52 PM
 * @author DNS   BOHMEG
 */
public interface BatchProcessService {
	public void saveJobResult(JobResult jr) throws ServiceException;
	public JobResultData saveAndOverlayJobResult(EntityKey jobResultKey, ProcessStatistics stats, int totalDataCount) throws ServiceException;
	public JobResult getJobResult(EntityKey key) throws ServiceException;
	
	public void saveJobConfig(JobConfig jc) throws ServiceException;
	public JobConfig getJobConfig(String jobName, String jobGroup) throws ServiceException;
	
	public List getJobResults(JobStatus status) throws ServiceException;
	public List getFinishedJobResults(String jobName, String jobGroup) throws ServiceException;
	
   public void executeJob(ScheduledProcessInvocationContext invocationContext) throws ServiceException;
   public void executeJob(ScheduledProcessTriggerEvent triggerEvent) throws ServiceException;
   
   public void cancelActiveJob(EntityKey key) throws ServiceException;
   public void errActiveJob(EntityKey key) throws ServiceException;
}
