/********************************************************************
 * Copyright  2007 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.ps;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.util.AbstractServiceTestCase;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.ps.model.PersonVPID;

/**
 * Initial javadoc for class IdentityTraitComparisonTest.
 * TODO - Add content here
 * 
 * Created Mar 28, 2007 3:02:49 PM
 * @author DNS   BOHMEG
 */
public class IdentityTraitComparisonTest extends AbstractServiceTestCase {
	private PSDelegateService tableDrivenService = null;
	private int RANDOM_COUNT = 10;
	
	private VPIDEntityKey VPID_FOR_TESTING_UPDATED_TRAITS =
		CommonEntityKeyFactory.createVPIDEntityKey(PersonVPID.DEFAULT_TESTING_VPID);
	
	public void testSingleIdentityTraitComparison() throws Exception {
		List vpids = new ArrayList();
		vpids.add(VPID_FOR_TESTING_UPDATED_TRAITS);
		int failureCount = compareIdentityTraits(vpids);
		assertTrue(failureCount + " failed out of 1", failureCount == 0);
	}
	
	public void testMultipleRandomIdentityTraitComparison() throws Exception {		
		List vpids = getVPIDs(RANDOM_COUNT);
		int failureCount = compareIdentityTraits(vpids);
		assertTrue(failureCount + " failed out of " + RANDOM_COUNT, failureCount == 0);
	}
	
	private List getVPIDs(int count) throws Exception {
		List rawData = super.getDAO().executeSQLQuery("SELECT vpid_value FROM( SELECT vpid_value FROM rpt_psim_traits ORDER BY dbms_random.value ) " +
				"WHERE rownum <= " + count);
		return rawData;
	}
	
	private int compareIdentityTraits(List vpids) throws Exception {
		Iterator itr = vpids.iterator();
		VPIDEntityKey vpid = null;
		PersonIdentityTraits apiIdentityTraits = null;
		PersonIdentityTraits tableIdentityTraits = null;
		Name legalName = null;
		int failureCount = 0;
		Object obj = null;
		while(itr.hasNext()) {
			obj = itr.next();
			if(obj instanceof VPIDEntityKey) {
				vpid = (VPIDEntityKey) obj;
			} else {				
				vpid = CommonEntityKeyFactory.createVPIDEntityKey(obj.toString());
			}
			
			apiIdentityTraits = getAPIService().getIdentityTraits(vpid);
			// remove extra stuff that comes from api (that is not in RPT_PSIM_TRAITS table)
			legalName = apiIdentityTraits.getLegalName();
			apiIdentityTraits.getNames().clear();
			apiIdentityTraits.addName(legalName);
			apiIdentityTraits.setAuditInfo(null);
			apiIdentityTraits.setHasPendingUpdates(false);
			BirthRecord dob = apiIdentityTraits.getBirthRecord();
			if(dob != null) {
				dob.setCity(null);
				dob.setState(null);
				dob.setCountry(null);
			}
			
			//System.out.println("API: " + apiIdentityTraits);
			tableIdentityTraits = getTableDrivenService().getIdentityTraits(vpid);
			//System.out.println("TABLE: " + tableIdentityTraits);
			if(!apiIdentityTraits.equals(tableIdentityTraits)) {
				failureCount++;
				System.out.println("VPID " + vpid.getKeyValueAsString() + " FAIL");
			} else {
				System.out.println("VPID " + vpid.getKeyValueAsString() + " PASS");
			}
		}
		return failureCount;
	}
	
	public PSDelegateService getAPIService() throws Exception {
		return super.getPsDelegateService();
	}
	
	public PSDelegateService getTableDrivenService() throws Exception {
		if(tableDrivenService == null)
			tableDrivenService = (PSDelegateService) this.applicationContext.getBean("tableDriven.psDelegateService");
		return tableDrivenService;			
	}
}
