package gov.va.med.esr.vcg.webservice;

import gov.va.med.esr.common.io.FileUtility;
import gov.va.med.esr.vcg.webservice.generated.GetHandbookRequest;
import gov.va.med.esr.vcg.webservice.generated.GetHandbookResponse;
import gov.va.med.esr.vcg.webservice.generated.HandbookServiceImplService;
import gov.va.med.esr.vcg.webservice.generated.HandbookServicePortType;
import gov.va.med.fw.service.ServiceException;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.MTOMFeature;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.types.resources.Files;

import junit.framework.TestCase;

public class TestVCGWebService extends TestCase {
	public void testVCGWebServiceCall() throws Exception{
		//ApplicationContext appContext = new ClassPathXmlApplicationContext("classpath:client/application-context-test-client.xml");
		//EESummaryClient client = (EESummaryClient) appContext.getBean("eeSummaryClient");
		HandbookServiceImplService handbookService = new HandbookServiceImplService();
		HandbookServicePortType service = handbookService.getPort(new QName("http://ws.handbook.vbh.DNS   /", "HandbookService"), HandbookServicePortType.class);
		GetHandbookRequest request = new GetHandbookRequest();
		byte[] requestPayload = FileUtils.readFileToByteArray(new File("C:\\bea\\dev\\projects\\ESR.3.11.0\\DNS   pounct_HECMS_Dev_11_DEV_rc\\vobs\\HECMS_common\\config\\test\\data\\batchprocess\\handbook\\VBR\\0000001004872704V230453000000_HANDBOOK_V1.xml"));
		request.setXmlData(Base64.encodeBase64(requestPayload));
		GetHandbookResponse response = service.getHandbook(request);
		byte[] payloadBytes = response.getPdfData();
		assertNotNull(payloadBytes);
		byte[] decodedPayloadBytes = Base64.decodeBase64(payloadBytes);
        FileOutputStream fos = new FileOutputStream(new File("c:/temp/vcg/myhandbook2.pdf"));
        fos.write(decodedPayloadBytes);
        fos.flush();
        fos.close();
	}
	
	public void testVCGWebServiceJaxwsCall() throws Exception{
		URL url = new URL("http://DNS   bhapp80.aac.DNS   :8001/VCG-ws/HandbookService?wsdl");
        QName qname = new QName("http://ws.handbook.vbh.DNS   /", "HandbookServiceImplService");
        
        Service service = Service.create(url, qname);
        MTOMFeature mtom = new MTOMFeature();

        OutputStream os = new FileOutputStream(new File("c:/temp/vcg/myhandbook.pdf")); 

        //HandbookService proxy = service.getPort(HandbookService.class,mtom);
        DataHandler handler = null;//proxy.getHandbook("<xml></xml>");
        
        //handler.writeTo(os);
        os.flush();
        os.close();
	}
	
	public File testConvertingXmlHandBookToPDF() throws Exception {
		File file = new File("C:\\bea\\dev\\projects\\ESR.3.11.0\\DNS   pounct_HECMS_Dev_11_DEV_rc\\vobs\\HECMS_common\\config\\test\\data\\batchprocess\\handbook\\VBR\\0000001004872704V230453000000_HANDBOOK_V1.xml");
		if(file == null) throw new ServiceException("Illegal Parameter.  Expected to receive an XML file; but no file received.");
		if(!file.getName().endsWith("xml")) throw new ServiceException("Illegal Parameter.  Expected to receive an XML file.");
		try{
			HandbookServiceImplService handbookService = new HandbookServiceImplService();
			MTOMFeature mtom = new MTOMFeature();
			HandbookServicePortType  service = handbookService.getPort(new QName("http://ws.handbook.vbh.DNS   /", "HandbookService"), HandbookServicePortType.class);
			GetHandbookRequest request = new GetHandbookRequest();
			byte[] requestPayload = FileUtils.readFileToByteArray(file);
			GetHandbookResponse response = service.getHandbook(request);
			byte[] responsePayload = response.getPdfData();
			DataHandler dataHandler = null;
			FileOutputStream fos = null;
			
	        try{
	        	File pdf = new File(file.getAbsolutePath().substring(0, (file.getAbsolutePath().lastIndexOf(".")+1))+"pdf");
	        	fos = new FileOutputStream(pdf);
	        	//dataHandler.writeTo(fos);
	            return pdf;
	        } finally{
		        if(fos != null) {
		        	fos.flush();
		        	fos.close();
		        }
	        }
		} catch (Exception e){
			throw new ServiceException("PDF version of the Handbook / Benefits At a Glance could not be retrieved from Virtual Content Generator");
		}
	}
	
	/*public byte[] readFile(InputStream inputStream){
		byte[] byteArray = null;
		String inputStreamAsString = inputStream.toString();
		byteArray = inputStreamAsString.getBytes();
		return byteArray;
	}*/
	
	public byte[] readFile(String fileString){
		byte[] byteArray = null;
		byteArray = fileString.getBytes();
		return byteArray;
	}
}
