// Created May 3, 2005 9:49:44 AM

/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

/**
 * This is a comment for new java file.
 */
package gov.va.med.esr.service.trigger;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.util.AbstractCommonTestCase;

/**
 * Initial javadoc for class TriggerableServicesTest.
 * 
 * @author DNS   BOHMEG
 */
public class TriggerableServicesTest extends AbstractCommonTestCase {
	MockTriggerAware mockTriggerAware;
	MockTriggerRouter mockTriggerRouter;
	
	public void testTriggerableServices() {
		PersonTriggerEvent e1 = new PersonTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
				PersonTrigger.TargetType.VBA,
				PersonTrigger.DispatchType.QUERY,
				PersonTrigger.DataType.ELIGIBILITY);
		PersonTriggerEvent e2 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA,
				PersonTrigger.DispatchType.NOTIFY,
				PersonTrigger.DataType.ELIGIBILITY);

		mockTriggerAware.addTriggerEvent(e1);
		mockTriggerAware.addTriggerEvent(e2);
		
		try {
			mockTriggerRouter.processTriggerAware(mockTriggerAware);
		} catch(Exception e) {
			fail("Unable to execute TriggerableServices", e);
		}		
	}
	
	/** Test routing of messages to be published (Rules side of fence) */
	public void testRouteSameTriggerEvent() throws Exception {
		PersonTriggerEvent e1 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VBA,
				PersonTrigger.DispatchType.QUERY,
				PersonTrigger.DataType.ELIGIBILITY);
		e1.setPersonId(CommonEntityKeyFactory.createPersonIdEntityKey("123"));
		assertTrue(mockTriggerRouter.processTriggerEvent(e1));
		e1.setPersonId(CommonEntityKeyFactory.createPersonIdEntityKey("456"));
		assertTrue(mockTriggerRouter.processTriggerEvent(e1));		
	}	
	

	/**
	 * @return Returns the mockTriggerAware.
	 */
	public MockTriggerAware getMockTriggerAware() {
		return mockTriggerAware;
	}

	/**
	 * @param mockTriggerAware The mockTriggerAware to set.
	 */
	public void setMockTriggerAware(MockTriggerAware mockTriggerAware) {
		this.mockTriggerAware = mockTriggerAware;
	}

	/**
	 * @return Returns the mockTriggerRouter.
	 */
	public MockTriggerRouter getMockTriggerRouter() {
		return mockTriggerRouter;
	}

	/**
	 * @param mockTriggerRouter The mockTriggerRouter to set.
	 */
	public void setMockTriggerRouter(MockTriggerRouter mockTriggerRouter) {
		this.mockTriggerRouter = mockTriggerRouter;
	}
}
