// Created May 3, 2005 9:20:15 AM

/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

/**
 * This is a comment for new java file.
 */
package gov.va.med.esr.service.trigger;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.util.AbstractCommonTestCase;

/**
 * Initial javadoc for class TriggerEventTest. 
 * 
 * @author DNS   BOHMEG
 */
public class TriggerEventTest extends AbstractCommonTestCase {
	public void testCommonTriggerEvent() {
		CommonTriggerEvent e1 = new CommonTriggerEvent(
				CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VBA, CommonTrigger.DispatchType.NOTIFY);

		CommonTriggerEvent e2 = new CommonTriggerEvent(
				CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VBA, CommonTrigger.DispatchType.NOTIFY);

		assertEquals(e1.getTriggerIdentity(), e2.getTriggerIdentity());

		CommonTriggerEvent e3 = new CommonTriggerEvent(
				CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VBA, CommonTrigger.DispatchType.QUERY);

		assertTrue(!e1.getTriggerIdentity().equals(e3.getTriggerIdentity()));

		EGTSetting egt1 = new EGTSetting();
		EGTSetting egt2 = new EGTSetting();
		EGTTriggerEvent e4 = new EGTTriggerEvent(egt1);
		EGTTriggerEvent e5 = new EGTTriggerEvent(egt2);
		assertEquals(e4.getTriggerIdentity(), e5.getTriggerIdentity());

		CommonTriggerEvent e6 = new CommonTriggerEvent(
				CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY);
		assertTrue(!e6.equals(e5));
		assertTrue(!e6.getTriggerIdentity().equals(e5.getTriggerIdentity()));

	}

	public void testPersonTriggerEvent() {
		PersonTriggerEvent e1 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING, PersonTrigger.TargetType.VBA, PersonTrigger.DispatchType.NOTIFY,
				PersonTrigger.DataType.ELIGIBILITY);

		PersonTriggerEvent e2 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING, PersonTrigger.TargetType.VBA, PersonTrigger.DispatchType.NOTIFY,
				PersonTrigger.DataType.ELIGIBILITY);

		assertEquals(e1.getTriggerIdentity(), e2.getTriggerIdentity());

		PersonTriggerEvent e3 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING, PersonTrigger.TargetType.VBA, PersonTrigger.DispatchType.QUERY,
				PersonTrigger.DataType.FULL_DATA);

		assertTrue(!e1.getTriggerIdentity().equals(e3.getTriggerIdentity()));

		PersonTriggerEvent e4 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING, PersonTrigger.TargetType.VBA, PersonTrigger.DispatchType.QUERY,
				PersonTrigger.DataType.FULL_DATA);
		e4.setPersonId(new PersonIdEntityKeyImpl(new BigDecimal(123)));

		assertEquals(e3.getTriggerIdentity(), e4.getTriggerIdentity());
		assertTrue(!e3.equals(e4));

		PersonTriggerEvent e7 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY,
				PersonTrigger.DataType.ADDRESS);
		PersonTriggerIdentity d1 = (PersonTriggerIdentity) e7.getTriggerIdentity();
		d1.setName("junk");  // should have no bearing on equals implementation
		PersonTriggerEvent e8 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY,
				PersonTrigger.DataType.ADDRESS);
		PersonTriggerIdentity d2 = (PersonTriggerIdentity) e8.getTriggerIdentity();
		d2.setName("blah");  // should have no bearing on equals implementation
		assertEquals(e7, e8);
		assertEquals(d1, d2);

	}

	public void testHashCode() {
		Map map = new HashMap();
		PersonTriggerEvent e1 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING, PersonTrigger.TargetType.VBA, PersonTrigger.DispatchType.NOTIFY,
				PersonTrigger.DataType.ELIGIBILITY);
		map.put(e1.getTriggerIdentity(), null);
		PersonTriggerEvent e2 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING, PersonTrigger.TargetType.VBA, PersonTrigger.DispatchType.NOTIFY,
				PersonTrigger.DataType.ELIGIBILITY);
		e2.setPersonId(new PersonIdEntityKeyImpl(new BigDecimal(123)));

		assertTrue(map.containsKey(e2.getTriggerIdentity()));
		assertFalse(map.containsKey(e2));

		PersonTriggerEvent e3 = new PersonTriggerEvent(
				PersonTrigger.DestinationType.MESSAGING, PersonTrigger.TargetType.VISTA, PersonTrigger.DispatchType.NOTIFY,
				PersonTrigger.DataType.ELIGIBILITY);
		assertFalse(map.containsKey(e3.getTriggerIdentity()));

		CommonTriggerIdentity d1 = (CommonTriggerIdentity) e3.getTriggerIdentity();
		d1.setName("cccc"); // should have no bearing on hashCode implementation
		map.put(d1, null);		
		PersonTriggerIdentity d2 = new PersonTriggerIdentity(
				PersonTrigger.DestinationType.MESSAGING, PersonTrigger.TargetType.VISTA, PersonTrigger.DispatchType.NOTIFY,
				PersonTrigger.DataType.ELIGIBILITY);
		assertTrue(map.containsKey(d2));
		
	}

}
