package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroupInstantiable;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroupInstantiable;
import gov.va.med.esr.service.LookupService;
import junit.framework.TestCase;

//import org.easymock.MockControl;

/**
 * @see gov.va.med.esr.service.impl.PersonHelperServiceImpl
 * 
 */
public class PersonHelperServiceImplTest extends TestCase {

    /**
     * 
     * @see gov.va.med.esr.service.impl.PersonHelperService#setInitialEnrollmentPriority(java.lang.String,
     *      gov.va.med.esr.common.model.ee.EnrollmentDetermination)
     */
    public void testSetInitialEnrollmentPriority() throws Exception {

        // verify exception when code is null
        PersonHelperServiceImpl personHelperServiceImpl = new PersonHelperServiceImpl();
        EnrollmentDetermination enrollmentDetermination = new EnrollmentDetermination();
        try {
            personHelperServiceImpl.setInitialEnrollmentPriority(null,
                    enrollmentDetermination);
            fail();
        } catch (IllegalArgumentException e) {

        }

        // verify exception when enrollment determination is null
        String code = "foo";
        try {
            personHelperServiceImpl.setInitialEnrollmentPriority(code, null);
            fail();
        } catch (IllegalArgumentException e) {

        }

//        // verify enrollment determination is set
//        enrollmentDetermination = new EnrollmentDetermination();
//        MockControl lookUpServiceMockControl = MockControl
//                .createStrictControl(LookupService.class);
//        LookupService lookupService = (LookupService) lookUpServiceMockControl
//                .getMock();
//        personHelperServiceImpl = new PersonHelperServiceImpl();
//        personHelperServiceImpl.setLookupService(lookupService);
//        lookupService.getEnrollmentPriorityGroupByCode(code);
//        EnrollmentDetermination enrollmentDeterminationExpected = new EnrollmentDetermination();
//        EnrollmentPriorityGroupInstantiable enrollmentPriorityGroup = new EnrollmentPriorityGroupInstantiable();
//        enrollmentDeterminationExpected
//                .setInitialPriorityGroup(enrollmentPriorityGroup);
//        lookUpServiceMockControl.setReturnValue(enrollmentPriorityGroup);
//        lookUpServiceMockControl.replay();
//        enrollmentDeterminationExpected
//                .setInitialPriorityGroup(enrollmentPriorityGroup);
//        personHelperServiceImpl.setInitialEnrollmentPriority(code,
//                enrollmentDetermination);
//        assertEquals(enrollmentDeterminationExpected.getInitialPriorityGroup(),
//                enrollmentDetermination.getInitialPriorityGroup());
//        lookUpServiceMockControl.verify();

    }

    /**
     * 
     * @see gov.va.med.esr.service.impl.PersonHelperService#setInitialEnrollmentPrioritySubGroup(java.lang.String,
     *      gov.va.med.esr.common.model.ee.EnrollmentDetermination)
     */
    public void testSetInitialEnrollmentPrioritySubGroup() throws Exception {

        // verify exception when code is null
        PersonHelperServiceImpl personHelperServiceImpl = new PersonHelperServiceImpl();
        EnrollmentDetermination enrollmentDetermination = new EnrollmentDetermination();
        try {
            personHelperServiceImpl.setInitialEnrollmentPrioritySubGroup(null,
                    enrollmentDetermination);
            fail();
        } catch (IllegalArgumentException e) {

        }

        // verify exception when enrollment determination is null
        String code = "foo";
        try {
            personHelperServiceImpl.setInitialEnrollmentPrioritySubGroup(code,
                    null);
            fail();
        } catch (IllegalArgumentException e) {

        }

        // verify enrollment determination is set
//        enrollmentDetermination = new EnrollmentDetermination();
//        MockControl lookUpServiceMockControl = MockControl
//                .createStrictControl(LookupService.class);
//        LookupService lookupService = (LookupService) lookUpServiceMockControl
//                .getMock();
//        personHelperServiceImpl = new PersonHelperServiceImpl();
//        personHelperServiceImpl.setLookupService(lookupService);
//        lookupService.getEnrollmentPrioritySubGroupByCode(code);
//        EnrollmentDetermination enrollmentDeterminationExpected = new EnrollmentDetermination();
//        EnrollmentPrioritySubGroupInstantiable enrollmentPrioritySubGroup = new EnrollmentPrioritySubGroupInstantiable();
//        enrollmentDeterminationExpected
//                .setInitialPrioritySubGroup(enrollmentPrioritySubGroup);
//        lookUpServiceMockControl.setReturnValue(enrollmentPrioritySubGroup);
//        lookUpServiceMockControl.replay();
//        enrollmentDeterminationExpected
//                .setInitialPrioritySubGroup(enrollmentPrioritySubGroup);
//        personHelperServiceImpl.setInitialEnrollmentPrioritySubGroup(code,
//                enrollmentDetermination);
//        assertEquals(enrollmentDeterminationExpected
//                .getInitialPrioritySubGroup(), enrollmentDetermination
//                .getInitialPrioritySubGroup());
//        lookUpServiceMockControl.verify();

    }
}
