/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service.impl;

import gov.va.med.esr.service.MockService1;
import gov.va.med.esr.service.MockService2;

/**
 * Initial javadoc for class MockService1Impl.
 * TODO - Add content here
 * 
 * Created Nov 2, 2005 1:30:41 PM
 * @author DNS   BOHMEG
 */
public class MockService1Impl extends AbstractMockService implements MockService1 {
	private MockService2 mockService2;
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -8889434010782323024L;

	/* (non-Javadoc)
	 * @see gov.va.med.esr.service.MockService1#processMock()
	 */
	public void processMock() {
		System.out.println("in MockService1Impl.processMock");
		createTriggerEvents("event1_from_MockService1", "event2_from_MockService1");
		
		checkRollback();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.service.MockService1#getMock()
	 */
	public void getMock() {
		System.out.println("in MockService1Impl.getMock");
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.service.MockService1#processNestedMock()
	 */
	public void processNestedMock() {
		System.out.println("in MockService1Impl.processNestedMock");
		createTriggerEvent("event1_from_MockService1_before_suspend");
		try {
			Thread.sleep(5000);
			mockService2.nestedMock(); // should start new TX
		} catch(Exception e) {
			System.out.println("problem calling mockService2...don't let affect suspended TX");
		}
		processMock();
		
		checkRollback();
	}
	
	/**
	 * @return Returns the mockService2.
	 */
	public MockService2 getMockService2() {
		return mockService2;
	}

	/**
	 * @param mockService2 The mockService2 to set.
	 */
	public void setMockService2(MockService2 mockService2) {
		this.mockService2 = mockService2;
	}
}
