// Package 
package gov.va.med.esr.service.impl;

// Java Classes
import java.util.Map;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;

// Framework Classes
import gov.va.med.fw.service.ServiceException;

// ESR Classes
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.infra.ImpreciseDate;

/**
 * This mock service alllows "fake" VPID data to be used in common Person
 * testing. <p/> Created Sep 20, 2005 4:11:27 PM
 * 
 * @author DNS   BOHMEG
 * @author Andrew Pach
 */
public class MockPSDelegateServiceImpl extends PSDelegateServiceImpl {
	
	/**
	 * MockPSDelegateServiceImpl.java long
	 */
	private static final long serialVersionUID = -2489848096148783732L;

	// private static final String VPID_KEY = "0000002000000008V562565000000"; 
    private static final String VPID = "0000002000000008V562565000000";

	public PersonIdentityTraits getIdentityTraits(VPIDEntityKey key)
			throws ServiceException {
		if (key == null)
			return null;

		// always return same set of identity traits
		return createPersonTraits(key);
	}

	public PersonIdentityTraits getIdentityTraits(String dfn,
			String stationNumber) throws ServiceException {
		if (dfn == null || stationNumber == null)
			return null;
        VPIDEntityKey VPIDEntityKey = CommonEntityKeyFactory.createVPIDEntityKey(VPID);
		// always return same set of identity traits
		return createPersonTraits(VPIDEntityKey);
	}

	public Map getIdentityTraits(Collection vpidEntityKeys)
			throws ServiceException {
		Map identityTraits = new HashMap();

		for (Iterator iter = vpidEntityKeys.iterator(); iter.hasNext();) {
			VPIDEntityKey vpidKey = (VPIDEntityKey) iter.next();
			identityTraits
					.put(vpidKey.getKeyValueAsString(), createPersonTraits(vpidKey));
		}

		return identityTraits;
	}

	/**
	 * @see gov.va.med.esr.service.PSDelegateService#getVPID(java.lang.String,
	 *      java.lang.String)
	 */
	public VPIDEntityKey getVPID(String dfn, String stationNumber)
			throws ServiceException {
		if (logger.isInfoEnabled())
			logger.info("Mock PSIM returned: " + VPID);

		return (CommonEntityKeyFactory.createVPIDEntityKey(VPID));
	}

	/**
	 * @see gov.va.med.esr.service.PSDelegateService#getVPID(java.lang.String,
	 *      java.lang.String)
	 */
	public Set getSites(VPIDEntityKey key) throws ServiceException {
		SiteIdentity siteIdentity = new SiteIdentity();
		siteIdentity.setDfn("12345");
		VAFacility facility = getLookupService().getVaFacilityByStationNumber(
				VAFacility.CODE_ALBUQUERQUE.getName());
		siteIdentity.setVaFacility(facility);

		Set sites = new HashSet();
		sites.add(siteIdentity);

		return sites;
	}

	/**
	 * @see gov.va.med.esr.service.PSDelegateService#attendedSearch
	 */
	public Set attendedSearch(PersonIdentityTraits criteria)
			throws ServiceException {
		Set results = new HashSet();

		PersonIdentityTraits personTraits = createPersonTraits(criteria.getVpid());
		results.add(personTraits);

		return results;
	}

	/**
	 * @see gov.va.med.esr.service.impl.PSDelegateServiceImpl#unattendedSearch(gov.va.med.esr.service.PersonIdentityTraits)
	 */
	public Set unattendedSearch(PersonIdentityTraits traits)
			throws ServiceException {
		return attendedSearch(traits);
	}

	/**
	 * Gets history of updates to identity traits
	 */
	public List getIdentityTraitsUpdateHistory(VPIDEntityKey key)
			throws ServiceException {
		List historyList = new ArrayList();
		PersonIdentityTraits personTraits = createPersonTraits(key);
		historyList.add(personTraits);
		return historyList;
	}

	/**
	 * Creates a fake set of person traits
	 * 
	 * @return the person traits
	 * @throws gov.va.med.esr.service.UnknownLookupTypeException
	 * @throws gov.va.med.esr.service.UnknownLookupCodeException
	 */
	private PersonIdentityTraits createPersonTraits(VPIDEntityKey key)
			throws UnknownLookupTypeException, UnknownLookupCodeException {
		PersonIdentityTraits traits = new PersonIdentityTraits();

//		VPIDEntityKey VPIDEntityKey = CommonEntityKeyFactory
//				.createVPIDEntityKey(VPID_KEY);
		traits.setVpid(key);

		Name legalName = new Name();
		legalName.setFamilyName("REINHOLD");
		legalName.setGivenName("CHAZZ");
		legalName.setPrefix("Mr.");
		legalName.setType(getLookupService().getNameTypeByCode(
				NameType.LEGAL_NAME.getName()));
		traits.addName(legalName);
		Name aliasName = new Name();
		aliasName.setFamilyName("CRASHER");
		aliasName.setGivenName("WEDDING");
		aliasName.setType(getLookupService().getNameTypeByCode(
				NameType.ALIAS_NAME.getName()));
		traits.addName(aliasName);

		SSN ssn = new SSN();
		ssn.setType(getLookupService().getSSNTypeByCode(
				SSNType.CODE_ACTIVE.getName()));
		ssn.setSsnText("123456789");
		ssn.setSsaVerificationStatus(this.getLookupService()
				.getSSAVerificationStatusByCode(
						SSAVerificationStatus.VERIFIED.getName()));
		traits.setSsn(ssn);

		traits.setGender(getLookupService()
				.getGenderByCode(Gender.MALE.getName()));
		BirthRecord birth = new BirthRecord();
		birth.setCity("Wilmington");
		birth.setState("NC");
		birth.setCountry("USA");
		birth.setBirthDate(new ImpreciseDate("190607"));
		traits.setBirthRecord(birth);
		return traits;
	}

	public void notifyOfPersonChange(VPIDEntityKey key) throws ServiceException {
	}

	public void requestIdentityTraitsUpdate(PersonIdentityTraits updatedTraits)
			throws ServiceException {
	}

	public void notifyPsdOfDemographicChange(VPIDEntityKey key) {
	}
	@Override
	public PersonIdentityTraits getIdentityTraitsWithCompositeCall(VPIDEntityKey key) throws ServiceException 
	{

		return this.createPersonTraits(key);
	}

	@Override
	public PersonIdentityTraits extractIdentityTraits(Person person) {
		PersonIdentityTraits traits = null;
		try {
			traits = createPersonTraits(person.getVPIDEntityKey());
		}
		catch (UnknownLookupTypeException u) {

		}
		catch (UnknownLookupCodeException c) {

		}
		return traits;
	}	
}
