/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service.impl;

// Java classes
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

// Library classes

// Framework classes
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.AbstractComponent;

// EDB classes
import gov.va.med.esr.common.model.ee.EGTProcessStatistic;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.persistent.ee.EGTSettingDAO;
import gov.va.med.esr.service.EGTService;
import gov.va.med.esr.service.LookupService;


/**
 * Mock EGT Service to provide a consistent 8C threshold otherwise
 * tests will fail. It takes a database change request for value in
 * table to be changed.
 * 
 * Project: Common
 * @author Carlos Ruiz
 * @version 1.0
 */
public class MockEGTServiceImpl extends AbstractComponent implements EGTService {

	/**
	 * An instance of personDAO
	 */
	private EGTSettingDAO egtDAO = null;
    
    private EGTSetting egtSetting = null;
    
    private LookupService lookupService = null;

   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8932467141395519860L;
	/**
    * 
    */
   public MockEGTServiceImpl() {
      super();
   }
   /**
    * @see gov.va.med.esr.service.EGTService#getEGTSetting(gov.va.med.fw.model.EntityKey)
    */
   public EGTSetting getEGTSetting( EntityKey key ) throws ServiceException
   {
	   return null;
   }

   /**
    * 
    */
   public EGTSetting getActiveEGTSetting() throws ServiceException {

		try {
            // This is for TEST purposes ONLY - don't use for anything else.
            if (egtSetting == null) {
                egtSetting = (EGTSetting) egtDAO.getActive();                
            }
			
            egtSetting.setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getName()));
            egtSetting.setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_C.getName()));
		} catch (DAOException ex) {
			throw new ServiceException("Failed to getActiveEGTSetting by date", ex);
		}
		
		return egtSetting;
   }
   
   
   public void scheduleEGTSetting(EGTSetting egt) throws ServiceException {
      // FIXME Auto-generated method stub
   }
   
   
	/**
	 * @see gov.va.med.esr.service.EGTService#saveAsCurrentEGTSetting(gov.va.med.esr.common.model.ee.EGTSetting)
	 */
	public EGTSetting saveAsCurrentEGTSetting(EGTSetting egt) throws ServiceException {
		return null;
	}

	/**
	 * @see gov.va.med.esr.service.EGTService#saveEGTProcessStatistics(gov.va.med.esr.common.model.ee.EGTProcessStatistic)
	 */
	public void saveEGTProcessStatistics(EGTProcessStatistic processStatistic) throws ServiceException {
	}
	
	/**
	 * @return Returns the egtDAO.
	 */
	public EGTSettingDAO getEgtDAO() {
		return egtDAO;
	}

	/**
	 * @param egtDAO
	 *            The egtDAO to set.
	 */
	public void setEgtDAO(EGTSettingDAO egtDAO) {
		this.egtDAO = egtDAO;
	}
    /**
     * @return Returns the lookupService.
     */
    public LookupService getLookupService() {
        return lookupService;
    }
    /**
     * @param lookupService The lookupService to set.
     */
    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
	public EGTSetting getCurrentEGTSetting() throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}
	public Set getFutureEGTSettings() throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}
	public EGTSetting updateEGTSetting(EGTSetting egt) throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}
	public Set getEGTSettingHistoryChangeTimes() throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}
	public HistoricalInfo getEGTSettingHistoryByChangeTime(ChangeEvent changeEvent) throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}
    /* (non-Javadoc)
     * @see gov.va.med.esr.service.EGTService#stopEGTProcessing()
     */
    public EGTSetting stopEGTProcessing() throws ServiceException {
        // TODO Auto-generated method stub
        return null;
    }
	/**
	 * @see gov.va.med.esr.service.EGTService#updateEnrollmentWithNewEGTSetting(java.util.List, gov.va.med.esr.common.model.ee.EGTSetting, java.util.Map)
	 */
	public void updateEnrollmentWithNewEGTSetting(List veteranIds, EGTSetting newSetting, Map siteStats) throws ServiceException {
	}
	/* (non-Javadoc)
	 * @see gov.va.med.esr.service.EGTService#getActiveEGTSetting(java.util.Date)
	 */
	public EGTSetting getActiveEGTSetting(Date asOf) throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}
}
