/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service.impl;

import java.util.HashSet;
import java.util.Set;

import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.service.AbstractComponent;

import gov.va.med.esr.service.trigger.CommonTriggerEvent;

/**
 * Initial javadoc for class AbstractMockService.
 * TODO - Add content here
 * 
 * Created Nov 3, 2005 10:12:37 AM
 * @author DNS   BOHMEG
 */
public class AbstractMockService extends AbstractComponent {
	private TriggerEventCacheManager cacheManager;
	private boolean shouldRollback = false;
	
	protected void createTriggerEvent(String name) {
		Set triggerEvents = new HashSet();
		CommonTriggerEvent e = new CommonTriggerEvent(name);
		triggerEvents.add(e);
		cacheManager.storeTriggerEvents(triggerEvents);		
	}

	protected void createTriggerEvents(String name1, String name2) {
		Set triggerEvents = new HashSet();
		CommonTriggerEvent e = new CommonTriggerEvent(name1);
		triggerEvents.add(e);
		e = new CommonTriggerEvent(name2);
		triggerEvents.add(e);		
		cacheManager.storeTriggerEvents(triggerEvents);		
	}
	
	
	protected void checkRollback() {
		if(shouldRollback)
			throw new RuntimeException("Forced rollback due to configuration");
	}
	
	/**
	 * @return Returns the shouldRollback.
	 */
	public boolean isShouldRollback() {
		return shouldRollback;
	}
	/**
	 * @param shouldRollback The shouldRollback to set.
	 */
	public void setShouldRollback(boolean shouldRollback) {
		this.shouldRollback = shouldRollback;
	}

	/**
	 * @return Returns the cacheManager.
	 */
	public TriggerEventCacheManager getCacheManager() {
		return cacheManager;
	}

	/**
	 * @param cacheManager The cacheManager to set.
	 */
	public void setCacheManager(TriggerEventCacheManager cacheManager) {
		this.cacheManager = cacheManager;
	}


}
