package gov.va.med.esr.service;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.ApplicationStatus;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.DiagnosticExtremity;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EthnicityType;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.RaceType;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * This test class contains CCR 11781 specific tests. 
 * See the ManageFinancialTest.java for more Vfa / CCR 11782 tests.
 * 
 * @author DNS   ruizc
 *
 */
public class VfaSupportTest extends RuleAbstractTestCase {

	public VfaSupportTest(String arg0) {
		super(arg0);
	}
	private void attachIncomeTest(Person person, Integer incomeYear,
			VAFacility facAO, MeansTestStatus.Code status) throws Exception {
		attachIncomeTest(this.getDate(incomeYear.intValue(), 3, 1), person,
				incomeYear, facAO, status);
	}
	private void attachIncomeTest(Date effective, Person person,
			Integer incomeYear, VAFacility facAO, MeansTestStatus.Code status)
			throws Exception {
		person.setIncomeTest(incomeYear, this.createIncomeTest(
				IncomeTestType.CODE_MEANS_TEST, status, incomeYear));
		person.setFinancialStatement(incomeYear,
				this.createFinancialStatement());
		person.getIncomeTest(incomeYear).setCompletedDate(
				this.getDate(incomeYear.intValue(), 11, 1));
		person.getIncomeTest(incomeYear).setEffectiveDate(effective);
		person.getIncomeTest(incomeYear).setLastEditedDate(effective);
		person.getIncomeTest(incomeYear).setSiteConductingTest(facAO);
		person.getIncomeTest(incomeYear).setSource(
				this.getLookupService().getIncomeTestSourceByCode(
						IncomeTestSource.CODE_VAMC.getCode()));
	}	
	public void testEffectiveImmediately() throws Exception {
		Integer incomeYear2011 = new Integer(2011);
		Integer incomeYear2010 = new Integer(2010);

		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		VAFacility fac = this.getLookupService().getVaFacilityByCode("657");
		VAFacility facAO = this.getLookupService().getVaFacilityByCode("552");
		this.attachIncomeTest(onFile, incomeYear2010, fac,
				MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT);
		attachIncomeTest(onFile, incomeYear2011, fac,
				MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED);
		onFile.getIncomeTest(incomeYear2010).setEffectiveDate(
				getDate(2011, 11, 23));
		onFile.getIncomeTest(incomeYear2010).setLastEditedDate(
				getDate(2011, 6, 23));
		onFile.getIncomeTest(incomeYear2011).setEffectiveDate(
				getDate(2012, 11, 23));
		onFile.getIncomeTest(incomeYear2011).setLastEditedDate(
				getDate(2011, 1, 25));
		onFile.getIncomeTest(incomeYear2011).setFutureTest(Boolean.TRUE);
		onFile.setFinancialStatement(incomeYear2010,
				this.createFinancialStatement());
		onFile.setFinancialStatement(incomeYear2011,
				this.createFinancialStatement());
		IncomeTest clonedTest = new IncomeTest();
		this.getMergeRuleService().mergeIncomeTest(
				onFile.getIncomeTest(incomeYear2010), clonedTest);
		IncomeTest pre = this.getPersonHelperService().getCurrentIncomeTest(onFile);
		System.out.println("ONFILE current income test future="+pre.getFutureTest() );
		System.out.println("ONFILE current income test year ="+pre.getIncomeYear() );

		Person incoming = savePerson(onFile);

		incoming.removeAllIncomeTests();
		incoming.setIncomeTest(incomeYear2010, clonedTest);

		// MODIFY 2007 to make INCOMING IVM CONVERTED TEST
		incoming.getIncomeTest(incomeYear2010).setMeansTestStatus(
				this.getLookupService().getMeansTestStatusByCode(
						MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));
		incoming.getIncomeTest(incomeYear2010).setCompletedDate(this.getDate(2012, 5, 1));
		incoming.getIncomeTest(incomeYear2010).setEffectiveDate(getDate(2012, 5, 1));
		incoming.getIncomeTest(incomeYear2010).setSiteConductingTest(facAO);
		incoming.getIncomeTest(incomeYear2010).setLastEditedDate(new Date());
		incoming.getIncomeTest(incomeYear2010).setSource(
				this.getLookupService().getIncomeTestSourceByCode(
						IncomeTestSource.CODE_IVM.getCode()));

		VerificationInfo info = new VerificationInfo("x", MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		info.setSiteNumber(fac.getCode());

		Person updated = this.getMessagingService().processZ07(incoming, fac, info);

		
		assertNotNull(updated.getIncomeTest(incomeYear2010));
		assertTrue(IncomeTestSource.CODE_IVM.getCode().equals(updated.getIncomeTest(incomeYear2010).getSource().getCode()));
		
		IncomeTest result = this.getPersonHelperService().getCurrentIncomeTest(updated);
		System.out.println("POST current income test future="+result.getFutureTest() );
		System.out.println("POST current income test year ="+result.getIncomeYear() );

		assertTrue(incomeYear2011.equals(result.getIncomeYear()));
		assertFalse(result.getFutureTest().booleanValue());
	}
	public void testZ07EffectiveImmediatelyNoExistingTestNewTest() throws Exception {
		VAFacility fac = this.getLookupService().getVaFacilityByCode("657");		
		
		Integer incomeYear2011 = new Integer(2011);
		Person onFile = this.buildSimplePerson();		
		this.attachVerifiedEnrollment(onFile);

		this.setEligibilityStatusToVerified(onFile);
		Person incoming = savePerson(onFile);

		attachIncomeTest(incoming, incomeYear2011, fac,
				MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED);
		incoming.getIncomeTest(incomeYear2011).setEffectiveDate(
				getDate(2012, 5, 23));
		incoming.getIncomeTest(incomeYear2011).setLastEditedDate(
				getDate(2011, 1, 25));
		incoming.setFinancialStatement(incomeYear2011,
				this.createFinancialStatement());

		VerificationInfo info = new VerificationInfo("x", MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		info.setSiteNumber(fac.getCode());
		Person updated = this.getMessagingService().processZ07(incoming, fac, info);
		System.out.println("enrollment="+updated.getEnrollmentDetermination());
		IncomeTest result = this.getPersonHelperService().getCurrentIncomeTest(updated);
		System.out.println(" ");
		System.out.println(" ");
		System.out.println("income test future="+result.getFutureTest() );
		System.out.println("income test year ="+result.getIncomeYear() );

		assertTrue("should be 2011",incomeYear2011.equals(result.getIncomeYear()));
		assertFalse("should not be future",result.getFutureTest().booleanValue());

	}
	public void testUIEffectiveImmediatelyNoExistingTestNewTest() throws Exception {
		VAFacility fac = this.getLookupService().getVaFacilityByCode("657");		
		Date completed = this.getDate(2012, 2, 2);		
		Integer incomeYear2011 = new Integer(2011);
		Person onFile = this.buildSimplePerson();		
		this.attachVerifiedEnrollment(onFile);
		this.addPermanentAddress(onFile, Calendar.getInstance().getTime(),null);
		this.setEligibilityStatusToVerified(onFile);
		Person incoming = savePerson(onFile);
		attachIncomeTest(incoming, incomeYear2011, fac,
				MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED);
		incoming.getIncomeTest(incomeYear2011).setEffectiveDate(
				getDate(2012, 5, 23));
		incoming.getIncomeTest(incomeYear2011).setLastEditedDate(
				getDate(2011, 1, 25));
		incoming.getIncomeTest(incomeYear2011).setCompletedDate(completed);
		System.out.println("completed date ="+incoming.getIncomeTest(incomeYear2011).getCompletedDate().toString() );		
		incoming.setFinancialStatement(incomeYear2011,this.createFinancialStatement());
		FinancialStatement fs = incoming.getFinancialStatement(incomeYear2011);
		fs.setDebt(null);
		Person updated = this.getFinancialsService().updateFinancialAssessment( incomeYear2011, incoming); 
		IncomeTest result = this.getPersonHelperService().getCurrentIncomeTest(updated);
		System.out.println("RESULT income test future="+result.getFutureTest() );
		System.out.println("RESULT income test year ="+result.getIncomeYear() );
		System.out.println("RESULT completed date ="+result.getCompletedDate().toString() );
		assertTrue("should be 2011",incomeYear2011.equals(result.getIncomeYear()));
		assertFalse("complete date should not remain same",completed.equals(result.getCompletedDate()));
	}
	
	//IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST
	public void testUIEffectiveImmediatelyRxTestWithExistingTest() throws Exception {
		VAFacility fac = this.getLookupService().getVaFacilityByCode("657");		
		Integer incomeYear2011 = new Integer(2011);
		Integer incomeYear2010 = new Integer(2010);
		
		Person onFile = this.buildSimplePerson();		
		this.attachVerifiedEnrollment(onFile);
		this.addPermanentAddress(onFile, Calendar.getInstance().getTime(),null);
		this.setEligibilityStatusToVerified(onFile);
		attachIncomeTest(onFile, incomeYear2010, fac,
				MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED);
		onFile.getIncomeTest(incomeYear2010).setEffectiveDate(getDate(2012, 6, 23));
		onFile.getIncomeTest(incomeYear2010).setLastEditedDate(getDate(2011, 1, 25));
		onFile.setFinancialStatement(incomeYear2010,
				this.createFinancialStatement());
		this.attachVerifiedEnrollment(onFile);
		IncomeTest current = this.getPersonHelperService().getCurrentIncomeTest(onFile);
		System.out.println("current income test type="+current.getType().getDescription() );		
		System.out.println("current income test type code="+current.getType().getCode() );
		System.out.println("income test year ="+current.getIncomeYear() );		
		Person incoming = savePerson(onFile);

		incoming.removeAllIncomeTests();
		IncomeTest incomeTest = this.createIncomeTest(
				IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST,
				MeansTestStatus.MT_STATUS_EXEMPT, incomeYear2011);
		incoming.setIncomeTest(incomeYear2011, incomeTest);
		incoming.getIncomeTest(incomeYear2011).setSiteConductingTest(fac);
		
		IncomeTest  incomingTest = this.getPersonHelperService().getCurrentIncomeTest(incoming);
		System.out.println("incoming income test type="+incomingTest.getType().getDescription() );		
		System.out.println("incoming income test type code="+incomingTest.getType().getCode() );
		System.out.println("incomingtest year ="+incomingTest.getIncomeYear() );		
		incomingTest.setEffectiveDate(getDate(2012, 5, 23));

		incoming.setFinancialStatement(incomeYear2011, this.createFinancialStatement());

		FinancialStatement fs = incoming.getFinancialStatement(incomeYear2011);
		fs.setDebt(null);

		Person updated = this.getFinancialsService().updateFinancialAssessment( incomeYear2011, incoming); 

		System.out.println("enrollment="+updated.getEnrollmentDetermination());
		IncomeTest result = this.getPersonHelperService().getCurrentIncomeTest(updated);
		System.out.println(" ");
		System.out.println(" ");
		System.out.println("income test type="+result.getType().getDescription() );		
		System.out.println("income test type code="+result.getType().getCode() );		
		System.out.println("income test future="+result.getFutureTest() );
		System.out.println("income test year ="+result.getIncomeYear() );

		assertTrue("should be 2011",incomeYear2011.equals(result.getIncomeYear()));
		assertFalse("should not be future",result.getFutureTest().booleanValue());

	}
	public void testZ07EffectiveImmedExistAndNewMTCOPAYREQ() throws Exception {
		VAFacility fac = this.getLookupService().getVaFacilityByCode("657");		
		Integer incomeYear2010 = new Integer(2010);		
		Integer incomeYear2011 = new Integer(2011);
		Person onFile = this.buildSimplePerson();		
		attachIncomeTest(onFile, incomeYear2010, fac,
				MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT);
		onFile.getIncomeTest(incomeYear2010).setEffectiveDate(
				getDate(2012, 1, 23));
		onFile.getIncomeTest(incomeYear2010).setLastEditedDate(
				getDate(2011, 1, 25));
		onFile.setFinancialStatement(incomeYear2010,
				this.createFinancialStatement());
		this.attachVerifiedEnrollment(onFile);

		this.setEligibilityStatusToVerified(onFile);
		Person incoming = savePerson(onFile);
		incoming.removeAllIncomeTests();
		attachIncomeTest(incoming, incomeYear2011, fac,
				MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED);
		incoming.getIncomeTest(incomeYear2011).setEffectiveDate(
				getDate(2012, 5, 23));
		incoming.getIncomeTest(incomeYear2011).setLastEditedDate(
				getDate(2011, 1, 25));
		incoming.setFinancialStatement(incomeYear2011,
				this.createFinancialStatement());

		VerificationInfo info = new VerificationInfo("x", MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		info.setSiteNumber(fac.getCode());
		Person updated = this.getMessagingService().processZ07(incoming, fac, info);
		IncomeTest result = this.getPersonHelperService().getCurrentIncomeTest(updated);
		System.out.println("POST income test future="+result.getFutureTest() );
		System.out.println("POST income test year="+result.getIncomeYear() );
		System.out.println("POST income test status="+result.getIncomeTestStatus().getStatus().getDescription() );
		assertTrue("should be 2011",incomeYear2011.equals(result.getIncomeYear()));
		assertFalse("should not be future",result.getFutureTest().booleanValue());
	}
	public void testZ07EffectiveImmediatelyExistingWithNewTest() throws Exception {
		VAFacility fac = this.getLookupService().getVaFacilityByCode("657");		
		Integer incomeYear2010 = new Integer(2010);		
		Integer incomeYear2011 = new Integer(2011);
		Person onFile = this.buildSimplePerson();		
		attachIncomeTest(onFile, incomeYear2010, fac,
				MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED);
		onFile.getIncomeTest(incomeYear2010).setEffectiveDate(
				getDate(2012, 6, 23));
		onFile.getIncomeTest(incomeYear2010).setLastEditedDate(
				getDate(2011, 1, 25));
		onFile.setFinancialStatement(incomeYear2010,
				this.createFinancialStatement());
		this.attachVerifiedEnrollment(onFile);

		this.setEligibilityStatusToVerified(onFile);
		Person incoming = savePerson(onFile);
		incoming.removeAllIncomeTests();
		attachIncomeTest(incoming, incomeYear2011, fac,
				MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED);
		incoming.getIncomeTest(incomeYear2011).setEffectiveDate(
				getDate(2012, 5, 23));
		incoming.getIncomeTest(incomeYear2011).setLastEditedDate(
				getDate(2011, 1, 25));
		incoming.setFinancialStatement(incomeYear2011,
				this.createFinancialStatement());

		VerificationInfo info = new VerificationInfo("x", MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		info.setSiteNumber(fac.getCode());
		Person updated = this.getMessagingService().processZ07(incoming, fac, info);
		System.out.println("enrollment="+updated.getEnrollmentDetermination());
		
		IncomeTest result = this.getPersonHelperService().getCurrentIncomeTest(updated);
		System.out.println(" ");
		System.out.println(" ");
		System.out.println("income test future="+result.getFutureTest() );
		System.out.println("income test year ="+result.getIncomeYear() );

		assertTrue("should be 2011",incomeYear2011.equals(result.getIncomeYear()));
		assertFalse("should not be future",result.getFutureTest().booleanValue());
		/*
(+) activate rule : determineRxCopayTestType
(-) deactivate rule : determineRxCopayTestType
(+) activate rule : isVoaGMTErrorStoreInProgressData
(+) add rule instance : isVoaGMTErrorStoreInProgressData@1a8a7a 
(->) fire rule instance : isVoaGMTErrorStoreInProgressData@1a8a7a
(-) deactivate rule : isVoaGMTErrorStoreInProgressData
(+) activate rule : isDeleteIncomeTestRequest
(+) add rule instance : isDeleteIncomeTestRequest@7981e7   
(->) fire rule instance : isDeleteIncomeTestRequest@7981e7
(-) deactivate rule : isDeleteIncomeTestRequest
(+) activate rule : checkDuplicateIncomeTestCond
(+) add rule instance : checkDuplicateIncomeTestCond@13f83b5
(->) fire rule instance : checkDuplicateIncomeTestCond@13f83b5
(-) deactivate rule : checkDuplicateIncomeTestCond
(+) activate rule : isNonIVMOrVAMC
(+) add rule instance : isNonIVMOrVAMC@e007b2  
(->) fire rule instance : isNonIVMOrVAMC@e007b2
(-) deactivate rule : isNonIVMOrVAMC
(+) activate rule : isTestIncomplete
(+) add rule instance : isTestIncomplete@19399e
(->) fire rule instance : isTestIncomplete@19399e
(-) deactivate rule : isTestIncomplete
(+) activate rule : processIVMTest
(+) add rule instance : processIVMTest@15bc53  
(->) fire rule instance : processIVMTest@15bc53
(-) deactivate rule : processIVMTest
(+) activate rule : isNewIncomeTestLTC
(+) add rule instance : isNewIncomeTestLTC@ff2287
(->) fire rule instance : isNewIncomeTestLTC@ff2287
(-) deactivate rule : isNewIncomeTestLTC
(+) activate rule : isNewIncomeTestNonLTC
(+) add rule instance : isNewIncomeTestNonLTC@3403f2
(->) fire rule instance : isNewIncomeTestNonLTC@3403f2
(-) deactivate rule : isNewIncomeTestNonLTC
(+) activate rule : determineIfEffectiveImmediately
(+) add rule instance : determineIfEffectiveImmediately@1622f6
(->) fire rule instance : determineIfEffectiveImmediately@1622f6
(-) deactivate rule : determineIfEffectiveImmediately
(+) activate rule : setCompletedDateToCurrentForUI
(+) add rule instance : setCompletedDateToCurrentForUI@15179dd
(->) fire rule instance : setCompletedDateToCurrentForUI@15179dd
(-) deactivate rule : setCompletedDateToCurrentForUI 
		 */
	}
	public void testEffectiveImmediatelyOlderTest() throws Exception {
		VAFacility fac = this.getLookupService().getVaFacilityByCode("657");		
		Integer incomeYear2010 = new Integer(2010);		

		Person onFile = this.buildSimplePerson();		
		attachIncomeTest(onFile, incomeYear2010, fac,
				MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED);
		onFile.getIncomeTest(incomeYear2010).setEffectiveDate(
				getDate(2012, 6, 23));
		onFile.getIncomeTest(incomeYear2010).setLastEditedDate(
				getDate(2011, 1, 25));
		onFile.setFinancialStatement(incomeYear2010,
				this.createFinancialStatement());
		this.attachVerifiedEnrollment(onFile);

		this.setEligibilityStatusToVerified(onFile);
		Person incoming = savePerson(onFile);
		Integer incomeYear2009 = new Integer(2009);		
		incoming.removeAllIncomeTests();
		// try putting an older test.
		attachIncomeTest(incoming, incomeYear2009, fac,
				MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED);
		incoming.getIncomeTest(incomeYear2009).setEffectiveDate(
				getDate(2012, 5, 23));
		incoming.getIncomeTest(incomeYear2009).setLastEditedDate(
				getDate(2011, 1, 25));
		incoming.setFinancialStatement(incomeYear2009,
				this.createFinancialStatement());

		VerificationInfo info = new VerificationInfo("x", MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		info.setSiteNumber(fac.getCode());
		Person updated = this.getMessagingService().processZ07(incoming, fac, info);
		System.out.println("enrollment="+updated.getEnrollmentDetermination());
		
		IncomeTest result = this.getPersonHelperService().getCurrentIncomeTest(updated);
		System.out.println(" ");
		System.out.println(" ");
		System.out.println("POST current income test future="+result.getFutureTest() );
		System.out.println("POST new current income test year ="+result.getIncomeYear() );
		IncomeTest old = updated.getIncomeTest(incomeYear2009);
		System.out.println("POST older income test future="+old.getFutureTest() );
		System.out.println("POST older income test year ="+old.getIncomeYear() );

		assertFalse("should not be 2009",incomeYear2009.equals(result.getIncomeYear()));
		assertNull("should not be future",result.getFutureTest());
		assertFalse("should not be future",old.getFutureTest() != null ? old.getFutureTest().booleanValue() : false );
		
	}	
	public void testNeverExpireOneTest() throws Exception {
		Integer incomeYear2010 = new Integer(2010);
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		VAFacility fac = this.getLookupService().getVaFacilityByCode("657");
		this.attachIncomeTest(onFile, incomeYear2010, fac,
				MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT);
		// 6-15-2009
		onFile.getIncomeTest(incomeYear2010).setEffectiveDate(
				getDate(2009, 1, 23));
		onFile.getIncomeTest(incomeYear2010).setLastEditedDate(
				getDate(20009, 5, 23));
		onFile.setFinancialStatement(incomeYear2010,
				this.createFinancialStatement());
		IncomeTest clonedTest = new IncomeTest();
		this.getMergeRuleService().mergeIncomeTest(
				onFile.getIncomeTest(incomeYear2010), clonedTest);

		this.setEligibilityStatusToVerified(onFile);
		Person incoming = savePerson(onFile);

		VerificationInfo info = new VerificationInfo("x", MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		info.setSiteNumber(fac.getCode());
		incoming.getEligibilityVerification().setVerificationMethod("some text");

		Person updated = this.getMessagingService().processZ07(incoming, fac, info);
		IncomeTest result = this.getPersonHelperService().getCurrentIncomeTest(updated);
		System.out.println(" ");
		System.out.println(" ");
		System.out.println("income test future="+result.getFutureTest() );
		System.out.println("income test year ="+result.getIncomeYear() );

		assertTrue(incomeYear2010.equals(result.getIncomeYear()));
	}
	public void testVfaStartDate() throws Exception {
		Date vfaStartDate = null;
      	SystemParameterService systemParameterService =  (SystemParameterService)this.applicationContext.getBean("systemParameterService");
    	vfaStartDate = systemParameterService.getVFAStartDate();		
	}
	public void testExpireMT() throws Exception {
        Person onFile = buildSimplePerson();
        this.setEligibilityStatusToVerified(onFile);  
        this.attachMilitaryService(onFile);
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setEnrollmentStatus(
        		this.getLookupService().getEnrollmentStatusByCode(EnrollmentStatus.CODE_VERIFIED.getCode()));
        onFile.getEnrollmentDetermination().setPriorityGroup(
        		this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_5.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(null);

        VAFacility fac = this.getRandomVAFacility();
		IncomeTest incomeTest = this.createIncomeTest(
				IncomeTestType.CODE_MEANS_TEST,
				MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT, new Integer(2011));
		incomeTest.setSiteConductingTest(fac);
		incomeTest.setGmtThresholdAmount(new BigDecimal(20));
		incomeTest.setThresholdA(new BigDecimal(20));
		
		incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
		
		incomeTest.setEffectiveDate(getDate(2011,6,31));
		incomeTest.setCadAdjusted(Boolean.TRUE);
		incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
		incomeTest.getIncomeTestStatus().setCompletedDate(getDate(2011,1,1));
		incomeTest.setPrimaryIncomeTest(Boolean.TRUE);
		onFile.setIncomeTest(new Integer(2011), incomeTest);
		
		onFile.setFinancialStatement(new Integer(2011), this.createFinancialStatement());
        Person incoming = this.getPersonService().save(onFile);
        

        incoming.getEligibilityVerification().setVerificationMethod("make a change");
        Person updated = this.getMessagingService().processZ07(incoming,fac, new VerificationInfo());
        System.out.println("test="+updated.getIncomeTest(new Integer(2011)));
        System.out.println("test status="+updated.getIncomeTest(new Integer(2011)).getIncomeTestStatus());
        assertTrue(updated.isVeteran().booleanValue());
		
	}
	
	   public void testProcessORUZ07WithIT() throws Exception {
	    	/*
			 * Scenario:
			 * 
			 * Person has a Means Test older than 730 days with status Pending
			 * Adjudication where GMTT < MTT and Veteran refused to pay copay.
			 * 
			 * Veteran adds a new means test and agrees to pay copay, but the
			 * scenario does not match any of the determine if test is effective
			 * immediately scenarios so the system applies the Future Dated Test
			 * rule and sets the effective date to the effective date of the earlier
			 * test plus 365 which makes it a past date. In some cases, its more
			 * than 2 years old and therefore the test is expired as soon as its
			 * uploaded. It also has an effective date that is incompatible for the
			 * Income Year so it cant be edited.
			 * 
			 */
	        Person onFile = buildSimplePerson();
	        this.setEligibilityStatusToVerified(onFile);  
	        this.attachMilitaryService(onFile);
	        this.attachVerifiedEnrollment(onFile);
	        onFile.getEnrollmentDetermination().setEnrollmentStatus(
	        		this.getLookupService().getEnrollmentStatusByCode(EnrollmentStatus.CODE_NOT_ELIGIBLE_REFUSED_TO_PAY_COPAY.getCode()));
	        onFile.getEnrollmentDetermination().setPriorityGroup(
	        		this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
	        onFile.getEnrollmentDetermination().setPrioritySubGroup(
	        		this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_G.getCode()));

			IncomeTest incomeTest = this.createIncomeTest(
					IncomeTestType.CODE_MEANS_TEST,
					MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION, new Integer(2008));
			incomeTest.setSiteConductingTest(this.getRandomVAFacility());
			incomeTest.setGmtThresholdAmount(new BigDecimal(20));
			incomeTest.setThresholdA(new BigDecimal(20));
			
			incomeTest.setAgreesToPayDeductible(Boolean.FALSE);
			
			incomeTest.setEffectiveDate(getDate(2009,1,1));
			incomeTest.setCadAdjusted(Boolean.TRUE);
			incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
			incomeTest.getIncomeTestStatus().setCompletedDate(getDate(2009,1,1));
			incomeTest.setPrimaryIncomeTest(Boolean.TRUE);
			onFile.setIncomeTest(new Integer(2008), incomeTest);
			
			onFile.setFinancialStatement(new Integer(2008), this.createFinancialStatement());
	        Person incoming = this.getPersonService().save(onFile);
	        incoming.removeAllIncomeTests();
	        IncomeTest it = this.createIncomeTest(
					IncomeTestType.CODE_MEANS_TEST,
					MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION, new Integer(2011));
	        
	        it.setAgreesToPayDeductible(Boolean.TRUE);
	        it.setPrimaryIncomeTest(Boolean.TRUE);
			it.setGmtThresholdAmount(new BigDecimal(10));
			it.setThresholdA(new BigDecimal(20));
			it.setSiteConductingTest(incomeTest.getSiteConductingTest());
			it.setEffectiveDate(getDate(2012,2,1));
			it.getIncomeTestStatus().setCompletedDate(getDate(2012,2,1));
			it.setCadAdjusted(Boolean.TRUE);
			it.setDiscloseFinancialInformation(Boolean.TRUE);
			incoming.setIncomeTest(new Integer(2011), it);
			incoming.setFinancialStatement(new Integer(2011), this.createFinancialStatement());        

	        Person updated = this.getMessagingService().processZ07(incoming,it.getSiteConductingTest(), new VerificationInfo());
	        System.out.println("test="+updated.getIncomeTest(new Integer(2011)));
	        System.out.println("test status="+updated.getIncomeTest(new Integer(2011)).getIncomeTestStatus());
	        assertTrue(updated.isVeteran().booleanValue());
	    }
	   public void testProcessORUZ07WithCopayRequired() throws Exception {
	        Person onFile = buildSimplePerson();
	        this.setEligibilityStatusToVerified(onFile);  
	        this.attachMilitaryService(onFile);
	        this.attachVerifiedEnrollment(onFile);
	        onFile.getEnrollmentDetermination().setEnrollmentStatus(
	        		this.getLookupService().getEnrollmentStatusByCode(EnrollmentStatus.CODE_VERIFIED.getCode()));
	        onFile.getEnrollmentDetermination().setPriorityGroup(
	        		this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_5.getCode()));
	        onFile.getEnrollmentDetermination().setPrioritySubGroup(null);

	        VAFacility fac = this.getRandomVAFacility();
			IncomeTest incomeTest = this.createIncomeTest(
					IncomeTestType.CODE_MEANS_TEST,
					MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT, new Integer(2011));
			incomeTest.setSiteConductingTest(fac);
			incomeTest.setGmtThresholdAmount(new BigDecimal(20));
			incomeTest.setThresholdA(new BigDecimal(20));
			
			incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
			
			incomeTest.setEffectiveDate(getDate(2011,11,1));
			incomeTest.setCadAdjusted(Boolean.TRUE);
			incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
			incomeTest.getIncomeTestStatus().setCompletedDate(getDate(2011,1,1));
			incomeTest.setPrimaryIncomeTest(Boolean.TRUE);
			onFile.setIncomeTest(new Integer(2011), incomeTest);
			
			onFile.setFinancialStatement(new Integer(2011), this.createFinancialStatement());
	        Person incoming = this.getPersonService().save(onFile);
	        
	        incoming.removeAllIncomeTests();
	        IncomeTest it = this.createIncomeTest(
					IncomeTestType.CODE_MEANS_TEST,
					MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2011));
	        
	        it.setAgreesToPayDeductible(Boolean.TRUE);
	        it.setPrimaryIncomeTest(Boolean.TRUE);
			it.setGmtThresholdAmount(new BigDecimal(10));
			it.setThresholdA(new BigDecimal(20));
			it.setSiteConductingTest(incomeTest.getSiteConductingTest());
			it.setEffectiveDate(getDate(2012,2,1));
			it.getIncomeTestStatus().setCompletedDate(getDate(2012,2,1));
			it.setCadAdjusted(Boolean.TRUE);
			it.setDiscloseFinancialInformation(Boolean.TRUE);
			incoming.setIncomeTest(new Integer(2011), it);
			incoming.setFinancialStatement(new Integer(2011), this.createFinancialStatement());        

	        Person updated = this.getMessagingService().processZ07(incoming,fac, new VerificationInfo());
	        System.out.println("test="+updated.getIncomeTest(new Integer(2011)));
	        System.out.println("test status="+updated.getIncomeTest(new Integer(2011)).getIncomeTestStatus());
	        assertTrue(updated.isVeteran().booleanValue());
	    }  	   
	
}
