/**
 * 
 */
package gov.va.med.esr.service;

import java.util.List;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.util.AbstractServiceTestCase;

import gov.va.med.esr.service.LookupService;

/**
 * @author DNS   KATIKM
 *
 */
public class UserAdminServiceTest extends AbstractServiceTestCase {
    private LookupService lookupSrv = null;

	public void testFindUsersByRoleName() throws Exception {		
		List users = getUserAdminService().findUsersByRoleName(Capability.ADMINISTRATOR.getCode());
		assertTrue(users.size()>0);
		System.out.println("Get Users By RoleName " + users);
	}

	public void testFindUsersAll() throws Exception {		
		List users = getUserAdminService().findAllUsers();
		assertTrue(users.size()>0);
	}

	public void testFindUsersByRoleAndFunctionalGroup() throws Exception {
        if (lookupSrv == null)
            lookupSrv = this.getLookupService();
        try
        {
        	FunctionalGroup fg = (FunctionalGroup)lookupSrv.getFunctionalGroupByCode(FunctionalGroup.EE.getCode());
    		List users = getUserAdminService().findUsersByRoleAndFunctionalGroup(fg, Capability.ADMINISTRATOR.getCode());
    		assertTrue(users.size()>0);
       }catch (Exception ex)
        {
            ex.printStackTrace();
        }
	}

	public void testFindUsersByFunctionalGroup() throws Exception {
        if (lookupSrv == null)
            lookupSrv = this.getLookupService();
        try
        {
        	FunctionalGroup fg = (FunctionalGroup)lookupSrv.getFunctionalGroupByCode(FunctionalGroup.EE.getCode());
    		List users = getUserAdminService().findUsersByFunctionalGroup(fg);
    		assertTrue(users.size()>0);
       }catch (Exception ex)
        {
            ex.printStackTrace();
        }
	}

	public void testFindUsersByCapabilityCode() throws Exception {		
		//List users = getUserAdminService().findUsersByCapabilityName(Capability.LOGIN_INTO_SYSTEM.getCode());
		List users = getUserAdminService().findUsersByCapabilityCode("28");
				
		assertTrue(users.size()>0);
		System.out.println("Get Users By Capability Code " + users);
	}	
}
