/*
 * Created on Aug 24, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import gov.va.med.esr.common.model.comms.AacLetterRequest;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.comms.AacLetterRequestDAO;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.esr.service.trigger.LetterTrigger;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.trigger.LetterTriggerIdentity;
import gov.va.med.esr.service.trigger.LetterTriggerEvent.MailType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.lookup.AddressType;

public class TestCommsLetterRequestService extends RuleAbstractTestCase {
    
    private CommsLetterRequestService service = null;
	
    public TestCommsLetterRequestService(String testName) {
		super(testName);
	}	 

    public void setUpData() throws Exception {
        AacLetterRequestDAO aacReqDao = (AacLetterRequestDAO)applicationContext.getBean("aacLetterRequestDAO");
        AacLetterRequest req = aacReqDao.findAacLetterRequestById(new BigDecimal(28355));
        aacReqDao.deleteById(req);
        
    }
    
    public void tearDownData() throws Exception {

    }
//8859561 6417462
    public void testCmsLetter400Manual() throws Exception {
    	this.doTestRequestCmsLetters("375200524", ComLetterTemplateType.FORM_NUMBER_400.getCode(), LetterTriggerEvent.MANUAL_MAIL);
    }
    public void testCmsLetter683ARemail() throws Exception {
    	this.doTestRequestCmsLetters("6417462", ComLetterTemplateType.FORM_NUMBER_683A.getCode(), LetterTriggerEvent.REMAIL_MAIL);
    }
    public void testCmsLetter455Remail() throws Exception {
    	this.doTestRequestCmsLetters("6417462", ComLetterTemplateType.FORM_NUMBER_455.getCode(), LetterTriggerEvent.REMAIL_MAIL);
    }        
    private void doTestRequestCmsLetters(String personId, String formNum, MailType mailType) throws Exception {
    	getLoginManager().loginAnonymous();

		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal(personId));
		Person person = this.getPersonService().getPerson(personKey);    	
    	
    	
    	ComLetterTemplateType formNumber = (ComLetterTemplateType)getLookupService().getComLetterTemplateTypeByCode(formNum);
    	String workflowCaseId = null;
    	service = (CommsLetterRequestService) applicationContext.getBean("commsLetterRequestService");
    	List errs = service.requestAacLetter(person, 
    			new LetterTriggerIdentity(formNumber), 
    			workflowCaseId,
    			LetterTriggerEvent.AUTO_MAIL, null, "Action Comment");
    	System.out.println("errs="+errs);
    	assertTrue(errs.isEmpty());
    }
	    
    public void testRequestCmsLettersViaTrigger() throws Exception {
    	getLoginManager().loginAnonymous();
    	ComLetterTemplateType type = this.getLookupService().getComLetterTemplateTypeByCode(ComLetterTemplateType.FORM_NUMBER_400.getCode());
    	LetterTriggerEvent lte = new LetterTriggerEvent(type);
    	lte.setIvmCaseClosureDate(new Date());
    	lte.setIvmCaseNumber("424234234");
    	    	
    	PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("6417462"));
		Person person = this.getPersonService().getPerson(personKey);    	    	
    	LetterTriggerIdentity letterTriggerIdentity = (LetterTriggerIdentity) lte.getTriggerIdentity();
    	service = (CommsLetterRequestService) applicationContext.getBean("commsLetterRequestService");
    	service.requestLetter(person, letterTriggerIdentity, lte);

//    	this.setComplete();
    }    
    
    
    public void testRequestAacLetter()
    {
        int personIds[] = {
                67110,
                71428,
                84379};
        
        getLoginManager().loginAnonymous();
        
//        StLetterTrigger.DataTypering formNumber = LetterTrigger.DataType.FORM_NUMBER_600C.getName();
//        String formNumber = "742-600C";
        
        ComLetterTemplateType formNumber = null;
        
        try{
            formNumber =(ComLetterTemplateType)getLookupService().getComLetterTemplateTypeByCode("742-600C");
        } catch (Exception ex)
        {
            ex.printStackTrace();
        }
        String workflowCaseId = null;
        try{
            service = (CommsLetterRequestService) applicationContext.getBean("commsLetterRequestService");
            
            Person person = null;
            PersonDAO personDao = (PersonDAO)applicationContext.getBean("personDAO");
            
//            for (int i = 0; i< personIds.length; i++)
//
//            {
                person = (Person) personDao.getByKey(
                    new PersonIdEntityKeyImpl(new BigDecimal("378177224")));
//            person = (Person) this.getPersonService().getPerson(new gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl(new java.math.BigDecimal(68)));

                service.requestAacLetter(person, 
                        new LetterTriggerIdentity(formNumber), 
                        workflowCaseId,
                        LetterTriggerEvent.AUTO_MAIL, null, "Action Comment");
//            }
        } catch (Exception ex)
        {
            ex.printStackTrace();
        }
        
    }
}
