package gov.va.med.esr.service;

import java.math.BigDecimal;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;

public class SecurityServiceTest
    extends AbstractSecurityTestCase {

    public UserPrincipal authenticate(String userName, String password)
            throws LoginException, ServiceException {
        Subject subject = getSecurityService().authenticate(userName, password.toCharArray());
        return (UserPrincipal) subject.getPrincipals().iterator().next();
    }

    public void testValidFindById() throws ServiceException {
        UserPrincipal user = getSecurityService().getUserById(
                getTestUser().getEntityKey());
        assertNotNull("UserPrincipal returned is Null.", user);
        assertEquals(user.getEntityKey().getKeyValue(),
                getTestUser().getEntityKey().getKeyValue());
    }

    public void testInvalidFindById() throws ServiceException {
        EntityKey key = getTestUser().getEntityKey();
        EntityKey newKey = EntityKeyFactory.createEntityKey(new BigDecimal(
                "999" + key.getKeyValue()), key.getEntityClass());
        UserPrincipal user = getSecurityService().getUserById(newKey);
        assertNull("UserPrincipal returned should be Null.", user);
    }
}