/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// EDB Classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.RuleAbstractTestCase;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public class ProcessVBAServiceTest extends RuleAbstractTestCase {
    /**
     * @param testName
     */
    public ProcessVBAServiceTest(String testName)  throws Exception {
        super(testName);        
    }
    
    private Person setupPersonDecision8Preconditions() throws Exception {
        Person person = this.buildSimplePerson();
	    this.attachIneligibleFactorFromSite( person );        
        
        return person;
    }
           
    
    public void testDecison11() throws Exception {
        Person person = this.buildSimplePerson();
        this.attachServiceConnectionAward( person );
        person.getServiceConnectionAward().addRatedDisability( 
                this.createRatedDisability("5271", new Integer(10)));
        person.getServiceConnectionAward().addRatedDisability( 
                this.createRatedDisability("5285", new Integer(10)));        
        this.setServiceConnectedPercentage( new Integer(0), person );
        this.attachVaPension( person );
        
	    Person vbaPerson = enrollFromSite( person );
	    this.attachEligibilityVerification( vbaPerson, "VBA" );
        vbaPerson.getEligibilityVerification().setVerificationMethod("VBA");
        this.setEligibilityStatusToPendingVerification(  vbaPerson );
        
        Person verifiedPerson = this.verifyEligibility( vbaPerson, this.createVerificationInfoFromORFZ11() );
   //     assertTrue(  verifiedPerson.getWorkloads().size() == 0 );        
		logger.info("Completed test for person " + vbaPerson.getEntityKey().getKeyValue() );
    }    


    public void testIsNotMB() throws Exception {
        Person person = this.buildSimplePerson();
        this.attachServiceConnectionAward( person );
        person.getServiceConnectionAward().addRatedDisability( 
                this.createRatedDisability("5271", new Integer(10)));
        person.getServiceConnectionAward().addRatedDisability( 
                this.createRatedDisability("5285", new Integer(10)));        
        this.setServiceConnectedPercentage( new Integer(0), person );
        
	    Person vbaPerson = enrollFromSite( person );
        
	    this.attachEligibilityVerification( vbaPerson, "VBA" );
        this.attachOtherFederalAgencyAsPrimary( vbaPerson );
        vbaPerson.getEligibilityVerification().setVerificationMethod("VBA");
        this.setEligibilityStatusToPendingVerification(  vbaPerson );
        
        Person verifiedPerson = this.verifyEligibility( vbaPerson, this.createVerificationInfoFromORFZ11() );
   //     assertTrue(  verifiedPerson.getWorkloads().size() == 0 );        
		logger.info("Completed test for person " + vbaPerson.getEntityKey().getKeyValue() );
    }        
}
