/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.util.RuleAbstractTestCase;


public class PreferredFacilityServiceTest extends RuleAbstractTestCase {

    Person person = null;
    
    private PreferredFacilityService preferredFacilityService = null;
    
    public PreferredFacilityServiceTest(String testName) {
        super(testName);
    }

    protected void customSetUp() throws Exception { 
        super.customSetUp();
        person  = this.buildPerson();
    }

  /*  public void testIsMostRecentParentPFChanged() throws Exception {
 
        // no enrollment determinations
        Person pristinPerson = this.buildSimplePerson();
        Person resultPerson = this.buildSimplePerson();
         
        pristinPerson.setMostRecentPreferredFacility(this.getLookupService()
				.getVaFacilityByCode("568A4"));
        resultPerson.setMostRecentPreferredFacility(this.getLookupService()
				.getVaFacilityByCode("528GN"));
        assertTrue(getPreferredFacilityService().isMostRecentParentPFChanged(pristinPerson.getMostRecentPreferredFacility(), resultPerson.getMostRecentPreferredFacility()));
    
        pristinPerson.setMostRecentPreferredFacility(this.getLookupService()
				.getVaFacilityByCode("740GA"));
        resultPerson.setMostRecentPreferredFacility(this.getLookupService()
				.getVaFacilityByCode("740GB"));
        assertFalse(getPreferredFacilityService().isMostRecentParentPFChanged(pristinPerson.getMostRecentPreferredFacility(), resultPerson.getMostRecentPreferredFacility()));
        
        pristinPerson.setMostRecentPreferredFacility(null);
        assertTrue(getPreferredFacilityService().isMostRecentParentPFChanged(pristinPerson.getMostRecentPreferredFacility(), resultPerson.getMostRecentPreferredFacility()));
        
        resultPerson.setMostRecentPreferredFacility(null);
        assertFalse(getPreferredFacilityService().isMostRecentParentPFChanged(pristinPerson.getMostRecentPreferredFacility(), resultPerson.getMostRecentPreferredFacility()));               
    }

    public void testIsAnyActiveParentPFChanged() throws Exception {
    	 
        // no enrollment determinations
        Person pristinPerson = this.buildSimplePerson();
        Person resultPerson = this.buildSimplePerson();
         
        PreferredFacility pf1 = new PreferredFacility();
        pf1.setFacility(this.getLookupService()
				.getVaFacilityByCode("740GA"));
 
        PreferredFacility pf2 = new PreferredFacility();
        pf1.setFacility(this.getLookupService()
				.getVaFacilityByCode("740GB"));

        pristinPerson.addPreferredFacility(pf1);
        resultPerson.addPreferredFacility(pf2);
        
        assertFalse(getPreferredFacilityService().isAnyActiveParentPFChanged(pristinPerson.getPreferredFacilities(), resultPerson.getPreferredFacilities()));
    
        PreferredFacility pf3 = new PreferredFacility();
        pf3.setFacility(this.getLookupService()
				.getVaFacilityByCode("568A4"));

        pristinPerson.addPreferredFacility(pf3);
        assertTrue(getPreferredFacilityService().isAnyActiveParentPFChanged(pristinPerson.getPreferredFacilities(), resultPerson.getPreferredFacilities()));

        
        PreferredFacility pf4 = new PreferredFacility();
        pf4.setFacility(this.getLookupService()
				.getVaFacilityByCode("528GN"));
        resultPerson.addPreferredFacility(pf4);
               assertTrue(getPreferredFacilityService().isAnyActiveParentPFChanged(pristinPerson.getPreferredFacilities(), resultPerson.getPreferredFacilities()));
       
        pristinPerson.removeAllPreferredFacilities();
        assertTrue(getPreferredFacilityService().isAnyActiveParentPFChanged(pristinPerson.getPreferredFacilities(), resultPerson.getPreferredFacilities()));
        
        resultPerson.removeAllPreferredFacilities();
        assertFalse(getPreferredFacilityService().isAnyActiveParentPFChanged(pristinPerson.getPreferredFacilities(), resultPerson.getPreferredFacilities()));               
    }
*/
	private PreferredFacilityService getPreferredFacilityService() {
		if (preferredFacilityService == null)
			preferredFacilityService = (PreferredFacilityService) this.applicationContext
					.getBean("preferredFacilityService");
		return preferredFacilityService;
	}

	private void setPreferredFacilityService(
			PreferredFacilityService preferredFacilityService) {
		this.preferredFacilityService = preferredFacilityService;
	}

}
