/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.service;

import java.util.Enumeration;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

/**
 * Use this for testing any Person Services (PSIM, PSD, etc) api's that ESR invokes
 * 
 * Created Feb 9, 2006 12:27:13 PM
 * @author DNS   BOHMEG
 */
public class PSTestSuite  {
	public static Test suite() {
		TestSuite suite = new TestSuite();
		
		// add tests
		suite.addTest(createPersonServiceTest("testRetrievePersonByPersonId"));
		suite.addTest(createPersonServiceTest("testCreatePerson"));		
		suite.addTest(createPersonServiceTest("testRetrievePersonByLongVPID"));		
		suite.addTest(createPersonServiceTest("testRetrievePersonByShortVPID"));		
		suite.addTest(createPersonServiceTest("testUpdatePersonWithoutIdentityTraitChange"));
		suite.addTest(createPersonServiceTest("testUpdatePersonWithPrimaryIdentityTraitChange"));
		suite.addTest(createPersonServiceTest("testUpdatePersonWithNonPrimaryIdentityTraitChange"));
		suite.addTest(createPersonServiceTest("testFindPerson"));
		suite.addTest(createPersonServiceTest("testSearchPersonOnlyESR"));
		suite.addTest(createPersonServiceTest("testSearchPersonOnlyPSIMYesMatch"));
		suite.addTest(createPersonServiceTest("testSearchPersonOnlyPSIMNoMatch"));
		suite.addTest(createPersonServiceTest("testSearchPersonOnlySSNYesMatch"));
		
		suite.addTest(createMessagingServiceTest("testGetSites"));
		
		suite.addTest(createPSDelegateServiceTest("testGetMultipleIdentityTraits"));
		suite.addTest(createPSDelegateServiceTest("testUnattendedSearch"));
		suite.addTest(createPSDelegateServiceTest("testUnattendedSearchInvalidCombo"));
		suite.addTest(createPSDelegateServiceTest("testAttendedSearch"));
		suite.addTest(createPSDelegateServiceTest("testGetShortVPID"));
		suite.addTest(createPSDelegateServiceTest("testGetVPIDsBYSSNVerificationStatus"));		
		suite.addTest(createPSDelegateServiceTest("testGetIdentityTraitsUpdateHistory"));
		
		return suite;
	}	
	
	private static TestCase createPersonServiceTest(String name) {
		TestCase test = new PersonServiceTest();
		test.setName(name);
		return test;		
	}
	
	private static TestCase createMessagingServiceTest(String name) {
		TestCase test = new MessagingServiceTest();
		test.setName(name);
		return test;		
	}
	
	private static TestCase createPSDelegateServiceTest(String name) {
		TestCase test = new PSDelegateServiceTest();
		test.setName(name);
		return test;		
	}
	
	/** Useful for running in Weblogic */
	public static void executeSuite() {
		TestSuite tests = (TestSuite) suite();
		Enumeration e = tests.tests();
		while(e.hasMoreElements()) {
			Test test = (Test) e.nextElement();
			System.out.println("## Running test: " + test);
			test.run(new TestResult());
		}
	}
}
