/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.validation.ValidationServiceException;

// ESR classes
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.lookup.InsuredRelationship;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.service.MatchRuleService;
import gov.va.med.esr.common.util.RuleAbstractTestCase;


/**
 * Test insurance service  
 *
 * Project: Common</br>
 * Created on: 4:17:42 PM </br>
 *
 * @author DNS   LEV
 */
public class InsuranceServiceTest extends RuleAbstractTestCase {

	/**
	 * An instance of onFile
	 */
	private Person onFile = null;

	/**
	 * An instance of mergeRuleService
	 */
	private MatchRuleService matchRuleService = null;
	
	/**
	 * constructor
	 */
	public InsuranceServiceTest(String testName) throws Exception {
		super(testName);
	}

	/**
	 * @see gov.va.med.fw.util.AbstractTestCase#customSetUp()
	 */
	protected void customSetUp() throws Exception {
		super.customSetUp();
		onFile = this.buildSimplePerson();
	}

	/**
	 * @see gov.va.med.fw.util.AbstractTestCase#customTearDown()
	 */
	protected void customTearDown() throws Exception {
		super.customTearDown();
		onFile = null;
	}


	// Tests BAL ValidationInsurance.irl and ProcessInsurance.irl
	public void testUpdateInsurance() throws Exception {

		// Create a policy for a veteran
		Medicare policy = (Medicare)this.createMedicareInsurance();
		InsuredRelationship relationship = 
			this.getLookupService().getInsuredRelationshipByCode( InsuredRelationship.CODE_VETERAN.getName() );
		
		InsuranceSubscriber subscriber = new InsuranceSubscriber();
		subscriber.setRelationship( relationship );
		
		policy.setSubscriber( subscriber );
		policy.setReportSource( this.getRandomReportSource() );
		policy.setEnrolledInPartB( Boolean.TRUE );
		policy.setMedicareClaimNumber( "111111" );
		
		onFile.addInsurance( policy );
		this.getPersonService().save( onFile );
		
		// Create a working person
		Person incoming = (Person)onFile.clone();
		
		policy = (Medicare)incoming.getInsurances().iterator().next();
		policy.setMedicareClaimNumber( "222222" );
		
		try {
			assertEquals( "111111", ((Medicare)onFile.getInsurances().iterator().next()).getMedicareClaimNumber() );
			this.getInsuranceService().updateInsurance( incoming );
			
			onFile = this.getPersonService().getPerson( incoming.getPersonEntityKey() );
			assertEquals( "222222", ((Medicare)onFile.getInsurances().iterator().next()).getMedicareClaimNumber() );
		} 
		catch( ValidationServiceException e ) {
			if( logger.isDebugEnabled() ) {
				logger.debug( "Got an un-expected exception ", e );
			}
		}
	}
	
	/**
	 * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
	 */
	public void afterPropertiesSet() throws Exception {
		Validate.notNull(this.getInsuranceService(), "An insurance service is required");
		Validate.notNull(this.getMatchRuleService(), "A match rule service is required");
	}

	/**
	 * @return Returns the matchRuleService.
	 */
	public MatchRuleService getMatchRuleService() {
		return matchRuleService;
	}

	/**
	 * @param matchRuleService The matchRuleService to set.
	 */
	public void setMatchRuleService(MatchRuleService matchRuleService) {
		this.matchRuleService = matchRuleService;
	}
}
