package gov.va.med.esr.service;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.FullyQualifiedIdentity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.ps.model.PatientIdentifier;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.util.AbstractServiceTestCase;
import gov.va.med.esr.service.impl.IdmWebServiceDelegate;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;


public class IdmWebServiceDelegateTest extends AbstractServiceTestCase{

	private String firstName = "John";
	private String lastName = "ESR-TESTFEB";
	private String middleName = "M";
	private String addLine1 = "675 Less st";
	private String addLine2 = "#123";
	private String addCity = "Ashburn";
	private String addState = "VA";
	private String addZip="20148";
	private String homePhone = "703-324-1234";
	private String ssn = "972712100";
	private String dob = "19700101";
	private String gender = "M";
//	
//
//	public void testGetCorrelationsByVPID() throws Exception {
//    	try {
//    		// 0000001008591029V157554000000
//    		// 0000001008591808V952911000000
//    		VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001008591029V157554000000");
//     		List list = getIdmWebServiceDelegate().getCorrelationsByVPID(key);
//    		System.out.println("number of correlations="+list.size());
//    		
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//	
//	
//	public void testSearch() throws Exception {
//    	try {
//    		// This can test populateSearchParameterList in IdmWebServiceDelegateImpl
//    		VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001008591808V952911000000");
//			PersonIdentityTraits traits = getIdmWebServiceDelegate().getESRCorrelation(key);		
//      		Set list = getIdmWebServiceDelegate().search(traits);
//    		System.out.println(list);
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//
//	public void testCompositeSearchWithFullyQId() throws Exception {
//    	try {
//    		
//    		FullyQualifiedIdentity id = new FullyQualifiedIdentity("0000001008522496V535571000000"); //deprecated vpid	
//    		PersonIdentityTraits traits = getIdmWebServiceDelegate().search(id);	
//    		//should always return surviving vpid
//    		assertEquals("0000001008588509V162242000000", traits.getVpid().getVPID());
//    		assertEquals(false, traits.isHasPendingUpdates());
//    		assertEquals(false, traits.isDeprecated());
//    		
//    		//CCR12665-siteIdentities, no sites returned here.
//    		Set sites = traits.getSiteIdentities();
//    		assertTrue(sites.size()==0);
//
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//	
//
//	public void testCompositeSearchWithDeprecatedVPID() throws Exception {
//    	try {
//    		FullyQualifiedIdentity id = new FullyQualifiedIdentity("0000001008523836V480329000000");	
//    		PersonIdentityTraits traits = getIdmWebServiceDelegate().searchWithCompositeCall(id,false);	
//    		System.out.println("vpid: " + traits.getVpid());
//    		System.out.println("hasPending: " + traits.isHasPendingUpdates());
//			System.out.println("deprecated: " + traits.isDeprecated());
//			System.out.println("ssn: " + traits.getSsnText());
//			System.out.println("dob: " + traits.getBirthRecord().getBirthDate());
//			System.out.println("last name: " + traits.getNames().iterator().next());
//			System.out.println("gender: " + traits.getGender().getCode());
//			//CCR12665-siteIdentities, 2 sites with station id 553 should be returned as this is the only station 
//			//supported in dev.  in prod, more will be returned.
//			//other sites are supported
//    		Set sites = traits.getSiteIdentities();
//    		System.out.println(sites.size());
//    		assertTrue(sites.size()==2);
//    		
//    		//only sites with id 553 should be returned
//			for (Iterator it = sites.iterator(); it.hasNext();){
//				SiteIdentity sid = (SiteIdentity)it.next();	
//				assertNotNull(sid.getDfn());
//				assertTrue(sid.getDfn().length() > 0);
//				System.out.println("sid: " + sid.getDfn());
//				System.out.println("facility name: " + sid.getVaFacility().getFacilityName());
//				System.out.println("station # : " + sid.getVaFacility().getStationNumber());
//				System.out.println("facility code: " +  sid.getVaFacility().getCode());
//				System.out.println("site id: " +  sid.getVaFacility().getIdentifier());
//				System.out.println("visn id: " + sid.getVaFacility().getVisnId());
//				System.out.println("Site # and Name: " + sid.getVaFacility().getSiteNumberAndName());
//				System.out.println();
//			}
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//	public void testCompositeSearch() throws Exception {
//    	try {
//    	
//    		//VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001001168193V233890000000");
//    		FullyQualifiedIdentity id = new FullyQualifiedIdentity("1001168528V211848");
//    		PersonIdentityTraits traits = getIdmWebServiceDelegate().searchWithCompositeCall(id,false);	
//    		assertEquals("0000001001168528V211848000000", traits.getVpid().getVPID());
//    		assertEquals(false, traits.isHasPendingUpdates());
//    		assertEquals(false, traits.isDeprecated());
//    		
//    		//CCR12665-siteIdentities
//    		Set sites = traits.getSiteIdentities();
//    		System.out.println(sites.size());
//    		
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//
//	public void testCompositeSearchWithSitesInfo() throws Exception {
//    	try {
//    	
//    		//VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001001168193V233890000000");
//    		FullyQualifiedIdentity id = new FullyQualifiedIdentity("1001170375V094875");  //deprecated vpid
//    		PersonIdentityTraits traits = idmService.searchWithCompositeCall(id,false);	
//    		//should return a surviving vpid as below
//    		assertEquals("0000001008522565V314128000000", traits.getVpid().getVPID());
//    		assertEquals(false, traits.isHasPendingUpdates());
//    		assertEquals(false, traits.isDeprecated());
//    		
//    			
//			VPIDEntityKey vpid = CommonEntityKeyFactory.createVPIDEntityKey("0000001008522565V314128000000"); 
//			Person person = getPersonService().getPersonWithCompositeCall(vpid);
//			assertNotNull(person);
//			assertTrue(person.getNames().size()>0);
//			assertEquals(person.getVPIDEntityKey().getKeyValueAsString(), vpid.getKeyValueAsString());
//			assertEquals("020143557", ((SSN)person.getSsns().toArray()[0]).getSsnText());
//			assertEquals("Female", person.getGender().getName());
//			
//			//CCR12665-siteIdentities
//			Set sites = person.getSiteIdentities();
//			assertEquals(1, sites.size());
//			System.out.println("number of sites: " + sites.size());
//			
//			//Print first site element...only site 553 should be returned as this is supported by dev env
//			SiteIdentity sid = (SiteIdentity)sites.toArray()[0];	
//			assertNotNull(sid.getDfn());
//			assertTrue(sid.getDfn().length() > 0);
//			assertEquals("100001168", sid.getDfn());
//			assertEquals("DETROIT, MI VAMC (#553)", sid.getVaFacility().getFacilityName());
//			assertEquals("553", sid.getVaFacility().getStationNumber());
//			assertEquals("553",  sid.getVaFacility().getCode());
//			assertEquals(new BigDecimal("1000153"), sid.getVaFacility().getIdentifier());
//			assertEquals(new BigDecimal(1002211), sid.getVaFacility().getVisnId());
//			assertEquals("553 - DETROIT, MI VAMC", sid.getVaFacility().getSiteNumberAndName());		
//    
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//	public void testCompositeSearchWithSitesInfo3() throws Exception {
//    	try {
//    	
//    		//VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001001168193V233890000000");
//    		FullyQualifiedIdentity id = new FullyQualifiedIdentity("0000001008596246V345034000000");  
//    		PersonIdentityTraits traits = idmService.searchWithCompositeCall(id,false);	
//    		//should return a surviving vpid as below
//    		assertEquals("0000001008596246V345034000000", traits.getVpid().getVPID());
//    		assertEquals(false, traits.isHasPendingUpdates());
//    		assertEquals(false, traits.isDeprecated());
//    		
//    			
//			VPIDEntityKey vpid = CommonEntityKeyFactory.createVPIDEntityKey("0000001008596246V345034000000"); 
//			Person person = getPersonService().getPersonWithCompositeCall(vpid);
//			assertNotNull(person);
//			assertTrue(person.getNames().size()>0);
//			assertEquals(person.getVPIDEntityKey().getKeyValueAsString(), vpid.getKeyValueAsString());
//			assertEquals("111223333", ((SSN)person.getSsns().toArray()[0]).getSsnText());
//			assertEquals("Male", person.getGender().getName());
//			
//			//CCR12665-siteIdentities allowed in dev env
//			Set sites = person.getSiteIdentities();
//			assertEquals(0, sites.size());
//    
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//	
//	
//	
//	public void testCompositeSearchWithSurvivingVPID() throws Exception {
//    	try {
//    		FullyQualifiedIdentity id = new FullyQualifiedIdentity("0000001008522565V314128000000");
//			//PersonIdentityTraits traits = getIdmWebServiceDelegate().getESRCorrelation(key);		
//    		PersonIdentityTraits traits = getIdmWebServiceDelegate().search(id);	
//    		assertEquals("0000001008522565V314128000000", traits.getVpid().getVPID());
//    		assertEquals(false, traits.isHasPendingUpdates());
//    		assertEquals(false, traits.isDeprecated());
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//	
//	
//	public void testCompositeSearchWithTraits() throws Exception {
//    	try {
// 
//    		PersonIdentityTraits traits = createTraits();
//    		Set list=  getIdmWebServiceDelegate().searchWithCompositeCall(traits);
//    		assertTrue(list.size() > 0);
//    		Iterator it = list.iterator();
//    		while (it.hasNext()){
//    			PersonIdentityTraits pi = (PersonIdentityTraits)it.next();    			
//    			System.out.println(pi.getVpid().getVPID());
//    			//System.out.println(pi.g);
//    			System.out.println(pi.isHasPendingUpdates());
//    			System.out.println("is deprecated: " + pi.isDeprecated());
//    		}
//
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//	
//	public void testNonCompositeSearchWithTraits() throws Exception {
//    	try {
//    		
//    		PersonIdentityTraits traits = createTraits();
//    		Set list=  getIdmWebServiceDelegate().search(traits);
//    		assertTrue(list.size() > 0);
//    		Iterator it = list.iterator();
//    		while (it.hasNext()){
//    			PersonIdentityTraits pi = (PersonIdentityTraits)it.next();    			
//    			System.out.println(pi.getVpid().getVPID());
//    			//System.out.println(pi.g);
//    			System.out.println(pi.isHasPendingUpdates());
//    			System.out.println("is deprecated: " + pi.isDeprecated());
//    		}
//
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//	
//	public void testCompositeSearchWithDeprecatedVPID3() throws Exception {
//    	try {
//    		
//    		FullyQualifiedIdentity id = new FullyQualifiedIdentity("1008530941V607356");  //this is deprecated id but returns surviving vpid
//    		PersonIdentityTraits traits = getIdmWebServiceDelegate().searchWithCompositeCall(id,false);	
//    		assertEquals(false, traits.isDeprecated());
//    		
//    		assertEquals("0000001008530939V497576000000", traits.getVpid().getVPID());
//    		assertEquals(false, traits.isHasPendingUpdates());
//
//			Name nm = (Name)traits.getNames().toArray()[0];
//			assertEquals("MPIDEV", nm.getFamilyName());
//    		assertEquals("PATIENT", nm.getGivenName());
//    		assertEquals("ONE", nm.getMiddleName());
//			assertEquals("030343321", traits.getSsn().getSsnText());
//			assertEquals("M", traits.getGender().getCode());
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//	
//	
//	public void testSearchByEDIPI() throws Exception {
//    	try {
//    		//"1606260004^NI^200DOD^USDOD"
//    		FullyQualifiedIdentity id = new FullyQualifiedIdentity("1606260004", "NI", "200DOD", "USDOD");	
//      		PersonIdentityTraits traits = getIdmWebServiceDelegate().search(id);
//      		assertEquals(traits.getVpid().getKeyValueAsString(), "1008593548V661716");
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	
//	public void testGetCorrelationsByEDIPI() throws Exception
//	{
///*		String[] edipis = {
//				"1606118356",
//				"1015599142",
//				"1006836751",
//				"1606118364",
//				"1606117066",
//				"1005094310",
//				"1606115870",
//				"1606115578",
//				"1606115519",
//				"1606115500",
//				"1606115497",
//				"1606115403",
//				"1606115349",
//				"1606259944",
//				"1606258387",
//				"1606219187",
//				"1005123867"};*/
///*		String[] edipis = {
//		"1606218911",
//		"1606218920",
//		"1606218938",
//		"1606218946",
//		"1606218954",
//		"1606218962",
//		"1606218970",
//		"1606218989",
//		"1606218997",
//		"1606219004",
//		"1606219012",
//		"1606219020",
//		"1606219039",
//		"1606219047",
//		"1606219055",
//		"1606219063",
//		"1606219071",
//		"1606219080",
//		"1606219098",
//		"1606219101",
//		"1606219110",
//		"1606219128",
//		"1606219136",
//		"1606219144",
//		"1606219152"};*/
//
///*		String[] edipis = {
//				"1606259626",
//				"1606111483",
//				"1606115349",
//				"1605851661",
//				"1605857929",
//				"1605836620",
//				"1605855926",
//				"1605848440",
//				"1605859298",
//				"1605857759",
//				"1014240248",
//				"1606125174",
//				"1606119808"
//		};*/
//		
///*		String[] edipis = {
//				"1605857759",
//				"1606115870",
//				"1005123867",
//				"1605838827",
//				"1130830745",
//				"11111001",
//				"1005094310",
//				"1605855926",
//				"1605849624",
//				"1605848687",
//				"1605859298",
//				"1605847524",
//				"756",
//				"8005199561",
//				"999830037",
//				//"10000001-004", //No ACTIVE Correlation found:gov.va.med.person.idmgmt.server.profile.Identifier@15c7bd4a[NI,,10000001-004,200DOD,USDOD,,,,]
//				"1010294122",
//				//"999820041", //No ACTIVE Correlation found:gov.va.med.person.idmgmt.server.profile.Identifier@7b1e43e3[PI,,0000001008592549V801710000000,200ESR,USVHA,,,,]
//				"1606323499",
//				"1606248675"
//		};*/
//		
//		String[] edipis = {
//				"1605851661",
//				"1606325882",
//				"1605857929",
//				"1605836620",
//				"1605848440",
//				"1014240248",
//				//"1203122012033000", //No Record Found: Correlation Does Not Exist:IQI[1203122012033000,NI,USDOD,200DOD]
//				"1605857236",
//				"1605859999",
//				"1605857503",
//				"1606124178",
//				"1606325815",
//				"1605847397",
//				"1606325149",
//				"1605846358",
//				"1606325394",
//				"1605859026",
//				"1605859700",
//				"1606120547",
//				"1606274706",
//				"KP2038298",
//				"1606260853",
//				"1605855225",
//				"1605849241",
//				"1605857546",
//				"1606260101",
//				"1605849152",
//				"1605863350",
//				"1606324630",
//				"1016845210",
//				"1606326633",
//				"1006836751"
//		};
//		
//		PatientIdentifier id = null;
//
//		System.out.print("\nEDIPI, VPID, SSN, DOB, Gender, Last, First, 200ESR Corr?\n");
//		for (int i=0; i< edipis.length; i++)
//		{
//			FullyQualifiedIdentity fullId = new FullyQualifiedIdentity(edipis[i], "NI", "200DOD", "USDOD");
//			PersonIdentityTraits traits = this.getIdmWebServiceDelegate().search(fullId);
//			System.out.print( edipis[i] + ", " + traits.getVpid().getKeyValueAsString() + ", " + traits.getSsnText() + ", " + traits.getBirthRecord().getBirthDate().getStandardFormat() + ", " + traits.getGender().getCode() + ", " + traits.getLegalName().getFamilyName() + ", " + traits.getLegalName().getGivenName() + ", " );
//			try {
//				traits = this.getPersonService().getESRCorrelation(traits.getVpid());
//			} catch (ServiceException se)
//			{
//				traits = null;
//				if (se.getMessage().indexOf("PI,USVHA,200ESR") > 0)
//					System.out.println("NO");
//				else
//					throw se;
//			}
//			
//			if (traits != null)
//				System.out.println("YES");
//		}
//
//	}
//	
//	public void testSearchDod() throws Exception {
//    	try {
//    		String[] vpids = {"1008590775V635010",
//    				"1008590710V899318",
//    				"1008590736V333355",
//    				"1008590759V367283",
//    				"1008590728V283240",
//    				"1008590720V128584",
//    				"1008590715V310891",
//    				"1008590722V437868"}; 
//    		//yyyyMMdd
//    		String[] dods = {"20010102",
//    				"19991231",
//    				"20110624",
//    				"20111005",
//    				"20100508",
//    				"20090105",
//    				"20101111",
//    				"20080808"
//    		};
//
//    		PersonIdentityTraits traits = null;
//    		for (int i = 0; i< vpids.length ; i++) {
//    			traits = getIdmWebServiceDelegate().search(new FullyQualifiedIdentity(vpids[i]));
//    			Assert.assertEquals(dods[i], traits.getDateOfDeathText());
//    		}
//    	} catch(Exception e) {
//    		e.printStackTrace();
//    	}
//	}
//	public void testAddPerson() throws Exception {
//		IdmServiceVO idmServiceVO = createIdmServiceVO();
//		getIdmWebServiceDelegate().addPerson(idmServiceVO);
//	}
//	
//	
//	
//	public void testAddPreferedFacility() throws Exception {
//		IdmServiceVO idmServiceVO = createIdmServiceVO();
//		VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001008590803V665353000000");
//		idmServiceVO.setVpid(key);
//		idmServiceVO.setPreferredFacilty(getLookupService().getVaFacilityByStationNumber("553"));
//		getIdmWebServiceDelegate().addPreferredFacility(idmServiceVO);
//	}
//	
//	
//	
//	public void testAddCorrelation() throws Exception {
//		// 375137257  0000001008591808V952911000000
//		VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001008591808V952911000000");
//		PersonIdentityTraits traits = getIdmWebServiceDelegate().getESRCorrelation(key);
//		IdmServiceVO idmServiceVO = this.convertTraitsToIdmServiceVO(traits);
//		idmServiceVO.setVpid(key);
//		getIdmWebServiceDelegate().addCorrelation(idmServiceVO);
//	}
//	public void testAddESRCorrelation() throws Exception {
//		// 375137257  0000001008591808V952911000000
//		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375137257"));
//		Person onFile = this.getPersonService().getPerson(personKey);
//		this.getPersonService().addESRCorrelation(onFile);
//		VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001008591808V952911000000");
//		PersonIdentityTraits traits = getIdmWebServiceDelegate().getESRCorrelation(key);
//		System.out.println(traits);		
// 		List list = getIdmWebServiceDelegate().getCorrelationsByVPID(key);
//		System.out.println("number of correlations="+list.size());		
//	}
//	
//	public void testCheckAddCorrelation() throws Exception {
//		// 374773268 has enrollment
//		// 375137257 did not have enrollment so will follow entire path
//		// This tests populate1302Person in the IdmWebServiceDelegateImpl 
//		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375137257"));
//		
//		Person onFile = this.getPersonService().getPerson(personKey);
//
//		System.out.println("vpid=" +onFile.getVPIDValue());		
//		this.getPersonService().checkAndAddESRCorrelation(onFile);
//	}
//	
//	public void testUpdateProfile() throws Exception {
//		
//    	// get ESR Correlation first
//		VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001008591029V157554000000");
//		PersonIdentityTraits traits = getIdmWebServiceDelegate().getESRCorrelation(key);
//
//		// overlay address data and call update person
//		IdmServiceVO idmServiceVO = convertTraitsToIdmServiceVO(traits);
//	    // use long vpid form for 200ESR correlation
//		idmServiceVO.setVpid(key);			
//		idmServiceVO.setMothersMaidenName("MOTHERMAIDENWED");
//		getIdmWebServiceDelegate().updatePerson(idmServiceVO);        
//	}	
//	
//	public void testUpdatePVWithSSN() throws Exception {
//		
//    	//mimic UI: get PV first, then update (either ssn verification status or pseudo ssn reason)
//		//to 200ESR Correlation 
//		String shortVpid = "1008590759V367283";
//		VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("000000" + shortVpid + "000000");
//		
//		PersonIdentityTraits pvTraits = getIdmWebServiceDelegate().search(new FullyQualifiedIdentity(shortVpid));
//
//		SSN ssn = pvTraits.getSsn();
//		
//		//set ssn verification status
//		//ssn.setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.IN_PROCESS.getCode()));
//		
//		//set pesudo ssn reason
//		ssn.setPseudoSSNReason(this.getLookupService().getPseudoSSNReasonByCode("R"));
//		
//		IdmServiceVO idmServiceVO = convertTraitsToIdmServiceVO(pvTraits);
//	    // use long vpid form for 200ESR correlation
//		idmServiceVO.setVpid(key);			
//		getIdmWebServiceDelegate().updatePerson(idmServiceVO);    
//		
//    	// get an ESR Correlation with a record with verification status = "4" verifiied 
//		PersonIdentityTraits esrTraits = this.getPersonService().getESRCorrelation(CommonEntityKeyFactory.createVPIDEntityKey("0000001008590775V635010000000"));
//		assertEquals(SSAVerificationStatus.VERIFIED.getCode(), esrTraits.getSsn().getSsaVerificationStatus().getCode());
//		
//	}
//	public void testUpdateProfileMaidenName() throws Exception {
//
//		// get ESR Correlation first
//		VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001008591260V853395000000");
//		PersonIdentityTraits traits = getIdmWebServiceDelegate().getESRCorrelation(key);
//
//		// overlay address data and call update person
//		IdmServiceVO idmServiceVO = convertTraitsToIdmServiceVO(traits);
//		// use long vpid form for 200ESR correlation
//		idmServiceVO.setVpid(key);
//		
//		idmServiceVO.setMothersMaidenName("MOTHERMAIDENWW");
//		getIdmWebServiceDelegate().updatePerson(idmServiceVO);        
//	}		
//	public void testOneTimeUpdateLegalName() throws Exception {
//
//		// get ESR Correlation first
//		VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001008591260V853395000000");
//		PersonIdentityTraits traits = getIdmWebServiceDelegate().getESRCorrelation(key);
//
//		// overlay address data and call update person
//		IdmServiceVO idmServiceVO = convertTraitsToIdmServiceVO(traits);
//		// use long vpid form for 200ESR correlation
//		idmServiceVO.setVpid(key);
//
//		//traits1.addName(legalName);
//		Set names = idmServiceVO.getNames();
//		if (names != null && names.size() > 0) {
//			Iterator nameItr = names.iterator();
//			while (nameItr.hasNext()) {
//				Name currName = (Name) nameItr.next();
//				// CCR 11486 enforce the legal name restriction
//				if ( currName.getType() != null && 
//						NameType.LEGAL_NAME.getCode().equals(currName.getType().getCode())){
//					currName.setFamilyName("SMITH");
//					currName.setGivenName("JIM");
//					currName.setType(getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getName()));
//					break;
//				}
//			}
//		}		
//		
//		idmServiceVO.setMothersMaidenName("MOTHERMAIDENTHUR");
//		getIdmWebServiceDelegate().updatePerson(idmServiceVO);        
//	}			
//	
//	public void testGetESRCorrelation() throws Exception {
//		try {
//			//0000001008591260V853395000000
//			//0000001008591029V157554000000
//			// 0000001008591808V952911000000
//			// 0000001008591016V221494000000 GOOD
//			String[] vpids= {
//					   "0000001008593239V627553000000",
//			           "0000001008593240V061486000000",
//			           "0000001008593252V258997000000",
//			           "0000001008593248V559649000000",
//			           "0000001008593253V031882000000",
//			           "0000001008593257V642414000000",
//			           "0000001008593263V664448000000",
//			           "0000001008593275V151004000000",
//			           "0000001008593263V664448000000",
//			           "0000001008593275V151004000000",
//			           "0000001008593270V946637000000",
//			           "0000001008593272V583451000000",
//			           "0000001008593273V299310000000",
//			           "0000001008593274V028279000000",
//			           "0000001008593276V337526000000",
//			           "0000001008593285V227356000000",
//			           "0000001008593286V055218000000",
//			           "0000001008593288V362505000000",
//			           "0000001008593289V416927000000",
//			           "0000001008593293V907967000000"
//	
//			};
//			
//			VPIDEntityKey key = null;
//			PersonIdentityTraits traits = null;
//			
//			for (int i =0; i< vpids.length; i++)
//			{
//				key = CommonEntityKeyFactory.createVPIDEntityKey(vpids[i]);
//				traits = getIdmWebServiceDelegate().getESRCorrelation(key);
//				if (traits == null)
//					System.out.println(vpids[i] + ": NO");
//				else
//					System.out.println(vpids[i] + ": YES");
//			}
//		} catch(Exception e) {
//			e.printStackTrace();
//		}
//	}
//
//	
//	public void testSearchCompositeCallByVPID() throws Exception {
//		try {
//			//0000001008590759V367283000000 - has 200ESR Correlation
//			//
//			PersonIdentityTraits traits = getIdmWebServiceDelegate().searchWithCompositeCall(new FullyQualifiedIdentity("0000001008591260V853395000000"), false);
//			
//			Assert.assertEquals("Y", traits.has200ESRCorrelation());
//
//		} catch(Exception e) {
//			e.printStackTrace();
//		}
//	}
//	
//	public void testUpdate200ESRCorrelation() throws Exception {
//		try {
//			// get ESR Correlation first
//			VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("0000001008591260V853395000000");
//			PersonIdentityTraits traits = getIdmWebServiceDelegate().getESRCorrelation(key);
//
//			// overlay address data and call update person
//			IdmServiceVO idmServiceVO = convertTraitsToIdmServiceVO(traits);
//			
//		    // use long vpid form for 200ESR correlation
//			idmServiceVO.setVpid(key);			
//
//			Address address = createAddress();
//			address.setType(getLookupService().getAddressTypeByCode("P"));
//			address.setPhoneNumber(homePhone);			
//			overlayAddress(idmServiceVO, address);
//			
//			getIdmWebServiceDelegate().updatePerson(idmServiceVO);
//		} catch(Exception e) {
//			e.printStackTrace();
//		}
//	}
//
//    private IdmServiceVO convertTraitsToIdmServiceVO(PersonIdentityTraits traits) throws ServiceException
//	{    
//		IdmServiceVO idmServiceVO = new IdmServiceVO();
//	    
//		idmServiceVO.setNames(traits.getNames());
//	    SSN ssnOfficial = traits.getSsn();
//	    if( ssnOfficial != null ) {
//	    	idmServiceVO.setSsn(ssnOfficial);
//	    }
//	    idmServiceVO.setGender(traits.getGender());
//	    idmServiceVO.setBirthRecord(traits.getBirthRecord());
//	    idmServiceVO.setVpid(traits.getVpid());
//	    idmServiceVO.setPatientType(traits.getPatientType());
//	    idmServiceVO.setVeteran(traits.isVeteran());
//	    idmServiceVO.setServiceConnected(traits.isServiceConnected());
//	    idmServiceVO.setPreferredFacilty(traits.getPreferredFacilty());
//	    idmServiceVO.setMothersMaidenName(traits.getMothersMaidenName());
//
//	    return idmServiceVO;
//	}
//    
//    private void overlayAddress(IdmServiceVO idmServiceVO, Address address) {
//    	idmServiceVO.addAddress(address);
//     }
//	
//	private PersonIdentityTraits createTraits() throws Exception  {
//		String personId = "686";
//
//		//Person person = getPersonService().getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(personId));
//		
//		
//		PersonIdentityTraits traits = new PersonIdentityTraits();
//		//traits.setNames(person.getNames());
//		
//	
//		Name lName = new Name();
//		
//		String prefixName = "";
//		
//		
//		lName.setGivenName(firstName);
//		lName.setMiddleName(middleName);
//		lName.setFamilyName(lastName);
//		//lName.setType();
//		//lName.setType(gov.va.med.esr.common.model.lookup.NameType.LEGAL_NAME.getCode());
//		HashSet names = new HashSet();
//		names.add(lName);
//		traits.setNames(names);
//	
//		BirthRecord br = new BirthRecord();
//		br.setBirthDate(new ImpreciseDate(dob));
//		traits.setBirthRecord(br);
//		Gender gender = getLookupService().getGenderByCode("M");
//		traits.setGender(gender);
//		
//		
//		Address permAddress = new Address();
//		permAddress.setLine1(addLine1);
//		permAddress.setLine2(addLine2);
//		permAddress.setLine3("");
//		permAddress.setCity(addCity);
//		permAddress.setZipCode("20148");
//		permAddress.setZipPlus4("1234");
//		permAddress.setPostalCode(addZip);
//		permAddress.setState(addState);
//		permAddress.setCountry("USA");
//		permAddress.setPhoneNumber(homePhone);
//		permAddress.setType(getLookupService().getAddressTypeByCode("P"));
//		traits.addAddress(permAddress);
//		
//		/**
//		traits.setAddress(person.getPermanentAddress());
//		traits.setBirthRecord(person.getBirthRecord());
//		traits.setGender(person.getGender());
//		traits.setSsn((SSN)person.getSsns().iterator().next());
//		**/
//		
//		SSN ssN = new SSN();
//		ssN.setSsnText(ssn);
//		traits.setSsn(ssN);
//		return traits;
//	}
//	
//	
//	
//	private IdmServiceVO createIdmServiceVO() throws Exception  {
//	
//		IdmServiceVO idmServiceVO = new IdmServiceVO();
//	
//		Name lName = new Name();
//				
//		lName.setGivenName(firstName);
//		lName.setMiddleName(middleName);
//		lName.setFamilyName(lastName);
//		lName.setType(this.getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getCode()));
//		HashSet names = new HashSet();
//		names.add(lName);
//		idmServiceVO.setNames(names);
//	
//		BirthRecord br = new BirthRecord();
//		br.setBirthDate(new ImpreciseDate(dob));
//		idmServiceVO.setBirthRecord(br);
//		Gender gender = getLookupService().getGenderByCode("M");
//		idmServiceVO.setGender(gender);
//		
//		
//		Address permAddress = new Address();
//		permAddress.setLine1(addLine1);
//		permAddress.setLine2(addLine2);
//		permAddress.setLine3("");
//		permAddress.setCity(addCity);
//		permAddress.setZipCode("20148");
//		permAddress.setZipPlus4("1234");
//		permAddress.setPostalCode(addZip);
//		permAddress.setState(addState);
//		permAddress.setCountry("USA");
//		permAddress.setPhoneNumber(homePhone);
//		permAddress.setType(getLookupService().getAddressTypeByCode("P"));
//		idmServiceVO.addAddress(permAddress);
//		
//		idmServiceVO.setPatientType("7");
//		SSN ssN = new SSN();
//		ssN.setSsnText(ssn);
//		idmServiceVO.setSsn(ssN);
//		return idmServiceVO;
//	}
//	
//
//	public void testCCR11777_SSNVerificationDate() throws Exception {
//		
//    	// search and update the EffectiveTime element.  The date value used depends on the ssn verification status 
//		String shortVpid = "1008593885V358130";
//		VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey("000000" + shortVpid + "000000");
//		
//		PersonIdentityTraits traits = getIdmWebServiceDelegate().search(new FullyQualifiedIdentity(shortVpid));
//
//		SSN ssn = traits.getSsn();
//		
//		//set ssn verification status
//		
//		// 1 - in_process + ssa sent date  (ONLY works within 1 hr of a new person being created)
//	    ssn.setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.IN_PROCESS.getCode()));
//		Date dateVal = new SimpleDateFormat("yyyyMMdd").parse("20120506");
//		ssn.setSsaSentDate(dateVal);
//		IdmServiceVO idmServiceVO = convertTraitsToIdmServiceVO(traits);
//	    // use long vpid form for 200ESR correlation
//		idmServiceVO.setVpid(key);			
//		getIdmWebServiceDelegate().updatePerson(idmServiceVO);    
//		
//    	// get the ESR Correlation
//		PersonIdentityTraits esrTraits = this.getPersonService().getESRCorrelation(key);
//		assertEquals(SSAVerificationStatus.IN_PROCESS.getCode(), esrTraits.getSsn().getSsaVerificationStatus().getCode());
//		assertEquals(dateVal, esrTraits.getSsn().getSsaSentDate());
//	
//		
//		// 2 - invalid per SSA & SSA_RECEIVED_DATE
//		traits = getIdmWebServiceDelegate().search(new FullyQualifiedIdentity(shortVpid));
//		ssn = traits.getSsn();
//		ssn.setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.INVALID_PER_SSA.getCode()));
//		dateVal = new SimpleDateFormat("yyyyMMdd").parse("20101025");
//		ssn.setSsaReceivedDate(dateVal);
//		idmServiceVO = convertTraitsToIdmServiceVO(traits);
//	    // use long vpid form for 200ESR correlation
//		idmServiceVO.setVpid(key);			
//		getIdmWebServiceDelegate().updatePerson(idmServiceVO);    
//		
//    	// get the ESR Correlation
//		esrTraits = this.getPersonService().getESRCorrelation(key);
//		assertEquals(SSAVerificationStatus.INVALID_PER_SSA.getCode(), esrTraits.getSsn().getSsaVerificationStatus().getCode());
//		assertEquals(dateVal, esrTraits.getSsn().getSsaReceivedDate());
//
//		// 4 (verified) & SSA_VERIFIED_DATE 
//		traits = getIdmWebServiceDelegate().search(new FullyQualifiedIdentity(shortVpid));
//		ssn = traits.getSsn();
//		ssn.setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.VERIFIED.getCode()));
//		dateVal = new SimpleDateFormat("yyyyMMdd").parse("20110319");
//		ssn.setSsaVerificationDate(dateVal);
//		idmServiceVO = convertTraitsToIdmServiceVO(traits);
//	    // use long vpid form for 200ESR correlation
//		idmServiceVO.setVpid(key);			
//		getIdmWebServiceDelegate().updatePerson(idmServiceVO);    
//		
//    	// get the ESR Correlation
//		esrTraits = this.getPersonService().getESRCorrelation(key);
//		assertEquals(SSAVerificationStatus.VERIFIED.getCode(), esrTraits.getSsn().getSsaVerificationStatus().getCode());
//		assertEquals(dateVal, esrTraits.getSsn().getSsaVerificationDate());
//
//		// 4 (verified) & NULL SSA_VERIFIED_DATE 
//		traits = getIdmWebServiceDelegate().search(new FullyQualifiedIdentity(shortVpid));
//		ssn = traits.getSsn();
//		ssn.setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.VERIFIED.getCode()));
//		ssn.setSsaVerificationDate(null);
//		idmServiceVO = convertTraitsToIdmServiceVO(traits);
//	    // use long vpid form for 200ESR correlation
//		idmServiceVO.setVpid(key);			
//		getIdmWebServiceDelegate().updatePerson(idmServiceVO);    
//		
//    	// get the ESR Correlation
//		esrTraits = this.getPersonService().getESRCorrelation(key);
//		assertEquals(SSAVerificationStatus.VERIFIED.getCode(), esrTraits.getSsn().getSsaVerificationStatus().getCode());
//		assertEquals(dateVal, esrTraits.getSsn().getSsaVerificationDate());
//
//		// 0 - NEW_RECORD & SSA_RECEIVED_DATE (should be rejected)
//		traits = getIdmWebServiceDelegate().search(new FullyQualifiedIdentity(shortVpid));
//		ssn = traits.getSsn();
//		ssn.setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.NEW_RECORD.getCode()));
//		dateVal = new SimpleDateFormat("yyyyMMdd").parse("20101025");
//		ssn.setSsaReceivedDate(dateVal);
//		idmServiceVO = convertTraitsToIdmServiceVO(traits);
//	    // use long vpid form for 200ESR correlation
//		idmServiceVO.setVpid(key);			
//		getIdmWebServiceDelegate().updatePerson(idmServiceVO);    
//		
//    	// get the ESR Correlation
//		esrTraits = this.getPersonService().getESRCorrelation(key);
//		assertNotSame(SSAVerificationStatus.NEW_RECORD.getCode(), esrTraits.getSsn().getSsaVerificationStatus().getCode());
//	}
//
//	public IdmWebServiceDelegate getIdmService() {
//		return idmService;
//	}
//
//
//
//	public void setIdmService(IdmWebServiceDelegate idmService) {
//		this.idmService = idmService;
//	}
//
//	private IdmWebServiceDelegate idmService;
//	
//	
	
}