package gov.va.med.esr.service;

import gov.va.med.esr.common.batchprocess.HealthBenefitPlanData;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.comms.HandBookDocument;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.comms.HandBookMailStatus;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.DescriptorType;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.service.impl.HandBookServiceImpl;

import java.util.Calendar;
import java.util.List;
import java.math.BigDecimal;
import java.util.Date;

public class HandBookServiceTest extends RuleAbstractTestCase{
  
	private PersonService personService = null;

	   /**
     * Login with a user that has permissions to perform test PSIM searches.
     * @throws Exception
     */
    protected void customSetUp() throws Exception
    {
        super.customSetUp();
        UserCredentials credentials = new UserCredentials();
        credentials.setUserID("bea");
        credentials.setPassword("bea");
        loginManager.login(credentials);
    }

    
    public void testSave() throws Exception {
    	
    	HealthBenefitPlanData healthBenefitPlanData = new HealthBenefitPlanData();
    	/**
    	F400H ^123456789^2004341118V132456^Enrollment^EN01^EN01001
    	F400H ^123456789^2004341118V132456^Dental^DN01^DN01001
    	F400H ^123456789^2004341118V132456^EyeGlasses^EY01^EY01001
    	private String productID;
    	private String handbookRequestId;
    	private String vpid;
    	private String categoryCode;
    	private String healthBenefitCode;
    	private String coveragePlanCode; 
    	private String releaseControlNumber;
    	**/
    	healthBenefitPlanData.setProductID("F400H");
    	healthBenefitPlanData.setHandbookRequestId("1234567103");
    	healthBenefitPlanData.setIcn("2004341118V132456");
    	healthBenefitPlanData.setCategoryCode("Enrollment");
    	healthBenefitPlanData.setHealthBenefitCode("EN01");
    	healthBenefitPlanData.setCoveragePlanCode("EY01001");
    	healthBenefitPlanData.setReleaseControlNumber("001");
    	
    	try{
    		saveHealthBenefitPlan(healthBenefitPlanData);
    		//setComplete();
    	}catch ( Exception e ) {
    			e.printStackTrace();	
    	}
    }
    
    
    
    
	public void saveHealthBenefitPlan(
			HealthBenefitPlanData healthBenefitPlanData)
			throws Exception {
		String pdfFileLocation = "D:\\bea\\projects\\ESR.3.0.0\\DNS   kavurt_HECMS_Dev_04_esr35\\vobs\\HECMS_common\\config\\test\\data\\batchprocess\\handbook";
		//getHandBookService().processHealthBenefitsPlanRecord(healthBenefitPlanData, pdfFileLocation);
	}

	
	   public void testGetHandBookDocument() throws Exception {
		   
		   Person person = null;
		   

            HandBookService srv = (HandBookService)applicationContext.getBean("handBookService");
            HandBookMailQueue mailQ = srv.findHandBookByIdentifier("10"); //get a null document one
            HandBookMailStatus status = mailQ.getHandBookMailStatus();
            HandBookDocument doc = status.getDocument();
            
 //           this.assertEquals(doc, null);
            
            HandBookMailStatusType statusType = null;
            
            //Update status to SENT_TO_CMS
            
            statusType = this.getLookupService()
            	.getHandBookMailingStatusTypeByCode(HandBookMailStatusType.SENT_TO_CMS.getCode()); //40005
            mailQ.getHandBookMailStatus().setStatusType(statusType);

            personService = (PersonService) this.applicationContext.getBean("personService");
    		Person p = personService.getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(String.valueOf(mailQ.getPersonId())));
    		

            //Update Address
          //  Address addr = mailQ.getPerson().getPermanentAddress(); 
    		Address addr = p.getPermanentAddress(); 
    		mailQ.setAddressId((BigDecimal)addr.getEntityKey().getKeyValue());
    		
    		//Update Document
//    		doc = new HandBookDocument();
//    		doc.setDocumentText("Test From George 2");
//    		doc.setMailStatus(status);
//    		status.setDocument(doc);
//
//    		getHandBookService().saveHandBookMailQueue(mailQ);
//    		
//    		/* Update status to REJECT_AT_HEC */
//    		
//            statusType = this.getLookupService()
//            	.getHandBookMailingStatusTypeByCode(HandBookMailStatusType.REJECT_AT_HEC.getCode()); //40001
//            mailQ.getHandBookMailStatus().setStatusType(statusType);
//
//
//    		mailQ.getHandBookMailStatus().setErrorText("Error Text From George 2");
//    		
    		getHandBookService().saveHandBookMailQueue(mailQ);

    		
	   }
	   
	   

	   public void testDeliveryPreference() throws Exception {

		   //BigDecimal personId = new BigDecimal(373961091);
		   String personId = "373961091";

		   HandBookService srv = (HandBookService)applicationContext.getBean("handBookService");
		   //Get delvivery preference
		   DeliveryPreference deliveryPreference = srv.findDeliveryPreferenceByPersonId(personId);
		   // Find editable field
		   srv.findDeliveryPreferenceEditableStatusByPersonId(personId);

		   deliveryPreference.setChangeDate(new Date());

		   // update  delivery Prefernece
		   srv.saveDeliveryPreference(deliveryPreference);
	   }
	   protected PersonService getPersonService() throws Exception {
		   if (personService == null)
			   personService = (PersonService) this.applicationContext
			   .getBean("personService");
		   return personService;
	   }
	   public void createPersonWithHardship() throws Exception {
		   Person onFile = buildSimplePerson(); // bare-bones person
		   this.attachApplication(onFile);
		   onFile.getApplication().setApplicationDate(getDate(2006, 1, 1));
		   this.attachVerifiedEnrollment(onFile);
		   this.setEligibilityStatusToVerified(onFile);
		   onFile.getEnrollmentDetermination().setPriorityGroup(
				   this.getLookupService().getEnrollmentPriorityGroupByCode(
						   EnrollmentPriorityGroup.GROUP_5.getCode()));
		   IncomeTest incomeTest = this.createIncomeTest(
				   IncomeTestType.CODE_MEANS_TEST,
				   MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT, new Integer(2011));
		   onFile.setIncomeTest(new Integer(2011), incomeTest);		   
		   
		   VAFacility fac = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);
		   Hardship hardship = this.createHardship("test1");
		   hardship.setEffectiveDate(this.getDate(2008, 0, 1));
		   hardship.setSiteGrantingHardship(fac);
		   onFile.getIncomeTest(new Integer(2011)).setHardship(hardship);		   
		   Person incoming = savePerson(onFile);
		   this.setComplete();
		   System.out.println("Person id="
				   + incoming.getPersonEntityKey().getKeyValueAsString());
	   }
	   
	   public void createPersonWithRx() throws Exception {
		   Person onFile = buildSimplePerson(); // bare-bones person
		   this.attachApplication(onFile);
		   onFile.getApplication().setApplicationDate(getDate(2006, 1, 1));
		   this.attachVerifiedEnrollment(onFile);
			PurpleHeart purpleHeart = new PurpleHeart();
			purpleHeart.setPhIndicator(Boolean.TRUE);
			onFile.addDecoration(purpleHeart);
			this.setPurpleHeartStatus(DecorationStatus.CODE_CONFIRMED, onFile);
		  
		   this.setEligibilityStatusToVerified(onFile);
		   onFile.getEnrollmentDetermination().setPriorityGroup(
				   this.getLookupService().getEnrollmentPriorityGroupByCode(
						   EnrollmentPriorityGroup.GROUP_3.getCode()));

		   IncomeTest incomeTest = this.createIncomeTest(
				   IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST,
				   MeansTestStatus.MT_STATUS_EXEMPT, new Integer(2011));
		   onFile.setIncomeTest(new Integer(2011), incomeTest);

		   VAFacility fac = (VAFacility) this.getLookupService().getByCode(
				   VAFacility.class, VAFacility.CODE_CONNECTICUT_HCS);
		   Hardship hardship = this.createHardship("test1");
		   hardship.setEffectiveDate(this.getDate(2008, 0, 1));
		   hardship.setSiteGrantingHardship(fac);
		   onFile.getIncomeTest(new Integer(2011)).setHardship(hardship);
		   Person incoming = savePerson(onFile);
		   this.setComplete();
		   System.out.println("Person id="
				   + incoming.getPersonEntityKey().getKeyValueAsString());
	   }	   

	   public void createPersonWithMedicaid() throws Exception {
		   Person onFile = buildSimplePerson(); // bare-bones person
		   this.attachApplication(onFile);
		   onFile.getApplication().setApplicationDate(getDate(2006, 1, 1));
		   this.attachVerifiedEnrollment(onFile);
		   this.setEligibilityStatusToVerified(onFile);
		   onFile.getEnrollmentDetermination().setPriorityGroup(
				   this.getLookupService().getEnrollmentPriorityGroupByCode(
						   EnrollmentPriorityGroup.GROUP_5.getCode()));
		   IncomeTest incomeTest = this.createIncomeTest(
				   IncomeTestType.CODE_MEANS_TEST,
				   MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT, new Integer(2011));
		   onFile.setIncomeTest(new Integer(2011), incomeTest);		   
		   
		   VAFacility fac = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);
		   this.attachMedicaidFactor(onFile);
		   onFile.getMedicaidFactor().setLastUpdateDate(getDate(2011,1,1));		   
		   Person incoming = savePerson(onFile);
		   this.setComplete();
		   System.out.println("Person id="
				   + incoming.getPersonEntityKey().getKeyValueAsString());
	   }
	   
	   public void testHandbookRxChange() throws Exception {
		   //375326966
		   PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375327015"));        
		   Person onFile = this.getPersonService().getPerson(personKey);

		   VAFacility fac = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);
		   Person incoming = (Person)onFile.clone();
		   incoming.getEligibilityVerification().setVerificationMethod("test444444");
		   VerificationInfo vi = new VerificationInfo("x",MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		   vi.setSiteNumber(fac.getCode());		   
		   Person updated = this.getMessagingService().processZ07(incoming, fac,vi);
	   }
	   
	   public void testHandbookMedicaidTriggerRemoval() throws Exception {
		  // Person onFile = this 375326856
		   PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375326872"));        
		   Person onFile = this.getPersonService().getPerson(personKey);

		   VAFacility fac = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);
		   Person incoming = (Person)onFile.clone();
		   incoming.getEligibilityVerification().setVerificationMethod("test444444");
		   VerificationInfo vi = new VerificationInfo("x",MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		   vi.setSiteNumber(fac.getCode());		   
		   incoming.getMedicaidFactor().setLastUpdateDate(new Date());
		   Person updated = this.getMessagingService().processZ07(incoming, fac,vi);
		   /* BEFORE see how medicaid triggered insert for date change (not good)
(+) activate rule : HandBookTriggerVeteransSWAsiaConditionChanged
(+) add rule instance : HandBookTriggerVeteransSWAsiaConditionChanged@b5e631  
(->) fire rule instance : HandBookTriggerVeteransSWAsiaConditionChanged@b5e631
(-) deactivate rule : HandBookTriggerVeteransSWAsiaConditionChanged
(+) activate rule : HandBookTriggerVeteransMedicaidChanged
(+) add rule instance : HandBookTriggerVeteransMedicaidChanged@f7706a 
(->) fire rule instance : HandBookTriggerVeteransMedicaidChanged@f7706a
(-) deactivate rule : HandBookTriggerVeteransMedicaidChanged
(+) activate rule : isHandbookBenefitAlreadySend
(+) add rule instance : isHandbookBenefitAlreadySend@ec184f 
(->) fire rule instance : isHandbookBenefitAlreadySend@ec184f
(-) deactivate rule : isHandbookBenefitAlreadySend
(+) activate rule : isHandBookRollOutOver
(+) add rule instance : isHandBookRollOutOver@13c0dd3
(->) fire rule instance : isHandBookRollOutOver@13c0dd3
(-) deactivate rule : isHandBookRollOutOver
		    */
		   
	/*  AFTER - no medicaid evaluation and no trigger of insert
(+) activate rule : HandBookTriggerVeteransSWAsiaConditionChanged
(+) add rule instance : HandBookTriggerVeteransSWAsiaConditionChanged@1ced5e1 
(->) fire rule instance : HandBookTriggerVeteransSWAsiaConditionChanged@1ced5e1
(-) deactivate rule : HandBookTriggerVeteransSWAsiaConditionChanged
(+) activate rule : HandBookTriggerVeteransPrescriptionCoPayStatusChanged
(+) add rule instance : HandBookTriggerVeteransPrescriptionCoPayStatusChanged@3bb1f6
(->) fire rule instance : HandBookTriggerVeteransPrescriptionCoPayStatusChanged@3bb1f6
(-) deactivate rule : HandBookTriggerVeteransPrescriptionCoPayStatusChanged
(+) activate rule : HandBookTriggerVeteransBadAddTextRemoved
(+) add rule instance : HandBookTriggerVeteransBadAddTextRemoved@120ad65
(->) fire rule instance : HandBookTriggerVeteransBadAddTextRemoved@120ad65
(-) deactivate rule : HandBookTriggerVeteransBadAddTextRemoved
(+) activate rule : HandBookTriggerVeteransPreferredFacilityChanged
(+) add rule instance : HandBookTriggerVeteransPreferredFacilityChanged@b3461 
(->) fire rule instance : HandBookTriggerVeteransPreferredFacilityChanged@b3461
(-) deactivate rule : HandBookTriggerVeteransPreferredFacilityChanged
	 */	   
	   }

	   public void testHandbookHardshipTriggerRemoval() throws Exception {
		   // Fixing bug where Person with Hardship ALWAYS causes trigger of insert.
		   //375326691
		   PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375326707"));        
		   Person onFile = this.getPersonService().getPerson(personKey);

		   VAFacility fac = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);
		   Person incoming = (Person)onFile.clone();
		   incoming.getEligibilityVerification().setVerificationMethod("test444444");
		   VerificationInfo vi = new VerificationInfo("x",MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		   vi.setSiteNumber(fac.getCode());		   
		   Person updated = this.getMessagingService().processZ07(incoming, fac,vi);
		   /* BEFORE
(-) deactivate rule : HandBookTriggerVeteransGenderChanged
(+) activate rule : HandBookTriggerVeteransMeansTestStatusChanged
(+) add rule instance : HandBookTriggerVeteransMeansTestStatusChanged@c255b4  
(->) fire rule instance : HandBookTriggerVeteransMeansTestStatusChanged@c255b4
(-) deactivate rule : HandBookTriggerVeteransMeansTestStatusChanged
(+) activate rule : HandBookTriggerVeteransHardshipChanged
(+) add rule instance : HandBookTriggerVeteransHardshipChanged@88cbff 
(->) fire rule instance : HandBookTriggerVeteransHardshipChanged@88cbff
(-) deactivate rule : HandBookTriggerVeteransHardshipChanged
(+) activate rule : isHandbookBenefitAlreadySend
(+) add rule instance : isHandbookBenefitAlreadySend@59ae6
(->) fire rule instance : isHandbookBenefitAlreadySend@59ae6
(-) deactivate rule : isHandbookBenefitAlreadySend
(+) activate rule : isHandBookRollOutOver
(+) add rule instance : isHandBookRollOutOver@1ec1db0 
(->) fire rule instance : isHandBookRollOutOver@1ec1db0
(-) deactivate rule : isHandBookRollOutOver
		    */

		   /* AFTER - no more Hardship rule
(+) activate rule : HandBookTriggerVeteransGenderChanged
(+) add rule instance : HandBookTriggerVeteransGenderChanged@17b463f
(->) fire rule instance : HandBookTriggerVeteransGenderChanged@17b463f
(-) deactivate rule : HandBookTriggerVeteransGenderChanged
(+) activate rule : HandBookTriggerVeteransMeansTestStatusChanged
(+) add rule instance : HandBookTriggerVeteransMeansTestStatusChanged@40e96c  
(->) fire rule instance : HandBookTriggerVeteransMeansTestStatusChanged@40e96c
(-) deactivate rule : HandBookTriggerVeteransMeansTestStatusChanged
(+) activate rule : HandBookTriggerVeteransRadiationExposureMethodChanged
(+) add rule instance : HandBookTriggerVeteransRadiationExposureMethodChanged@19cef21 
(->) fire rule instance : HandBookTriggerVeteransRadiationExposureMethodChanged@19cef21
(-) deactivate rule : HandBookTriggerVeteransRadiationExposureMethodChanged
 
		    */
	   }

	   public void testHandbookZ07() throws Exception {
			// has hardship 373963503
			PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("373963503"));        
			Person onFile = this.getPersonService().getPerson(personKey);
			this.setEligibilityStatusToVerified(onFile);
			Person incoming = savePerson(onFile);
	  	  	VAFacility fac = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);

			this.addPermanentAddress(incoming, Calendar.getInstance().getTime(),
					null);
			VerificationInfo vi = new VerificationInfo("x",
					MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
			incoming.getEligibilityVerification().setEligibilityStatus(
					this.getLookupService().getEligibilityStatusByCode(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode()));
			this.addPermanentAddress(incoming, Calendar.getInstance().getTime(),				null);
			vi.setSiteNumber(fac.getCode());
			Person updated = this.getMessagingService().processZ07(incoming, fac,vi);
			System.out.println("Person id="
					+ updated.getPersonEntityKey().getKeyValueAsString());
			//this.setComplete(); 
		}
		
		public void testHandbookZ07MT() throws Exception {
			// has hardship 373963503
			PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("373971922"));        
			Person onFile = this.getPersonService().getPerson(personKey);
			this.setEligibilityStatusToVerified(onFile);
			Person incoming = savePerson(onFile);
	  	  	VAFacility fac = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);

			this.addPermanentAddress(incoming, Calendar.getInstance().getTime(),
					null);
			VerificationInfo vi = new VerificationInfo("x",
					MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
			incoming.getEligibilityVerification().setEligibilityStatus(
					this.getLookupService().getEligibilityStatusByCode(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode()));
			this.addPermanentAddress(incoming, Calendar.getInstance().getTime(),				null);
			vi.setSiteNumber(fac.getCode());
			Person updated = this.getMessagingService().processZ07(incoming, fac,vi);
			System.out.println("Person id="
					+ updated.getPersonEntityKey().getKeyValueAsString());
			//this.setComplete(); 
		}	
	
		public void testHandbookAdrPerson() throws Exception {
			PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375319532"));        
			Person onFile = this.getPersonService().getPerson(personKey);		
			Person incoming = savePerson(onFile);
			Hardship hardship2 = onFile.getIncomeTest(new Integer(2011)).getHardship();
			hardship2.setReason("junk");		
			this.getEventRuleService().manageHandBookEvents(onFile);
		}	
		
		public void testHandbookAddHardship() throws Exception {
			PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("373963503"));        
			Person onFile = this.getPersonService().getPerson(personKey);
			this.attachMeansTestWithMtCopayExempt(onFile);
			Hardship hardship = this.createHardship("test1");
			hardship.setEffectiveDate(this.getDate(2011, 0, 1));
			onFile.getIncomeTest(new Integer(2011)).setCompletedDate(this.getDate(2011, 1, 1));
			onFile.getIncomeTest(new Integer(2011)).setHardship(hardship);
			
			Person incoming = savePerson(onFile);
			this.setComplete();
		}	
		
		public void testHandbookAdrPersonSC() throws Exception {
			PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("373971922"));        
			Person onFile = this.getPersonService().getPerson(personKey);		
			Person incoming = savePerson(onFile);
			this.attachServiceConnectionAward(incoming, new Integer(87));
			this.getEventRuleService().manageHandBookEvents(incoming);
		}	
		
		
		// CCR 13067 Changing ILOG logic for handbook Insert Triggers
	   public void testHandbookRemoveInsertTriggerChange() throws Exception {
		  // If there is record in "send to CMS", neither Handbook nor Insert can be sent
		  // If there is existing handbook in "sent" "mailed" or "online", for current version, Insert should be sent
		  // Insert is now triggered ONLY when PG changes, other changes should NOT trigger insert
		   PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("376736621"));        
		   Person onFile = this.getPersonService().getPerson(personKey);
		   Person incoming = this.savePerson(onFile);
			   
		   // this will not trigger handbook benefit insert
		   this.attachRadiationExposure(incoming);
		   this.getEventRuleService().manageHandBookEvents(incoming);

		   // this should trigger it
		   incoming.getEnrollmentDetermination().setPriorityGroup(
				   this.getLookupService().getEnrollmentPriorityGroupByCode(
						   EnrollmentPriorityGroup.GROUP_6.getCode()));
		   this.getEventRuleService().manageHandBookEvents(incoming); 
	   }
  
}
