/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java classes
import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.hbp.HealthBenefitPlanDefinition;
import gov.va.med.esr.common.model.hbp.HealthBenefitPlanName;
import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.esr.service.external.demographics.DemographicsChangeEvent;
import gov.va.med.esr.service.external.demographics.DemographicsChangeSummary;
import gov.va.med.esr.service.external.demographics.DemographicsChangeType;
import gov.va.med.esr.service.external.person.VPIDEntityKey;
import gov.va.med.fw.model.EntityKey;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.RandomStringUtils;


public class HBPDefinitionServiceTest extends RuleAbstractTestCase {

     
    private HBPDefinitionService hbpDefinitionService = null;
    
    public HBPDefinitionServiceTest(String testName) {
        super(testName);
    }

    protected void customSetUp() throws Exception { 
        super.customSetUp();
    }
    
    public void testGetHBPNames() throws Exception {
    	List<HealthBenefitPlanName> planNames = this.getHbpDefinitionService().getAllHealthBenefitPlanNames();
    	for (HealthBenefitPlanName planName : planNames) {
    		System.out.println(planName.toString());
     		for (HealthBenefitPlanDefinition hbp : planName.getPlanDefinitions()) {
        		System.out.println(hbp.toString());
     		}
    	}
    }
    
    public void testGetHealthBenefitPlanNameByID() throws Exception {
		EntityKey key = CommonEntityKeyFactory.createHealthBenefitPlanNameEntityKey("24");
    	HealthBenefitPlanName planName = this.getHbpDefinitionService().getHealthBenefitPlanNameByID(key);
		System.out.println(planName.toString());
 		for (HealthBenefitPlanDefinition hbp : planName.getPlanDefinitions()) {
    		System.out.println(hbp.toString());
 		}
    }    
    /**
     * @return Returns the hbpDefinitionService.
     */
    public HBPDefinitionService getHbpDefinitionService() {
        return hbpDefinitionService;
    }

    /**
     * @param hbpDefinitionService The hbpDefinitionService to set.
     */
    public void setHbpDefinitionService(HBPDefinitionService hbpDefinitionService) {
        this.hbpDefinitionService = hbpDefinitionService;
    }    
    

}
    
/*	public void testDateOfDeathFromIdm() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		this.attachMeansTestWithMtCopayExempt(onFile);
	    SSN ssn = this.createSSN(); 
	    ssn.setType(this.getLookupService().getSSNTypeByCode(SSNType.CODE_ACTIVE.getName()));
        onFile.addSsn(ssn);		
		Person incoming = this.savePerson(onFile);	
		VAFacility sendingFacility = this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName());				

		Date dateOfDeath = new Date();
		Person updated = this.getDemographicService().processDateOfDeathFromIdm(incoming, dateOfDeath);
		assertNotNull(updated.getDeathRecord());
		System.out.println("Person id="
				+ updated.getPersonEntityKey().getKeyValueAsString());
		//this.setComplete(); // only enable this when you want to test persistence capability
	}		
	 	
     public void testUpdateAddressForExistingPerson() throws Exception {
		Person person = getPersonService().getPerson(
				CommonEntityKeyFactory.createPersonIdEntityKey("72137"));
		person = (Person) person.clone(); // simulates incoming
		person.getPermanentAddress().setLine3(RandomStringUtils.randomAlphabetic(10));
		this.getDemographicService().updateContactInformation(person);
    }
    
   
  
    public void testUpdateContactInformationAddressForPermanent() throws Exception {
        PhoneType homePhone = this.getLookupService().getPhoneTypeByCode(PhoneType.CODE_HOME.getName());
        EmailType privEmail = this.getLookupService().getEmailTypeByCode(EmailType.CODE_PRIVATE.getName());
        PhoneType busPhone = this.getLookupService().getPhoneTypeByCode(PhoneType.CODE_BUSINESS.getName());
        EmailType busEmail = this.getLookupService().getEmailTypeByCode(EmailType.CODE_BUSINESS.getName());
        
        person.addPhone(this.createPhone(homePhone));
        person.addEmail(this.createEmail(privEmail));
        Person incoming = this.getPersonService().save(person);        
        
        this.addPermanentAddress(incoming, Calendar.getInstance()
                .getTime(), null);

        assertTrue(incoming.getPhones().size() == 1);
        assertTrue(incoming.getEmails().size() == 1);        
        
        incoming.addPhone(this.createPhone(busPhone));
        incoming.addPhone(this.createPhone(busPhone));        
        incoming.addEmail(this.createEmail(busEmail));
        assertTrue(incoming.getPhones().size() == 3);        
        assertTrue(incoming.getEmails().size() == 2);        
        
        Person result = this.getDemographicService().updateContactInformation(incoming);
        this.assessPermanentAddressUpdateResults(incoming, result);
        assertTrue(result.getPhones().size() == 3);        
        assertTrue(result.getEmails().size() == 2);
   }*/
    