package gov.va.med.esr.service;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.EEServiceField;
import gov.va.med.esr.common.model.lookup.EEServiceFieldLite;
import gov.va.med.esr.common.model.lookup.EEServiceGroup;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.security.EEServiceRequest;
import gov.va.med.esr.common.model.security.EEServiceRequestField;
import gov.va.med.esr.common.model.security.EEServiceRequestLite;
import gov.va.med.esr.common.model.security.EEServiceUser;
import gov.va.med.esr.common.model.security.EEServiceUserRequest;
import gov.va.med.esr.common.util.AbstractServiceTestCase;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.model.lookup.AbstractLookup;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EEServiceAdminServiceTest 	extends AbstractServiceTestCase {
    private LookupService lookupSrv = null;
    
    
    
    public void testCreateServicerequest() throws Exception {
    	
    	EEServiceRequest serviecRequest = new EEServiceRequest();
    	serviecRequest.setName("Test Request");
    	serviecRequest.setDescription("Test Description");
        if (lookupSrv == null)
            lookupSrv = this.getLookupService();

        EEServiceGroup serviceGroup = null;
        
        try {
			serviceGroup =  lookupSrv.getEEServiceGroupByCode("ALL");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw e;
		}
		
		addFields(serviecRequest, serviceGroup.getFields());
		addChildGroups(serviecRequest, serviceGroup.getChildGroups());
		
		getEeServiceAdminService().saveEEServiceRequest(serviecRequest);
		
    }
    
    public void testFindRequests() throws Exception {
    	List requests = getEeServiceAdminService().getEEServiceRequests();
    	System.out.println("requests :" + requests);
    	assertNotNull(requests);
    }

    
    public void testFindRequestByKey() throws Exception {
    	
    	EntityKey  key = EntityKeyFactory.createEntityKey("21", EEServiceRequest.class) ;
    	EEServiceRequest request = getEeServiceAdminService().getEEserviceRequest(key);
    	System.out.println("request :" + request);
    	assertNotNull(request);
    }
    
    public void testServiceLookupCDConditionUknownIndicator() throws Exception {
    	//CAT_DSBLTY_CONDITION.PRMNT_DSBLTY_STDYESNO_ID
    	//CDCondition.permanentIndicator - 3 UNKNOWN code
    	AbstractLookup value = getLookupService().getByCode(gov.va.med.esr.common.model.lookup.PermanentIndicator.class, "3");
    	System.out.println("value :"+value);
    	//assertNotNull(value);
    }
    
    public void testServiceLookupCDConditionPermanentIndicator() throws Exception {
    	//CAT_DSBLTY_CONDITION.PRMNT_DSBLTY_STDYESNO_ID
    	//CDCondition.permanentIndicator - 1- FOR PERMANENT
    	AbstractLookup value = getLookupService().getByCode(gov.va.med.esr.common.model.lookup.PermanentIndicator.class, "1");
    	System.out.println("value :"+value);
    	assertNotNull(value);
    	
    	//2- FOR NOT PERMANENT
    	value = getLookupService().getByCode(gov.va.med.esr.common.model.lookup.PermanentIndicator.class, "2");
    	System.out.println("value :"+value);
    	assertNotNull(value);    	
    }
    
    public void testUpdateRequest() throws Exception {
    	EntityKey  key = EntityKeyFactory.createEntityKey("1", EEServiceRequest.class) ;
    	EEServiceRequest request = getEeServiceAdminService().getEEserviceRequest(key);

    	
        if (lookupSrv == null)
            lookupSrv = this.getLookupService();

        EEServiceFieldLite serviceField = null;
        
        try {
			serviceField = (EEServiceFieldLite) getLookupService().getByCode(EEServiceFieldLite.class,"GroupLevel11-F2");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw e;
		}
		
		EEServiceRequestField reqField = new EEServiceRequestField();
		reqField.setEeServiceField(serviceField);
		
		Set removefields = new HashSet();
		removefields.add(reqField);
		
		
		request.removeFields(removefields );
		
		getEeServiceAdminService().saveEEServiceRequest(request);
    	//System.out.println("request :" + request);
    	assertNotNull(request);
    	setComplete();
    	
    }
    
    
    
    public void testFindRequestByName() throws Exception {
    	
    	EEServiceRequest request = getEeServiceAdminService().getEEServicerequestByName("22Test Request");
    	System.out.println("request :" + request);
    	assertNotNull(request);
    }
    
    
    public void testFindRequestFields() throws Exception {
    	Set fields = getEeServiceAdminService().getEEServiceRequestFieldsByRequest(EntityKeyFactory.createEntityKey("101", EEServiceRequest.class));
    	System.out.println("Fields :" + fields);
    }
    
    public void testAddServiceUser() throws Exception {
    	
    	/**
    	EEServiceUser user = new EEServiceUser();
    	user.setUserName("trinadh.kavuri-1");
    	user.setPassword("password");
    	user.setContactName("Trinadh Kavuri");
    	user.setContactPhone("111-222-3333");
    	user.setActive(true);
    	***/
    	
    	EEServiceUser user = getEeServiceAdminService().getEEserviceUser(EntityKeyFactory.createEntityKey("1300017599", EEServiceUser.class));
    	
    	
    	List requests = getEeServiceAdminService().getEEServiceLiteRequests();
    	Set userReqs = new HashSet();
    	
    	
    	for (int i=0; i<requests.size();i++) {
    		EEServiceRequestLite request = (EEServiceRequestLite)requests.get(i);
    		EEServiceUserRequest uReq = new EEServiceUserRequest();
    		uReq.setEeServiceUser(user);
    		uReq.setEeServiceRequestLite(request);
    		user.addEEServiceUserRequest(request);
    	}
    	
    	
    	
    	//user.setEeServiceUserRequests(userReqs);
    	getEeServiceAdminService().saveEEServiceUser(user);
    	
    	System.out.println("user :" + user.getIdentifier());
    }
    
    
    private void addFields(EEServiceRequest serviecRequest,Set fields ) throws Exception{
    	if ( fields == null ) return;
    	
    	Iterator itr = fields.iterator();
    	while ( itr != null && itr.hasNext())
    	{
    		EEServiceField serviceField = (EEServiceField) itr.next();
    		EEServiceFieldLite serviceFieldLite = (EEServiceFieldLite)lookupSrv.getByCode(EEServiceFieldLite.class, serviceField.getCode());
    		EEServiceRequestField requestField = new EEServiceRequestField();
    		requestField.setEeServiceField(serviceFieldLite);
    		serviecRequest.addField(requestField);
    		
    	}
    }
    
    private void addChildGroups(EEServiceRequest serviecRequest,Set childGroups) throws Exception {
    	
    	if (childGroups == null  )  return;
    	
    	Iterator itr = childGroups.iterator();
    	
    	while (itr != null && itr.hasNext()) {
    		EEServiceGroup childGroup = (EEServiceGroup)itr.next();
    		addFields(serviecRequest,childGroup.getFields());
    		addChildGroups(serviecRequest, childGroup.getChildGroups());
    	}
    }
    
    
    
    public void testEESummaryRequests () throws Exception {
    	
    	
		String personId = "20";

		Person person = getPersonService().getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(personId));
		Integer incomeYear = new Integer (2010);

		EESummary eeSummary = getExternalSummaryFactory().buildEESummary(person, incomeYear, "IVMData");
		System.out.println(eeSummary);
		getEeServiceAdminService().applyRequest(eeSummary, "user1","request_financials_only" );
		System.out.println(eeSummary);

    }
}
