package gov.va.med.esr.service;

import java.math.BigDecimal;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.util.RuleAbstractTestCase;



public class BatchProcessTest extends RuleAbstractTestCase {

    public BatchProcessTest() {
        super();
        // TODO Auto-generated constructor stub
    }

    public BatchProcessTest(String testName) {
        super(testName);
        // TODO Auto-generated constructor stub
    }

    
    public void testProcessFutureDatedTestFlag() throws Exception {
        Person person = this.getPerson("20429718");
        
        Person result = this.getFinancialsService().processFutureDatedTestFlag(person.getPersonEntityKey(), new Integer(2005));
        assertNotNull(result);
    }
    
    public void testBuildPerson() throws Exception {
        Person onFile = this.buildSimplePerson();
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT, new Integer(2004));
        incomeTest.setEffectiveDate(this.getDate(2005,1,1));
        onFile.setIncomeTest(new Integer(2004), incomeTest);        
        
        this.attachVerifiedEnrollment(onFile);
        this.setEligibilityStatusToVerified(onFile);
        
        // Make CE
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(this.getDate(2000, 1, 1));
        
        Person incoming = savePerson(onFile);
        
        
        Person result = this.getEligibilityEnrollmentService().updateEligibilityData(incoming);

        this.setComplete();
        
        System.out.println("Person id="
                + result.getPersonEntityKey().getKeyValueAsString());
    }
    
    
    public void testUpdatePerson() throws Exception {
        PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("20429718"));        
        Person onFile = this.getPersonService().getPerson(personKey);        
        IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2005));
        incomeTest.setEffectiveDate(this.getDate(2006,9,16));
        incomeTest.setFutureTest(Boolean.TRUE);
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);

        onFile.setIncomeTest(new Integer(2005), incomeTest); 
        
        
        Person incoming = savePerson(onFile);
        
        this.setComplete();
        
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    }    

    
    
}
