/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.service;

// Java classes
import java.sql.Date;
import java.util.Calendar;
import java.util.Iterator;

// Library classes
import org.apache.commons.lang.Validate;

import java.util.List;

// Framework classes
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.ps.model.PersonVPID;

// ESR classes

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.ApplicationStatus;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.EnrollmentApplication;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.ApplicationInProcess;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.common.util.AbstractCommonTestCase;


/** Test AssociationService's updateAssociation use case
 * 
 * Project: Common</br>
 * Created on: 7:00:09 PM </br>
 *
 * @author DNS   LEV
 */
public class ApplicationInProcessServiceTest extends AbstractCommonTestCase {

	/**
	 * An instance of onFile
	 */
	private Person onFile = null;

	/**
	 * An instance of mergeRuleService
	 */
	private ApplicationInProcessService aipSrv = null;
	
	/**
	 * constructor
	 */
	public ApplicationInProcessServiceTest(String testName) throws Exception {
		super(testName);
	}

	/**
	 * @see gov.va.med.fw.util.AbstractTestCase#customSetUp()
	 */
	protected void customSetUp() throws Exception {
		super.customSetUp();
		onFile = this.buildSimplePerson();
	}

	/**
	 * @see gov.va.med.fw.util.AbstractTestCase#customTearDown()
	 */
	protected void customTearDown() throws Exception {
		super.customTearDown();
		onFile = null;
	}


	// Tests use case to update an existing association
	public void testAllGetByIcnWithIcnEmpty() throws Exception {

		String icn = "1234";
		ApplicationInProcess aip = this.getApplicationInProcessService().getByIcn(icn);
		List statusLst = this.getApplicationInProcessService().getApplicationStatusesByIcn(icn);
		Person person = this.getApplicationInProcessService().getInProcessPersonByIcn(icn);
		
		this.assertEquals(aip, null);
		this.assertEquals(statusLst.size(), 0);
		this.assertEquals(person, null);
		
	}
	
	public void testSaveNewApplicationInProcess() throws Exception {

		
		try{
			//185,186, 189, 194
			PersonEntityKey identifier = CommonEntityKeyFactory.createPersonIdEntityKey("185");
		
			//set up data
			Person person = this.getPersonService().getPerson(identifier);
			BirthRecord br = person.getBirthRecord();
			br.setBirthDate(new ImpreciseDate("01/01/1950")); //for some reasons, 41-45 has birth date of YYYYMM, but no day, which cause enrollment application has null DOB.

			ApplicationStatus as = this.getLookupService().getApplicationStatusByCode(ApplicationStatus.NEW_APPLICATION.getCode());
			
			//save a new application
			this.getApplicationInProcessService().savePersonInProcess(person, as);
			
		}catch (Exception e)
		{
			System.out.println(e.toString());
		}
		
		this.setComplete();
	}

	public void testUpdateNewApplicationInProcess() throws Exception {

		//41-45
		try{
			//get the existing person that has new application status
			String icn = "1002146505V687284"; //person id = 185
			Person person = this.getApplicationInProcessService().getInProcessPersonByIcn(icn);

			//set the application status from NEW to IN_PROCESS
			ApplicationStatus as = this.getLookupService().getApplicationStatusByCode(ApplicationStatus.IN_PROCESS.getCode());
			
			//save a in process application
			this.getApplicationInProcessService().savePersonInProcess(person, as);
						
		}catch (Exception e)
		{
			System.out.println(e.toString());
		}
		
		this.setComplete();
	}
	/**
	 * @return Returns the matchRuleService.
	 */
	public ApplicationInProcessService getApplicationInProcessService() {
		if (aipSrv == null)
			aipSrv = (ApplicationInProcessService) this.applicationContext
					.getBean("applicationInProcessService");
		return aipSrv;
	}

	/**
	 * @param matchRuleService The matchRuleService to set.
	 */
	public void setApplicationInProcessService(ApplicationInProcessService aipSrv) {
		this.aipSrv = aipSrv;
	}
}
