package gov.va.med.esr.common.util;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.fw.model.EntityKeyFactory;

import java.math.BigDecimal;

import junit.framework.TestCase;

public class EnrollmentDeterminationComparatorByEntityKeyValueTest extends
        TestCase {

    public void testCompare() {
        EnrollmentDeterminationComparatorByEntityKeyValue enrollmentDeterminationComparatorByEntityKeyValue = new EnrollmentDeterminationComparatorByEntityKeyValue();

        // return 0 both null
        EnrollmentDetermination arg0 = new EnrollmentDetermination();
        EnrollmentDetermination arg1 = new EnrollmentDetermination();
        assertTrue(enrollmentDeterminationComparatorByEntityKeyValue.compare(
                arg0, arg1) == 0);

        // return 0 both equal
        arg0 = new EnrollmentDetermination();
        arg0.setIdentifier(new BigDecimal(1));
        arg1 = new EnrollmentDetermination();
        arg1.setIdentifier(new BigDecimal(1));
        assertTrue(enrollmentDeterminationComparatorByEntityKeyValue.compare(
                arg0, arg1) == 0);

        // return -1 first greater than second
        arg0 = new EnrollmentDetermination();
        arg0.setIdentifier(new BigDecimal(1));
        arg1 = new EnrollmentDetermination();
        arg1.setIdentifier(new BigDecimal(2));
        assertTrue(enrollmentDeterminationComparatorByEntityKeyValue.compare(
                arg0, arg1) == -1);

        // return 1 second greater than first
        arg0 = new EnrollmentDetermination();
        arg0.setIdentifier(new BigDecimal(2));
        arg1 = new EnrollmentDetermination();
        arg1.setIdentifier(new BigDecimal(1));
        assertTrue(enrollmentDeterminationComparatorByEntityKeyValue.compare(
                arg0, arg1) == 1);
    }

}
