package gov.va.med.esr.common.util;

import java.util.Date;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.util.EnrollmentDeterminationComparatorByEffectiveDate;
import junit.framework.TestCase;

public class EnrollmentDeterminationComparatorByEffectiveDateTest extends 
        TestCase {

    public void testCompare() {
        EnrollmentDeterminationComparatorByEffectiveDate enrollmentDeterminationComparatorByEffectiveDate = new EnrollmentDeterminationComparatorByEffectiveDate();
        EnrollmentDetermination a = new EnrollmentDetermination();
        EnrollmentDetermination b = new EnrollmentDetermination();
        
        //test return zero when both dates are null
        assertEquals(enrollmentDeterminationComparatorByEffectiveDate.compare(a, b),0);
        
        Date d = new Date();
        Date d2 = (Date)d.clone();
        a.setEffectiveDate(d);
        b.setEffectiveDate(d2);
        
        //test return zero when both dates are equal 
        assertEquals(enrollmentDeterminationComparatorByEffectiveDate.compare(a, b),0);
        
        a = new EnrollmentDetermination();
        b = new EnrollmentDetermination();
        d = new Date();
        d.setYear(97);
        d2 = new Date();
        a.setEffectiveDate(d);
        b.setEffectiveDate(d2);
        
        //test return less than 0 when first date before second
        assertTrue(enrollmentDeterminationComparatorByEffectiveDate.compare(a, b)<0);
        
        a = new EnrollmentDetermination();
        b = new EnrollmentDetermination();
        d = new Date();
        d2 = new Date();
        d2.setYear(97);
        a.setEffectiveDate(d);
        b.setEffectiveDate(d2);
        
        //test return greater than zero when first date after second
        assertTrue(enrollmentDeterminationComparatorByEffectiveDate.compare(a, b)>0);
        
        a = new EnrollmentDetermination();
        b = new EnrollmentDetermination();
        d = new Date();
        a.setEffectiveDate(d);
               
        //test throws IllegalArgumentException when one date is null but the other is not
        try{
            enrollmentDeterminationComparatorByEffectiveDate.compare(a, b);
            fail();
        }catch(IllegalArgumentException e){
            
        }
        
        a = new EnrollmentDetermination();
        b = new EnrollmentDetermination();
        d = new Date();
        b.setEffectiveDate(d);
        
        try{
            enrollmentDeterminationComparatorByEffectiveDate.compare(a, b);
            fail();
        }catch(IllegalArgumentException e){
            
        }
    }

}
