package gov.va.med.esr.common.util;

// Java classes
import java.math.BigDecimal;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;

/**
 * @author Yi He Base test case class that auto setup and tear down common test
 *         data in the database
 */
public class DataSetupTestCase extends AbstractCommonTestCase {

	private Person person = null;

	protected PersonDAO personDao = null;


	public DataSetupTestCase() {
		super();
	}

	/**
	 * @param testName
	 */
	public DataSetupTestCase(String testName) {
		super(testName);
	}

	/**
	 * Setup the test data. Create test data in the database
	 */
	protected void customSetUp() throws Exception {
		super.customSetUp();
	    // use an available person
	    person = (Person) personDao.getByKey(new PersonIdEntityKeyImpl(new BigDecimal(68)));
		setUpData();
	}

	protected void setUpData() throws Exception {
	}

	/**
	 * Delete the test data created by setUp from the database. By default, any
	 * updates made by the test is rolled back by Spring.
	 */
	protected final void customTearDown() throws Exception {
		person = null;
		tearDownData();
	}

	protected void tearDownData() throws Exception {
	}

	/**
	 * Overriding org.springframework.test.AbstractTransactionalSpringContextTests.endTransaction.
	 * Fail the test when exceptions occur in org.springframework.test.AbstractTransactionalSpringContextTests.endTransaction.
	 */
    protected void endTransaction() {
    	try {
    		super.endTransaction();
    	}
    	catch(Exception ex) {
    		logger.error("Test failed on ending transaction", ex);
    		fail("Test failed on ending transaction", ex);
    	}
    }
	/**
	 * Get the test person created and saved in the database by setUp.
	 * 
	 * @return
	 */
	public Person getPerson() {
		return person;
	}

	/**
	 * Dependency Injection Setter for PersonDAO
	 * 
	 * @param dao
	 */
	public void setPersonDao(PersonDAO dao) {
		personDao = dao;
	}


	/**
	 * Create a new Person in memory
	 * 
	 * @return
	 */
	public Person createPerson() throws Exception {
		Person p = new Person();
 // FIXME structure change		
//		p.setSsn("123456789");
		p.addName(createName());
		
		BirthRecord birth = new BirthRecord();
		birth.setBirthDate(ImpreciseDateUtils.createImpreciseDate(2005, 1, 1));
		p.setBirthRecord(birth);
		return p;
	}

	public SiteIdentity createSiteIdentity() throws Exception {
		SiteIdentity si = new SiteIdentity();
		if (getPerson() == null) {
			person = createPerson();
		}
		si.setPerson(person);
		VAFacility facility = this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName());
		si.setVaFacility(facility);
		si.setDfn("dfn");
		return si;
	}
}
