package gov.va.med.esr.common.security;

import gov.va.med.esr.service.AbstractSecurityTestCase;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;

import javax.security.auth.login.LoginException;

/**
 * TestCase to test EDBLoginManager.
 * 
 * @author DNS   MANSOG
 */
public class LoginManagerTest
    extends AbstractSecurityTestCase {

    private static final String TARGET_EDBLOGINMANAGER = "edbLoginManager";
    private UserPrincipalImpl   newUser;

    protected void customSetUp() throws Exception {
        super.customSetUp();
    }

    protected UserPrincipal authenticate(String userName, String password)
            throws LoginException, ServiceException {
        //authenticate using LoginManager
        UserCredentials userCredentials = new UserCredentials();
        userCredentials.setUserID(userName);
        userCredentials.setPassword(password);
        getLoginManager().login(userCredentials);
        SecurityContext sc = SecurityContextHelper.getSecurityContext();
        assertNotNull("SecurityContext must not be null at this point", sc);
        UserPrincipal up = sc.getUserPrincipal();
        assertNotNull(
                "UserPrincipal can not be null after successful authentication.",
                up);
        assertEquals(userName, up.getName());
        assertEquals(password, up.getPassword());
        return up;
    }

    protected void failAuthenticationTest(String userName, String password)
            throws Exception {
        super.failAuthenticationTest(userName, password);
        try {
            SecurityContextHelper.getSecurityContext();
            fail("Expected IllegalStateException as there should be no SecurityContext on invalid authentication.");
        } catch (IllegalStateException e1) {
        }
    }

    public void testLogout() throws LoginException, ServiceException {
        String userId = getTestUser().getName();
        String password = getTestUser().getPassword();
        authenticate(userId, password);
        getLoginManager().logout();
        try {
            SecurityContextHelper.getSecurityContext();
            fail("Expected IllegalStateException as there should be no SecurityContext after logout.");
        } catch (IllegalStateException e1) {
        }
    }

    public void testAnonymousLogin() {
        getLoginManager().loginAnonymous();
        SecurityContext sc = SecurityContextHelper.getSecurityContext();
        assertNotNull("SecurityContext must not be null at this point", sc);
        UserPrincipal up = sc.getUserPrincipal();
        assertTrue("UserPrincipal.isAnonymous must return true after anonymous login.", up.isAnonymous());
        assertNotNull("Anonymous UserPrincipal should not be null.", up);
        assertNotNull("Anonymous username should not be null.", up.getName());
        assertNotNull("Anonymous user roles should not be null.",
                up.getUserRoles());
        assertTrue("Must have atleast one role for anonymous.",
                up.getUserRoles().size() > 0);
    }

}