/**
 * 
 */
package gov.va.med.esr.common.rule.service;

import java.util.Iterator;
import java.util.List;

import gov.va.med.esr.common.model.financials.GMTThreshold;
import gov.va.med.esr.common.model.financials.IncomeThreshold;
import gov.va.med.esr.common.util.AbstractCommonTestCase;

/**
 * @author DNS   MANSOG
 */
public class ViewThresholdsTest extends AbstractCommonTestCase {

	/**
	 * @param testName
	 */
	public ViewThresholdsTest(String testName) {
		super(testName);
		
	}

	public void testAllIncomeThresholds() throws Exception {
		List list = getLookupService().getAllIncomeThresholds();
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			IncomeThreshold it = (IncomeThreshold) iter.next();
			System.out.println("IncomeThreshold= "+it);		
		}
	}
	
	public void testGMTThreshold() throws Exception {
		Integer year = new Integer(2003);
		String zipCode = "20191";
		GMTThreshold gmtThreshold = getFinancialsService().getGMTThreshold(year, zipCode);
		System.out.println("GMTThreshold = "+gmtThreshold);		
	}

	public void testGMTThresholdExtraDependents() throws Exception {
		Integer year = new Integer(2003);
		String zipCode = "20172";
		
		GMTThreshold gmtThreshold = getFinancialsService().getGMTThreshold(year, zipCode, 5);
		System.out.println("GMTThreshold = "+gmtThreshold);		
	}


	public void testIncomeThreshold() throws Exception {
		Integer year = new Integer(2003);
		IncomeThreshold incomeThreshold= getFinancialsService().getIncomeThreshold(year);
		System.out.println("IncomeThreshold = "+incomeThreshold);		
	}

	public void testIncomeThresholdExtraDependents() throws Exception {
		Integer year = new Integer(2003);
		IncomeThreshold incomeThreshold= getFinancialsService().getIncomeThreshold(year, 7);
		System.out.println("IncomeThreshold = "+incomeThreshold);		
	}
}
