package gov.va.med.esr.common.rule.service;

import java.math.BigDecimal;

import gov.va.med.esr.common.util.RuleAbstractTestCase;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.SpinalCordInjuryType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.service.EventRuleService;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public class TriggerMessageTest extends RuleAbstractTestCase {

	public TriggerMessageTest(String testName) {
		super(testName);

	}

	public void testProcessMessageQRYZ11Event() throws Exception {
		try {

			Person onFile = buildSimplePerson();
			Person incoming = this.getPersonService().save(onFile);
			this.getEventRuleService().processMessageEvents(incoming);

			logger.info("Completed Test");
		} catch (Exception e) {
			this.logger.debug("Errors due to", e);
			fail("failed due to exception " + e);
		}
	}

	public void testProcessMessageORUZ11Event() throws Exception {
		try {

			Person onFile = buildSimplePerson();
			this.setEligibilityStatusToVerified(onFile);
			onFile.setEnrollmentDetermination(new EnrollmentDetermination());
			// onFile.getEnrollmentDetermination().setEgtSetting(this.getPersonHelperService().getCurrentEGTSetting());
			Person incoming = this.getPersonService().save(onFile);

			Person updated = this.getEligibilityEnrollmentService()
					.assessEEImpact(incoming);
			this.getEventRuleService().processMessageEvents(updated);

			logger.info("Completed Test");
		} catch (Exception e) {
			this.logger.debug("Errors due to", e);
			fail("failed due to exception " + e);
		}
	}

	public void testVOAORUZ11Event() throws Exception {
		try {

			// find a vet with Eligibility Status = verified
			Person onFile = this.getPersonByVPID("2000002330V397526");
		//	onFile.setVOA(new Boolean("True"));
			
			SpinalCordInjury sci =	new SpinalCordInjury();
			SpinalCordInjuryType type = (SpinalCordInjuryType)this.getLookupService().getByCode(SpinalCordInjuryType.class, SpinalCordInjuryType.CODE_PARAPLEGIA_TRAUMATIC);
			sci.setSpinalCordInjuryType(type);
			onFile.setSpinalCordInjury(sci);

			this.getEventRuleService().processMessageEvents(onFile);

			logger.info("Completed Test");
		} catch (Exception e) {
			this.logger.debug("Errors due to", e);
			fail("failed due to exception " + e);
		}
	}

	private Person getPersonByShortVPID(String shortVPID) throws Exception {

		return getPersonService().getPerson(
				CommonEntityKeyFactory.createVPIDEntityKey(shortVPID));
	}

	public void testVOA() throws Exception {
		try {

			Person onFile = getPersonByVPID("2000002330V397526");
			Person incoming = (Person) onFile.clone();

			this.setEligibilityStatusToVerified(incoming);

			incoming.setEnrollmentDetermination(new EnrollmentDetermination());
			// onFile.getEnrollmentDetermination().setEgtSetting(this.getPersonHelperService().getCurrentEGTSetting());

			Person updated = this.getEligibilityEnrollmentService()
					.assessEEImpact(incoming);

			// default VOAOnly = false
			this.getEventRuleService().processMessageEvents(updated);

			logger.info("Completed Test");
		} catch (Exception e) {
			this.logger.debug("Errors due to", e);
			fail("failed due to exception " + e);
		}
	}

}
