/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.PHDocumentType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.fw.hl7.HL7MessageUtils;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.PID;
import gov.va.med.person.idmgmt.VPID;
import gov.va.med.ps.model.PersonVPID;


/**
 * @author VHAIVMNgVS
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PurpleHeartRuleServiceTest extends  RuleAbstractTestCase  
{    
    public PurpleHeartRuleServiceTest (String testName) 
    {
        super(testName);
    }
  
    public void testPurpleHeartIsYESFromHec() throws Exception 
    {
        Person onFile = buildSimplePerson();
        this.attachPurpleHeartWithPHStatusPending(onFile);        
        Person incoming = this.getPersonService().save(onFile);       
        attachFacilityToPurpleHeart(incoming,VAFacility.CODE_HEC.getName());
        PurpleHeartDocument purpleHeartDocument = new PurpleHeartDocument();
        purpleHeartDocument.setAcceptable(Boolean.TRUE);
        purpleHeartDocument.setDocumentType((PHDocumentType)this.getLookupService().getByCode(PHDocumentType.class,"1"));
        purpleHeartDocument.setReceivedDate(this.getDate(2005,1,1));  // I tested for validation error with future date already      
        incoming.getPurpleHeart().addDocument(purpleHeartDocument);

        this.getPurpleHeartRuleService().managePurpleHeart(incoming, onFile);
        
        assertEquals(1, onFile.getDecorations().size());
        PurpleHeart resultPurpleHeart = getPurpleHeart(onFile);
        assertNotNull(resultPurpleHeart);
        
        Boolean PHIndicator = resultPurpleHeart.getPhIndicator();
        assertTrue("Indicator is set to false.",PHIndicator.booleanValue());
        String purpleHeartStatus = resultPurpleHeart.getStatus().getCode();
        assertEquals(DecorationStatus.CODE_CONFIRMED.getName(), purpleHeartStatus);
        String facility = resultPurpleHeart.getFacility().getCode();
        assertEquals(facility,VAFacility.CODE_HEC.getName());
        
        // The incoming PH had no remark text so processing should reset text 
        assertNull(resultPurpleHeart.getRejectionRemark());              
    }
    
    public void testPHValidationFromHec() throws Exception 
    {
        Person onFile = buildSimplePerson();
        this.attachPurpleHeartWithPHStatusPending(onFile);        
        Person incoming = this.getPersonService().save(onFile);       
        attachFacilityToPurpleHeart(incoming,VAFacility.CODE_HEC.getName());
        PurpleHeartDocument purpleHeartDocument = new PurpleHeartDocument();
        purpleHeartDocument.setAcceptable(Boolean.TRUE);
        purpleHeartDocument.setReceivedDate(this.getDate(2005,1,1));  // I tested for validation error with future date already      
        incoming.getPurpleHeart().addDocument(purpleHeartDocument);


        this.getPurpleHeartRuleService().managePurpleHeart(incoming, onFile);
        assertNotNull(onFile.getPurpleHeart());                
    }    
    
/*
 I set the status to Rejected and adding a Rejection Remark.
Rejection remark is saved, but the status is not saved. Previously it was in confirmed status.
 
 */    

    public void testPHReject() throws Exception {
        Person onFile = buildSimplePerson();
        this.attachPurpleHeartWithPHStatusPending(onFile);
        this.setPurpleHeartStatus(DecorationStatus.CODE_CONFIRMED, onFile);
//        onFile.getPurpleHeart().addDocument(this.createPurpleHeartDocument());
        Person incoming = this.getPersonService().save(onFile);
        this.setPurpleHeartStatus(DecorationStatus.CODE_REJECTED, incoming);
        incoming.getPurpleHeart().setRejectionRemark(this.getLookupService().getRejectionRemarkByCode("1"));
        this.getPurpleHeartRuleService().managePurpleHeart(incoming, onFile);
        PurpleHeart resultPurpleHeart = getPurpleHeart(onFile);
        assertNotNull(resultPurpleHeart);
        assertNotNull(resultPurpleHeart.getRejectionRemark());        
    }
    
    public void testNewPurpleHeartFromHec() throws Exception 
    {
        Person onFile = buildSimplePerson();
        Person incoming = this.getPersonService().save(onFile);
        this.attachPurpleHeartWithPHStatusPending(incoming);
        attachFacilityToPurpleHeart(incoming,VAFacility.CODE_HEC.getName());
        PurpleHeartDocument purpleHeartDocument = new PurpleHeartDocument();
        purpleHeartDocument.setAcceptable(Boolean.TRUE);
        purpleHeartDocument.setDocumentType((PHDocumentType)this.getLookupService().getByCode(PHDocumentType.class,"1"));
        purpleHeartDocument.setReceivedDate(this.getDate(2005,1,1));  // I tested for validation error with future date already      
        incoming.getPurpleHeart().addDocument(purpleHeartDocument);
        
        this.getPurpleHeartRuleService().managePurpleHeart(incoming, onFile);
     
        PurpleHeart resultPurpleHeart = getPurpleHeart(onFile);
        assertNotNull(resultPurpleHeart);
        
        Boolean PHIndicator = resultPurpleHeart.getPhIndicator();
        assertTrue("Indicator is set to false.",PHIndicator.booleanValue());
        String purpleHeartStatus = resultPurpleHeart.getStatus().getCode();
        assertEquals(DecorationStatus.CODE_CONFIRMED.getName(), purpleHeartStatus);
        
    }    
    
    
    public void testPurpleHeartIsNoFromHec() throws Exception 
    {
        Person onFile = buildSimplePerson();
        Person incoming = this.getPersonService().save(onFile);       
        
        // Set the incoming with PH equal Yes
        this.attachPurpleHeartWithPHStatusPending(incoming);
        attachFacilityToPurpleHeart(incoming,VAFacility.CODE_HEC.getName());
        this.setPurpleHeartToNo(incoming);        
        this.getPurpleHeartRuleService().managePurpleHeart(incoming, onFile);

        assertEquals(1, onFile.getDecorations().size());
        PurpleHeart resultPurpleHeart = getPurpleHeart(onFile);
        assertNotNull(resultPurpleHeart);
        
        Boolean PHIndicator = resultPurpleHeart.getPhIndicator();
        assertFalse("Indicator is set to true.",PHIndicator.booleanValue());
        String facility = resultPurpleHeart.getFacility().getCode();
        assertEquals(facility,VAFacility.CODE_HEC.getName());
        
        // The incoming PH had remark text 
        assertNotNull(resultPurpleHeart.getRejectionRemark());              
        
    }    
  

    public void testPurpleHeartIsYESFromSite() throws Exception 
    {
        Person onFile = buildSimplePerson();
        Person updated = this.getPersonService().save(onFile);       
        Person incoming = (Person)updated.clone();
        // Set the incoming with PH equal Yes
        this.attachPurpleHeartWithPHStatusPending(incoming);
        attachFacilityToPurpleHeart(incoming,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER.getName());
        
        this.getPurpleHeartRuleService().processPurpleHeart(incoming,onFile,null);

        assertEquals(1, onFile.getDecorations().size());
        PurpleHeart resultPurpleHeart = getPurpleHeart(onFile);
        assertNotNull(resultPurpleHeart);
        
        Boolean PHIndicator = resultPurpleHeart.getPhIndicator();
        assertTrue("Indicator is set to false.",PHIndicator.booleanValue());
        String purpleHeartStatus = resultPurpleHeart.getStatus().getCode();
        assertEquals(DecorationStatus.CODE_PENDING.getName(), purpleHeartStatus);
        String facility = resultPurpleHeart.getFacility().getCode();
        assertEquals(facility,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER.getName());
        
        // The incoming PH had no remark text so processing should reset text 
        assertNull(resultPurpleHeart.getRejectionRemark());        
    }
    
    public void testPHVOAYes() throws Exception
    {
    	Person onFile = getPerson("2000002330V397526");
    	Person incoming = (Person) onFile.clone();
    	
        // Set the incoming with PH equal Yes
        this.attachPurpleHeartWithPHStatusPending(incoming);
        attachFacilityToPurpleHeart(incoming,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER.getName());
    	
        PurpleHeartRuleService phRuleService = this.getPurpleHeartRuleService();
        phRuleService.processPurpleHeart(incoming, onFile, createVerificationInfo());
    }
    
    private VerificationInfo createVerificationInfo() throws Exception {
		// Z07 message doesn't have an entitlement code so set it to null
		VerificationInfo info = new VerificationInfo("ORUZ07-E", null);
		// Set the site number to sending facility
		info.setSiteNumber(VAFacility.CODE_MHV.getCode());

		// Set the DFN in the Verification Info
		// String dfn =
		// getDfnFromPID((PID)message.getSegment(SegmentConstants.PID));
		info.setDfn("123456789");

		// create workflow case object for potential usage by Rules
		WorkflowCaseInfo caseInfo = new WorkflowCaseInfo();
		caseInfo.setTransmissionSite(getLookupService()
				.getVaFacilityByStationNumber(VAFacility.CODE_MHV.getCode()));
		caseInfo.setMessageID("1234567");

		// create workflow case object for potential usage by Rules
		info.setWorkflowCaseInfo(caseInfo);

		return info;
	}
    
    
    public void testPurpleHeartIsNOFromSite() throws Exception 
    {
        Person onFile = buildSimplePerson();
        Person updated = this.getPersonService().save(onFile);       
        Person incoming = (Person)updated.clone();            
     
        // Set the incoming with PH equal No
        this.attachPurpleHeartWithPHStatusPending(incoming);
        attachFacilityToPurpleHeart(incoming,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER.getName());
        
        // Set the purple heart status to NO
        this.setPurpleHeartToNo(incoming);      

        this.getPurpleHeartRuleService().processPurpleHeart(incoming,onFile,null);
        
        assertEquals(1, onFile.getDecorations().size());
        PurpleHeart resultPurpleHeart = getPurpleHeart(onFile);
        assertNotNull(resultPurpleHeart);
        
        Boolean PHIndicator = resultPurpleHeart.getPhIndicator();
        assertFalse("Indicator is set to true.",PHIndicator.booleanValue());
        // The incoming PH had rejection text 
        assertNotNull(resultPurpleHeart.getRejectionRemark());     
    }
  
    private PurpleHeart getPurpleHeart(Person person)
    {
        return this.getPersonHelperService().getPurpleHeart(person);
    }
/*
    private PurpleHeartDocument createPurpleHeartDocument() throws Exception {
        PurpleHeartDocument purpleHeartDocument = new PurpleHeartDocument();
        purpleHeartDocument.setAcceptable(Boolean.TRUE);
        purpleHeartDocument.setDocumentType((PHDocumentType)this.getLookupService().getByCode(PHDocumentType.class,"1"));
        purpleHeartDocument.setReceivedDate(this.getDate(2005,1,1));       
        return purpleHeartDocument;
    }
  */  
   /* 
    private Person getPerson(String id) throws Exception
    {
        PersonIdEntityKey key = CommonEntityKeyFactory.createPersonIdEntityKey(id);
        return this.getPersonService().getPerson(key);
    }
    */
    

}
