/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2005
 *
 */
package gov.va.med.esr.common.rule.service;

// Java classes
import java.util.Date;

// Library classes

// Framework classes

// EDB Classes
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.util.RuleAbstractTestCase;


/**
 * @author Yi He
 * @version 1.0
 */
public class ProcessPersonTest extends RuleAbstractTestCase {
	
	/**
	 * Constructor for ProcessFinancialTest.
	 * @param testName
	 */
	public ProcessPersonTest(String testName) {
		super(testName);
	}
	
	
	public void testTriggerPHIndicatorUpdatedToNoBulletin() throws Exception {
        try {

            Person onFile = buildSimplePerson();
            EnrollmentDetermination ed = new EnrollmentDetermination();
            ed.setEgtSetting(this.getEgtService().getCurrentEGTSetting());
            onFile.setEnrollmentDetermination(ed);
            this.attachPurpleHeartWithPHStatusPending(onFile);            
            Person incoming = this.getPersonService().save(onFile);                
            incoming.removeAllDecorations();   
            this.getEventRuleService().managePersonEvents(incoming);
            logger.info("Completed Test");
        } catch (Exception e) {
            this.logger.debug("Errors due to", e);
            fail("failed due to exception " + e);
        }             

	}			
}

