package gov.va.med.esr.common.rule.service;


// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.lookup.SignatureIndicator;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.util.RuleAbstractTestCase;


public class ProcessPersonSignatureTest extends RuleAbstractTestCase {

    public ProcessPersonSignatureTest(String testName) {
        super(testName);

    }

    public void testSignatureIndicatorIsNoWithBulletin() throws Exception{
        Person onFile = buildSimplePerson();
        this.attachPrimaryMeansTest(onFile);
        this.attachVerifiedEnrollment(onFile);
        this.attachSignatureImage(onFile);
        SignatureImage onFileSig = (SignatureImage)onFile.getSignatureImages().iterator().next();
        onFileSig.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, SignatureIndicator.CODE_YES));
        onFileSig.setSiteSubmittingImage(this.getVaFacility(VAFacility.CODE_HEC));
        
        Person incoming = savePerson( onFile );
        SignatureImage si = (SignatureImage)incoming.getSignatureImages().iterator().next();

        si.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, SignatureIndicator.CODE_NO));
        //Person updated = null;
                
        this.getFinancialsService().updatePersonSignature(incoming); 

//        assertTrue(updated.getSignatureImages().size() == 1);
  //      SignatureImage result = (SignatureImage)updated.getSignatureImages().iterator().next();
    }
    
    public void testSignatureIndicatorIsNoFromMessageWithBulletin() throws Exception{
        Person onFile = buildSimplePerson();
        this.attachPrimaryMeansTest(onFile);
        this.attachVerifiedEnrollment(onFile);
        this.attachSignatureImage(onFile);
        SignatureImage onFileSig = (SignatureImage)onFile.getSignatureImages().iterator().next();
        onFileSig.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, SignatureIndicator.CODE_YES));
        onFileSig.setSiteSubmittingImage(this.getVaFacility(VAFacility.CODE_HEC));
        
        Person incoming = savePerson( onFile );
        SignatureImage si = (SignatureImage)incoming.getSignatureImages().iterator().next();

        si.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, SignatureIndicator.CODE_NO));
               
        this.getFinancialInfoRuleService().processPersonSignatures(incoming.getSignatureImages(), onFile, null);         
    }
    
    public void testSignatureIndicatorIsNoWithoutBulletin() throws Exception{
        Person onFile = buildSimplePerson();
        this.attachPrimaryMeansTest(onFile);
        this.attachVerifiedEnrollment(onFile);
        this.attachSignatureImage(onFile);
        SignatureImage onFileSig = (SignatureImage)onFile.getSignatureImages().iterator().next();
        onFileSig.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, SignatureIndicator.CODE_YES));
        onFileSig.setSiteSubmittingImage(this.getVaFacility(VAFacility.CODE_HEC));
        
        Person incoming = savePerson( onFile );
        SignatureImage si = (SignatureImage)incoming.getSignatureImages().iterator().next();

        si.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, SignatureIndicator.CODE_NO));
        this.attachSignatureImage(incoming); 
                
        this.getFinancialsService().updatePersonSignature(incoming); 

//        assertTrue(updated.getSignatureImages().size() == 1);
  //      SignatureImage result = (SignatureImage)updated.getSignatureImages().iterator().next();
    }
    
    public void testSignatureIndicatorIsNoFromMessageWithoutBulletin() throws Exception{
        Person onFile = buildSimplePerson();
        this.attachPrimaryMeansTest(onFile);
        this.attachVerifiedEnrollment(onFile);
        this.attachSignatureImage(onFile);
        
        SignatureImage onFileSig = (SignatureImage)onFile.getSignatureImages().iterator().next();
        onFileSig.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, SignatureIndicator.CODE_YES));
        onFileSig.setSiteSubmittingImage(this.getVaFacility(VAFacility.CODE_HEC));
        
        Person incoming = savePerson( onFile );
        SignatureImage si = (SignatureImage)incoming.getSignatureImages().iterator().next();

        si.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, SignatureIndicator.CODE_NO));
        this.attachSignatureImage(onFile);        
        this.getFinancialInfoRuleService().processPersonSignatures(incoming.getSignatureImages(), onFile, null);         
    }       
    
    public void testSignatureIndicatorIsError() throws Exception{
        this.doTestFromUI(SignatureIndicator.CODE_YES, SignatureIndicator.CODE_ERROR);
    }
    
    public void testSignatureIndicatorIsYes() throws Exception{
        this.doTestFromUI(SignatureIndicator.CODE_NO, SignatureIndicator.CODE_YES);
    }        
    
    public void testSignatureIndicatorIsNoFromMessage() throws Exception{
        Person onFile = buildSimplePerson();
        this.attachPrimaryMeansTest(onFile);
        this.attachVerifiedEnrollment(onFile);
        this.attachSignatureImage(onFile);
        SignatureImage onFileSig = (SignatureImage)onFile.getSignatureImages().iterator().next();
        onFileSig.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, SignatureIndicator.CODE_YES));
        onFileSig.setSiteSubmittingImage(this.getVaFacility(VAFacility.CODE_HEC));
        
        Person incoming = savePerson( onFile );
        SignatureImage si = (SignatureImage)incoming.getSignatureImages().iterator().next();

        si.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, SignatureIndicator.CODE_NO));
               
        this.getFinancialInfoRuleService().processPersonSignatures(incoming.getSignatureImages(), onFile, null);         
    }
    
    public void testSignatureIndicatorIsYesFromMessage() throws Exception{
        this.doTestFromMessage(SignatureIndicator.CODE_NO, SignatureIndicator.CODE_YES);
    }       
     
    public void testRemoveSignatureImage() throws Exception{
        Person onFile = buildSimplePerson();
        this.attachSignatureImage(onFile);        
        Person incoming = this.getPersonService().save( onFile );
        incoming.removeAllSignatureImages();
        Person updated = this.getFinancialsService().updatePersonSignature(incoming);
        assertTrue(updated.getSignatureImages().size() == 0);
    }    
    
    private void doTestFromMessage(SignatureIndicator.Code from, SignatureIndicator.Code to) throws Exception {
        this.doTest(from, to, false);
    }
    private void doTestFromUI(SignatureIndicator.Code from, SignatureIndicator.Code to) throws Exception {
        this.doTest(from, to, true);
    }
    private void doTest(SignatureIndicator.Code from, SignatureIndicator.Code to, boolean gui) throws Exception {
        Person onFile = buildSimplePerson();
        this.attachPrimaryMeansTest(onFile);
        this.attachVerifiedEnrollment(onFile);
        this.attachSignatureImage(onFile);
        SignatureImage onFileSig = (SignatureImage)onFile.getSignatureImages().iterator().next();
        onFileSig.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, from));
        onFileSig.setSiteSubmittingImage(this.getVaFacility(VAFacility.CODE_HEC));
        
        Person incoming = savePerson( onFile );
        this.attachSignatureImage(incoming);
        SignatureImage si = (SignatureImage)incoming.getSignatureImages().iterator().next();

        si.setSignatureIndicator((SignatureIndicator)this.getLookupService().getByCode(SignatureIndicator.class, to));
        Person updated = null;
                
        if (gui) {
            updated = this.getFinancialsService().updatePersonSignature(incoming); 
        }
        else {
            this.getFinancialInfoRuleService().processPersonSignatures(incoming.getSignatureImages(), onFile, null);
            updated = onFile;
        }
        this.setComplete();
        assertTrue(updated.getSignatureImages().size() == 1);
        SignatureImage result = (SignatureImage)updated.getSignatureImages().iterator().next();
        assertEquals(result.getSignatureIndicator().getCode(), to.getName());       
    }
}
