package gov.va.med.esr.common.rule.service;




import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;

import gov.va.med.fw.util.DateUtils;
import gov.va.med.esr.UseCaseName;
import gov.va.med.esr.common.builder.msds.MilitaryServiceBuilderForMSDS;
import gov.va.med.esr.common.builder.msds.VadirCombatServiceBuilderStrategy;
import gov.va.med.esr.common.builder.msds.VadirCombatEpisodeBuilderStrategy;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.PeriodOfService;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Activation;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Deployment;
import gov.va.med.esr.common.model.cases.WorkflowCase;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.lookup.MilitaryServiceComponent;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.MedalOfHonor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.CombatServiceSource;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.NamedContingency;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
//import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.SpecialOperation;
import gov.va.med.esr.common.model.lookup.TerminationReason;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.MilitaryServiceInputData;
import gov.va.med.esr.common.rule.parameter.MilitaryServiceInputParameter;
import gov.va.med.esr.common.rule.parameter.PurpleHeartInputParameter;
import gov.va.med.esr.common.util.ActivationComparator;
import gov.va.med.esr.common.util.CombatServiceComparator;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.esr.jms.vadir.outboundResponse.VadirServiceResponseWrapper;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryHistory;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.BIRLS;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.VADIR;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryPay;
import gov.va.med.esr.service.MsdsResponseInfo;

import org.apache.commons.lang.ObjectUtils;



/**
 * Provides methods to test rules dealing with processing MSDS data
 *
 * @author DNS   RUIZC
 */
public class ProcessPersonMSDSDataTest extends AbstractMsdsTest {

	private static final Character VOA_IND_1 = '1';
	private static final Character VOA_IND_2 = '2';

	public ProcessPersonMSDSDataTest(String arg0) {
		super(arg0);
	}


	protected Person createQmsePerson() throws Exception {
        // Creates a person with a HEC record and with appropriate Eligibility Verification data
        Person person = this.buildSimplePerson();
        this.attachVerifiedEnrollment(person);
        MilitaryService ms = new MilitaryService();
        this.setEligibilityStatusToPendingVerification(person);
        person.getEligibilityVerification().setAacIndicator(
                this.getLookupService().getAACIndicatorByCode(
                        AACIndicator.CODE_DATA_ACCEPTED.getName()));
        person.setMilitaryService(ms); 
        //setup CampLejeune data for onFile
        CampLejeuneVerification onFilecampLejeuneVerification = new CampLejeuneVerification();
        onFilecampLejeuneVerification.setSpecialFactorIndicator(getLookupService().getIndicatorByCode(Indicator.YES));
        onFilecampLejeuneVerification.setChangeSite(getRandomVAFacility());
        person.addSpecialFactor(onFilecampLejeuneVerification);

        MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
        m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_NEW_BEDFORD_CBOC.getName()));
        person.getMilitaryService().addMilitaryServiceSiteRecord(m);
        return person;
    }
 
	public void testDefect203322_2() throws Exception {

	    Date startTime = new Date();

	    MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
	    BIRLS birls = new BIRLS();
	    VADIR vadir = new VADIR();
	    ServicePeriod servicePeriod =
	            new ServicePeriod();
	    PeriodOfService periodOfService =
	            new PeriodOfService();

	    VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
	    Person p = createQmsePerson ();



	    MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
        m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));

        MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
                this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
                new ImpreciseDate("20001112"), new ImpreciseDate("20040224") );
        m.addMilitaryServiceEpisode(mse);
        p.getMilitaryService().addMilitaryServiceSiteRecord(m);

	    Person o = this.savePerson(p);

	    wrapper.setPersonId(new Long(o.getPersonEntityKey().getKeyValueAsString()).longValue());//vpid=0000001008693047V996100000000, new
	    wrapper.setResult(mockMilitaryHistory);
	    MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
	    MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

	    Person result = this.getMilitaryInfoService().processMSDSData(info);




	    // Assert VOA PENDING workflow item just created
	    //        WorkflowCase wfc = getWorkflowService().getMostRecentWorkflowItem(result);
	    //        assertTrue("Most recent workflow must be created just now for Veteran CL Eligibility cannot be determined",
	    //              wfc != null && wfc.getCreatedOn().after(startTime) && "Veteran CL Eligibility cannot be determined".equalsIgnoreCase(wfc.getErrorMessage()));

	    System.out.println("verification record ="+result.getEligibilityVerification());

	}



	public void testDefect203322() throws Exception {

	    Date startTime = new Date();

	    MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
	    BIRLS birls = new BIRLS();
	    VADIR vadir = new VADIR();
	    ServicePeriod servicePeriod =
	            new ServicePeriod();
	    PeriodOfService periodOfService =
	            new PeriodOfService();

	    VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
	    Person p = createQmsePerson ();

	    Person o = this.savePerson(p);

	    wrapper.setPersonId(new Long(o.getPersonEntityKey().getKeyValueAsString()).longValue());//vpid=0000001008693047V996100000000, new
	    wrapper.setResult(mockMilitaryHistory);
	    MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
	    MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

	    Person result = this.getMilitaryInfoService().processMSDSData(info);


	    // Assert VOA PENDING workflow item just created
	    //        WorkflowCase wfc = getWorkflowService().getMostRecentWorkflowItem(result);
	    //        assertTrue("Most recent workflow must be created just now for Veteran CL Eligibility cannot be determined",
	    //              wfc != null && wfc.getCreatedOn().after(startTime) && "Veteran CL Eligibility cannot be determined".equalsIgnoreCase(wfc.getErrorMessage()));

	    System.out.println("verification record ="+result.getEligibilityVerification());

	}

	// GOAL
	public void testCombatEpisodeParamMethods() throws Exception {
		MilitaryServiceInputParameter militaryServiceInput = buildMilitaryServiceInputParameter();
		RuleDataAware ruleDataAware = militaryServiceInput.getRuleDataAware();
		MilitaryServiceInputData inData = (MilitaryServiceInputData)ruleDataAware;
		Person onFile = militaryServiceInput.getResultPerson();
		Person incoming = militaryServiceInput.getIncomingPerson();

		gov.va.med.esr.common.model.ee.Activation activation = this.createEsrActivation(onFile);
		activation.addDeployment(createEsrDeployment());
		gov.va.med.esr.common.model.ee.Activation act = this.createEsrActivation(incoming);
		gov.va.med.esr.common.model.ee.Deployment inDeployment = this.createEsrDeployment();

		act.addDeployment(inDeployment);
		inData.setActivation(act);
		inData.setDeployment(inDeployment);

		CombatService cs = this.createCombatService(incoming);
		inData.setCombatService(cs);

		CombatEpisode ce0 = this.createCombatEpisode();
		onFile.getMilitaryService().addCombatEpisode(ce0);

		MilitaryServiceEpisode mse = (MilitaryServiceEpisode)incoming.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator().next();

		inData.setIncomingMilitaryServiceEpisode(mse);
		CombatEpisode ce =this.createCombatEpisode();
		assertTrue("expected TRUE", militaryServiceInput.hasCombatEpisodeWithOverlap(ce));
		assertFalse("expected False", militaryServiceInput.hasCombatEpisodeWithStartDateOnlyOverlap(ce));

		CombatEpisode ce2 =this.createCombatEpisode();
		ce2.setEndDate(ImpreciseDateUtils.createImpreciseDate(2011,1,1));
		onFile.getMilitaryService().addCombatEpisode(ce2);
		assertTrue("expected True", militaryServiceInput.hasCombatEpisodeWithStartDateOnlyOverlap(ce2));

		militaryServiceInput.setCombatEpisode(ce2);
		// test with the Ce that matched in person
		assertFalse(ce2.getEndDate().equals(ce0.getEndDate()));

		militaryServiceInput.setMatchedCombatEpisodeEndDate();
		assertTrue(ce2.getEndDate().equals(ce0.getEndDate()));

		onFile.getMilitaryService().removeAllCombatEpisodes();
		militaryServiceInput.setMatchedCombatEpisode(null);
		militaryServiceInput.setCombatEpisode(ce2);
		militaryServiceInput.acceptCombatEpisodesFromVadir();
		assertTrue(onFile.getMilitaryService().getCombatEpisodes().size() == 1);
	}

//	protected CombatEpisode createCombatEpisode() throws Exception {
//		CombatEpisode ce = new CombatEpisode();
//		ce.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OEF.getCode()));
//		ce.setStartDate(ImpreciseDateUtils.createImpreciseDate(2002,2,1));
//		ce.setEndDate(ImpreciseDateUtils.createImpreciseDate(2008,11,1));
//		return ce;
//	}
	public void testCR10681() throws Exception {
		DischargeType hva = this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_HONORABLE_VA.getCode());
		DischargeType dva = this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_DISHONORABLE_VA.getCode());
		assertNotNull(hva);
		assertNotNull(dva);
	}

//	public String getCountryByFipsCode(String fips)
//	throws ServiceException {
//		Validate.notNull(fips, "Fips code can not be null.");
//		List result = null;
//		try {
//			String[] paramNames = { "fips"};
//			Object[] paramValues = { fips };
//			result = getGenericDAO().findByNamedQueryAndNamedParam(
//					"countryCodeByFipsCodeQuery_getCountryCodeByFipsCode", paramNames,
//					paramValues);
//		} catch (DAOException ex) {
//			throw new ServiceException(
//					"Error finding Country information from the database.", ex);
//		}
//		return result == null || result.size() ==0 ? null : (String)result.get(0);
//	}
  
	public void testCombatEpisodesFromVadir() throws Exception {
			BIRLS birls = new BIRLS();
			VADIR vadir = new VADIR();
			PeriodOfService periodOfService = new PeriodOfService();
			ServicePeriod servicePeriod = new ServicePeriod();
			Activation activation = new Activation();
			Deployment deployment = new Deployment();
			Deployment deployment2 = new Deployment();

			VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
			wrapper.setPersonId(new Long(489358).longValue());
			MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
			PersonEntityKey key =
				CommonEntityKeyFactory.createPersonIdEntityKey(String.valueOf(wrapper.getPersonId()));

			// BIRLS
			periodOfService.setBranchOfService("WAC");
			periodOfService.setCharacterOfService("Z");
			periodOfService.setReleasedActiveDutyDate(this.getDate(2003, 1, 8));
			periodOfService.setEnteredOnDutyDate(this.getDate(2003, 1, 8));

			List periodOfServices = new ArrayList();
			periodOfService.setBranchOfService("WAC");
			periodOfServices.add(periodOfService);

			birls.setPeriodOfService(periodOfServices);
			birls.setMedalOfHonorInd("Y");
			birls.setPurpleHeartInd("Y");

			mockMilitaryHistory.setBirls(birls);

			// VADIR
			activation.setStartDate(this.getDate(2002, 1, 8));
			activation.setEndDate(this.getDate(2003, 1, 8));
			activation.setTerminationRsn("D");
			activation.setCharacterOfService(null);

			deployment.setStartDate(this.getDate(2002, 1, 8));
			deployment.setEndDate(this.getDate(2003, 1, 8));
			deployment.setTerminationRsn("D");
			deployment.setSpecialOperation(SpecialOperation.OPERATION_ENDURING_FREEDOM.getCode());
			deployment.setLocation("ZZ"); // MSDS_CodeCR10606 disabled

			deployment2.setStartDate(this.getDate(2003, 5, 9));
			deployment2.setEndDate(this.getDate(2005, 3, 7));
			deployment2.setTerminationRsn("D");
			deployment2.setSpecialOperation(SpecialOperation.OPERATION_NOBLE_EAGLE.getCode());
			deployment2.setLocation("ZZ"); // MSDS_CodeCR10606 disabled


			// Deployments
			List deployments = new ArrayList();
			deployments.add(deployment);
			deployments.add(deployment2);

			servicePeriod.setDeployments(deployments);

			// Activations
			List activations = new ArrayList();
			activations.add(activation);

			servicePeriod.setActivations(activations);

			// Combat Service
			MilitaryPay pay = new MilitaryPay();
			pay.setPayType(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode());
			pay.setStartDate(this.getDate(2002, 1, 1));
			pay.setEndDate(this.getDate(2006, 6, 8));
			pay.setCombatServiceLocation("ZZ"); // MSDS_CodeCR10606 disabled

			List pays = new ArrayList();
			pays.add(pay);
			servicePeriod.setMilitaryPayments(pays);
			servicePeriod.setStartDate(this.getDate(2006, 1, 8));
			servicePeriod.setEndDate(new Date());
			servicePeriod.setBranchOfService("WAC");
			servicePeriod.setPersonnelCategory("A");
			servicePeriod.setCharacterOfService("A");

			List servicePeriods = new ArrayList();
			servicePeriods.add(servicePeriod);

			// 01 OEF, 02 OIF, 03 both OEF and OIF, 04 neither/unable to determine
			vadir.setOefOifIndicator("02");
			vadir.setServicePeriods(servicePeriods);

			mockMilitaryHistory.setVadir(vadir);
			wrapper.setResult(mockMilitaryHistory);

			MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
			MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
			MilitaryService ms = info.getVadirMilitaryService();
			assertNotNull(ms);
			assertNotNull(ms.getCombatEpisodes());
			assertTrue("expected 1 combat episode",ms.getCombatEpisodes().size() == 1);
			CombatEpisode ce = (CombatEpisode)ms.getCombatEpisodes().iterator().next();
			System.out.println( "combat episode=" + ce.toString());
	}



	/*

What I expected were the following CEs:
1.  OIF     5/4/04 to 7/15/04    CZTE Pay Type (based on the Deployments highlighted in YELLOW that fall within the Military Svc in YELLOW)
2.  Conflict Unspecified    1/1/05 to 1/31/05   CZTE Pay Type (based on Military Pay in PINK  there were no Deployments within the Mil Pay)
3.  Conflict Unspecified    5/1/05 to 5/31/06   CZTE Pay Type (based on Military Pay in GREY  there were no Deployments within the Mil Pay)
4.  Conflict Unspecified    11/1/04 to 11/30/04   HF/ID Pay Type (based on Military Pay in GREEN  there were no Deployments within the Mil Pay)





	 */
	public void testCCR11407CombatEpisodesUATissue() throws Exception {
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		PeriodOfService periodOfService1 = new PeriodOfService();
		PeriodOfService periodOfService2 = new PeriodOfService();
		PeriodOfService periodOfService3 = new PeriodOfService();


		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(373963503).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		PersonEntityKey key =
			CommonEntityKeyFactory.createPersonIdEntityKey(String.valueOf(wrapper.getPersonId()));
		/*
        <BIRLS>
          <VerifiedSvcDataInd>Y</VerifiedSvcDataInd>
          <PeriodOfService>
            <EnteredOnDutyDate>1972-03-20</EnteredOnDutyDate>
            <ReleasedActiveDutyDate>1976-03-20</ReleasedActiveDutyDate>
            <BranchOfService>M</BranchOfService>
            <SeparationReason>SAT</SeparationReason>
            <CharacterOfService>HON</CharacterOfService>
          </PeriodOfService>
          */
		// BIRLS
		periodOfService1.setBranchOfService("M");
		periodOfService1.setCharacterOfService("HON");
		periodOfService1.setReleasedActiveDutyDate(this.getDate(1976,2,20));
		periodOfService1.setEnteredOnDutyDate(this.getDate(1972,02,20));


       /*   <PeriodOfService>
            <EnteredOnDutyDate>2004-04-18</EnteredOnDutyDate>
            <ReleasedActiveDutyDate>2005-02-16</ReleasedActiveDutyDate>
            <BranchOfService>ARMY</BranchOfService>
            <SeparationReason>SAT</SeparationReason>
            <CharacterOfService>HON</CharacterOfService>
          </PeriodOfService>*/
		// BIRLS
		periodOfService2.setBranchOfService("ARMY");
		periodOfService2.setCharacterOfService("HON");
		periodOfService2.setReleasedActiveDutyDate(this.getDate(2005,1,16));
		periodOfService2.setEnteredOnDutyDate(this.getDate(2004,3,18));


        /*  <PeriodOfService>
            <EnteredOnDutyDate>2005-03-16</EnteredOnDutyDate>
            <ReleasedActiveDutyDate>2006-05-27</ReleasedActiveDutyDate>
            <BranchOfService>ARMY</BranchOfService>
            <SeparationReason>SAT</SeparationReason>
            <CharacterOfService>HON</CharacterOfService>
          </PeriodOfService>
        </BIRLS>*/

		// BIRLS
		periodOfService3.setBranchOfService("ARMY");
		periodOfService3.setCharacterOfService("HON");
		periodOfService3.setReleasedActiveDutyDate(this.getDate(2006,4,27));
		periodOfService3.setEnteredOnDutyDate(this.getDate(2005,2,16));


		List periodOfServices = new ArrayList();
		periodOfServices.add(periodOfService1);
		periodOfServices.add(periodOfService2);
		periodOfServices.add(periodOfService3);

		birls.setPeriodOfService(periodOfServices);

		mockMilitaryHistory.setBirls(birls);



  /*<VADIR>
          <vaId>1112551111</vaId>
          <OefOifIndicator>02</OefOifIndicator>
          <RetirementStatusIndicator>N</RetirementStatusIndicator>
          <ServicePeriods>
            <StartDate>1982-08-25</StartDate>
            <EndDate>2007-01-31</EndDate>
            <BranchOfService>A</BranchOfService>
            <PersonnelCategory>N</PersonnelCategory>
            <CharacterOfService>Z</CharacterOfService>*/

		ServicePeriod servicePeriod1 = new ServicePeriod();
		servicePeriod1.setStartDate(this.getDate(1982,7,25));
		servicePeriod1.setEndDate(this.getDate(2007,0,31));
		servicePeriod1.setBranchOfService("A");
		servicePeriod1.setPersonnelCategory("N");
		servicePeriod1.setCharacterOfService("Z");

        /*    <Activations>
        <StartDate>2004-04-14</StartDate>
        <EndDate>2005-02-16</EndDate>
        <CharacterOfService>A</CharacterOfService>
      </Activations>*/

		Activation activation1 = new Activation();
		activation1.setStartDate(this.getDate(2004,3,14));
		activation1.setEndDate(this.getDate(2005,1,16));
		activation1.setCharacterOfService("A");

          /*  <Activations>
              <StartDate>2005-03-16</StartDate>
              <EndDate>2006-05-27</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <CharacterOfService>A</CharacterOfService>
            </Activations>*/
		Activation activation2 = new Activation();
		activation2.setStartDate(this.getDate(2005,2,16));
		activation2.setEndDate(this.getDate(2006,4,27));
		activation2.setTerminationRsn("C");
		activation2.setCharacterOfService("A");

           /* <MilitaryPayments>
              <StartDate>2004-05-01</StartDate>
              <EndDate>2004-07-31</EndDate>
              <PayType>01</PayType>
              <CombatServiceLocation>KU</CombatServiceLocation>
            </MilitaryPayments>*/
		MilitaryPay pay = new MilitaryPay();
		pay.setPayType("01");
		pay.setStartDate(this.getDate(2004,4,1));
		pay.setEndDate(this.getDate(2004,6,31));
		pay.setCombatServiceLocation("KU"); // MSDS_CodeCR10606 disabled
 /*           <MilitaryPayments>
              <StartDate>2005-01-01</StartDate>
              <EndDate>2005-01-31</EndDate>
              <PayType>01</PayType>
              <CombatServiceLocation>KU</CombatServiceLocation>
            </MilitaryPayments>*/
		MilitaryPay pay1 = new MilitaryPay();
		pay1.setPayType("01");
		pay1.setStartDate(this.getDate(2005,0,1));
		pay1.setEndDate(this.getDate(2005,0,31));
		pay1.setCombatServiceLocation("KU"); // MSDS_CodeCR10606 disabled
     /*       <MilitaryPayments>
              <StartDate>2005-05-01</StartDate>
              <EndDate>2006-05-31</EndDate>
              <PayType>01</PayType>
              <CombatServiceLocation>KU</CombatServiceLocation>
            </MilitaryPayments>*/
		MilitaryPay pay2 = new MilitaryPay();
		pay2.setPayType("01");
		pay2.setStartDate(this.getDate(2005,4,1));
		pay2.setEndDate(this.getDate(2006,8,31));
		pay2.setCombatServiceLocation("KU"); // MSDS_CodeCR10606 disabled
  /*          <MilitaryPayments>
              <StartDate>2004-05-01</StartDate>  Same dates as Pay Type 01, so this is ignored
              <EndDate>2004-07-31</EndDate>
              <PayType>02</PayType>
           </MilitaryPayments>*/
		MilitaryPay pay3 = new MilitaryPay();
		pay3.setPayType("02");
		pay3.setStartDate(this.getDate(2004,4,1));
		pay3.setEndDate(this.getDate(2004,6,31));
    /*        <MilitaryPayments>
              <StartDate>2004-11-01</StartDate>
              <EndDate>2004-11-30</EndDate>
              <PayType>02</PayType>
            </MilitaryPayments>*/
		MilitaryPay pay4 = new MilitaryPay();
		pay4.setPayType("02");
		pay4.setStartDate(this.getDate(2004,10,1));
		pay4.setEndDate(this.getDate(2004,10,30));

   /*         <MilitaryPayments>
              <StartDate>2005-01-01</StartDate>  Same dates as Pay Type 01, so this is ignored
              <EndDate>2005-01-31</EndDate>
              <PayType>02</PayType>
            </MilitaryPayments>*/
		MilitaryPay pay5 = new MilitaryPay();
		pay5.setPayType("02");
		pay5.setStartDate(this.getDate(2005,0,1));
		pay5.setEndDate(this.getDate(2005,0,31));

      /*      <MilitaryPayments>
              <StartDate>2005-05-01</StartDate>  Same dates as Pay Type 01, so this is ignored
              <EndDate>2006-05-31</EndDate>
              <PayType>02</PayType>
            </MilitaryPayments>*/
		MilitaryPay pay6 = new MilitaryPay();
		pay6.setPayType("02");
		pay6.setStartDate(this.getDate(2005,4,1));//4,1
		pay6.setEndDate(this.getDate(2006,4,31));//was 4,31



		/*         <Deployments>
              <StartDate>2004-05-04</StartDate>
              <EndDate>2004-05-26</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>KU</Location>
            </Deployments>*/
		Deployment deployment1 = new Deployment();
		deployment1.setStartDate(this.getDate(2004,4,4));
		deployment1.setEndDate(this.getDate(2004,4,26));
		deployment1.setTerminationRsn("C");
		deployment1.setSpecialOperation("10");
		deployment1.setLocation("KU"); // MSDS_CodeCR10606 disabled

        /*    <Deployments>
              <StartDate>2004-06-26</StartDate>
              <EndDate>2004-07-15</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>KU</Location>
            </Deployments>*/
		Deployment deployment2 = new Deployment();
		deployment2.setStartDate(this.getDate(2004,5,26));
		deployment2.setEndDate(this.getDate(2004,6,15));
		deployment2.setTerminationRsn("C");
		deployment2.setSpecialOperation("10");
		deployment2.setLocation("KU"); // MSDS_CodeCR10606 disabled
           /* <Deployments>
              <StartDate>2005-06-04</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>IZ</Location>
            </Deployments>*/
		Deployment deployment3 = new Deployment();
		deployment3.setStartDate(this.getDate(2005,5,4));
		deployment3.setEndDate(this.getDate(2005,1,16));
		deployment3.setTerminationRsn("C");
		deployment3.setSpecialOperation("10");
		deployment3.setLocation("IZ"); // MSDS_CodeCR10606 disabled
       /*     <Deployments>
              <StartDate>2005-07-24</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>IZ</Location>
            </Deployments>*/
		Deployment deployment4 = new Deployment();
		deployment4.setStartDate(this.getDate(2005,6,24));
		deployment4.setEndDate(this.getDate(2005,1,16));
		deployment4.setTerminationRsn("C");
		deployment4.setSpecialOperation("10");
		deployment4.setLocation("IZ"); // MSDS_CodeCR10606 disabled
            /*<Deployments>
              <StartDate>2005-10-04</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>IZ</Location>
            </Deployments>*/
		Deployment deployment5 = new Deployment();
		deployment5.setStartDate(this.getDate(2005,9,4));
		deployment5.setEndDate(this.getDate(2005,1,16));
		deployment5.setTerminationRsn("C");
		deployment5.setSpecialOperation("10");
		deployment5.setLocation("IZ"); // MSDS_CodeCR10606 disabled
            /*<Deployments>
              <StartDate>2005-10-29</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>IZ</Location>
            </Deployments>*/
		Deployment deployment6 = new Deployment();
		deployment6.setStartDate(this.getDate(2005,9,29));
		deployment6.setEndDate(this.getDate(2005,1,16));
		deployment6.setTerminationRsn("C");
		deployment6.setSpecialOperation("10");
		deployment6.setLocation("IZ"); // MSDS_CodeCR10606 disabled
            /*<Deployments>
              <StartDate>2006-01-14</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>IZ</Location>
            </Deployments>*/
		Deployment deployment7 = new Deployment();
		deployment7.setStartDate(this.getDate(2006,0,14));
		deployment7.setEndDate(this.getDate(2005,1,16));
		deployment7.setTerminationRsn("C");
		deployment7.setSpecialOperation("10");
		deployment7.setLocation("IZ"); // MSDS_CodeCR10606 disabled
           /* <Deployments>
              <StartDate>2006-01-16</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>IZ</Location>
            </Deployments>*/
		Deployment deployment8 = new Deployment();
		deployment8.setStartDate(this.getDate(2006,0,16));
		deployment8.setEndDate(this.getDate(2005,1,16));
		deployment8.setTerminationRsn("C");
		deployment8.setSpecialOperation("10");
		deployment8.setLocation("IZ"); // MSDS_CodeCR10606 disabled
            /*<Deployments>
              <StartDate>2006-01-26</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>IZ</Location>
            </Deployments>*/
		Deployment deployment9 = new Deployment();
		deployment9.setStartDate(this.getDate(2006,0,26));
		deployment9.setEndDate(this.getDate(2005,1,16));
		deployment9.setTerminationRsn("C");
		deployment9.setSpecialOperation("10");
		deployment9.setLocation("IZ"); // MSDS_CodeCR10606 disabled
            /*<Deployments>
              <StartDate>2006-02-20</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>IZ</Location>
            </Deployments>*/
		Deployment deployment10 = new Deployment();
		deployment10.setStartDate(this.getDate(2006,1,20));
		deployment10.setEndDate(this.getDate(2005,1,16));
		deployment10.setTerminationRsn("C");
		deployment10.setSpecialOperation("10");
		deployment10.setLocation("IZ"); // MSDS_CodeCR10606 disabled
            /*<Deployments>
              <StartDate>2006-02-24</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>IZ</Location>
            </Deployments>*/
		Deployment deployment11 = new Deployment();
		deployment11.setStartDate(this.getDate(2006,1,24));
		deployment11.setEndDate(this.getDate(2005,1,16));
		deployment11.setTerminationRsn("C");
		deployment11.setSpecialOperation("10");
		deployment11.setLocation("IZ"); // MSDS_CodeCR10606 disabled
            /*<Deployments>
              <StartDate>2006-04-21</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
             <Location>IZ</Location>
            </Deployments>*/
		Deployment deployment12 = new Deployment();
		deployment12.setStartDate(this.getDate(2006,3,21));
		deployment12.setEndDate(this.getDate(2005,1,16));
		deployment12.setTerminationRsn("C");
		deployment12.setSpecialOperation("10");
		deployment12.setLocation("IZ"); // MSDS_CodeCR10606 disabled
         /*   <Deployments>
              <StartDate>2004-10-23</StartDate>
              <EndDate>2004-11-18</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>KU</Location>
            </Deployments>*/
		Deployment deployment13 = new Deployment();
		deployment13.setStartDate(this.getDate(2004,9,23));
		deployment13.setEndDate(this.getDate(2004,10,18));
		deployment13.setTerminationRsn("C");
		deployment13.setSpecialOperation("10");
		deployment13.setLocation("KU"); // MSDS_CodeCR10606 disabled
            /*<Deployments>
              <StartDate>2004-12-07</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>KU</Location>
            </Deployments>*/
		Deployment deployment14 = new Deployment();
		deployment14.setStartDate(this.getDate(2004,11,7));
		deployment14.setEndDate(this.getDate(2005,1,16));
		deployment14.setTerminationRsn("C");
		deployment14.setSpecialOperation("10");
		deployment14.setLocation("KU"); // MSDS_CodeCR10606 disabled
           /* <Deployments>
              <StartDate>2005-05-12</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>KU</Location>
            </Deployments>*/
		Deployment deployment15 = new Deployment();
		deployment15.setStartDate(this.getDate(2005,4,12));
		deployment15.setEndDate(this.getDate(2005,1,16));
		deployment15.setTerminationRsn("C");
		deployment15.setSpecialOperation("10");
		deployment15.setLocation("KU"); // MSDS_CodeCR10606 disabled
          /*  <Deployments>
              <StartDate>2005-05-15</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>KU</Location>
            </Deployments>*/
		Deployment deployment16 = new Deployment();
		deployment16.setStartDate(this.getDate(2005,4,15));
		deployment16.setEndDate(this.getDate(2005,1,16));
		deployment16.setTerminationRsn("C");
		deployment16.setSpecialOperation("10");
		deployment16.setLocation("KU"); // MSDS_CodeCR10606 disabled
          /*  <Deployments>
              <StartDate>2004-11-19</StartDate>
              <EndDate>2004-12-06</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>ZZ</Location>
            </Deployments>*/
		Deployment deployment17 = new Deployment();
		deployment17.setStartDate(this.getDate(2004,10,19));
		deployment17.setEndDate(this.getDate(2004,11,6));
		deployment17.setTerminationRsn("C");
		deployment17.setSpecialOperation("10");
		deployment17.setLocation("ZZ"); // MSDS_CodeCR10606 disabled
          /*   <Deployments>
             <StartDate>2005-06-03</StartDate>
              <EndDate>2005-02-16</EndDate>
              <TerminationRsn>C</TerminationRsn>
              <SpecialOperation>10</SpecialOperation>
              <Location>ZZ</Location>
            </Deployments>
          </ServicePeriods> */
		Deployment deployment18 = new Deployment();
		deployment18.setStartDate(this.getDate(2005,5,3));
		deployment18.setEndDate(this.getDate(2005,1,16));
		deployment18.setTerminationRsn("C");
		deployment18.setSpecialOperation("10");
		deployment18.setLocation("ZZ"); // MSDS_CodeCR10606 disabled


          /*
          <ServicePeriods>
            <StartDate>2008-10-01</StartDate>
            <BranchOfService>A</BranchOfService>
            <PersonnelCategory>Q</PersonnelCategory>
          </ServicePeriods>
        </VADIR> */
		ServicePeriod servicePeriod2 = new ServicePeriod();
		servicePeriod2.setStartDate(this.getDate(2008,9,1));
		servicePeriod2.setBranchOfService("A");
		servicePeriod2.setPersonnelCategory("Q");

		// VADIR


		// Deployments
		List deployments = new ArrayList();
		deployments.add(deployment1);
		deployments.add(deployment2);
		deployments.add(deployment3);
		deployments.add(deployment4);
		deployments.add(deployment5);
		deployments.add(deployment6);
		deployments.add(deployment7);
		deployments.add(deployment8);
		deployments.add(deployment9);
		deployments.add(deployment10);
		deployments.add(deployment11);
		deployments.add(deployment12);
		deployments.add(deployment13);
		deployments.add(deployment14);
		deployments.add(deployment15);
		deployments.add(deployment16);
		deployments.add(deployment17);
		deployments.add(deployment18);

		servicePeriod1.setDeployments(deployments);

		// Activations
		List activations = new ArrayList();
		activations.add(activation1);
		activations.add(activation2);
		servicePeriod1.setActivations(activations);

		// Combat Service


		List pays = new ArrayList();
		pays.add(pay);
		pays.add(pay1);
		pays.add(pay2);
		pays.add(pay3);
		pays.add(pay4);
		pays.add(pay5);
		pays.add(pay6);
		servicePeriod1.setMilitaryPayments(pays);



		List servicePeriods = new ArrayList();
		servicePeriods.add(servicePeriod1);
		servicePeriods.add(servicePeriod2);

		// 01 OEF, 02 OIF, 03 both OEF and OIF, 04 neither/unable to determine
		vadir.setOefOifIndicator("02");
		vadir.setServicePeriods(servicePeriods);

		mockMilitaryHistory.setVadir(vadir);
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		MilitaryService ms = info.getVadirMilitaryService();
		//assertNotNull(ms);
		//assertNotNull(ms.getCombatEpisodes());
		//assertTrue("expected 1 combat episode",ms.getCombatEpisodes().size() == 1);
		//CombatEpisode ce = (CombatEpisode)ms.getCombatEpisodes().iterator().next();
		//System.out.println( "ms=" + ms);
		for (Iterator itr = ms.getCombatEpisodes().iterator(); itr.hasNext();) {
			CombatEpisode c = (CombatEpisode)itr.next();
		//	System.out.println( "combat episode type=" + c.getCombatPayType().getDescription());
			System.out.println( "combat episode start date=" + c.getStartDate() + "   combat episode end date=" + c.getEndDate());

		}

		Person result = this.getMilitaryInfoService().processMSDSData(info);
		ms = result.getMilitaryService();
		System.out.println( "AFTER PROCESS MSDS");
		System.out.println( "ms=" + ms);
		for (Iterator itr = ms.getCombatEpisodes().iterator(); itr.hasNext();) {
			CombatEpisode c = (CombatEpisode)itr.next();
//			System.out.println( "combat episode type=" + c.getCombatPayType().getDescription());
			System.out.println( "combat episode end date=" + c.getEndDate());
		}
		for (Iterator itr = ms.getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator(); itr.hasNext();) {
			MilitaryServiceEpisode e = (MilitaryServiceEpisode)itr.next();
			System.out.println( "result mse =  "+e);
		}
		//this.setComplete();
    }

	public void testCCR11407UATissue() throws Exception {
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		PeriodOfService periodOfService1 = new PeriodOfService();


		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(373963503).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		PersonEntityKey key =
			CommonEntityKeyFactory.createPersonIdEntityKey(String.valueOf(wrapper.getPersonId()));

		ServicePeriod servicePeriod1 = new ServicePeriod();
		servicePeriod1.setStartDate(this.getDate(1982,7,25));
		servicePeriod1.setEndDate(this.getDate(2007,0,31));
		servicePeriod1.setBranchOfService("A");
		servicePeriod1.setPersonnelCategory("N");
		servicePeriod1.setCharacterOfService("Z");

		MilitaryPay pay = new MilitaryPay();
		pay.setPayType("01");
		/* use these dates to stop CE from being created
		pay.setStartDate(this.getDate(1990,4,1));
		pay.setEndDate(this.getDate(1990,6,31));
		 */
		pay.setStartDate(this.getDate(1990,4,1));
		pay.setEndDate(this.getDate(1990,6,31));

		/* use these dates to allow CE to be created
		pay.setStartDate(this.getDate(2004,4,1));
		pay.setEndDate(this.getDate(2004,6,31));
		 */
		pay.setCombatServiceLocation("KU"); // MSDS_CodeCR10606 disabled

		// Combat Service
		List pays = new ArrayList();
		pays.add(pay);
		servicePeriod1.setMilitaryPayments(pays);
		List servicePeriods = new ArrayList();
		servicePeriods.add(servicePeriod1);

		// 01 OEF, 02 OIF, 03 both OEF and OIF, 04 neither/unable to determine
		vadir.setOefOifIndicator("02");
		vadir.setServicePeriods(servicePeriods);
		mockMilitaryHistory.setVadir(vadir);
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		MilitaryService ms = info.getVadirMilitaryService();
		//assertNotNull(ms);
		//assertNotNull(ms.getCombatEpisodes());
		//assertTrue("expected 1 combat episode",ms.getCombatEpisodes().size() == 1);
		//CombatEpisode ce = (CombatEpisode)ms.getCombatEpisodes().iterator().next();
		System.out.println( "ms=" + ms);
		for (Iterator itr = ms.getCombatEpisodes().iterator(); itr.hasNext();) {
			CombatEpisode c = (CombatEpisode)itr.next();
			System.out.println( "combat episode type=" + c.getCombatPayType().getDescription());
		}

		Person result = this.getMilitaryInfoService().processMSDSData(info);
		ms = result.getMilitaryService();
		System.out.println( "AFTER PROCESS MSDS");
		System.out.println( "ms=" + ms);
		for (Iterator itr = ms.getCombatEpisodes().iterator(); itr.hasNext();) {
			CombatEpisode c = (CombatEpisode)itr.next();
			System.out.println( "combat episode type=" + c.getCombatPayType().getDescription());
		}
		for (Iterator itr = ms.getCombatServices().iterator(); itr.hasNext();) {
			CombatService c = (CombatService)itr.next();
			System.out.println( "combat service (pay) e=" + c);
		}
		//this.setComplete();
	}
	public void testCCR11407AcceptMSEfromActivation() throws Exception {
		// This test requires a person without any MSEs. The idea
		// is to get the processMSDS rules to accept the MSE created
		// from Vadir Activation data, even though no improvement in EE is noted.

		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		PeriodOfService periodOfService1 = new PeriodOfService();
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		// The person id must reference person that meets data requirements
		wrapper.setPersonId(new Long(373963503).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		PersonEntityKey key =
			CommonEntityKeyFactory.createPersonIdEntityKey(String.valueOf(wrapper.getPersonId()));

		ServicePeriod servicePeriod1 = new ServicePeriod();
		servicePeriod1.setStartDate(this.getDate(1982,7,25));
		servicePeriod1.setEndDate(this.getDate(2002,0,31));
		servicePeriod1.setBranchOfService("A");
//		servicePeriod1.setPersonnelCategory("N");
//		servicePeriod1.setPersonnelCategory("V");
		servicePeriod1.setPersonnelCategory("Q");
		servicePeriod1.setCharacterOfService("HON");
		Activation activation1 = new Activation();
		activation1.setStartDate(this.getDate(2004,3,14));
		activation1.setEndDate(this.getDate(2005,1,29));
		activation1.setCharacterOfService("F");
		Activation activation2 = new Activation();
		activation2.setStartDate(this.getDate(2005,2,16));
		activation2.setEndDate(this.getDate(2006,9,27));
		activation2.setTerminationRsn("C");
		activation2.setCharacterOfService("A");
		List servicePeriods = new ArrayList();
		servicePeriods.add(servicePeriod1);
		List activations = new ArrayList();
		activations.add(activation1);
		activations.add(activation2);
		servicePeriod1.setActivations(activations);
		vadir.setServicePeriods(servicePeriods);

		mockMilitaryHistory.setVadir(vadir);
		wrapper.setResult(mockMilitaryHistory);
		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		MilitaryService ms = info.getVadirMilitaryService();
		for (Iterator itr = ms.getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator(); itr.hasNext();) {
			MilitaryServiceEpisode e = (MilitaryServiceEpisode)itr.next();
			System.out.println( "incoming mse =  "+e);
		}
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		ms = result.getMilitaryService();
		System.out.println( "AFTER PROCESS MSDS");
		for (Iterator itr = ms.getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator(); itr.hasNext();) {
			MilitaryServiceEpisode e = (MilitaryServiceEpisode)itr.next();
			System.out.println( "result mse =  "+e);
		}
		//this.setComplete();
	}
	public void testCCR11407AcceptMSEsimpleMatchUpdate() throws Exception {
		// You have to null out the Char of Discharge for MSEs affected by
		// the change to existing MSE

		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		PeriodOfService periodOfService1 = new PeriodOfService();
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		// The person id must reference person that meets data requirements
		wrapper.setPersonId(new Long(373963503).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		PersonEntityKey key =
			CommonEntityKeyFactory.createPersonIdEntityKey(String.valueOf(wrapper.getPersonId()));

		ServicePeriod servicePeriod1 = new ServicePeriod();
		servicePeriod1.setStartDate(this.getDate(1982,7,25));
		servicePeriod1.setEndDate(this.getDate(2002,0,31));
		servicePeriod1.setBranchOfService("A");
//		servicePeriod1.setPersonnelCategory("N");
//		servicePeriod1.setPersonnelCategory("V");
		servicePeriod1.setPersonnelCategory("Q");
		servicePeriod1.setCharacterOfService("HON");
		Activation activation1 = new Activation();
		activation1.setStartDate(this.getDate(2004,3,14));
		activation1.setEndDate(this.getDate(2005,2,14));
		activation1.setCharacterOfService("A");
		Activation activation2 = new Activation();
		activation2.setStartDate(this.getDate(2005,2,16));
		activation2.setEndDate(this.getDate(2006,9,27));
		activation2.setTerminationRsn("C");
		activation2.setCharacterOfService("A");
		List servicePeriods = new ArrayList();
		servicePeriods.add(servicePeriod1);
		List activations = new ArrayList();
		activations.add(activation1);
		activations.add(activation2);
		servicePeriod1.setActivations(activations);
		vadir.setServicePeriods(servicePeriods);

		mockMilitaryHistory.setVadir(vadir);
		wrapper.setResult(mockMilitaryHistory);
		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		MilitaryService ms = info.getVadirMilitaryService();
		for (Iterator itr = ms.getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator(); itr.hasNext();) {
			MilitaryServiceEpisode e = (MilitaryServiceEpisode)itr.next();
			System.out.println( "incoming mse char discharge=  "+e.getDischargeType().getDescription() + "  end date=" +
					e.getEndDate().toString());
		}
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		ms = result.getMilitaryService();
		System.out.println( "AFTER PROCESS MSDS");
		for (Iterator itr = ms.getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator(); itr.hasNext();) {
			MilitaryServiceEpisode e = (MilitaryServiceEpisode)itr.next();
			System.out.println( "result mse char discharge=  "+e.getDischargeType().getDescription() + "  end date=" +
					e.getEndDate().toString());
		}
		//this.setComplete();
	}
	// GOAL
	public void testCombatEpisodeStrategy() throws Exception {
		// Create Vadir Deployment
		String NOBLE_EAGLE = SpecialOperation.OPERATION_NOBLE_EAGLE.getCode();
		String IRAQI_FREEDOM = SpecialOperation.OPERATION_IRAQI_FREEDOM.getCode();
		String ENDURING_FREEDOM = SpecialOperation.OPERATION_ENDURING_FREEDOM.getCode();

		Deployment enduring = this.createVadirDeployment(
				this.getDate(2002, 1, 8),this.getDate(2003, 1, 8),
				"D", ENDURING_FREEDOM, "ZZ");
		Deployment eagle = this.createVadirDeployment(
				this.getDate(2002, 1, 8),this.getDate(2003, 1, 8),
				"D", NOBLE_EAGLE, "ZZ");
		Deployment iraqi = this.createVadirDeployment(
				this.getDate(2002, 1, 8),this.getDate(2003, 1, 8),
				"D", IRAQI_FREEDOM, "ZZ");
		Deployment bosnia = this.createVadirDeployment(this.getDate(2002, 1, 8),this.getDate(2003, 1, 8),
				"D", SpecialOperation.BOSNIA.getCode(), "ZZ");

		// Deployments
		List deployments = new ArrayList();
		deployments.add(enduring);
		deployments.add(bosnia);

		Date payStartDate = this.getDate(2002, 1, 8);
		Date payEndDate = this.getDate(2003, 1, 8);


		String lc = null;
		lc = processStrategy(payStartDate, payEndDate, null);
		assertNotNull(lc);

		//---enduring--------------------------------------------
		lc = processStrategy(payStartDate, payEndDate, deployments);

		assertTrue(ConflictLocation.CODE_OEF.getCode().equals(lc));

		//--multiple with ALL exclusions-----------------------------------------
		deployments.clear();
		deployments.add(bosnia);
		deployments.add(enduring);
		deployments.add(eagle);
		deployments.add(iraqi);
		payStartDate = this.getDate(2000, 1, 8);
		payEndDate = this.getDate(2002, 1, 8);

		lc = processStrategy(payStartDate, payEndDate, deployments);
		assertTrue(ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode().equals(lc));

		//--multiple---------------------------------------------

		payStartDate = this.getDate(2002, 1, 8);
		payEndDate = this.getDate(2003, 1, 8);
		lc = processStrategy(payStartDate, payEndDate, deployments);
		assertTrue(ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode().equals(lc));

		//---eagle--------------------------------------------
		deployments.clear();
		deployments.add(bosnia);
		deployments.add(eagle);

		lc = processStrategy(payStartDate, payEndDate, deployments);
		assertTrue(ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode().equals(lc));

		//---eagle--------------------------------------------
		deployments.clear();
		deployments.add(bosnia);
		deployments.add(iraqi);
		lc = processStrategy(payStartDate, payEndDate, deployments);
		assertTrue(ConflictLocation.CODE_OIF.getCode().equals(lc));

		//---default--------------------------------------------
		deployments.clear();
		deployments.add(bosnia);

		lc = processStrategy(payStartDate, payEndDate, deployments);
		assertTrue(ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode().equals(lc));

	}

	private String processStrategy(Date start, Date end, List deployments) {
		VadirCombatEpisodeBuilderStrategy strategy = new VadirCombatEpisodeBuilderStrategy();
		strategy.setCombatPayStart(start);
		strategy.setCombatPayEnd(end);
		strategy.setDeployments(deployments);
		return strategy.determineConflictLocationCode();
	}

	// GOAL
	public void testCombatServiceStrategy() throws Exception {
		// Combat Service
		CombatPayType.Code czte = CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION;
		CombatPayType.Code hfid = CombatPayType.CODE_HOSTILE_FIRE_IMMINENT_DANGER;
		MilitaryPay pay1 =
			this.createVadirMilitaryPay("ZZ",this.getDate(2002, 1, 1),
					this.getDate(2005, 6, 8),czte);
		MilitaryPay pay2 =
			this.createVadirMilitaryPay("ZZ",this.getDate(2003, 1, 1),
					this.getDate(2006, 6, 8), hfid);
		MilitaryPay pay3 =
			this.createVadirMilitaryPay("ZZ",this.getDate(2003, 1, 1),
					this.getDate(2006, 6, 8), czte);
		MilitaryPay pay4 =
			this.createVadirMilitaryPay("ZZ",this.getDate(2007, 1, 1),
					this.getDate(2009, 6, 8),czte);
		MilitaryPay pay5 =
			this.createVadirMilitaryPay("ZZ",this.getDate(2000, 1, 1),
					this.getDate(2003, 6, 8),czte);
		MilitaryPay pay6 =
			this.createVadirMilitaryPay("ZZ",this.getDate(2010, 1, 1),
					this.getDate(2011, 6, 8),hfid);

		MilitaryPay pay7 =
			this.createVadirMilitaryPay("ZZ",this.getDate(2002, 10, 1),
					this.getDate(2005, 8, 8),hfid);

		List pays = new ArrayList();
		pays.add(pay1);
		pays.add(pay2);
		pays.add(pay3);
		pays.add(pay4);
		pays.add(pay5);
		pays.add(pay6);
		pays.add(pay7);

		VadirCombatServiceBuilderStrategy strategy = new VadirCombatServiceBuilderStrategy();
		List toKeep = strategy.determineMilitaryPayToKeep(null);
		assertNotNull("list should not be null",toKeep);

		toKeep = strategy.determineMilitaryPayToKeep(pays);
		assertNotNull("list should never be null when list is provided",toKeep);
		assertTrue("list size should be greater than 0",toKeep.size() > 0);
		for (Iterator itr = toKeep.iterator(); itr.hasNext();) {
			MilitaryPay record = (MilitaryPay)itr.next();
			System.out.println( "type=" + record.getPayType());
			System.out.println( "start=" + record.getStartDate());
			System.out.println( "end=" + record.getEndDate());
		}

	}

	// GOAL
	public void testCCR10681_NewCodes() throws Exception {
		Long id = new Long(490823);

		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();

		List periodOfServices = new ArrayList();
		birls.setPeriodOfService(periodOfServices);
		periodOfServices.add(createBirlsPeriodOfService("ANG","HVA",getDate(1969, 11, 6),getDate(1973, 8, 26)));
		periodOfServices.add(createBirlsPeriodOfService("ARNG","DVA",getDate(1969, 11, 6),getDate(1973, 8, 26)));

		birls.setPeriodOfService(periodOfServices);

		mockMilitaryHistory.setBirls(birls);
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();

		wrapper.setPersonId(id.longValue());
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		MilitaryServiceEpisode mse = (MilitaryServiceEpisode)info.getBirlsMilitaryService().getHECMilitaryServiceSiteRecord().
		getMilitaryServiceEpisodes().iterator().next();
		assertNotNull("mse component should be non null", mse.getMilitaryServiceComponent());
		mse = (MilitaryServiceEpisode)info.getBirlsMilitaryService().getHECMilitaryServiceSiteRecord().
		getMilitaryServiceEpisodes().iterator().next();
		assertNotNull("mse component should be non null", mse.getMilitaryServiceComponent());

		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertNotNull(result);
		//this.setComplete();
	}
//	  public DAOOperations getGenericDAO() throws ServiceException{
//	        if(genericDAO == null) {
//	            genericDAO = (DAOOperations)applicationContext.getBean("genericDAO");
//	        }
//	        return this.genericDAO;
//	    }


	//MSDS_CodeCR10670_CR_Recomputation of the CV End Date
	public void testUpdateMSEFromUI() throws Exception {
		// 8195
		//Person onFile = this.getPerson("286186");
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);
		ImpreciseDate id = new ImpreciseDate("20101112");
		Date cv = ImpreciseDateUtils.getDateWithDefault(new ImpreciseDate("20151111"));
		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("20001112"), id);

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		m.addMilitaryServiceEpisode(mse);

		onFile.getMilitaryService().setCombatVeteranEligibilityEndDate(cv);
		CombatEpisode cee = new CombatEpisode();
		cee.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OEF.getCode()));
		cee.setStartDate(ImpreciseDateUtils.createImpreciseDate(2002,2,1));
		cee.setEndDate(ImpreciseDateUtils.createImpreciseDate(2008,11,1));
		onFile.getMilitaryService().addCombatEpisode(cee);

		Person incoming = this.savePerson(onFile);

		MilitaryServiceEpisode changed = (MilitaryServiceEpisode)incoming.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator().next();

		Date updatedCv = ImpreciseDateUtils.getDateWithDefault(new ImpreciseDate("20141112"));
		changed.setEndDate(new ImpreciseDate("20091112"));

		Person result = this.getMilitaryInfoService().updateMilitaryServiceInformation(incoming);

		Date d = result.getMilitaryService().getCombatVeteranEligibilityEndDate();
		System.out.println( "original=" + cv );
		System.out.println( "updated=" + d );
		System.out.println( "equal=" + ObjectUtils.equals(d,cv) );

		assertTrue("CV date should be prior when receiving prior date from EST UI",DateUtils.isBefore(d, cv));
	}
	/**
	IF
	 The veteran is Combat Veteran Eligible
	AND
	 The veteran has no enrollment record prior to the NDAA Date of Enactment (1/28/2008)
	***AND
	*** The most recent of:
	*** SSD (if one exists),
	*** Combat To Date,
	*** Activation End Date, OR Combat Pay End Date]
	*** is less than 1/28/03 (five years prior to the NDAA Date of Enactment)
	THEN
	***  The system automatically sets the CV Eligibility End Date = 01/27/11 (NDAA Date of Enactment +
	***  3 years  1 day)
	ELSE
	***  The system automatically sets the CV Eligibility End Date = the most recent of
	***  [SSD + 5 years minus 1 day, OR
	***  Combat To Date + 5 years minus 1 day.
	*/
	public void testCodeCR10709_UI_NDAADatePlus3YearsMinus1Day() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);

		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), new ImpreciseDate("20021112"));

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);


		CombatEpisode cee = new CombatEpisode();
		cee.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OEF.getCode()));
		cee.setStartDate(ImpreciseDateUtils.createImpreciseDate(2000,4,1));
		cee.setEndDate(ImpreciseDateUtils.createImpreciseDate(2002,10,1));
		onFile.getMilitaryService().addCombatEpisode(cee);

		onFile.getMilitaryService().setCombatVeteranEligibilityEndDate(null);
		Person incoming = this.savePerson(onFile);

		MilitaryServiceEpisode changed = (MilitaryServiceEpisode)incoming.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator().next();
		changed.setEndDate(new ImpreciseDate("20021114"));

		Person result = this.getMilitaryInfoService().updateMilitaryServiceInformation(incoming);

		Date d = result.getMilitaryService().getCombatVeteranEligibilityEndDate();

		ImpreciseDate ddd =  new ImpreciseDate("20110127");
		System.out.println( "updated=" + d );
		System.out.println( "updated=" + ddd.getDate());
		assertTrue("CV date should equal 01/27/2011", ObjectUtils.equals(ddd.getDate(),d));
	}
	public void testCodeCR10709_UI_CombatPayOnly() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);

		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), new ImpreciseDate("20021112"));

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);

		ImpreciseDate start = new ImpreciseDate("20091112");
		ImpreciseDate end = new ImpreciseDate("20110127");
		CombatService cs = new CombatService();
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		onFile.getMilitaryService().addCombatService(cs);

		Person incoming = this.savePerson(onFile);
		MilitaryServiceEpisode changed = (MilitaryServiceEpisode)incoming.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator().next();
		changed.setEndDate(new ImpreciseDate("20021114"));
		Person result = this.getMilitaryInfoService().updateMilitaryServiceInformation(incoming);

		Date d = result.getMilitaryService().getCombatVeteranEligibilityEndDate();

		ImpreciseDate ddd =  new ImpreciseDate("20110127");
		System.out.println( "updated=" + d );
		System.out.println( "updated=" + ddd.getDate());
		assertTrue("CV date should equal 01/27/2011", ObjectUtils.equals(ddd.getDate(),d));
	}

	/*
	 * ESR 3.4 MSDS -- Combat Pay record that uploaded to ESR with no Combat Pay
	 * End Date. The business does NOT want to upload those records.
	 *
	 */
	public void testCodeCR10801WithNullEnd() throws Exception {
		ImpreciseDate start = new ImpreciseDate("20091112");
		ImpreciseDate end = null;

		Person person = this.testCodeCR10801(start, end);
		assertTrue("Combat Pay should be null", person.getMilitaryService().getCombatServices().isEmpty());

	}
	public void testCodeCR10801WithBothDates() throws Exception {
		ImpreciseDate start = new ImpreciseDate("20091112");
		ImpreciseDate end = new ImpreciseDate("20101114");

		Person person = this.testCodeCR10801(start, end);
		assertTrue("Combat Pay should not be null", !person.getMilitaryService().getCombatServices().isEmpty());

	}
	private Person testCodeCR10801(ImpreciseDate start, ImpreciseDate end) throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);

		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), new ImpreciseDate("20021112"));

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);

		Person incoming = this.savePerson(onFile);

		CombatService cs = new CombatService();

		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		MilitaryService vadirMilitaryService = new MilitaryService();
		vadirMilitaryService.addCombatService(cs);
		MsdsResponseInfo info = new MsdsResponseInfo();
		info.setVadirMilitaryService(vadirMilitaryService);
		boolean flag  = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		return onFile;


	}
	public void testCodeCR10709_NDAADatePlus3YearsMinus1Day() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);

		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), new ImpreciseDate("20021112"));

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);

		Person incoming = this.savePerson(onFile);

		CombatService cs = new CombatService();
		ImpreciseDate start = new ImpreciseDate("20091112");
		ImpreciseDate end = new ImpreciseDate("201007");
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		MilitaryService vadirMilitaryService = new MilitaryService();
		vadirMilitaryService.addCombatService(cs);
		MsdsResponseInfo info = new MsdsResponseInfo();
		info.setVadirMilitaryService(vadirMilitaryService);
		boolean flag  = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);

		Date d = onFile.getMilitaryService().getCombatVeteranEligibilityEndDate();

		assertNotNull("cv end date should not be null",d);
		ImpreciseDate ddd =  new ImpreciseDate("20110127");
		System.out.println( "updated=" + d );
		System.out.println( "updated=" + ddd.getDate());
		assertTrue("CV date should equal 01/27/2011", ObjectUtils.equals(ddd.getDate(),d));
	}

	public void testCodeCR11681_CV_Calculation() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);

		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), new ImpreciseDate("20101112"));

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);

		Person incoming = this.savePerson(onFile);

		CombatService cs = new CombatService();
		ImpreciseDate start = new ImpreciseDate("20011112");
		ImpreciseDate end = new ImpreciseDate("20020707");
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		MilitaryService vadirMilitaryService = new MilitaryService();
		vadirMilitaryService.addCombatService(cs);
		MsdsResponseInfo info = new MsdsResponseInfo();
		info.setVadirMilitaryService(vadirMilitaryService);
		boolean flag  = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);

		Date d = onFile.getMilitaryService().getCombatVeteranEligibilityEndDate();

		assertNotNull("cv end date should not be null",d);
		ImpreciseDate ddd =  new ImpreciseDate("20110127");
		System.out.println( "updated=" + d );
		System.out.println( "updated=" + ddd.getDate());
		assertTrue("CV date should be after 01/27/2011", DateUtils.isAfter(d, ddd.getDate()));

	}
	public void testCodeCR11681_CV_ProcessMilitaryService() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);

		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), new ImpreciseDate("20101112"));

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);

		CombatService cs = new CombatService();
		ImpreciseDate start = new ImpreciseDate("20011112");
		ImpreciseDate end = new ImpreciseDate("20020707");
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		ms.addCombatService(cs);
		Person incoming = this.savePerson(onFile);
		Person result  = this.getMilitaryRuleService().manageMilitaryService(incoming.getMilitaryService(), onFile);
		Date d = result.getMilitaryService().getCombatVeteranEligibilityEndDate();
		assertNotNull("cv end date should not be null",d);
		ImpreciseDate ddd =  new ImpreciseDate("20110127");
		System.out.println( "updated=" + d );
		System.out.println( "updated=" + ddd.getDate());
		assertTrue("CV date should be after 01/27/2011", DateUtils.isAfter(d, ddd.getDate()));
	}

	public void testCodeCR11681_CV_Calculation1() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		//ms.setCombatVeteranEligibilityEndDate(this.getDate(2013, 1, 1));
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);


		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), new ImpreciseDate("20021111"));

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);

		Person incoming = this.savePerson(onFile);

		CombatService cs = new CombatService();
		ImpreciseDate start = new ImpreciseDate("20011112");
		ImpreciseDate end = new ImpreciseDate("20020707");
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		MilitaryService vadirMilitaryService = new MilitaryService();
		vadirMilitaryService.addCombatService(cs);
		MsdsResponseInfo info = new MsdsResponseInfo();
		info.setVadirMilitaryService(vadirMilitaryService);
		boolean flag  = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);

		Date d = onFile.getMilitaryService().getCombatVeteranEligibilityEndDate();

		assertNotNull("cv end date should not be null",d);
		ImpreciseDate ddd =  new ImpreciseDate("20110127");
		System.out.println( "updated=" + d );
		System.out.println( "updated=" + ddd.getDate());
		assertTrue("CV date should equal 01/27/2011", ObjectUtils.equals(d, ddd.getDate()));
	}
	public void testCodeCR11681_CV_CalculationNulls() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		//ms.setCombatVeteranEligibilityEndDate(this.getDate(2013, 1, 1));
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);


		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), null);

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);

		Person incoming = this.savePerson(onFile);

		CombatService cs = new CombatService();
		ImpreciseDate start = new ImpreciseDate("20011112");
		ImpreciseDate end = null;
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		MilitaryService vadirMilitaryService = new MilitaryService();
		vadirMilitaryService.addCombatService(cs);
		MsdsResponseInfo info = new MsdsResponseInfo();
		info.setVadirMilitaryService(vadirMilitaryService);
		boolean flag  = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);

		Date d = onFile.getMilitaryService().getCombatVeteranEligibilityEndDate();

		assertNull("cv end date should be null",d);
		System.out.println( "updated=" + d );

	}

	public void testCodeCR11681_CV_NullsProcessMilSvc() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		//ms.setCombatVeteranEligibilityEndDate(this.getDate(2013, 1, 1));
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);
			MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), null);
		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);
		CombatService cs = new CombatService();
		ImpreciseDate start = new ImpreciseDate("20011112");
		ImpreciseDate end = null;
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		ms.addCombatService(cs);
		ms.addCombatEpisode(createCombatEpisode()); // has 2008, 11, 1 date
		((CombatEpisode)(ms.getCombatEpisodes().iterator().next())).setEndDate(new ImpreciseDate("20101112"));
		Person incoming = this.savePerson(onFile);
		Person result  = this.getMilitaryRuleService().processMilitaryService(null,null,incoming.getMilitaryService(), onFile, null);
		Date d = result.getMilitaryService().getCombatVeteranEligibilityEndDate();
		assertNull("cv end date should be null",d);
		System.out.println( "updated=" + d );
	}

	public void testCodeCR11681_CV_NullsAndNoMse() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		CombatService cs = new CombatService();
		ImpreciseDate start = new ImpreciseDate("20011112");
		ImpreciseDate end = null;
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		ms.addCombatService(cs);
		ms.addCombatEpisode(createCombatEpisode()); // has 2008, 11, 1 date
		((CombatEpisode)(ms.getCombatEpisodes().iterator().next())).setEndDate(new ImpreciseDate("20101112"));
		Person incoming = this.savePerson(onFile);
		Person result  = this.getMilitaryRuleService().processMilitaryService(null,null,incoming.getMilitaryService(), onFile, null);
		Date d = result.getMilitaryService().getCombatVeteranEligibilityEndDate();
		assertNotNull("cv end date should not be null",d);
		System.out.println( "updated=" + d );
	}

	public void testCodeCR11681_CV_ALLdatesProcessMilSvc() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		//ms.setCombatVeteranEligibilityEndDate(this.getDate(2013, 1, 1));
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);
		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), new ImpreciseDate("20061111"));

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);
		gov.va.med.esr.common.model.ee.Activation a = this.createEsrActivation(onFile);
		a.setActivationBeginDate(getDate(2001,1,1));
		a.setActivationEndDate(getDate(2002,1,1));

		ms.addCombatEpisode(createCombatEpisode()); // has 2008, 11, 1 date
		((CombatEpisode)(ms.getCombatEpisodes().iterator().next())).setEndDate(new ImpreciseDate("20111111"));
		CombatService cs = new CombatService();
		ImpreciseDate start = new ImpreciseDate("20011112");
		ImpreciseDate end = new ImpreciseDate("20020707");
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		ms.addCombatService(cs);
		Person incoming = this.savePerson(onFile);
		Person result = this.getMilitaryRuleService().manageMilitaryService(incoming.getMilitaryService(), onFile);
		Date d = onFile.getMilitaryService().getCombatVeteranEligibilityEndDate();

		assertNotNull("cv end date should not be null",d);
		ImpreciseDate ddd =  new ImpreciseDate("20110127");
		System.out.println( "updated=" + d );
		System.out.println( "updated=" + ddd.getDate());
		assertTrue("CV date should be after 01/27/2011", DateUtils.isAfter(d, ddd.getDate()));

		/*RESULT:
		 * I manually set hasNoEnrollRecordPriorNDAA to false so that it could take different path.
Invoked rule flow: ProcessMilitaryService

(+) activate rule : HECcvRules.HECisVeteranCVEligible
(+) add rule instance : HECcvRules.HECisVeteranCVEligible
(->) fire rule instance : HECcvRules.HECisVeteranCVEligible@74f334
(-) deactivate rule : HECcvRules.HECisVeteranCVEligible
(+) activate rule : HECcvRules.HEChasNoEnrollRecordPriorNDAA
(+) add rule instance : HECcvRules.HEChasNoEnrollRecordPriorNDAA
(->) fire rule instance : HECcvRules.HEChasNoEnrollRecordPriorNDAA@af6da
(-) deactivate rule : HECcvRules.HEChasNoEnrollRecordPriorNDAA
(+) activate rule : HECcvRules.HECisCurrEnrollRejectedBelowEGTOrInitApplVAMC
(+) add rule instance : HECcvRules.HECisCurrEnrollRejectedBelowEGTOrInitApplVAMC
(->) fire rule instance : HECcvRules.HECisCurrEnrollRejectedBelowEGTOrInitApplVAMC@1daf238
(-) deactivate rule : HECcvRules.HECisCurrEnrollRejectedBelowEGTOrInitApplVAMC
(+) activate rule : HECcvRules.HECisCleanedUpAndSetTo01272011
(+) add rule instance : HECcvRules.HECisCleanedUpAndSetTo01272011
(->) fire rule instance : HECcvRules.HECisCleanedUpAndSetTo01272011@1545b48
(-) deactivate rule : HECcvRules.HECisCleanedUpAndSetTo01272011
(+) activate rule : HECcvRules.HECsetCVEndDateBasedOnMostRecentSSDCombatToDate
(+) add rule instance : HECcvRules.HECsetCVEndDateBasedOnMostRecentSSDCombatToDate@134f473
(->) fire rule instance : HECcvRules.HECsetCVEndDateBasedOnMostRecentSSDCombatToDate@134f473
(-) deactivate rule : HECcvRules.HECsetCVEndDateBasedOnMostRecentSSDCombatToDate

		 */
	}

	public void testNDAADatePlus3YearsMinus1DayFromMsg() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);

		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19991112"), new ImpreciseDate("20021112"));

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);

		onFile.getMilitaryService().setCombatVeteranEligibilityEndDate(this.getDate(2012, 1, 1));

		CombatEpisode cee = new CombatEpisode();
		cee.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OEF.getCode()));
		cee.setStartDate(ImpreciseDateUtils.createImpreciseDate(2000,4,1));
		cee.setEndDate(ImpreciseDateUtils.createImpreciseDate(2002,10,1));
		onFile.getMilitaryService().addCombatEpisode(cee);

		ImpreciseDate ddd =  new ImpreciseDate("20140127");
		onFile.getMilitaryService().setCombatVeteranEligibilityEndDate((new ImpreciseDate("20140127")).getDate());
		Person incoming = this.savePerson(onFile);

		MilitaryServiceEpisode changed = (MilitaryServiceEpisode)incoming.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator().next();
		changed.setEndDate(new ImpreciseDate("20021114"));


		this.getMilitaryRuleService().processMilitaryService(null,null, incoming.getMilitaryService(),onFile, null);

		Date d = onFile.getMilitaryService().getCombatVeteranEligibilityEndDate();


		System.out.println( "updated=" + d );
		System.out.println( "updated=" + ddd.getDate());
		assertTrue("CV date should equal original", ObjectUtils.equals(ddd.getDate(),d));
	}
	//MSDS_CodeCR10670_CR_Recomputation of the CV End Date
	public void testUpdateMSEFromUIforNonCombatVet() throws Exception {
		// 8195
		//Person onFile = this.getPerson("286186");
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);
		ImpreciseDate id = new ImpreciseDate("19950112");

		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19901112"), id);

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		m.addMilitaryServiceEpisode(mse);

		onFile.getMilitaryService().setCombatVeteranEligibilityEndDate(null);

		CombatEpisode cee = new CombatEpisode();
		cee.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_PERSIAN_GULF_WAR.getCode()));
		cee.setStartDate(ImpreciseDateUtils.createImpreciseDate(1991,2,1));
		cee.setEndDate(ImpreciseDateUtils.createImpreciseDate(1994,11,1));
		onFile.getMilitaryService().addCombatEpisode(cee);

		onFile.getMilitaryService().setCombatVeteranEligibilityEndDate(getDate(2009,1,1));
		Person incoming = this.savePerson(onFile);

		MilitaryServiceEpisode changed = (MilitaryServiceEpisode)incoming.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator().next();
		changed.setEndDate(new ImpreciseDate("19950512"));

		Person result = this.getMilitaryInfoService().updateMilitaryServiceInformation(incoming);

		Date d = result.getMilitaryService().getCombatVeteranEligibilityEndDate();

		System.out.println( "updated=" + d );
		assertTrue("CV date should be null", d == null);
	}

//	MSDS_CodeCR10670_CR_Recomputation of the CV End Date
	public void testUpdateMSEFromMsg() throws Exception {
		// 8195
		//Person onFile = this.getPerson("286186");
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);
		ImpreciseDate id = new ImpreciseDate("20101112");
		Date cv = ImpreciseDateUtils.getDateWithDefault(new ImpreciseDate("20151111"));
		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("20001112"), id);

		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
						MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		m.addMilitaryServiceEpisode(mse);

		onFile.getMilitaryService().setCombatVeteranEligibilityEndDate(cv);
		CombatEpisode cee = new CombatEpisode();
		cee.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OEF.getCode()));
		cee.setStartDate(ImpreciseDateUtils.createImpreciseDate(2002,2,1));
		cee.setEndDate(ImpreciseDateUtils.createImpreciseDate(2008,11,1));
		onFile.getMilitaryService().addCombatEpisode(cee);

		Person incoming = this.savePerson(onFile);

		MilitaryServiceEpisode changed = (MilitaryServiceEpisode)incoming.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator().next();


		changed.setEndDate(new ImpreciseDate("20091112"));

		this.getMilitaryRuleService().processMilitaryService(null,null, incoming.getMilitaryService(),
				onFile, null);

		Date d = onFile.getMilitaryService().getCombatVeteranEligibilityEndDate();
		System.out.println( "original=" + cv );
		System.out.println( "updated=" + d );
		System.out.println( "equal=" + ObjectUtils.equals(d,cv) );

		assertTrue("CV date should be unchanged when receiving prior date in Message",DateUtils.isEqualOrAfter(d, cv));
		changed.setEndDate(new ImpreciseDate("20110112"));
		this.getMilitaryRuleService().processMilitaryService(null,null, incoming.getMilitaryService(),
				onFile, null);

		d = onFile.getMilitaryService().getCombatVeteranEligibilityEndDate();
		System.out.println( "original=" + cv );
		System.out.println( "updated=" + d );
		System.out.println( "is after=" + DateUtils.isAfter(d,cv));

		assertTrue("CV date should be AFTER when receiving more recent date in Message",DateUtils.isEqualOrAfter(d, cv));
	}
	public void testDod() throws Exception {
		Person onFile = this.buildSimplePerson();
	//	onFile.setMilitaryService(new MilitaryService());
		this.attachVerifiedEnrollment(onFile);
        Person incoming = this.savePerson(onFile);
     //   this.attachDeathRecord(incoming);
       this.attachMilitaryServiceEpisode(incoming);
    	VerificationInfo vi = new VerificationInfo("x",
				MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		this.getEventRuleService().processMessageEvents(incoming, getRandomVAFacility(), vi, false);

	}



	public void testMerges() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachMilitaryService(onFile);
	    MilitaryServiceSiteRecord some = this.createMilitaryServiceSireRecord();
	    some.setSite(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode()));
	    onFile.getMilitaryService().addMilitaryServiceSiteRecord(some);
		ConflictExperience c = new ConflictExperience();
		c.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_LEBANON.getCode()));
		c.setStartDate(new ImpreciseDate("19951112"));
		c.setEndDate(new ImpreciseDate("19961112"));
		some.addConflictExperience(c);

		CombatService cs = new CombatService();
		ImpreciseDate start = new ImpreciseDate("20091112");
		ImpreciseDate end = new ImpreciseDate("201007");
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VETERAN_INFORMATION_SYSTEM.getCode()));
		cs.setPayStartDate(start);
		cs.setPayEndDate(end);
		onFile.getMilitaryService().addCombatService(cs);

		CombatService csDup = new CombatService();
		csDup.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		csDup.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
						CombatServiceSource.CODE_VETERAN_INFORMATION_SYSTEM.getCode()));
		csDup.setPayStartDate(new ImpreciseDate("20080112"));
		csDup.setPayEndDate(new ImpreciseDate("20081207"));
		onFile.getMilitaryService().addCombatService(csDup);

		this.createEsrActivation(onFile);

        CombatEpisode cep = new CombatEpisode();
        cep.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OIF.getCode()));
        cep.setStartDate(ImpreciseDateUtils.createImpreciseDate(2002,2,1));
        cep.setEndDate(ImpreciseDateUtils.createImpreciseDate(2007,11,1));
        onFile.getMilitaryService().addCombatEpisode(cep);

        gov.va.med.esr.common.model.ee.Activation a = (gov.va.med.esr.common.model.ee.Activation)onFile.getMilitaryService().getActivations().iterator().next();
		a.setNamedContingency(this.getLookupService().getNamedContingencyByCode(NamedContingency.DISASTER_RELIEF_HURRICANE_KATRINA.getCode()));
		a.setSpecialOperation(this.getLookupService().getSpecialOperationByCode(SpecialOperation.OPERATION_ENDURING_FREEDOM.getCode()));
		a.setTerminationReason(this.getLookupService().getTerminationReasonByCode(TerminationReason.COMPLETE.getCode()));
		a.setActivationBeginDate(this.getDate(2006, 3, 2));
		a.setActivationEndDate(this.getDate(2007, 3, 3));
		gov.va.med.esr.common.model.ee.Deployment d = this.createEsrDeployment();
		d.setSpecialOperation(this.getLookupService().getSpecialOperationByCode(SpecialOperation.LOS_ANGELES_RIOTS.getCode()));
		d.setDeploymentBeginDate(this.getDate(2006, 3, 2));
		d.setDeploymentEndDate(this.getDate(2007, 3, 3));
		a.addDeployment(d);

		this.createCombatService(onFile);

		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
        m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);
	    m.addMilitaryServiceEpisode(this.createMilitaryServiceEpisode(
	    		this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()), new ImpreciseDate("19951112"), new ImpreciseDate("19961112")));

		ConflictExperience cee = new ConflictExperience();
		cee.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_GRENADA.getCode()));
		cee.setStartDate(new ImpreciseDate("19991112"));
		cee.setEndDate(new ImpreciseDate("20001112"));
		m.addConflictExperience(cee);
		assertTrue(onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().getConflictExperiences().size() == 1);
		assertTrue(onFile.getMilitaryService().getMilitaryServiceSiteRecordsBySite(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode())).getConflictExperiences().size() == 1);
		assertTrue(onFile.getMilitaryService().getCombatEpisodes().size() == 1);
		assertTrue(onFile.getMilitaryService().getCombatServices().size() == 3);
		Person incoming = this.savePerson(onFile);
		/////////////////////////////////////////////////////////////////////////
		// SETUP incoming
		/////////////////////////////////////////////////////////////////////////
		gov.va.med.esr.common.model.ee.Activation save =
			(gov.va.med.esr.common.model.ee.Activation)incoming.getMilitaryService().getActivations().iterator().next();
		save.setActivationEndDate(this.getDate(2007, 6, 3));

		incoming.setMilitaryService(null);


		this.attachMilitaryService(incoming);
		this.createEsrActivation(incoming);
		gov.va.med.esr.common.model.ee.Activation aa =
			(gov.va.med.esr.common.model.ee.Activation)incoming.getMilitaryService().getActivations().iterator().next();
		gov.va.med.esr.common.model.ee.Deployment dd =this.createEsrDeployment();
		dd.setSpecialOperation(this.getLookupService().getSpecialOperationByCode(SpecialOperation.BOSNIA.getCode()));
		aa.addDeployment(dd);
		incoming.getMilitaryService().addActivation(save);

		MilitaryServiceSiteRecord siterecord = this.createMilitaryServiceSireRecord();
        siterecord.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_NEW_BEDFORD_CBOC.getName()));
		incoming.getMilitaryService().addMilitaryServiceSiteRecord(siterecord);

		ConflictExperience siteCE = new ConflictExperience();
		siteCE.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_KOREA.getCode()));
		siteCE.setStartDate(new ImpreciseDate("19991112"));
		siteCE.setEndDate(new ImpreciseDate("20001112"));
		siterecord.addConflictExperience(siteCE);
		/////////////////////////////////////////////////////
		this.attachOEF(incoming);
		/////////////////////////////////////////////////////
		ConflictExperience ce = new ConflictExperience();
		ce.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_YUGOSLAVIA_CONFLICT.getCode()));
		ce.setStartDate(new ImpreciseDate("19961212"));
		ce.setEndDate(new ImpreciseDate("19981112"));

		MilitaryServiceSiteRecord mssr = incoming.getMilitaryService().getHECMilitaryServiceSiteRecord();
		// simulating MSDS message without conflict experience... should not delete the existing one when merge
		mssr.addConflictExperience(ce);

		assertTrue(onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().getConflictExperiences().size() == 1);
		assertTrue("incoming actual was ="+incoming.getMilitaryService().getCombatServices().size() ,incoming.getMilitaryService().getCombatServices().size() == 1);

		this.getMergeRuleService().mergeMilitaryServiceNoDeletes(incoming, onFile);

		assertTrue(onFile.getMilitaryService().getMilitaryServiceSiteRecords().size() == 3);
		assertNotNull("site record should not be null",onFile.getMilitaryService().getMilitaryServiceSiteRecordsBySite(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode())));
		assertTrue(onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().size()== 3);
		assertTrue(onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().getConflictExperiences().size() == 2);
		assertTrue("ce actual was ="+onFile.getMilitaryService().getCombatEpisodes().size(),onFile.getMilitaryService().getCombatEpisodes().size() == 2);
		assertTrue("cs actual was ="+onFile.getMilitaryService().getCombatServices().size() ,onFile.getMilitaryService().getCombatServices().size() == 4);
		assertTrue("act actual was ="+onFile.getMilitaryService().getActivations().size(),onFile.getMilitaryService().getActivations().size() == 2);
		assertTrue("act actual was ="+onFile.getMilitaryService().getActivations().size(),onFile.getMilitaryService().getActivations().size() == 2);
		Iterator itr = onFile.getMilitaryService().getActivations().iterator();
		Set deployments1 = ((gov.va.med.esr.common.model.ee.Activation)itr.next()).getDeployments();
		Set deployments2 = ((gov.va.med.esr.common.model.ee.Activation)itr.next()).getDeployments();
		assertTrue("deployments1 actual was ="+deployments1.size(),deployments1.size() == 1);
		assertTrue("deployments2 actual was ="+deployments2.size(),deployments2.size() == 1);
	}
	// GOAL
	public void testBuilders() throws Exception {

		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(375299183).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		PeriodOfService periodOfService = this.createBirlsPeriodOfService("WAC",
				"Z", this.getDate(2003, 1, 8), this.getDate(2004, 1, 8));
		Activation activationV = this.createVadirActivation(this.getDate(2002, 1, 8), this.getDate(2003, 1, 8), "D");
		Deployment deploymentV = this.createVadirDeployment(this.getDate(2002, 1, 8),
				this.getDate(2003, 1, 8), "D",
				SpecialOperation.OPERATION_IRAQI_FREEDOM.getCode(), "ZZ");
		List periodOfServices = new ArrayList();
		periodOfServices.add(periodOfService);
		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		birls.setPurpleHeartInd("Y");
		mockMilitaryHistory.setBirls(birls);
		ServicePeriod servicePeriod = this.createVadirServicePeriod("WAC", "A", "A", this.getDate(2006, 1, 8), new Date());
		// Deployments
		List deploymentsV = new ArrayList();
		deploymentsV.add(deploymentV);
		List activationsV = new ArrayList();
		activationsV.add(activationV);
		// Combat Service
		MilitaryPay payV = new MilitaryPay();
		payV.setPayType("01");
		payV.setStartDate(this.getDate(2002, 1, 1));
		payV.setEndDate(this.getDate(2005, 6, 8));
		payV.setCombatServiceLocation("ZZ"); // MSDS_CodeCR10606 disabled
		List pays = new ArrayList();
		pays.add(payV);
		servicePeriod.setActivations(activationsV);
		servicePeriod.setDeployments(deploymentsV);
		servicePeriod.setMilitaryPayments(pays);
		List servicePeriodsV = new ArrayList();
		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);
		vadir.setOefOifIndicator("02"); // OEF
		mockMilitaryHistory.setVadir(vadir);
		wrapper.setResult(mockMilitaryHistory);

		///////////////////////////////////////////////
		// Do a build
		///////////////////////////////////////////////
		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		MilitaryService ms = info.getVadirMilitaryService();
		assertNotNull(ms);
		assertNotNull(ms.getCombatServices());
		assertTrue("expected 1 combat pay",ms.getCombatServices().size() == 1);
		assertTrue("expected 1 activation", ms.getActivations().size() == 1);
		CombatService cs = (CombatService)ms.getCombatServices().iterator().next();
		assertNotNull("expected combat pay source", cs.getCombatServiceSource());
		assertNotNull("expected combat pay start", cs.getPayStartDate());
		assertNotNull("expected combat pay end", cs.getPayEndDate());

		gov.va.med.esr.common.model.ee.Activation a =
			(gov.va.med.esr.common.model.ee.Activation)ms.getActivations().iterator().next();
		assertNotNull("expected activation date", a.getActivationBeginDate());
		assertNotNull("expected activation date", a.getActivationEndDate());
		assertNotNull("expected activation source", a.getDataSource());
		assertNull("expected null activation spec op", a.getSpecialOperation());
		assertNotNull("expected activation term reason ", a.getTerminationReason());
		assertTrue("expected 1 deployment", a.getDeployments().size() == 1);
		gov.va.med.esr.common.model.ee.Deployment d =
			(gov.va.med.esr.common.model.ee.Deployment)a.getDeployments().iterator().next();
		assertNotNull("expected a deployment", d);
		assertNotNull("expected a deployment date", d.getDeploymentBeginDate());
		assertNotNull("expected a deployment date", d.getDeploymentEndDate());
		assertNotNull("expected a deployment spec op", d.getSpecialOperation());
		assertNotNull("expected a deployment term reason", d.getTerminationReason());

		/////////////////////////////////////////////////////////////
		// Feed the build info to Process Person MSDS Data use case
		////////////////////////////////////////////////////////////
		SecurityContextHelper.getSecurityContext().setLogicalName("MsdsService");
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		System.out.println( "done");
	//	this.setComplete();


	}


	public void testCCRs() throws Exception {
		Person onFile = this.buildSimplePerson();
		Person incoming = this.savePerson(onFile);

		boolean ddd = Boolean.valueOf(null).booleanValue();
		assertFalse(ddd);

		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(286186).longValue());

		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		PersonEntityKey key =
			CommonEntityKeyFactory.createPersonIdEntityKey(String.valueOf(wrapper.getPersonId()));

		ServiceBranch sb =this.getLookupService().getServiceBranchByCode("2");
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		PeriodOfService periodOfService =
			new PeriodOfService();
		ServicePeriod servicePeriod =
			new ServicePeriod();
		Activation activationV =
			new Activation();
		Deployment deploymentV =
			new Deployment();

		///////////////////////////////////////////////
		// Setting up the data to simulate a message
		///////////////////////////////////////////////
		// BIRLS
		periodOfService.setBranchOfService("WAC");
		//periodOfService.setCharacterOfService("HON");
		periodOfService.setCharacterOfService(" ");
		periodOfService.setReleasedActiveDutyDate(this.getDate(2003, 1, 8));
		periodOfService.setEnteredOnDutyDate(this.getDate(2003, 1, 8));

		List periodOfServices = new ArrayList();
		periodOfService.setBranchOfService("WAC");
		periodOfServices.add(periodOfService);
		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		birls.setPurpleHeartInd("Y");
		mockMilitaryHistory.setBirls(birls);

		// VADIR
		activationV.setStartDate(this.getDate(2002, 1, 8));
		activationV.setEndDate(this.getDate(2003, 1, 8));
		activationV.setTerminationRsn("D");
		//activationV.setCharacterOfService(arg0); NOT USED IN ESR Activation

		deploymentV.setStartDate(this.getDate(2002, 1, 8));
		deploymentV.setEndDate(this.getDate(2003, 1, 8));
		deploymentV.setTerminationRsn("D");
		deploymentV.setSpecialOperation("14");

		// Deployments
		List deploymentsV = new ArrayList();
		deploymentsV.add(deploymentV);
		servicePeriod.setDeployments(deploymentsV);

		// Activations
		List activationsV = new ArrayList();
		activationsV.add(activationV);
		servicePeriod.setActivations(activationsV);

		// Combat Service
		MilitaryPay payV = new MilitaryPay();
		payV.setPayType("01");
		/*
		payV.setStartDate(this.getDate(2008, 1, 1));
		payV.setEndDate(this.getDate(2008, 6, 8));
		*/
		payV.setStartDate(this.getDate(2002, 1, 1));
		payV.setEndDate(this.getDate(2002, 6, 8));

		List pays = new ArrayList();
		pays.add(payV);
		servicePeriod.setMilitaryPayments(pays);
		// Military Service Episodes
		// Future test
		//servicePeriod.setStartDate(this.getDate(2011, 1, 8));
		servicePeriod.setStartDate(this.getDate(2006, 1, 8));

		servicePeriod.setEndDate(new Date());
		servicePeriod.setBranchOfService("WAC");
		//*****************************************
		servicePeriod.setPersonnelCategory("A");
		//servicePeriod.setPersonnelCategory("Y");
		//*****************************************
		/**
		 * 01 OEF
		 * 02 OIF
		 * 03 both OEF and OIF
		 * 04 neither/unable to determine
		 *
		 */
		servicePeriod.setCharacterOfService("Z");
		// invalid char of discharge test
		//servicePeriod.setCharacterOfService("Z");
		List servicePeriodsV = new ArrayList();
		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);
		vadir.setOefOifIndicator("02"); // OEF
		mockMilitaryHistory.setVadir(vadir);

		////////////////////////////
		wrapper.setResult(mockMilitaryHistory);


		///////////////////////////////////////////////
		// Do a build
		///////////////////////////////////////////////
		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		/////////////////////////////////////////////////////////////
		// Feed the build info to Process Person MSDS Data use case
		////////////////////////////////////////////////////////////
		Person result = this.getMilitaryInfoService().processMSDSData(info);



	}

	public void testDecorationsWithNullMS() throws Exception {
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(286186).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();

		BIRLS birls = new BIRLS();

		birls.setMedalOfHonorInd("Y");
		birls.setPurpleHeartInd("Y");
		mockMilitaryHistory.setBirls(birls);

		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertNotNull(result);
	}

	public void testDecorationWithNo() throws Exception {
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		/*
        <BIRLS>
          <MedalOfHonorInd>Y</MedalOfHonorInd>
          <RecurServiceNumber>00485270</RecurServiceNumber>
          <VerifiedSvcDataInd>Y</VerifiedSvcDataInd>
          <PeriodOfService>
            <EnteredOnDutyDate>1946-06-05</EnteredOnDutyDate>
            <ReleasedActiveDutyDate>1973-02-28</ReleasedActiveDutyDate>
            <BranchOfService>NAVY</BranchOfService>
            <SeparationReason>SAT</SeparationReason>
            <CharacterOfService>HON</CharacterOfService>
          </PeriodOfService>
        </BIRLS>
		*/

		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		PeriodOfService periodOfService =
			new PeriodOfService();
		ServicePeriod servicePeriod =
			new ServicePeriod();

		periodOfService.setBranchOfService("NAVY");
		periodOfService.setCharacterOfService("HON");
		periodOfService.setReleasedActiveDutyDate(this.getDate(1973, 1, 28));
		periodOfService.setEnteredOnDutyDate(this.getDate(1946, 5, 5));

		List periodOfServices = new ArrayList();
		periodOfServices.add(periodOfService);

		birls.setPeriodOfService(periodOfServices);
		birls.setPurpleHeartInd("N");
		mockMilitaryHistory.setBirls(birls);

		/*
        <VADIR>
          <vaId>1011478260</vaId>
          <OefOifIndicator>04</OefOifIndicator>
          <RetirementStatusIndicator>N</RetirementStatusIndicator>
          <ServicePeriods>
            <StartDate>1973-03-01</StartDate>
            <BranchOfService>N</BranchOfService>
            <PersonnelCategory>R</PersonnelCategory>
          </ServicePeriods>
        </VADIR>
		*/

		// VADIR
		servicePeriod.setStartDate(this.getDate(1973, 2, 1));
		servicePeriod.setEndDate(this.getDate(1974, 2, 1));
		servicePeriod.setBranchOfService("N");
		servicePeriod.setPersonnelCategory("A");  // Notice that personnel category R causes ignoring record
		servicePeriod.setCharacterOfService("A");

		List servicePeriodsV = new ArrayList();
		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);
		vadir.setOefOifIndicator("04");
		mockMilitaryHistory.setVadir(vadir);

		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(375124624).longValue());
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		// Test George's fix CCR 12484
		assertNotNull(result.getPurpleHeart());
		assertNotNull(result.getPurpleHeart().getRejectionRemark());
	}

	public void testUpdateWithMSE() throws Exception {
		/*
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("485620"));
		Person incoming = this.getPersonService().getPerson(personKey);		//this.getPerson("476524");
		this.attachMilitaryService(incoming);
		//are 20050104-20051103
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_MARINE_CORPS.getCode()),
				new ImpreciseDate("20010116"), new ImpreciseDate("20010704"));
		//activation1.setStartDate(this.getDate(2001, 0, 16));
		//activation1.setEndDate(this.getDate(2001, 6, 4));

		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
        m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
        mse.setMilitaryServiceComponent((MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class, MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
        m.addMilitaryServiceEpisode(mse);
		incoming.getMilitaryService().addMilitaryServiceSiteRecord(m);
		*/
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("485620"));
		Person incoming = this.getPersonService().getPerson(personKey);		//this.getPerson("476524");
		//added HEC MSE as Guard with SED = 12/1/2008 and SSD = 12/20/2010) and there was no CV End Date set.  I assumed it would be set based on:
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_MARINE_CORPS.getCode()),
				new ImpreciseDate("20080112"), new ImpreciseDate("20101220"));
        mse.setMilitaryServiceComponent((MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,
        		MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));

		MilitaryServiceSiteRecord m = incoming.getMilitaryService().getHECMilitaryServiceSiteRecord();
        m.addMilitaryServiceEpisode(mse);

		this.savePerson(incoming);

		this.setComplete();
	}

	public void testUpdateWithSiteMSE() throws Exception {

		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("490773"));
		Person incoming = this.getPersonService().getPerson(personKey);		//this.getPerson("476524");
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_MARINE_CORPS.getCode()),
				new ImpreciseDate("20010116"), new ImpreciseDate("20010704"));

		mse.setDischargeType(null);
		mse.setMilitaryServiceComponent(null);
		mse.setStartDate(null);
		mse.setEndDate(null);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
        m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_ALBUQUERQUE.getName()));
        mse.setMilitaryServiceComponent((MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class, MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
        m.addMilitaryServiceEpisode(mse);
		incoming.getMilitaryService().addMilitaryServiceSiteRecord(m);
		this.savePerson(incoming);

		this.setComplete();
	}

	public void testUpdateWithSiteConflictExperience() throws Exception {

		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("490773"));
		Person incoming = this.getPersonService().getPerson(personKey);		//this.getPerson("476524");
		MilitaryServiceSiteRecord m = incoming.getMilitaryService().getMilitaryServiceSiteRecordsBySite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		ConflictExperience ce = new ConflictExperience();
		ce.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OTHER.getCode()));
		ce.setStartDate(new ImpreciseDate("19980631"));
		ce.setEndDate(new ImpreciseDate("19990631"));
		m.addConflictExperience(ce);

		this.savePerson(incoming);

		this.setComplete();
	}
	public void testUpdateWithPH() throws Exception {

		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("485620"));
		Person incoming = this.getPersonService().getPerson(personKey);		//this.getPerson("476524");

		this.attachPurpleHeartWithPHStatusPending(incoming);

		this.savePerson(incoming);

		this.setComplete();
	}
	// 375299183
	public void testUpdateWithEliVerif() throws Exception {

		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375299183"));
		Person incoming = this.getPersonService().getPerson(personKey);		//this.getPerson("476524");

		this.setEligibilityStatusToPendingVerification(incoming);

		incoming.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(AACIndicator.CODE_AAC_QUERIED_NO_DATA.getCode()));
		this.savePerson(incoming);

		this.setComplete();
	}
	public void testUpdateWithBirls() throws Exception {

		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("485311"));
		Person incoming = this.getPersonService().getPerson(personKey);		//this.getPerson("476524");
		/*
    <PurpleHeartInd>Y</PurpleHeartInd>
    <MedalOfHonorInd>Y</MedalOfHonorInd>
    <VADSInd>Y</VADSInd>
    <RecurServiceNumber>28999063</RecurServiceNumber>
    <VerifiedSvcDataInd>Y</VerifiedSvcDataInd>
    <PeriodOfService>
      <EnteredOnDutyDate>1953-01-08</EnteredOnDutyDate>
      <ReleasedActiveDutyDate>1977-07-31</ReleasedActiveDutyDate>
      <BranchOfService>ARMY</BranchOfService>
      <SeparationReason>SAT</SeparationReason>
      <CharacterOfService>HON</CharacterOfService>
    </PeriodOfService>

		 */
		this.attachPurpleHeartWithPHStatusPending(incoming);
		incoming.getPurpleHeart().setStatus(this.getLookupService().getDecorationStatusByCode(DecorationStatus.CODE_CONFIRMED.getCode()));
		this.attachMilitaryService(incoming);
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()),
				new ImpreciseDate("19530008"), new ImpreciseDate("19770631"));
		mse.setMilitaryServiceComponent((MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class, MilitaryServiceComponent.CODE_REGULAR.getCode()));
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
        m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
        m.addMilitaryServiceEpisode(mse);
		incoming.getMilitaryService().addMilitaryServiceSiteRecord(m);
		this.savePerson(incoming);
		this.setComplete();
	}
	public void testUpdateWithOef() throws Exception {

		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("490823"));
		Person incoming = this.getPersonService().getPerson(personKey);		//this.getPerson("476524");
		this.attachOEF(incoming);
		this.savePerson(incoming);
		this.setComplete();
	}


	public void testNoDataFromBirlsOrVadir() throws Exception {
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();

		List periodOfServices = new ArrayList();
		birls.setPeriodOfService(periodOfServices);

		mockMilitaryHistory.setBirls(birls);

		List servicePeriodsV = new ArrayList();
		vadir.setServicePeriods(servicePeriodsV);
		mockMilitaryHistory.setVadir(vadir);
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(482655).longValue());
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertNotNull(result);
	}

	public void testCombatPayAndCombatEpisode() throws Exception {
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		ServicePeriod servicePeriod =
			new ServicePeriod();

		// NO BIRLS DATA
		List periodOfServices = new ArrayList();
		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		mockMilitaryHistory.setBirls(birls);

		// SETUP VADIR DATA
		List servicePeriodsV = new ArrayList();
		vadir.setServicePeriods(servicePeriodsV);

		// Combat Service
		MilitaryPay pay1 = new MilitaryPay();
		MilitaryPay pay2 = new MilitaryPay();
		pay1.setPayType(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode());
		pay1.setStartDate(this.getDate(2002, 7, 1));
		pay1.setEndDate(this.getDate(2006, 9, 8));
		pay2.setPayType(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode());
		pay2.setStartDate(this.getDate(2007, 7, 1));
		pay2.setEndDate(this.getDate(2010, 9, 8));

		List pays = new ArrayList();
		pays.add(pay1);
		pays.add(pay2);

		servicePeriod.setMilitaryPayments(pays);
		servicePeriod.setStartDate(this.getDate(2001, 1, 8));
		servicePeriod.setEndDate(this.getDate(2008, 6, 8));
		servicePeriod.setBranchOfService("N");
		servicePeriod.setPersonnelCategory("A");
		servicePeriod.setCharacterOfService("A");

		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);

		mockMilitaryHistory.setVadir(vadir);
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		//373984341
		//373973277

		wrapper.setPersonId(new Long(373973277).longValue());
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

        Person onFile = this.getPerson(String.valueOf(wrapper.getPersonId()));
		Person pristine = (Person)onFile.clone();
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertNotNull(result);
		assertTrue(result.getMilitaryService().getCombatEpisodes().size() > 0);
		CombatEpisode ce = (CombatEpisode)result.getMilitaryService().getCombatEpisodes().iterator().next();
		assertNotNull(ce.getOEFOIFSource());
		getRuleValidationService().validateCombatEpisode(ce, result, pristine, true);
		//this.setComplete();
	}

	public void testCombatPayAndDeployment() throws Exception {
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		ServicePeriod servicePeriod = new ServicePeriod();
		Activation activation = this.createVadirActivation(this.getDate(2002, 1, 8), this.getDate(2003, 1, 8), "D");
		Deployment deployment = this.createVadirDeployment(this.getDate(2002, 1, 8),this.getDate(2003, 1, 8), "D",SpecialOperation.OPERATION_ENDURING_FREEDOM.getCode(),
				"ZZ");



		// NO BIRLS DATA
		List periodOfServices = new ArrayList();
		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		mockMilitaryHistory.setBirls(birls);

		// SETUP VADIR DATA
		List servicePeriodsV = new ArrayList();
		vadir.setServicePeriods(servicePeriodsV);

		// Combat Service
		MilitaryPay pay1 = new MilitaryPay();
		MilitaryPay pay2 = new MilitaryPay();
		pay1.setPayType(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode());
		pay1.setStartDate(this.getDate(2002, 7, 1));
		pay1.setEndDate(this.getDate(2006, 9, 8));
		pay1.setCombatServiceLocation("ZZ");
		pay2.setPayType(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode());
		pay2.setStartDate(this.getDate(2007, 7, 1));
		pay2.setEndDate(this.getDate(2010, 9, 8));
		pay2.setCombatServiceLocation("ZZ");
		List pays = new ArrayList();
		pays.add(pay1);
		pays.add(pay2);

		servicePeriod.setMilitaryPayments(pays);
		servicePeriod.setStartDate(this.getDate(2001, 1, 8));
		servicePeriod.setEndDate(this.getDate(2008, 6, 8));
		servicePeriod.setBranchOfService("N");
		servicePeriod.setPersonnelCategory("A");
		servicePeriod.setCharacterOfService("A");

		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);

		// Deployments
		List deploymentsV = new ArrayList();
		deploymentsV.add(deployment);
		servicePeriod.setDeployments(deploymentsV);
		// Activations
		List activationsV = new ArrayList();
		activationsV.add(activation);
		servicePeriod.setActivations(activationsV);

		mockMilitaryHistory.setVadir(vadir);
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		//373984341
		//373973277

		wrapper.setPersonId(new Long(375124624).longValue());
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

        Person onFile = this.getPerson(String.valueOf(wrapper.getPersonId()));
		Person pristine = (Person)onFile.clone();
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertNotNull(result);
		assertTrue(result.getMilitaryService().getCombatEpisodes().size() > 0);
		CombatEpisode ce = (CombatEpisode)result.getMilitaryService().getCombatEpisodes().iterator().next();
		assertNotNull(ce.getOEFOIFSource());
		getRuleValidationService().validateCombatEpisode(ce, result, pristine, true);
		this.setComplete();
	}


//	// GOAL
//	protected PeriodOfService createBirlsPeriodOfService(
//			String branch, String charOfService, Date start, Date end) {
//		PeriodOfService periodOfService =
//			new PeriodOfService();
//		periodOfService.setBranchOfService(branch);
//		periodOfService.setCharacterOfService(charOfService);
//		periodOfService.setReleasedActiveDutyDate(end);
//		periodOfService.setEnteredOnDutyDate(start);
//		return periodOfService;
//	}
//	// GOAL
//	protected ServicePeriod createVadirServicePeriod(
//			String branch, String charOfService, String personnelCategory, Date start, Date end) {
//		ServicePeriod servicePeriod =
//			new ServicePeriod();
//		servicePeriod.setBranchOfService(branch);
//		servicePeriod.setCharacterOfService(charOfService);
//		servicePeriod.setPersonnelCategory(personnelCategory);
//		servicePeriod.setStartDate(start);
//		servicePeriod.setEndDate(end);
//		return servicePeriod;
//	}
	private  Date getDatePlus1Day(Date date) {
		if( date != null ) {
			Calendar calendar = Calendar.getInstance();
			calendar.clear();
			calendar.setTime( date );
			calendar.add(Calendar.DATE,+1);
			return calendar.getTime();
		}
		return null;
	}
	public void testCCR10688() throws Exception {
		Long id = new Long(484261);
        Person onFile = this.getPerson(id.toString());
		Person incoming = (Person)onFile.clone();
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();

		// BIRLS DATA /////////////////////////////////////////////////////////////////////////
		BIRLS birls = new BIRLS();
		List periodOfServices = new ArrayList();
		birls.setPeriodOfService(periodOfServices);
		periodOfServices.add(createBirlsPeriodOfService("NAVY","HON",this.getDate(2001, 1, 8),this.getDate(2008, 6, 8)));
		periodOfServices.add(createBirlsPeriodOfService("NAVY","HON",this.getDate(2008, 7, 8),null));
		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		mockMilitaryHistory.setBirls(birls);

		// SETUP VADIR DATA ////////////////////////////////////////////////////////////////////
		VADIR vadir = new VADIR();
		List servicePeriodsV = new ArrayList();
		vadir.setServicePeriods(servicePeriodsV);
		servicePeriodsV.add(createVadirServicePeriod("F", "A", "A", this.getDate(2003, 1, 19), this.getDate(2008, 0, 18)));
		servicePeriodsV.add(createVadirServicePeriod("F", "A", "V", this.getDate(2008, 0, 19), null));
		vadir.setServicePeriods(servicePeriodsV);
		mockMilitaryHistory.setVadir(vadir);
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(id.longValue());
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		// Attention - this is direct call to rule service
		boolean result = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		System.out.println("test 3 " + info.getMsdsWorkItem());

		// BIRLS & VADIR
		PeriodOfService periodOfService =
			createBirlsPeriodOfService("NAVY","HON",this.getDate(2001, 1, 8),this.getDate(2008, 6, 8));
		ServicePeriod servicePeriod =
			createVadirServicePeriod("F", "A", "A", this.getDate(2002, 1, 8), this.getDate(2003, 1, 8));

		Activation activationV =
			this.createVadirActivation(this.getDate(2002, 1, 8),this.getDate(2003, 1, 8),"D");
		Deployment deploymentV =
			createVadirDeployment(this.getDate(2002, 1, 9),this.getDate(2003, 1, 7),"D","14","ZZ");

		servicePeriodsV.clear();
		periodOfServices.clear();

		// Deployments
		List deploymentsV = new ArrayList();
		deploymentsV.add(deploymentV);

		// Activations
		List activationsV = new ArrayList();
		activationsV.add(activationV);
        servicePeriod.setActivations(activationsV);

		// Combat Service
		MilitaryPay payV = new MilitaryPay();
		payV.setPayType("01");
		payV.setStartDate(this.getDate(2002, 1, 1));
		payV.setEndDate(this.getDate(2002, 6, 8));
		payV.setCombatServiceLocation("ZZ"); // MSDS_CodeCR10606 disabled

		List pays = new ArrayList();
		pays.add(payV);
		servicePeriod.setMilitaryPayments(pays);
		//vadir
		servicePeriod.setActivations(activationsV);
		servicePeriodsV.add(servicePeriod);

		// Future checks
		Date hold = activationV.getStartDate();
		activationV.setStartDate(null);
		info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		result = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		System.out.println("test 4 " + info.getMsdsWorkItem());
		assertEquals("09", info.getMsdsWorkItem());

		activationV.setStartDate(this.getDate(2015, 1, 1));
		servicePeriod.setDeployments(deploymentsV);
		info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		result = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		System.out.println("test 5 " + info.getMsdsWorkItem());
		assertEquals("12", info.getMsdsWorkItem());

		activationV.setStartDate(hold);
		hold = payV.getStartDate();
		payV.setStartDate(this.getDate(2015, 1, 1));
		info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		result = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		System.out.println("test 6 " + info.getMsdsWorkItem());
		assertEquals("12", info.getMsdsWorkItem());

		// Data Range checks
		hold = activationV.getStartDate();
		activationV.setStartDate(this.getDatePlus1Day(activationV.getEndDate()));
		info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		result = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		System.out.println("test 7 " + info.getMsdsWorkItem());
		assertEquals("13", info.getMsdsWorkItem());

		activationV.setStartDate(hold);
		hold = payV.getStartDate();
		payV.setStartDate(this.getDatePlus1Day(payV.getEndDate()));
		info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		result = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		System.out.println("test 8 " + info.getMsdsWorkItem());
		assertEquals("13", info.getMsdsWorkItem());

		payV.setStartDate(hold);
		servicePeriod.setStartDate(getDatePlus1Day(servicePeriod.getEndDate()));
		info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		result = this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		System.out.println("test 9 " + info.getMsdsWorkItem());
		assertEquals("13", info.getMsdsWorkItem());
	}

//	protected Activation createVadirActivation(Date start, Date end,
//			String termReason) {
//		Activation activation = new
//		Activation();
//		activation.setStartDate(start);
//		activation.setEndDate(end);
//		activation.setTerminationRsn(termReason);
//		return activation;
//	}

//	protected Deployment createVadirDeployment(
//			Date start, Date end, String termReason, String specialOp, String location) {
//		Deployment deployment = new Deployment();
//		deployment.setStartDate(start);
//		deployment.setEndDate(end);
//		deployment.setTerminationRsn(termReason);
//		deployment.setSpecialOperation(specialOp);
//		deployment.setLocation(location);
//		return deployment;
//	}




	public void testSetVeteranIndicator() throws Exception {
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		ServicePeriod servicePeriod =
			new ServicePeriod();
		PeriodOfService periodOfService =
			new PeriodOfService();

		// BIRLS DATA
		periodOfService.setBranchOfService("NAVY");
		//periodOfService.setCharacterOfService("D");// was HON
		periodOfService.setCharacterOfService("HON");// was HON
		periodOfService.setEnteredOnDutyDate(this.getDate(2001, 1, 8));
		periodOfService.setReleasedActiveDutyDate(this.getDate(2008, 6, 8));
		//periodOfService.setReleasedActiveDutyDate(this.getDate(2002, 6, 8));


		List periodOfServices = new ArrayList();
		birls.setPeriodOfService(periodOfServices);

		periodOfServices.add(periodOfService);

		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		mockMilitaryHistory.setBirls(birls);

		// SETUP VADIR DATA
		List servicePeriodsV = new ArrayList();
		vadir.setServicePeriods(servicePeriodsV);

		// Combat Service
		MilitaryPay payV = new MilitaryPay();
		payV.setPayType("01");
		payV.setStartDate(this.getDate(2002, 1, 1));
		payV.setEndDate(this.getDate(2002, 6, 8));
		MilitaryPay payW = new MilitaryPay();
		payW.setPayType("01");
		payW.setStartDate(this.getDate(2002, 7, 1));
		payW.setEndDate(this.getDate(2003, 6, 8));

		List pays = new ArrayList();
		pays.add(payV);
		pays.add(payW);

		servicePeriod.setMilitaryPayments(pays);
		servicePeriod.setStartDate(this.getDate(2001, 1, 8));
		servicePeriod.setEndDate(this.getDate(2008, 6, 8));
		//servicePeriod.setEndDate(this.getDate(2002, 6, 8));
		servicePeriod.setBranchOfService("N");
		servicePeriod.setPersonnelCategory("A");
		servicePeriod.setCharacterOfService("D");////
		servicePeriod.setCharacterOfService("HON");////


		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);

		mockMilitaryHistory.setVadir(vadir);
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(483098).longValue());
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertNotNull(result);
		this.setComplete();
	}
	public void testSetVeteranIndicatorWorkItem() throws Exception {
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		ServicePeriod servicePeriod =
			new ServicePeriod();
		PeriodOfService periodOfService =
			new PeriodOfService();

		// BIRLS DATA
		periodOfService.setBranchOfService("NAVY");
		periodOfService.setCharacterOfService("DIS");
		periodOfService.setReleasedActiveDutyDate(this.getDate(2008, 6, 8));
		periodOfService.setEnteredOnDutyDate(this.getDate(2001, 1, 8));

		List periodOfServices = new ArrayList();
		birls.setPeriodOfService(periodOfServices);

		periodOfServices.add(periodOfService);

		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		mockMilitaryHistory.setBirls(birls);

		// SETUP VADIR DATA
		List servicePeriodsV = new ArrayList();
		vadir.setServicePeriods(servicePeriodsV);

		// Combat Service
		MilitaryPay payV = new MilitaryPay();
		payV.setPayType("01");
		payV.setStartDate(this.getDate(2002, 1, 1));
		payV.setEndDate(this.getDate(2002, 6, 8));
		MilitaryPay payW = new MilitaryPay();
		payW.setPayType("01");
		payW.setStartDate(this.getDate(2002, 7, 1));
		payW.setEndDate(this.getDate(2003, 6, 8));

		List pays = new ArrayList();
		pays.add(payV);
		pays.add(payW);

		servicePeriod.setMilitaryPayments(pays);
		servicePeriod.setStartDate(this.getDate(2001, 1, 8));
		servicePeriod.setEndDate(this.getDate(2008, 6, 8));
		servicePeriod.setBranchOfService("N");
		servicePeriod.setPersonnelCategory("A");
		servicePeriod.setCharacterOfService("A");

		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);

		mockMilitaryHistory.setVadir(vadir);
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(483098).longValue());
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertNotNull(result);
		//this.setComplete();
	}
	public void testCharOfDischargeNotSame() throws Exception {
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		ServicePeriod servicePeriod =
			new ServicePeriod();
		PeriodOfService periodOfService =
			new PeriodOfService();

		// BIRLS DATA
		periodOfService.setBranchOfService("NAVY");
		periodOfService.setCharacterOfService("DIS");
		periodOfService.setReleasedActiveDutyDate(this.getDate(2008, 6, 8));
		periodOfService.setEnteredOnDutyDate(this.getDate(2001, 1, 8));

		List periodOfServices = new ArrayList();
		birls.setPeriodOfService(periodOfServices);

		periodOfServices.add(periodOfService);

		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		mockMilitaryHistory.setBirls(birls);

		// SETUP VADIR DATA
		List servicePeriodsV = new ArrayList();
		vadir.setServicePeriods(servicePeriodsV);

		// Combat Service
		MilitaryPay payV = new MilitaryPay();
		payV.setPayType("01");
		payV.setStartDate(this.getDate(2002, 1, 1));
		payV.setEndDate(this.getDate(2002, 6, 8));
		MilitaryPay payW = new MilitaryPay();
		payW.setPayType("01");
		payW.setStartDate(this.getDate(2002, 7, 1));
		payW.setEndDate(this.getDate(2003, 6, 8));

		List pays = new ArrayList();
		pays.add(payV);
		pays.add(payW);

		servicePeriod.setMilitaryPayments(pays);
		servicePeriod.setStartDate(this.getDate(2001, 1, 8));
		servicePeriod.setEndDate(this.getDate(2008, 6, 8));
		servicePeriod.setBranchOfService("N");
		servicePeriod.setPersonnelCategory("A");
		servicePeriod.setCharacterOfService("A");

		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);

		mockMilitaryHistory.setVadir(vadir);
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(373971922).longValue());
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertNotNull(result);
		//this.setComplete();
	}
	public void testUpdatePHwithYes() throws Exception {

		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("476524"));
		Person incoming = this.getPerson("476524");//this.getPersonService().getPerson(personKey);
		incoming.getPurpleHeart().setPhIndicator(Boolean.TRUE);
		incoming.getPurpleHeart().setRejectionRemark(null);
		Person result = this.getPurpleHeartService().updatePurpleHeart(incoming);

//		assertFalse(result.getPurpleHeart().getPhIndicator().booleanValue());

		//this.setComplete();
	}

	public void testDecorationsWithNullData() throws Exception {
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(286186).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();

		BIRLS birls = new BIRLS();
		birls.setMedalOfHonorInd(" ");
		birls.setPurpleHeartInd("N");
		mockMilitaryHistory.setBirls(birls);

		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);
	}

	public void testCCR13095_1DecorationsWithNullData() throws Exception {

		Date startTime = new Date();

		//Test VOAindicator = 2, terminate=false; improved=true, is enroll pending=true, VBA query status =2 PENDING, erollmentStatus = PENDING;
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(377323380).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();

		BIRLS birls = new BIRLS();
		birls.setMedalOfHonorInd(" ");
		birls.setPurpleHeartInd("N");
		mockMilitaryHistory.setBirls(birls);

		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);

		// Assert VOA Indicator still = 2
		assertTrue("VOA Indicator not set to '2'.", VOA_IND_2.equals(result.getVOAIndicator()));
        // Assert no VOA PENDING workflow item just created
        WorkflowCase wfc = getWorkflowService().getMostRecentWorkflowItem(result);
        assertTrue("Most recent workflow must not be created just now for VOA Enrollment Pending.",
        		wfc == null || wfc.getCreatedOn().before(startTime) && !"VOA Submission with Determined Enrollment Status of PENDING".equalsIgnoreCase(wfc.getErrorMessage()));

		System.out.println("verification record ="+result.getEligibilityVerification());
	}

	public void testCCR13095_3DecorationsWithNullData() throws Exception {

		Date startTime = new Date();

		//Test VOA_IND = 2, terminate=false; improved=false, is enroll pending=false, VBA query status =6, VOA_IND changed to 1;
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(377326248).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();

		BIRLS birls = new BIRLS();
		birls.setMedalOfHonorInd(" ");
		birls.setPurpleHeartInd("N");
		mockMilitaryHistory.setBirls(birls);

		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);

		assertTrue("VOA Indicator not set to '1'.", VOA_IND_1.equals(result.getVOAIndicator()));

        // Assert no VOA PENDING workflow item just created
        WorkflowCase wfc = getWorkflowService().getMostRecentWorkflowItem(result);
        assertTrue("Most recent VOA workflow shall not be created just now by this process.",
        		wfc == null || wfc.getCreatedOn().before(startTime));

		System.out.println("verification record ="+result.getEligibilityVerification());
	}

	public void testCCR13095_4DecorationsWithNullData() throws Exception {

		Date startTime = new Date();

		//Test VOA_IND = 2, terminate=false; improved=false, is enroll pending=false, VBA query status =6 Data Recv, wk VOA PENDING closed, VOA_IND changed to 1;
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(377318219).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();

		BIRLS birls = new BIRLS();
		birls.setMedalOfHonorInd(" ");
		birls.setPurpleHeartInd("N");
		mockMilitaryHistory.setBirls(birls);

		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);

		assertTrue("VOA Indicator not set to '1'.", VOA_IND_1.equals(result.getVOAIndicator()));

        // Assert no VOA workflow item just created
		WorkflowCase wfc = getWorkflowService().getMostRecentWorkflowItem(result);
        assertTrue("Most recent VOA workflow shall not be created just now by this process.",
        		wfc == null || wfc.getCreatedOn().before(startTime));

        assertTrue("Most recent VOA workflow AFTER the process should be 'VOA Submission with Determined Enrollment Status of PENDING' and closed",
        		"VOA Submission with Determined Enrollment Status of PENDING".equals(wfc.getErrorMessage()) &&
        		WkfCaseStatusType.CLOSED.getCode().equals(wfc.getStatus().getStatusValue().getCode()));

		System.out.println("verification record ="+result.getEligibilityVerification());
	}

	public void testCCR13095_5DecorationsWithNullData() throws Exception {

		Date startTime = new Date();

		//Test VOA_IND = null, terminate=false; improved=true, VOA_IND still null;
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(375124624).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();

		BIRLS birls = new BIRLS();
		birls.setMedalOfHonorInd(" ");
		birls.setPurpleHeartInd("N");
		mockMilitaryHistory.setBirls(birls);

		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);

		// Assert VOA Indicator still = null
		assertTrue("VOA Indicator not set to 'null'.", result.getVOAIndicator() == null);

        // Assert no VOA workflow item just created
        WorkflowCase wfc = getWorkflowService().getMostRecentWorkflowItem(result);
        assertTrue("Most recent VOA workflow shall not be created just now by this process.",
        		wfc == null || wfc.getCreatedOn().before(startTime));

		System.out.println("verification record ="+result.getEligibilityVerification());
	}

	public void testCCR13095_6DecorationsWithNullData() throws Exception {

		Date startTime = new Date();

		//Test VOA_IND = 1, terminate=false; improved=false, Enroll Pending, VBA QVOA_IND still null;
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(377459275).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();

		BIRLS birls = new BIRLS();
		birls.setMedalOfHonorInd(" ");
		birls.setPurpleHeartInd("N");
		mockMilitaryHistory.setBirls(birls);

		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);

		// Assert VOA Indicator still = 1
		assertTrue("VOA Indicator not set to '1'.", VOA_IND_1.equals(result.getVOAIndicator()));

		// Assert NO workflow items created
        WorkflowCase wfc = getWorkflowService().getMostRecentWorkflowItem(result);
        assertTrue("Unexpected workflow item added.", wfc == null || wfc.getCreatedOn().before(startTime));


		System.out.println("verification record ="+result.getEligibilityVerification());
	}

	public void testMerges2() throws Exception {
		Person onFile = this.buildSimplePerson();
		this.attachMilitaryService(onFile);

		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
        m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);

		ConflictExperience cee = new ConflictExperience();
		cee.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_GRENADA.getCode()));
		cee.setStartDate(new ImpreciseDate("19991112"));
		cee.setEndDate(new ImpreciseDate("20001112"));
		m.addConflictExperience(cee);

		Person incoming = this.savePerson(onFile);
		// SETUP incoming
		incoming.setMilitaryService(null);
		this.attachMilitaryService(incoming);
		this.getMergeRuleService().mergeMilitaryServiceNoDeletes(incoming, onFile);
	}


	public void testComparators() {
		ActivationComparator c = new ActivationComparator();
		gov.va.med.esr.common.model.ee.Activation one = new gov.va.med.esr.common.model.ee.Activation();
		gov.va.med.esr.common.model.ee.Activation two = new gov.va.med.esr.common.model.ee.Activation();
		one.setActivationEndDate(getDate(2001,1,1));
		two.setActivationEndDate(getDate(2003,1,1));
		assertTrue(c.compare(one, two) < 0);
		assertTrue(c.compare(two, one) > 0);
		CombatServiceComparator cs = new CombatServiceComparator();
		CombatService oneCs = new CombatService();

		CombatService twoCs = new CombatService();
		oneCs.setPayEndDate(new ImpreciseDate("200110"));
		twoCs.setPayEndDate(new ImpreciseDate("200112"));
		assertTrue(cs.compare(oneCs, twoCs) < 0);
		assertTrue(cs.compare(twoCs, oneCs) > 0);

	}
	public void testCombatService() throws Exception {
		Person onFile = this.buildSimplePerson();
		CombatService cs = new CombatService();
		ImpreciseDate id = new ImpreciseDate("200912");
		Date dt =   ImpreciseDateUtils.getDateWithDefault(id);
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(CombatServiceSource.CODE_VADIR.getCode()));
		cs.setPayStartDate(id);
		assertNotNull(cs.getPayStartDate());
		onFile.setMilitaryService(new MilitaryService());
		onFile.getMilitaryService().addCombatService(cs);
		assertTrue(onFile.getMilitaryService().getCombatServices().size() == 1);

		fail("need to map new PayType in combat service");
	}






	public void testPHRuleParameter() throws Exception {
		Person onfile = this.buildSimplePerson();
		Person incoming = (Person)onfile.clone();


		PurpleHeartInputParameter purpleHeartInput = new PurpleHeartInputParameter();
		purpleHeartInput.setApplicationContext(this.applicationContext);
		purpleHeartInput.setLookupService(this.getLookupService());
		purpleHeartInput.setTimestampManagerName("common.timestampManager");
		purpleHeartInput.setMergeRuleService(this.getMergeRuleService());

		purpleHeartInput.setIncomingData(incoming);
		purpleHeartInput.setResultData(onfile);

		incoming.setPurpleHeart(new PurpleHeart());
		PurpleHeart purpleHeart = incoming.getPurpleHeart();
		purpleHeart.setPhIndicator(Boolean.TRUE);

		// ?purpleHeartInput.setPurpleHeart( "Y" );
		purpleHeartInput.setPurpleHeart("Y");
		assertTrue("Y".equals(purpleHeartInput.getPurpleHeartIndicator()));

		// ?purpleHeartInput.setPurpleHeartStatus( DecorationStatus.CODE_CONFIRMED.getCode() );
		purpleHeartInput.setPurpleHeartStatus( DecorationStatus.CODE_CONFIRMED.getCode() );
		assertTrue(DecorationStatus.CODE_CONFIRMED.getCode().equals(purpleHeart.getStatus().getCode()));

		// ?purpleHeartInput.setStatusUpdateDate( ?purpleHeartInput.getCurrentDate() );
		purpleHeartInput.setStatusUpdateDate( purpleHeartInput.getCurrentDate() );
		assertNotNull(incoming.getPurpleHeart().getStatusLastEditDate());

		// ?purpleHeartInput.setRejectedRemarks(null);
		purpleHeartInput.setRejectedRemarks(null);
		assertNull(incoming.getPurpleHeart().getRejectionRemark());

		// ?purpleHeartInput.setDocumentType( gov.va.med.esr.common.model.lookup.PHDocumentType.CODE_VBA_DOD_FILE.getCode() );
		purpleHeartInput.setDocumentType( gov.va.med.esr.common.model.lookup.PHDocumentType.CODE_VBA_DOD_FILE.getCode() );
		PurpleHeartDocument doc = (incoming.getPurpleHeart().getDocuments().size() > 0) ?
				(PurpleHeartDocument)incoming.getPurpleHeart().getDocuments().iterator().next() : null;
		assertNotNull(doc);
		
		assertTrue("doc type wrong",
				gov.va.med.esr.common.model.lookup.PHDocumentType.CODE_VBA_DOD_FILE.getCode().equals(doc.getDocumentType().getCode()));

		// ?purpleHeartInput.setPHDocumentDataSource( gov.va.med.esr.common.model.lookup.PHDataSource.VBA.getCode() );
		purpleHeartInput.setPHDocumentDataSource( gov.va.med.esr.common.model.lookup.PHDataSource.VBA.getCode() );
		assertTrue("doc source wrong",gov.va.med.esr.common.model.lookup.PHDataSource.VBA.getCode().equals(doc.getDataSource().getCode()));

		// ?purpleHeartInput.setPHFacilityByCode( gov.va.med.esr.common.model.lookup.VAFacility.CODE_MVR.getCode() );
		purpleHeartInput.setPHFacilityByCode( gov.va.med.esr.common.model.lookup.VAFacility.CODE_MVR.getCode() );
		assertTrue("facility wrong",gov.va.med.esr.common.model.lookup.VAFacility.CODE_MVR.getCode().equals(incoming.getPurpleHeart().getFacility().getCode()));

		// ?purpleHeartInput.setAssignedContactUser(null);
		purpleHeartInput.setAssignedContactUser(null);
		assertNull(incoming.getPurpleHeart().getAssignedContactUser());

		// ?purpleHeartInput.setPHDocumentReceivedDate(?purpleHeartInput.getPHDocReceivedDateFromMSDSmessage());
		purpleHeartInput.setPHDocumentReceivedDate(new Date());
		Date recvDate = purpleHeartInput.getPHDocReceivedDateFromMSDSmessage();
		assertNotNull(recvDate);

		// ?purpleHeartInput.setPHDocumentAcceptableIndicator( "Y" );
		purpleHeartInput.setPHDocumentAcceptableIndicator( "Y" );
		assertTrue(incoming.getPurpleHeart().getPhIndicator().booleanValue());

		// ?purpleHeartInput.setLoginDate( ?purpleHeartInput.getCurrentDate() );
		purpleHeartInput.setLoginDate( purpleHeartInput.getCurrentDate() );
		assertNotNull(doc.getLoginDate());

		// ?purpleHeartInput.acceptPHFromMSDS();
		assertNull(onfile.getPurpleHeart());
		purpleHeartInput.acceptPHFromMSDS();
		assertTrue(onfile.getPurpleHeart().getPhIndicator().booleanValue());
	}

	public void testMedalOfHonorFromMSDS() throws Exception {

		Person result = this.getMilitaryInfoService().processMSDSData(this.createMockMsdsResponseInfo(1020,null,null, 1));
		assertNotNull("expected non-null result",result);
	//	this.setComplete();
	}

	public void testMedalOfHonorFromBirlsOnly() throws Exception {

		Person result = this.getMilitaryInfoService().processMSDSData(this.createMockMsdsResponseInfoFromOneSource(1021,null,null, 1));
		assertNotNull("expected non-null result",result);
	//	this.setComplete();
	}

	private void attachOEF(Person person) throws Exception {

		  	MilitaryService ms = person.getMilitaryService();
		  	if (ms == null) {
		  		this.attachMilitaryService(person);
		  		ms = person.getMilitaryService();
		  	}

	        MilitaryServiceSiteRecord mssr = person.getMilitaryService().getHECMilitaryServiceSiteRecord();
	        if (mssr == null) {
	        	mssr = this.createMilitaryServiceSireRecord();
		        mssr.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		        person.getMilitaryService().addMilitaryServiceSiteRecord(mssr);
	        }
	        mssr.setServicePeriod(this.getLookupService().getServicePeriodByCode(
	        		gov.va.med.esr.common.model.lookup.ServicePeriod.CODE_OPERATION_DESERT_SHIELD.getCode()));

	        // Create mse
	        MilitaryServiceEpisode mse = new MilitaryServiceEpisode();
	        mse.setServiceBranch(this.getRandomServiceBranch());
	        mse.setDischargeType(this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_HONORABLE.getCode()));
	        mse.setStartDate(ImpreciseDateUtils.createImpreciseDate(2002,1,1));
	        mse.setEndDate(ImpreciseDateUtils.createImpreciseDate(2006,1,1));
	        mse.setServiceNumber("12345");
	        mssr.addMilitaryServiceEpisode(mse);
	        MilitaryServiceEpisode mse2 = new MilitaryServiceEpisode();
	        mse2.setServiceBranch(this.getRandomServiceBranch());
	        mse2.setDischargeType(this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_HONORABLE.getCode()));
	        mse2.setStartDate(ImpreciseDateUtils.createImpreciseDate(2007,1,1));
	        mse2.setEndDate(ImpreciseDateUtils.createImpreciseDate(2009,1,1));
	        mse2.setServiceNumber("12345");
	        mssr.addMilitaryServiceEpisode(mse2);

	        CombatEpisode ce = new CombatEpisode();
	        ce.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OEF.getCode()));
	        ce.setStartDate(ImpreciseDateUtils.createImpreciseDate(2002,2,1));
	        ce.setEndDate(ImpreciseDateUtils.createImpreciseDate(2007,11,1));
	        ms.addCombatEpisode(ce);

	    	CombatService cs = new CombatService();
			ImpreciseDate start = new ImpreciseDate("20011112");
			ImpreciseDate end = new ImpreciseDate("200312");
			cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
			cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
							CombatServiceSource.CODE_VETERAN_INFORMATION_SYSTEM.getCode()));

			cs.setPayStartDate(start);
			cs.setPayEndDate(end);
			person.getMilitaryService().addCombatService(cs);
	}
//	protected MilitaryServiceEpisode createMilitaryServiceEpisode(ServiceBranch branch, ImpreciseDate start, ImpreciseDate end) throws Exception {
//        MilitaryServiceEpisode mse = new MilitaryServiceEpisode();
//        mse.setServiceBranch(branch == null ? this.getRandomServiceBranch(): branch);
//        mse.setDischargeType(this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_HONORABLE.getCode()));
//        mse.setStartDate(start);
//        mse.setEndDate(end);
//        mse.setServiceNumber("12345");
//        return mse;
//	}
//	protected MilitaryServiceInputParameter buildMilitaryServiceInputParameter() throws Exception {
//		Person onfile = this.buildSimplePerson();
//		this.attachMilitaryService(onfile);
//		this.attachMilitaryServiceEpisode(onfile);
//		onfile.getMilitaryService().addCombatService(this.createCombatService(onfile));
//		Person incoming = (Person)onfile.clone();
//		Person pristine = (Person)onfile.clone();
//		gov.va.med.esr.common.model.ee.Activation activation = this.createEsrActivation(pristine);
//		activation.addDeployment(createEsrDeployment());
//
//		MilitaryServiceInputData ruleData = new MilitaryServiceInputData(incoming.getMilitaryService(), onfile,pristine,true);
//
//		MilitaryServiceInputParameter militaryServiceInput = new MilitaryServiceInputParameter();
//		militaryServiceInput.setApplicationContext(this.applicationContext);
//		militaryServiceInput.setLookupService(this.getLookupService());
//		militaryServiceInput.setTimestampManagerName("common.timestampManager");
//		militaryServiceInput.setMergeRuleService(this.getMergeRuleService());
//		militaryServiceInput.setRuleDataAware(ruleData);
//
//		return militaryServiceInput;
//	}

	/**
	 * @throws Exception
	 */
	public void testMilServInputParameter() throws Exception {
		MilitaryServiceInputParameter militaryServiceInput = buildMilitaryServiceInputParameter();
		RuleDataAware ruleDataAware = militaryServiceInput.getRuleDataAware();
		MilitaryServiceInputData inData = (MilitaryServiceInputData)ruleDataAware;
		Person onFile = militaryServiceInput.getResultPerson();
		Person incoming = militaryServiceInput.getIncomingPerson();
		Person pristine = militaryServiceInput.getPristinePerson();
		Date beginDate=ImpreciseDateUtils.getDateWithDefault(ImpreciseDateUtils.createImpreciseDate(2001,1,1));
		Date endDate=ImpreciseDateUtils.getDateWithDefault(ImpreciseDateUtils.createImpreciseDate(2005,1,1));
		gov.va.med.esr.common.model.ee.Activation activation = this.createEsrActivation(onFile);
		activation.addDeployment(createEsrDeployment());
		gov.va.med.esr.common.model.ee.Activation act = this.createEsrActivation(incoming);
		gov.va.med.esr.common.model.ee.Deployment inDeployment = this.createEsrDeployment();
		act.addDeployment(inDeployment);
		inData.setActivation(act);
		inData.setDeployment(inDeployment);
		CombatService cs = this.createCombatService(incoming);
		inData.setCombatService(cs);

		MilitaryServiceEpisode mse = (MilitaryServiceEpisode)incoming.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator().next();

		inData.setIncomingMilitaryServiceEpisode(mse);

		boolean flag = militaryServiceInput.hasDeployment(onFile);
		assertTrue("expected TRUE hasDeploymentMatch", militaryServiceInput.hasDeploymentMatch(militaryServiceInput.getDeploymentBeginDate()/*Date begin*/));
		assertTrue("expected TRUE hasDeploymentExactMatch", militaryServiceInput.hasDeploymentExactMatch(militaryServiceInput.getDeployment()/*Date begin*/));

		assertTrue("has deployment sb true", flag);
		assertFalse("expected false to CV compare", militaryServiceInput.isCVEndDateImproved(militaryServiceInput.getResultPerson(), militaryServiceInput.getPristinePerson()));
		assertNotNull("missing named contingency", militaryServiceInput.getNameContingencyCode());
		assertNotNull("missing Deployment End Date", militaryServiceInput.getDeploymentEndDate());
//		assertNotNull("missing persons Deployment End Date", militaryServiceInput.getDeploymentEndDate(incoming));
		assertNotNull("missing persons EnteredOnDuty",militaryServiceInput.getEnteredOnDuty());
		assertNotNull("missing persons CombatPayType",militaryServiceInput.getCombatPayType());
		assertNotNull("missing persons CharacterOfServiceCode",militaryServiceInput.getCharacterOfServiceCode());
		assertNotNull("missing persons SpecialOperationCode",militaryServiceInput.getSpecialOperationCode());
		assertNotNull("missing persons TerminationReasonCode",militaryServiceInput.getTerminationReasonCode());
	//		getActivationEndDate(Person person)
		assertNotNull("missing persons ActivationEndDate",militaryServiceInput.getActivationEndDate());

		assertTrue("expected TRUE hasCombatService", militaryServiceInput.hasCombatService(incoming/*Person person*/));
		assertNotNull("missing getCombatServices", militaryServiceInput.getCombatServices(incoming/*Person person*/));

		assertNotNull("missing TerminationReasonCode", militaryServiceInput.getTerminationReasonCode());
		assertNotNull("missing ActivationEndDate", militaryServiceInput.getActivationEndDate(/*Person person*/));
		assertNotNull("missing RADDate", militaryServiceInput.getMatchedRADDate());
		assertNotNull("missing RADDate", militaryServiceInput.getRADDate());
		assertNotNull("missing DeploymentCountry", militaryServiceInput.getDeploymentCountry());
		assertNotNull("missing DeploymentBeginDate", militaryServiceInput.getDeploymentBeginDate());
		assertNotNull("missing CombatServiceSourceCode", militaryServiceInput.getCombatServiceSourceCode());
		assertNotNull("missing ServiceDischargeType", militaryServiceInput.getServiceDischargeType(incoming/*Person person*/));
		assertNotNull("missing DeploymentSourceOfData", militaryServiceInput.getDeploymentSourceOfData());

		inData.setMsdsDataSource(UseCaseName.MSDSVADIR);
		assertNotNull("missing MSDSdataSource", militaryServiceInput.getMSDSdataSource());

		assertTrue("expected TRUE VADIR = MSDSdataSource", UseCaseName.MSDSVADIR.equals(militaryServiceInput.getMSDSdataSource()));
		inData.setMsdsDataSource(UseCaseName.MSDSVBA);
		assertTrue("expected TRUE VBA = MSDSdataSource", UseCaseName.MSDSVBA.equals(militaryServiceInput.getMSDSdataSource()));

		assertNotNull("missing CombatPaySourceOfData", militaryServiceInput.getCombatPaySourceOfData());
		CombatService inCs = militaryServiceInput.getCombatService();
		inCs.setPayStartDate(new ImpreciseDate("200201"));
		inCs.setPayEndDate(new ImpreciseDate("200311"));
		assertTrue("expected TRUE isCombatPayPeriodLessThan", militaryServiceInput.isCombatPayPeriodLessThan(militaryServiceInput.getCombatPayStartDate(),
				militaryServiceInput.getCombatPayEndDate()));/*Date start, Date end*/
		inCs.setPayStartDate(new ImpreciseDate("200001"));
		inCs.setPayEndDate(new ImpreciseDate("200511"));
		assertFalse("expected FALSE isCombatPayPeriodLessThan", militaryServiceInput.isCombatPayPeriodLessThan(militaryServiceInput.getCombatPayStartDate(),
				militaryServiceInput.getCombatPayEndDate()));/*Date start, Date end*/

		MilitaryServiceEpisode mseMatch = inData.getIncomingMilitaryServiceEpisode();
		assertTrue("expected TRUE hasServiceEpisodeExactMatch", militaryServiceInput.hasServiceEpisodeExactMatch());

		ImpreciseDate holdEndDate = mseMatch.getEndDate();
		ImpreciseDate holdStartDate = mseMatch.getStartDate();
		mseMatch.setEndDate(new ImpreciseDate("200701"));
		mseMatch.setStartDate(new ImpreciseDate("200601"));
		assertFalse("expected FALSE hasServiceEpisodeExactMatch", militaryServiceInput.hasServiceEpisodeExactMatch());

		assertFalse("expected FALSE hasCombatPayExactMatch", militaryServiceInput.hasCombatPayExactMatch(null/*CombatService cp*/));

		assertFalse("expected FALSE hasCombatPayExactMatch", militaryServiceInput.hasCombatPayExactMatch(militaryServiceInput.getCombatService()/*CombatService cp*/));
		inCs.setPayStartDate(new ImpreciseDate("200112"));
		inCs.setPayEndDate(new ImpreciseDate("200312"));

		assertTrue("expected TRUE hasCombatPayExactMatch", militaryServiceInput.hasCombatPayExactMatch(militaryServiceInput.getCombatService()/*CombatService cp*/));
		assertTrue("expected TRUE hasMatchingBOSandBegDateOfServiceInADR", militaryServiceInput.hasMatchingBOSandBegDateOfServiceInADR(
				militaryServiceInput.getServiceBranch(),ImpreciseDateUtils.getDateWithDefault(ImpreciseDateUtils.createImpreciseDate(1940,1,1))));/*ServiceBranch branch, Date begin*/
		assertNotNull("missing  getCombatPayEndDateADR", militaryServiceInput.getCombatPayEndDateADR());
		assertFalse("expected FALSE hasServiceEpisodeWithOverlap", militaryServiceInput.hasServiceEpisodeWithOverlap(militaryServiceInput.getMSEFromMSDS()/*MilitaryServiceEpisode mse*/));
		// setup for next test
		mseMatch.setEndDate(holdEndDate);
		mseMatch.setStartDate(holdStartDate);
		assertTrue("expected TRUE hasServiceEpisodeWithOverlap", militaryServiceInput.hasServiceEpisodeWithOverlap(militaryServiceInput.getMSEFromMSDS()/*MilitaryServiceEpisode mse*/));

		assertFalse("expected FALSE hasMultNonbreakServiceEpisodeEQorGT24ContinuousMonths", militaryServiceInput.hasMultNonbreakServiceEpisodeEQorGT24ContinuousMonths());
		assertTrue("expected TRUE hasSingleServiceEpisodeEQorGT24ContinuousMonths", militaryServiceInput.hasSingleServiceEpisodeEQorGT24ContinuousMonths());
		MilitaryServiceEpisode anMse = new MilitaryServiceEpisode();
		anMse.setServiceBranch(this.getRandomServiceBranch());
		anMse.setDischargeType(this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_HONORABLE.getCode()));
		anMse.setStartDate(ImpreciseDateUtils.createImpreciseDate(1946,1,2));
		anMse.setEndDate(ImpreciseDateUtils.createImpreciseDate(1948,1,1));
		anMse.setServiceNumber("12345");
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(anMse);
		MilitaryServiceEpisode bnMse = new MilitaryServiceEpisode();
		bnMse.setServiceBranch(this.getRandomServiceBranch());
		bnMse.setDischargeType(this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_HONORABLE.getCode()));
		bnMse.setStartDate(ImpreciseDateUtils.createImpreciseDate(1948,1,2));
		bnMse.setEndDate(ImpreciseDateUtils.createImpreciseDate(1951,1,1));
		bnMse.setServiceNumber("12345");
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(bnMse);

		assertTrue("expected TRUE isCharacterOfDischargeOfFirstNonbreakServiceEpisodeEqual",
				militaryServiceInput.isCharacterOfDischargeOfFirstNonbreakServiceEpisodeEqual(DischargeType.CODE_HONORABLE.getCode()));/*String code*/
		assertTrue("expected TRUE hasMultNonbreakServiceEpisodeEQorGT24ContinuousMonths",
				militaryServiceInput.hasMultNonbreakServiceEpisodeEQorGT24ContinuousMonths());
		assertTrue("expected TRUE isCharacterOfDischargeOfFirstNonbreakServiceEpisodeEqual",
				militaryServiceInput.isCharacterOfDischargeOfFirstNonbreakServiceEpisodeEqual(DischargeType.CODE_HONORABLE.getCode()));/*String code*/
		assertTrue("expected TRUE hasMultNonbreakServiceEpisode",
				militaryServiceInput.hasMultNonbreakServiceEpisode());
		Date d = ImpreciseDateUtils.getDateWithDefault(new ImpreciseDate("200112"));
		CombatPayType ptype = this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION);
		assertTrue("expected TRUE hasCombatPayMatch",
				militaryServiceInput.hasCombatPayMatch(ptype,d));/*CombatPayType type, Date begin*/
		assertTrue("expected TRUE hasCombatServiceWithOverlap", militaryServiceInput.hasCombatServiceWithOverlap(
				militaryServiceInput.getCombatService()/*CombatService cs*/));

		///////////////////////////
		// SETTER TESTING
		///////////////////////////
		// Won't work since mse does not have source
		militaryServiceInput.setServiceEpisodeSourceOfData();

		MilitaryServiceEpisode tmpMse = militaryServiceInput.getMatchedMSE();
		MilitaryServiceEpisode inMse = militaryServiceInput.getMSEFromMSDS();
		inMse.setDischargeType(this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_OTHER_THAN_HONORABLE.getCode()));
		militaryServiceInput.setCharacterOfDischarge(militaryServiceInput.getServiceDischargeType()/*DischargeType type*/);
		assertEquals("expected equal Discharge Type", tmpMse.getDischargeType().getCode(), inMse.getDischargeType().getCode() );

		CombatService tmp = militaryServiceInput.getCombatService();
		System.out.println( "date start:" + tmp.getPayStartDate().toString()+ "   date end:" + tmp.getPayEndDate().toString() );
		militaryServiceInput.adjustMSDSImpreciseDates();
		System.out.println( "AFTER ADJUSTMENT: date start:" + tmp.getPayStartDate().toString()+ "   date end:" + tmp.getPayEndDate().toString());
		tmp.setPayEndDate(ImpreciseDateUtils.createImpreciseDate(2006,7,17));
		tmp.setPayStartDate(ImpreciseDateUtils.createImpreciseDate(2001,1,23));
		System.out.println( "Before Second Adjustment: date start:" + tmp.getPayStartDate().toString()+ "   date end:" + tmp.getPayEndDate().toString() );
		militaryServiceInput.adjustMSDSImpreciseDates();
		System.out.println( "AFTER ADJUSTMENT: date start:" + tmp.getPayStartDate().toString()+ "   date end:" + tmp.getPayEndDate().toString());

		MilitaryServiceEpisode m = militaryServiceInput.getMatchedMSE();
		System.out.println( "Before RAD date:" + ImpreciseDateUtils.getDateWithDefault(m.getEndDate()).toString());
		Date testDate = new Date();
		militaryServiceInput.setRAD(testDate/*Date rad*/);
		System.out.println( "After RAD date:" + ImpreciseDateUtils.getDateWithDefault(m.getEndDate()).toString());

		CombatService cs2 = militaryServiceInput.getMatchedCombatPay();
		System.out.println( "Before Pay End date:" + ImpreciseDateUtils.getDateWithDefault(cs2.getPayEndDate()).toString());
		militaryServiceInput.updateCombatPayEndDate();
		System.out.println( "After Pay End date:" + ImpreciseDateUtils.getDateWithDefault(cs2.getPayEndDate()).toString());

		gov.va.med.esr.common.model.ee.Deployment depTmp = militaryServiceInput.getMatchedDeployment();
		gov.va.med.esr.common.model.ee.Deployment dep = militaryServiceInput.getDeployment();
		dep.setDeploymentEndDate(new Date());
		System.out.println( "Before Dep End date:" + depTmp.getDeploymentEndDate().toString());
		militaryServiceInput.updateDeploymentEndDate();
		System.out.println( "After Dep End date:" + depTmp.getDeploymentEndDate().toString());

		militaryServiceInput.setDeploymentDateLastUpdated();

		militaryServiceInput.setDeploymentSourceOfData(null/*MHDataSource source*/);

		militaryServiceInput.setServiceEndDate();

		militaryServiceInput.setServiceEpisodeDateLastUpdated();

		militaryServiceInput.setCombatPayDateLastUpdated();

		militaryServiceInput.setCombatPaySourceOfData(null/*MHDataSource source*/);

		militaryServiceInput.getResultPerson().setMilitaryService(null);
		militaryServiceInput.acceptServiceEpisodeFromMSDS();
		Person p = militaryServiceInput.getResultPerson();
		militaryServiceInput.updateCombatPayData();
		militaryServiceInput.updateDeploymentData();
		this.createEsrActivation(militaryServiceInput.getResultPerson());
		gov.va.med.esr.common.model.ee.Activation a = new gov.va.med.esr.common.model.ee.Activation();
		activation.setActivationEndDate(this.getDate(2005, 3, 3));
		militaryServiceInput.getResultPerson().getMilitaryService().addActivation(a);
		Date mostRecent = militaryServiceInput.getMostRecentActivationEndDate();
		assertNotNull("expected most recent date", mostRecent);

		this.createCombatService(militaryServiceInput.getResultPerson());
		CombatService c = new CombatService();
		c.setPayEndDate( new ImpreciseDate("200712"));
		militaryServiceInput.getResultPerson().getMilitaryService().addCombatService(c);
		Date mostRecentCS = militaryServiceInput.getMostRecentCombatPayEndDate();
		assertNotNull("expected most recent combat pay date", mostRecentCS);
	}

	public void testMilitaryServiceDataChange() throws Exception {
		MilitaryServiceInputParameter militaryServiceInput = buildMilitaryServiceInputParameter();
		RuleDataAware ruleDataAware = militaryServiceInput.getRuleDataAware();
		MilitaryServiceInputData inData = (MilitaryServiceInputData)ruleDataAware;

		Person onFile = militaryServiceInput.getResultPerson();

		Person incoming = militaryServiceInput.getIncomingPerson();


		MilitaryServiceEpisode mse = (MilitaryServiceEpisode)incoming.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator().next();


		inData.setIncomingMilitaryServiceEpisode(mse);


		assertFalse("should false for new mse", militaryServiceInput.hasNewMilitaryServiceEpisode());
		assertFalse("should false for new OEFOIF", militaryServiceInput.hasNewOEFOIFdata());
	}


//	protected CombatService createCombatService(Person person) throws Exception {
//		CombatService cs = new CombatService();
//		ImpreciseDate start = new ImpreciseDate("200112");
//		ImpreciseDate end = new ImpreciseDate("200312");
//		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
//		cs.setCombatServiceSource(this.getLookupService().getCombatServiceSourceByCode(
//						CombatServiceSource.CODE_WEBHINQ.getCode()));
//
//		cs.setPayStartDate(start);
//		cs.setPayEndDate(end);
//		if (person.getMilitaryService() == null)
//			this.attachMilitaryService(person);
//		person.getMilitaryService().addCombatService(cs);
//		return cs;
//	}
//
//	// GOAL
//	protected MilitaryPay createVadirMilitaryPay(String location, Date start, Date end, Code payType) throws Exception {
//		MilitaryPay pay =  new MilitaryPay();
//		pay.setCombatServiceLocation(location);
//		pay.setStartDate(start);
//		pay.setEndDate(end);
//		pay.setPayType(payType.getCode());
//		return pay;
//	}

//	protected gov.va.med.esr.common.model.ee.Activation createEsrActivation(Person person) throws Exception {
//		gov.va.med.esr.common.model.ee.Activation activation = new gov.va.med.esr.common.model.ee.Activation();
//		activation.setNamedContingency(this.getLookupService().getNamedContingencyByCode(NamedContingency.DISASTER_RELIEF_HURRICANE_KATRINA.getCode()));
//		activation.setTerminationReason(this.getLookupService().getTerminationReasonByCode(TerminationReason.COMPLETE.getCode()));
//		activation.setActivationBeginDate(this.getDate(2001, 3, 2));
//		activation.setActivationEndDate(this.getDate(2004, 3, 3));
//		if (person.getMilitaryService() == null)
//			attachMilitaryService(person);
//		person.getMilitaryService().addActivation(activation);
//		return activation;
//	}
//	protected gov.va.med.esr.common.model.ee.Deployment createEsrDeployment() throws Exception  {
//		gov.va.med.esr.common.model.ee.Deployment deployment = new gov.va.med.esr.common.model.ee.Deployment();
//		deployment.setSpecialOperation(this.getLookupService().getSpecialOperationByCode(SpecialOperation.OPERATION_ENDURING_FREEDOM.getCode()));
//		deployment.setTerminationReason( this.getLookupService().getTerminationReasonByCode(TerminationReason.COMPLETE.getCode()));
//		deployment.setDataSource(this.getLookupService().getMHDataSourceByCode(MHDataSource.VADIR.getCode()));
//		Date beginDate=ImpreciseDateUtils.getDateWithDefault(ImpreciseDateUtils.createImpreciseDate(2001,1,1));
//		Date endDate=ImpreciseDateUtils.getDateWithDefault(ImpreciseDateUtils.createImpreciseDate(2005,1,1));
//		deployment.setDeploymentBeginDate(beginDate);
//		deployment.setDeploymentEndDate(endDate);
//		deployment.setCountry(this.getLookupService().getMsdsCountryByCode(MsdsCountry.CODE_USA.getCode()));
//
//		return deployment;
//	}

	public void testMHRuleParameter() throws Exception {
		MilitaryServiceInputParameter militaryServiceInput = buildMilitaryServiceInputParameter();
		Person onfile = militaryServiceInput.getResultPerson();
		Person incoming = militaryServiceInput.getIncomingPerson();
		Boolean flag = new Boolean(true);

		assertTrue(Boolean.TRUE.equals( flag));


		incoming.setMedalOfHonor(new MedalOfHonor());
		MedalOfHonor medalOfHonor = incoming.getMedalOfHonor();
		medalOfHonor.setMhIndicator(Boolean.TRUE);
		assertTrue(incoming.getMedalOfHonor().getMhIndicator().booleanValue());

		// ?militaryServiceInput.setMHDecorationStatus( DecorationStatus.CODE_CONFIRMED.getCode() );
		militaryServiceInput.setMHDecorationStatus( DecorationStatus.CODE_CONFIRMED.getCode() );
		assertTrue(DecorationStatus.CODE_CONFIRMED.getCode().equals(incoming.getMedalOfHonor().getStatus().getCode()));

		// ?militaryServiceInput.setMHDataSource(gov.va.med.esr.common.model.lookup.MHDataSource.WEBHINQ.getCode());
		militaryServiceInput.setMHDataSource(gov.va.med.esr.common.model.lookup.MHDataSource.WEBHINQ.getCode());
		assertTrue(gov.va.med.esr.common.model.lookup.MHDataSource.WEBHINQ.getCode().equals(incoming.getMedalOfHonor().getDataSource().getCode()));

		// ?militaryServiceInput.setMHDocumentReceiptDate( ?militaryServiceInput.getCurrentDate() );
		militaryServiceInput.setMHDocumentReceiptDate( militaryServiceInput.getCurrentDate() );
		assertNotNull(incoming.getMedalOfHonor().getDocumentReceiptDate());

		// ?militaryServiceInput.setMHStatusUpdateDate( ?militaryServiceInput.getCurrentDate() );
		militaryServiceInput.setMHStatusUpdateDate( militaryServiceInput.getCurrentDate() );
		assertNotNull(incoming.getMedalOfHonor().getStatusLastUpdateDate());

		// ?militaryServiceInput.setMHDocumentType(gov.va.med.esr.common.model.lookup.MHDocumentType.CODE_VBA_DOD_FILE.getCode());
		militaryServiceInput.setMHDocumentType(gov.va.med.esr.common.model.lookup.MHDocumentType.CODE_VBA_DOD_FILE.getCode());
		assertTrue(gov.va.med.esr.common.model.lookup.MHDocumentType.CODE_VBA_DOD_FILE.getCode().equals(incoming.getMedalOfHonor().getDocumentType().getCode()));

		// ?militaryServiceInput.setMHIndicator( "Y" );
		militaryServiceInput.setMHIndicator( "Y" );
		assertTrue("Y".equals(militaryServiceInput.getMedalOfHonorIndicator(incoming)));
		militaryServiceInput.setMHIndicator( "N" );
		assertTrue("N".equals(militaryServiceInput.getMedalOfHonorIndicator(incoming)));

		// ?militaryServiceInput.acceptMHFromMSDS();
		militaryServiceInput.acceptMHFromMSDS();
		assertTrue(onfile.getMedalOfHonor().getMhIndicator().booleanValue());
	}



	public void test24Months() {
		Date start = getDate(2009,0,1);
		Date end = getDatePlus24MonthsMinus1Day(start);

		System.out.println( "date start:" + start.toString()+ "   date end:" + end.toString() );
	}

	public void testCCR13810_CLEOnFileYesMSDSNo() throws Exception {

		Date startTime = new Date();

		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		ServicePeriod servicePeriod =
			new ServicePeriod();
		PeriodOfService periodOfService =
			new PeriodOfService();

		// BIRLS DATA
		periodOfService.setBranchOfService("NAVY");
		periodOfService.setCharacterOfService("DIS");
		periodOfService.setReleasedActiveDutyDate(this.getDate(2008, 6, 8));
		periodOfService.setEnteredOnDutyDate(this.getDate(2004, 1, 8));

		List periodOfServices = new ArrayList();
		birls.setPeriodOfService(periodOfServices);

		periodOfServices.add(periodOfService);

		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		mockMilitaryHistory.setBirls(birls);

		// SETUP VADIR DATA
		List servicePeriodsV = new ArrayList();
		vadir.setServicePeriods(servicePeriodsV);

		// Combat Service
		MilitaryPay payV = new MilitaryPay();
		payV.setPayType("01");
		payV.setStartDate(this.getDate(2004, 1, 8));
		payV.setEndDate(this.getDate(2006, 1, 1));
		MilitaryPay payW = new MilitaryPay();
		payW.setPayType("01");
		payW.setStartDate(this.getDate(2006, 1, 1));
		payW.setEndDate(this.getDate(2008, 6, 8));

		List pays = new ArrayList();
		pays.add(payV);
		pays.add(payW);

		servicePeriod.setMilitaryPayments(pays);
		servicePeriod.setStartDate(this.getDate(2004, 1, 8));
		servicePeriod.setEndDate(this.getDate(2008, 6, 8));
		servicePeriod.setBranchOfService("N");
		servicePeriod.setPersonnelCategory("A");
		servicePeriod.setCharacterOfService("A");

		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);

		mockMilitaryHistory.setVadir(vadir);
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
//		wrapper.setPersonId(new Long(377538927).longValue());//vpid=0000001008693042V111533000000, new
//		wrapper.setPersonId(new Long(377268964).longValue());//vpid=0000001008519846V083682000000, existing
//		wrapper.setPersonId(new Long(377539155).longValue());//vpid=0000001008693043V377965000000, new
		wrapper.setPersonId(new Long(377551770).longValue());//vpid=0000001008693048V824429000000, new
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);


        // Assert VOA PENDING workflow item just created
//        WorkflowCase wfc = getWorkflowService().getMostRecentWorkflowItem(result);
//        assertTrue("Most recent workflow must be created just now for Veteran CL Eligibility cannot be determined",
//        		wfc != null && wfc.getCreatedOn().after(startTime) && "Veteran CL Eligibility cannot be determined".equalsIgnoreCase(wfc.getErrorMessage()));

		System.out.println("verification record ="+result.getEligibilityVerification());

		this.setComplete();
	}

	public void testCCR13810_CLEOnFileNoMSDSYes() throws Exception {

		Date startTime = new Date();

		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		ServicePeriod servicePeriod =
			new ServicePeriod();
		PeriodOfService periodOfService =
			new PeriodOfService();

		// BIRLS DATA
		periodOfService.setBranchOfService("NAVY");
		periodOfService.setCharacterOfService("HON");
		periodOfService.setReleasedActiveDutyDate(this.getDate(1985, 6, 8));
		periodOfService.setEnteredOnDutyDate(this.getDate(1980, 1, 8));

		List periodOfServices = new ArrayList();
		birls.setPeriodOfService(periodOfServices);

		periodOfServices.add(periodOfService);

		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		mockMilitaryHistory.setBirls(birls);

		// SETUP VADIR DATA
		List servicePeriodsV = new ArrayList();
		vadir.setServicePeriods(servicePeriodsV);

		// Combat Service
		MilitaryPay payV = new MilitaryPay();
		payV.setPayType("01");
		payV.setStartDate(this.getDate(1981, 1, 1));
		payV.setEndDate(this.getDate(1983, 6, 8));
		MilitaryPay payW = new MilitaryPay();
		payW.setPayType("01");
		payW.setStartDate(this.getDate(1984, 7, 1));
		payW.setEndDate(this.getDate(1986, 6, 8));

		List pays = new ArrayList();
		pays.add(payV);
		pays.add(payW);

		servicePeriod.setMilitaryPayments(pays);
		servicePeriod.setStartDate(this.getDate(1980, 1, 8));
		servicePeriod.setEndDate(this.getDate(1986, 6, 8));
		servicePeriod.setBranchOfService("N");
		servicePeriod.setPersonnelCategory("A");
		servicePeriod.setCharacterOfService("A");

		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);

		mockMilitaryHistory.setVadir(vadir);
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();

		wrapper.setPersonId(new Long(377545742).longValue());//vpid=0000001008693047V996100000000, new
		wrapper.setResult(mockMilitaryHistory);
		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);

		Person result = this.getMilitaryInfoService().processMSDSData(info);


        // Assert VOA PENDING workflow item just created
//        WorkflowCase wfc = getWorkflowService().getMostRecentWorkflowItem(result);
//        assertTrue("Most recent workflow must be created just now for Veteran CL Eligibility cannot be determined",
//        		wfc != null && wfc.getCreatedOn().after(startTime) && "Veteran CL Eligibility cannot be determined".equalsIgnoreCase(wfc.getErrorMessage()));

		System.out.println("verification record ="+result.getEligibilityVerification());

		this.setComplete();
	}
//	public void testW() throws Exception {
//	   WorkflowCaseInfo caseInfo = new WorkflowCaseInfo();
//
//       caseInfo.setGroupType(this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()));
//	   caseInfo.setCaseType(this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_REVIEW_FILE.getCode()));
//       caseInfo.setIssueType(this.getLookupService().getWkfIssueTypeByCode("RF8"));
//		System.out.println( "done" );
//	}

	private Date getDatePlus24MonthsMinus1Day(Date date) {
        if( date != null ) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime( date );
            calendar.add(Calendar.MONTH,24);
            calendar.add(Calendar.DATE,-1);
            return calendar.getTime();
        }
        return null;
    }

//	protected VadirServiceResponseWrapper createWrapper(long val,
//	PeriodOfService birlsPeriodOfService,
//	ServicePeriod vadirServicePeriod, int newParam) throws Exception {
//		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
//		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
//		wrapper.setPersonId(new Long(val).longValue());
//		if (newParam == 2) {
//			wrapper.setErrorMessage(NoPersonFound);
//			return wrapper;
//
//		}
//		if (newParam == 3) {
//			wrapper.setErrorMessage(null);
//			return wrapper;
//
//		}
//
//		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
//		BIRLS birls = new BIRLS();
//		VADIR vadir = new VADIR();
//		PeriodOfService periodOfService =
//			new PeriodOfService();
//		ServicePeriod servicePeriod =
//			new ServicePeriod();
//		Activation activationV =
//			new Activation();
//		Activation activationX =
//			new Activation();
//		Deployment deploymentV =
//			new Deployment();
//		Deployment deploymentX =
//			new Deployment();
//
//
//		if (birlsPeriodOfService != null) {
//			periodOfService = birlsPeriodOfService;
//		}
//		else {
//			// BIRLS
//			periodOfService.setBranchOfService("WAC");
//			periodOfService.setCharacterOfService("HON");
//			//periodOfService.setCharacterOfService(" ");
//			periodOfService.setReleasedActiveDutyDate(this.getDate(2009, 1, 8));
//			periodOfService.setEnteredOnDutyDate(this.getDate(2003, 1, 8));
//			periodOfService.setBranchOfService("WAC");
//		}
//
//		if (vadirServicePeriod != null) {
//			servicePeriod = vadirServicePeriod;
//		}
//		else {
//			// Military Service Episodes
//			servicePeriod.setStartDate(this.getDate(2008, 1, 8));
//			servicePeriod.setEndDate(this.getDate(2010, 1, 8));
//			servicePeriod.setBranchOfService("A");
//			servicePeriod.setPersonnelCategory("A");
//			servicePeriod.setCharacterOfService("A");
//		}
//
//		ServicePeriod servicePeriod2 =
//			new ServicePeriod();
//		if (newParam == 1) {
//			// Military Service Episodes
//			servicePeriod2.setStartDate(this.getDate(2000, 1, 8));
//			servicePeriod2.setEndDate(this.getDate(2001, 1, 8));
//			servicePeriod2.setBranchOfService("WAC");
//			servicePeriod2.setPersonnelCategory("A");
//			servicePeriod2.setCharacterOfService("A");
//
//			periodOfService.setEnteredOnDutyDate(this.getDate(2006, 1, 8));
//			periodOfService.setReleasedActiveDutyDate(this.getDate(2007, 1, 8));
//			periodOfService.setCharacterOfService(null);
//
//			servicePeriod.setStartDate(this.getDate(2005, 1, 8));
//			servicePeriod.setEndDate(this.getDate(2006, 1, 8));
//			servicePeriod.setCharacterOfService(null);
//		}
//		vadir.setOefOifIndicator("02"); // OEF
//
//		// BIRLS
//		List periodOfServices = new ArrayList();
//		periodOfServices.add(periodOfService);
//		birls.setPeriodOfService(periodOfServices);
//		birls.setMedalOfHonorInd("Y");
//		birls.setPurpleHeartInd("Y");
//		mockMilitaryHistory.setBirls(birls);
//
//		// VADIR
//		activationV.setStartDate(this.getDate(2002, 1, 8));
//		activationV.setEndDate(this.getDate(2005, 1, 8));
//		activationV.setTerminationRsn("D");
//		activationX.setStartDate(this.getDate(2006, 1, 8));
//		activationX.setEndDate(this.getDate(2007, 1, 8));
//		activationX.setTerminationRsn("D");
//
//		deploymentV.setStartDate(this.getDate(2002, 1, 8));
//		deploymentV.setEndDate(this.getDate(2003, 1, 8));
//		deploymentV.setTerminationRsn("D");
//		deploymentV.setSpecialOperation("14");
//
//		deploymentX.setStartDate(this.getDate(2003, 2, 8));
//		deploymentX.setEndDate(this.getDate(2005, 6, 8));
//		deploymentX.setTerminationRsn("D");
//		deploymentX.setSpecialOperation("14");
//
//		// Deployments
//		List deploymentsV = new ArrayList();
//		deploymentsV.add(deploymentV);
//		deploymentsV.add(deploymentX);
//		servicePeriod.setDeployments(deploymentsV);
//
//		// Activations
//		List activationsV = new ArrayList();
//		activationsV.add(activationV);
//		activationsV.add(activationX);
//		servicePeriod.setActivations(activationsV);
//
//		// Combat Service
//		MilitaryPay payV = new MilitaryPay();
//		payV.setPayType("01");
//		payV.setStartDate(this.getDate(2004, 1, 8));
//		payV.setEndDate(this.getDate(2005, 1, 8));
//
//		List pays = new ArrayList();
//		pays.add(payV);
//		servicePeriod.setMilitaryPayments(pays);
//
//		List servicePeriodsV = new ArrayList();
//		servicePeriodsV.add(servicePeriod);
//		if (newParam > 0) {
//			servicePeriodsV.add(servicePeriod2);
//		}
//		vadir.setServicePeriods(servicePeriodsV);
//
//		mockMilitaryHistory.setVadir(vadir);
//		wrapper.setResult(mockMilitaryHistory);
//		///////////////////////////////////////////////
//		// Do a build
//		///////////////////////////////////////////////
//
//		return wrapper;
//	}

//	protected  MsdsResponseInfo createMockMsdsResponseInfo(long val,
//			PeriodOfService birlsPeriodOfService,
//			ServicePeriod vadirServicePeriod, int newParam) throws Exception {
//		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
//
//		VadirServiceResponseWrapper wrapper = this.createWrapper(val, birlsPeriodOfService, vadirServicePeriod, newParam);
//		return (MsdsResponseInfo)msdsBuilder.build(wrapper);
//	}

//	protected  MsdsResponseInfo createMockMsdsResponseInfoFromOneSource(long val,
//			PeriodOfService birlsPeriodOfService,
//			ServicePeriod vadirServicePeriod, int newParam) throws Exception {
//		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
//		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
//		wrapper.setPersonId(new Long(val).longValue());
//
//		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
//		BIRLS birls = new BIRLS();
//
//		PeriodOfService periodOfService =
//			new PeriodOfService();
//
//
//		if (birlsPeriodOfService != null) {
//			periodOfService = birlsPeriodOfService;
//		}
//		else {
//			// BIRLS
//			periodOfService.setCharacterOfService("HON");
//			//periodOfService.setCharacterOfService(" ");
//			periodOfService.setReleasedActiveDutyDate(this.getDate(2003, 1, 8));
//			periodOfService.setEnteredOnDutyDate(this.getDate(2003, 1, 8));
//			periodOfService.setBranchOfService("NAVY");
//		}
//
//		// BIRLS
//		List periodOfServices = new ArrayList();
//		periodOfServices.add(periodOfService);
//		birls.setPeriodOfService(periodOfServices);
//		birls.setMedalOfHonorInd("Y");
//		birls.setPurpleHeartInd("Y");
//		mockMilitaryHistory.setBirls(birls);
//
//		mockMilitaryHistory.setReturnStatus(this.NoPersonFoundinVADIR);
//		wrapper.setResult(mockMilitaryHistory);
//
//		///////////////////////////////////////////////
//		// Do a build
//		///////////////////////////////////////////////
//
//		return (MsdsResponseInfo)msdsBuilder.build(wrapper);
//	}
//

//	protected SessionFactory getSessionFactory() {
//		if (sessionFactory == null) {
//			Object bean = applicationContext.getBean( "sessionFactory" );
//			sessionFactory = bean instanceof SessionFactory ? (SessionFactory)bean : null;
//		}
//		return sessionFactory;
//	}
//	protected Session getCurrentSession() throws Exception {
//		return this.getSessionFactory().getCurrentSession();
//	}
	
	public void testEMISResponse1() throws Exception {
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		PeriodOfService periodOfService = new PeriodOfService();
		PeriodOfService periodOfService2 = new PeriodOfService();
		PeriodOfService periodOfService3 = new PeriodOfService();
		ServicePeriod servicePeriod = new ServicePeriod();
		ServicePeriod servicePeriod2 = new ServicePeriod();
		ServicePeriod servicePeriod3 = new ServicePeriod();
		Activation activation = new Activation();
		Activation activation2 = new Activation();
		Activation activation3 = new Activation();
		Deployment deployment = new Deployment();

		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(489358).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		PersonEntityKey key =
			CommonEntityKeyFactory.createPersonIdEntityKey(String.valueOf(wrapper.getPersonId()));

		// BIRLS
		periodOfService.setBranchOfService("A");
		periodOfService.setCharacterOfService("Z");		
		periodOfService.setEnteredOnDutyDate(this.getDate(1993, 6, 17));
		periodOfService.setReleasedActiveDutyDate(this.getDate(2012, 7, 26));
		periodOfService.setSeparationReason("900");

		
		periodOfService2.setBranchOfService("A");
		periodOfService2.setCharacterOfService("Z");
		periodOfService2.setEnteredOnDutyDate(this.getDate(1992, 8, 30));
		periodOfService2.setReleasedActiveDutyDate(this.getDate(1993, 6, 16));
		periodOfService2.setSeparationReason("999");
		
		periodOfService3.setBranchOfService("A");
		periodOfService3.setCharacterOfService("A");
		periodOfService3.setEnteredOnDutyDate(this.getDate(1981, 7, 25));
		periodOfService3.setReleasedActiveDutyDate(this.getDate(1992, 8, 29));
		periodOfService3.setSeparationReason("037");
		
		
		List periodOfServices = new ArrayList();
		//periodOfService.setBranchOfService("WAC");
		periodOfServices.add(periodOfService);
		periodOfServices.add(periodOfService2);
		periodOfServices.add(periodOfService3);

		birls.setPeriodOfService(periodOfServices);
		//birls.setMedalOfHonorInd("Y");
		//birls.setPurpleHeartInd("Y");

		mockMilitaryHistory.setBirls(birls);

		// VADIR
		activation.setStartDate(this.getDate(2009, 10, 16));
		activation.setEndDate(this.getDate(2011, 9, 23));
		activation.setTerminationRsn("C");
		activation.setCharacterOfService("H");
		
		activation2.setStartDate(this.getDate(2003, 3, 1));
		activation2.setEndDate(this.getDate(2005, 0, 10));
		activation2.setTerminationRsn("C");
		activation2.setCharacterOfService("H");
		
		activation3.setStartDate(this.getDate(2003, 0, 30));
		activation3.setEndDate(this.getDate(2003, 2, 31));
		activation3.setTerminationRsn("C");
		activation3.setCharacterOfService("H");
		
		deployment.setStartDate(this.getDate(2009, 5, 28));
		deployment.setEndDate(this.getDate(2009, 10, 18));
		//deployment.setStartDate(this.getDate(2009, 10, 17));
		//deployment.setEndDate(this.getDate(2009, 10, 21));
		deployment.setTerminationRsn("C");
		deployment.setLocation("GM"); // MSDS_CodeCR10606 disabled

		// Deployments
		List deployments = new ArrayList();
		deployments.add(deployment);

		servicePeriod.setDeployments(deployments);

		// Activations
		List activations = new ArrayList();
		activations.add(activation);
		activations.add(activation2);
		activations.add(activation3);

		servicePeriod.setActivations(activations);

		/*
		// Combat Service
		MilitaryPay pay = new MilitaryPay();
		pay.setPayType(CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode());
		pay.setStartDate(this.getDate(2002, 1, 1));
		pay.setEndDate(this.getDate(2006, 6, 8));
		pay.setCombatServiceLocation("ZZ"); // MSDS_CodeCR10606 disabled

		List pays = new ArrayList();
		pays.add(pay);
		
		servicePeriod.setMilitaryPayments(pays);
		*/
		
		servicePeriod.setStartDate(this.getDate(1993, 7, 17));
		servicePeriod.setEndDate(this.getDate(2012, 7, 26));
		servicePeriod.setBranchOfService("A");
		servicePeriod.setPersonnelCategory("N");
		servicePeriod.setCharacterOfService("Z");

		
		servicePeriod2.setStartDate(this.getDate(1992, 8, 30));
		servicePeriod2.setEndDate(this.getDate(1993, 6, 16));
		servicePeriod2.setBranchOfService("A");
		servicePeriod2.setPersonnelCategory("V");
		servicePeriod2.setCharacterOfService("Z");
		
		servicePeriod3.setStartDate(this.getDate(1981, 7, 25));
		servicePeriod3.setEndDate(this.getDate(1992, 8, 29));
		servicePeriod3.setBranchOfService("A");
		servicePeriod3.setPersonnelCategory("A");
		servicePeriod3.setCharacterOfService("A");
		
		List servicePeriods = new ArrayList();
		servicePeriods.add(servicePeriod);
		servicePeriods.add(servicePeriod2);
		servicePeriods.add(servicePeriod3);

		// 01 OEF, 02 OIF, 03 both OEF and OIF, 04 neither/unable to determine
		vadir.setOefOifIndicator("03");
		vadir.setRetirementStatusIndicator("R");
		vadir.setServicePeriods(servicePeriods);

		mockMilitaryHistory.setVadir(vadir);
		wrapper.setResult(mockMilitaryHistory);

		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS();
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		MilitaryService ms = info.getVadirMilitaryService();
		assertNotNull(ms);
		//assertNotNull(ms.getCombatEpisodes());
		//assertTrue("expected 1 combat episode",ms.getCombatEpisodes().size() == 1);
		//CombatEpisode ce = (CombatEpisode)ms.getCombatEpisodes().iterator().next();
		//System.out.println( "combat episode=" + ce.toString());
	}
	
}

