package gov.va.med.esr.common.rule.service;

// Java classes
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.lookup.EligibilityFactor;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.util.RuleAbstractTestCase;


public class ProcessOtherEligibilitiesTest extends RuleAbstractTestCase {

    
    
    public ProcessOtherEligibilitiesTest(String testName) {
        super(testName);
        // TODO Auto-generated constructor stub
    }

    
  public void testAddOtherEligibilities() throws Exception {
      Person onFile = buildSimplePerson();
      Person incoming = this.getPersonService().save(onFile);      
      EnrollmentDetermination ed = new EnrollmentDetermination();
 
      // AgentOrange- If the Agent Orange indicator is YES then add the
      // Agent
      // Orange to other eligibility list.
      this.attachAgentOrangeExposure(incoming);
      
      // CatastrophicDisabled-  If catastrophically disabled is yes then
      // add Catastrophic disabled to the Other Eligibility List.
      this.attachCatastrophicDisability(incoming);
      
      // EnvironmentalContaminants- If the environmental contaminants is YES
      // then add the environmental contaminants to other eligibility list.
      this.attachEnvironmentalContaminationExposure(incoming);
      
      // RadiationExposure- If the Radiation Exposure indicator is YES then
      // add the Radiation Exposure to other eligibility list.
      this.attachRadiationExposure(incoming);
      
      // Shad  If the veteran is part of the shad file then add shad to other
      // eligibility
      incoming.setShad(new SHAD());

      // NTRVerification  If NTR verification method station number is not
      // null and NTR verification method is military medical Record (M)  or
      // Qualifying military Service (S) then add NTR to other eligibility
      // list.
      this.attachNoseThroatRadium(incoming);
      
      // MSTVerification- If MST indicator is yes and creened reports MST
      // is
      // yes then add MST to other eligibility list
      this.attachMilitarySexualTrauma(incoming);
      
      this.attachMeansTestWithHardship(incoming);
      
      // Combat Veteran Eligible -- if CV Eligibility End Date not expired then
      // add Combat Veteran Eligible to other eligibility list
      //this.attachConflictExperience(incoming, new Date(((new Date()).getTime() + 100000)) /*this.getDate(2016, 1, 5)*/);
      this.attachConflictExperience(incoming, this.getDate(2007, 1, 5));
      
      // Eligible for Medicaid -- if Eligible for Medicaid Indicator is YES then add
      // Eligible for Medicaid to other eligibility list
      this.attachMedicaidFactor(incoming);

      // Simulate a business service that would get person from db.
      onFile = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey()); 
      
      // Execute Rules
      this.getEnrollmentRuleService().processOtherEligibililities(incoming, onFile, ed);
      onFile.setEnrollmentDetermination(ed);

      this.assessIfHasOtherRanking(
              EligibilityFactor.AGENT_ORANGE_EXPOSURE.getName(), onFile);
      this.assessIfHasOtherRanking(
    		  EligibilityFactor.CATASTROPHICALLY_DISABLED.getName(), 
              onFile);
      this.assessIfHasOtherRanking(
    		  EligibilityFactor.RADIATION_EXPOSURE.getName(), onFile);
      this.assessIfHasOtherRanking(
    		  EligibilityFactor.SHAD.getName(), onFile);
     this.assessIfHasOtherRanking(
    		 EligibilityFactor.ENVIRONMENTAL_CONTAMINANTS.getName(),
              onFile);
      this.assessIfHasOtherRanking(
    		  EligibilityFactor.HARDSHIP_GRANTED.getName(), onFile);
      this.assessIfHasOtherRanking(
    		  EligibilityFactor.NOSE_THROAT_RADIUM.getName(), onFile);
      this.assessIfHasOtherRanking(
    		  EligibilityFactor.MILITARY_SEXUAL_TRAUMA.getName(), onFile);
      this.assessIfHasOtherRanking(
    		  EligibilityFactor.COMBAT_VETERAN.getName(), onFile);
      this.assessIfHasOtherRanking(
              EligibilityType.ELIGIBLE_FOR_MEDICAID.getName(), onFile);
  }    
    
}
