/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

// Java classes

// Library classes

// Framework classes

// EDB Classes
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.lookup.EthnicityType;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.SourceDesignation;
import gov.va.med.esr.common.model.lookup.RaceType;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Ethnicity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.common.util.RuleAbstractTestCase;


/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public class ProcessNewVeteranTest extends RuleAbstractTestCase {
    /**
     * Constructor for ProcessNewVeteran.
     * @param testName
     */
    public ProcessNewVeteranTest(String testName) throws Exception {
        super(testName);        
    }

    
    /** Req 1578, TBL928: 

    IF new person and person has non-veteran primary eligibility THEN
     Upload the data
     (Accept Sites Eligibility Status)
        
    */
    public void testNewPersonIsNonVeteran() throws Exception {
        Person onFile = this.buildSimpleNonVeteran();
        Person person = this.savePerson(onFile); 
        setEligibilityStatus(EligibilityStatus.CODE_VERIFIED, person);

        executeProcessNewVeteranRuleSet(person, onFile);
        assertNotNull(onFile.getEligibilityVerification());        
        assertTrue(onFile.getEligibilityVerification().getEligibilityStatus()
                .getCode().equals(EligibilityStatus.CODE_VERIFIED.getName()));
    }
    
    public void testNewVeteranDataIsPending() throws Exception {
        Person onFile = buildPerson();
        Person person = this.savePerson(onFile);
        setEligibilityStatus(EligibilityStatus.CODE_PENDING_VERIFICATION, person);

        executeProcessNewVeteranRuleSet(person, onFile);
        assertNull(onFile.getEligibilityVerification());
    }     
    public void testAAPVerifiedSC0Person11457() throws Exception {
    	Person onFile = this.buildSimpleAAPPerson();
    	Person incoming = (Person)onFile.clone();	
		// Notice this is being set to VERIFIED
		this.setEligibilityStatusToVerified(incoming);
		this.setServiceConnectedPercentage(new Integer(0), incoming);
		Iterator iter = incoming.getServiceConnectionAward().getRatedDisabilities().iterator();
		while (iter.hasNext()) {
			RatedDisability rd = (RatedDisability) iter.next();
			rd.setPercentage(new Integer(0));
		}
		getEligibilityFactorRuleService().manageNewVeteranFromAddPerson(incoming, onFile);
        assertNotNull(onFile.getEligibilityVerification());
        assertTrue("eligibility status should be Pending",EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));

    }	
    public void testAAPPendingSC0Person11457() throws Exception {
    	Person onFile = this.buildSimpleAAPPerson();
    	Person incoming = (Person)onFile.clone();	
		// Notice this is being set to Pending
		this.setEligibilityStatusToPendingVerification(incoming);
		this.setServiceConnectedPercentage(new Integer(0), incoming);
		Iterator iter = incoming.getServiceConnectionAward().getRatedDisabilities().iterator();
		while (iter.hasNext()) {
			RatedDisability rd = (RatedDisability) iter.next();
			rd.setPercentage(new Integer(0));
		}
		getEligibilityFactorRuleService().manageNewVeteranFromAddPerson(incoming, onFile);
        assertNotNull(onFile.getEligibilityVerification());
        assertTrue("eligibility status should be Pending",EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));

    }	      
    public void testAAPVerifiedNSCPerson11457() throws Exception {
    	Person onFile = this.buildSimpleAAPPerson();
    	Person incoming = (Person)onFile.clone();	
		// Notice this is being set to VERIFIED
		this.setEligibilityStatusToVerified(incoming);
		getEligibilityFactorRuleService().manageNewVeteranFromAddPerson(incoming, onFile);
        assertNotNull(onFile.getEligibilityVerification());
        assertTrue("eligibility status should be Pending",EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));
    }	        
    public void testAAPPendingNSCPerson11457() throws Exception {
    	Person onFile = this.buildSimpleAAPPerson();
    	Person incoming = (Person)onFile.clone();
		this.setEligibilityStatusToPendingVerification(incoming);
		getEligibilityFactorRuleService().manageNewVeteranFromAddPerson(incoming, onFile);
        assertNotNull(onFile.getEligibilityVerification());
        assertTrue("eligibility status should be Pending",EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));
    }	            
    private Person buildSimpleAAPPerson() throws Exception {
    	Person onFile = buildSimplePerson();
		VAFacility fac = this.getLookupService().getVaFacilityByCode("553");
		PreferredFacility pfac = new PreferredFacility();
		pfac.setFacility(fac);
		pfac.setSourceDesignation(this.getLookupService().getSourceDesignationByCode(SourceDesignation.CODE_ESR.getCode()));
		onFile.addPreferredFacility(pfac);
		onFile.setMostRecentPreferredFacility(fac);
		// Notice this is being set to Pending
		onFile.setEligibilityVerification(this.createEligibilityVerification());
		onFile.getEligibilityVerification().setVerificationFacility(this.getRandomVAFacility());
		onFile.getEligibilityVerification().setVerificationSource(
				this.getLookupService().getEligibilityVerificationSourceByCode(EligibilityVerificationSource.CODE_CEV.getCode()));
		this.addPermanentAddress(onFile, Calendar.getInstance().getTime(),null);
		onFile.getPermanentAddress().setChangeDate(null);
		return this.getPersonService().save(onFile);		
    }	                
    public void testNewVeteranDataIsPendingReverify() throws Exception {
        Person onFile = buildPerson();
        Person person = this.savePerson(onFile);
        setEligibilityStatus(EligibilityStatus.CODE_PENDING_REVERIFICATION, person);

        executeProcessNewVeteranRuleSet(person, onFile);
        assertNull(onFile.getEligibilityVerification());
    }        
	private void executeProcessNewVeteranRuleSet(Person inPerson, Person onFile)
            throws Exception {

        this.getEligibilityFactorRuleService().processNewVeteran(inPerson, onFile);

    } 
}
