/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.rule.service;

import java.util.Calendar;
import java.util.Set;

import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.fw.service.ServiceException;

/**
 * 
 * @author DNS   MANSOG
 * @version 1.0
 */
public class ProcessFeeBasisTest extends RuleAbstractTestCase {

    public ProcessFeeBasisTest(String testName) throws Exception {
        super(testName);
    }

	public void testFeeBasisAdd() throws Exception {
		VAFacility facility = getVaFacility(VAFacility.CODE_ALBUQUERQUE);
		Person person = savePerson(buildSimplePerson());
		
		// Clone the pristine to have a working version
		Person incoming = (Person) person.clone();
		FeeBasis fb = createFeeBasis();
		fb.setReportSite(facility);
		VAFacility reportSite = fb.getReportSite();
		incoming.addFeeBasis(fb);		
		
		Person onFile = getPersonService().getPerson(person.getPersonEntityKey());

		try {
			Person result = getFinancialInfoRuleService().processFeeBasis(facility, incoming, onFile, false);
			assertNotNull("Result Person can not be null.", result);
			FeeBasis resultFeeBasis = getFeeBasis(result,reportSite);
			assertNotNull("Result FeeBasis can not be null.", resultFeeBasis);
			assertNotNull("Result resultFeeBasis.getProgram can not be null.", resultFeeBasis.getProgram());
			assertNotNull("Result resultFeeBasis.getTreatmentType can not be null.", resultFeeBasis.getTreatmentType());
			assertNotNull("Result resultFeeBasis.getAuthorizationFromDate can not be null.", resultFeeBasis.getAuthorizationFromDate());
			assertNotNull("Result resultFeeBasis.getAuthorizationToDate can not be null.", resultFeeBasis.getAuthorizationToDate());
			
		} catch (Exception e) {
			fail("Failed due to exception ", e);
		}
	}

	public void testFeeBasisUpdate() throws Exception {
		VAFacility facility = getVaFacility(VAFacility.CODE_ALBUQUERQUE);
		FeeBasis fb = createFeeBasis();
		fb.setReportSite(facility);
		Person person = savePerson(buildSimplePerson());
		person.addFeeBasis(fb);		
		
		// Clone the pristine to have a working version
		Person incoming = (Person) person.clone();
		FeeBasis inFb = getFeeBasis(incoming,facility);
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.DATE, 5);
		calendar.add(Calendar.HOUR, 3);
		inFb.setReportDate(calendar.getTime());
		
		Person onFile = getPersonService().getPerson(person.getPersonEntityKey());

		try {
			Person result = getFinancialInfoRuleService().processFeeBasis(facility, incoming, onFile,false);
			assertNotNull("Result Person can not be null.", result);
			FeeBasis resultFeeBasis = getFeeBasis(result,facility);
			assertNotNull("Result FeeBasis can not be null.", resultFeeBasis);
			assertNotNull("Result resultFeeBasis.getProgram can not be null.", resultFeeBasis.getProgram());
			assertNotNull("Result resultFeeBasis.getTreatmentType can not be null.", resultFeeBasis.getTreatmentType());
			assertNotNull("Result resultFeeBasis.getAuthorizationFromDate can not be null.", resultFeeBasis.getAuthorizationFromDate());
			assertNotNull("Result resultFeeBasis.getAuthorizationToDate can not be null.", resultFeeBasis.getAuthorizationToDate());
			assertEquals("Report date is not updated.", calendar.getTime(), resultFeeBasis.getReportDate());
			
		} catch (Exception e) {
			fail("Failed due to exception ", e);
		}
	}

    protected Person savePerson(Person person) throws ServiceException,
            Exception {
        return getPersonService().save(person);
    }
    
    private FeeBasis getFeeBasis(Person person, VAFacility reportSite){
        Set feeBasisSet = person.getFeeBasis(reportSite);
        if (feeBasisSet != null && feeBasisSet.size() > 0){
            return (FeeBasis)feeBasisSet.iterator().next();
        }
        return null;
    }
}