package gov.va.med.esr.common.rule.service;



// Java classes
import java.util.HashSet;


// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.service.external.demographics.DemographicsChangeEvent;
import gov.va.med.esr.service.external.demographics.DemographicsChangeType;
import gov.va.med.esr.service.external.person.EntityKeyFactory;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.AddressType;

/**
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class ProcessExternalServicesTest extends RuleAbstractTestCase {

    public ProcessExternalServicesTest(String testName) {
        super(testName);

    }
    
    public void testDODChange() throws Exception {
        this.doTest(DemographicsChangeType.DATE_OF_DEATH_CHANGE);
    }
    
    public void testAddressChange() throws Exception {
        this.doTest(DemographicsChangeType.ADDRESS_CHANGE);
    }
    
    public void testBadData1() throws Exception {
        this.doBadDataTest(DemographicsChangeType.ADDRESS_CHANGE);
    }    
    public void testBadData2() throws Exception {
        this.doBadDataTest(DemographicsChangeType.PHONE_CHANGE);
    }     
    
    public void testAssociation() throws Exception {
        this.doTest(DemographicsChangeType.GUARDIAN_INFO_CHANGE);
    }    
    
    public void testEmailChange() throws Exception {
        this.doTest(DemographicsChangeType.EMAIL_CHANGE);
    }   
    
    public void testPhoneChange() throws Exception {
        this.doTest(DemographicsChangeType.PHONE_CHANGE);
    }       
    
    
    public void testCalculateEEForExternalSystem() throws Exception {
        Person person = this.buildSimplePerson();
        this.attachVerifiedEnrollment(person);        
        Person incoming = this.getPersonService().save(person);        
        this.getEligibilityEnrollmentService().assessEEImpact(incoming);
        assertNotNull(incoming.getEnrollmentDetermination());
    }

    private void doTest(DemographicsChangeType demographicsChangeType) throws Exception {
        Person person = this.buildSimplePerson();
        person.setDeathRecord(this.createDeathRecord());
        this.attachVerifiedEnrollment(person);        
        Address address = this.createAddress(this.getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getName()));
        
        person.addAddress(address);
        Association association = this.createPersonAssociation("test", "test", AssociationType.CODE_GUARDIAN_CIVIL.getName()); 
        person.addAssociation(association);
        Phone phone = this.createPhone();
        person.addPhone(phone);
        Email email = this.createEmail();
        person.addEmail(email);
        Person incoming = this.getPersonService().save(person);        
        
        
        
        HashSet changes = new HashSet();
        DemographicsChangeEvent demographicsChangeEvent = new  DemographicsChangeEvent( demographicsChangeType);
     
        if (demographicsChangeType.equals(DemographicsChangeType.GUARDIAN_INFO_CHANGE)) {
            demographicsChangeEvent.setEntityKey(EntityKeyFactory.createEntityKey(association.getEntityKey().getKeyValueAsString()));
        }
        else
        if (demographicsChangeType.equals(DemographicsChangeType.ADDRESS_CHANGE)) {
            demographicsChangeEvent.setEntityKey(EntityKeyFactory.createEntityKey(address.getEntityKey().getKeyValueAsString()));
        }
        else
        if (demographicsChangeType.equals(DemographicsChangeType.PHONE_CHANGE)) {
            demographicsChangeEvent.setEntityKey(EntityKeyFactory.createEntityKey(phone.getEntityKey().getKeyValueAsString()));
        }
        else
        if (demographicsChangeType.equals(DemographicsChangeType.EMAIL_CHANGE)) {
            demographicsChangeEvent.setEntityKey(EntityKeyFactory.createEntityKey(email.getEntityKey().getKeyValueAsString()));
        }        
        changes.add(demographicsChangeEvent);
        
        this.getDemographicRuleService().processExternalDemographicChanges(changes, incoming);        
    }
    
    private void doBadDataTest(DemographicsChangeType demographicsChangeType) throws Exception {
        Person person = this.buildSimplePerson();
        this.attachVerifiedEnrollment(person);
        Person incoming = this.getPersonService().save(person);        
        
        HashSet changes = new HashSet();
        DemographicsChangeEvent demographicsChangeEvent = new  DemographicsChangeEvent( demographicsChangeType);
     
        demographicsChangeEvent.setEntityKey(EntityKeyFactory.createEntityKey("BOGUS"));
        changes.add(demographicsChangeEvent);
        
        
        this.getDemographicRuleService().processExternalDemographicChanges(changes, incoming);        
    }    
}
