package gov.va.med.esr.common.rule.service;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import java.util.HashSet;

import gov.va.med.esr.common.builder.msds.MilitaryServiceBuilderForMSDS;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.PeriodOfService;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Activation;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Deployment;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.lookup.MilitaryServiceComponent;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.CombatServiceSource;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.SpecialOperation;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.esr.common.rule.parameter.MilitaryServiceInputParameter;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.esr.jms.vadir.outboundResponse.VadirServiceResponseType;
import gov.va.med.esr.jms.vadir.outboundResponse.VadirServiceResponseWrapper;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryHistory;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.BIRLS;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.VADIR;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryPay;
import gov.va.med.esr.service.ApplicationInProcessService;
import gov.va.med.esr.service.MsdsResponseInfo;
import gov.va.med.esr.service.UnknownLookupCodeException;

/**
 *  Msds focused unit tests
 *  
 *  To get certain tests to work correctly, add the following to your test_components.xml 
 *  	<bean id="anonymousLogonUserAttribute" class="java.lang.String">
 *		<constructor-arg>
 *			<value>MsdsService,ROLE_ANONYMOUS</value>
 *		</constructor-arg>
 *		</bean>	
 *  
 * @author DNS   ruizc
 *
 */
public class MsdsRulesTest extends AbstractMsdsTest {
	private ApplicationInProcessService applicationInProcessService = null;
	public static final String HEC_RECORD_CREATE_AUDIT_ID = "HecRecordProcess"; 	
	public MsdsRulesTest(String arg0) {
		super(arg0);
	}
		
	public void testMseFromBroker() throws Exception {
		MilitaryServiceEpisode mse = new MilitaryServiceEpisode();
		Set<MilitaryServiceEpisode> candidates = new HashSet<MilitaryServiceEpisode>();
		Person person = this.createQmsePerson();
		candidates.add(mse);
		person.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		savePerson(person);
		MilitaryServiceEpisode tmp = (MilitaryServiceEpisode)person.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().iterator().next();
		
		if (candidates.contains(tmp))
			System.out.println("mse contained");
		else
			System.out.println("mse missing");
		/*
		if (mse.getCreatedBy() != null &&
				(mse.getCreatedBy().getName() == null || 
						"MsdsService".equals(mse.getCreatedBy().getName()))) {
			
		}
		*/
	}
	
	public void testUpdateMSEFromUI() throws Exception {
	
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);


		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()), 
				new ImpreciseDate("20001112"), new ImpreciseDate("20091012"));
		
		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class, 
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);	    		

		onFile.getMilitaryService().setCombatVeteranEligibilityEndDate(ImpreciseDateUtils.getDateWithDefault(new ImpreciseDate("20151111")));
		CombatEpisode cee = new CombatEpisode();
		cee.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OEF.getCode()));
		cee.setStartDate(ImpreciseDateUtils.createImpreciseDate(2002,2,1));
		cee.setEndDate(ImpreciseDateUtils.createImpreciseDate(2009,10,1));
		onFile.getMilitaryService().addCombatEpisode(cee);        		

		assertTrue(onFile.isVeteran());
		Person incoming = this.savePerson(onFile);		

		Person result = this.getMilitaryInfoService().updateMilitaryServiceInformation(incoming);

		Date d = result.getMilitaryService().getCombatVeteranEligibilityEndDate();
		System.out.println( "original=" + ImpreciseDateUtils.getDateWithDefault(new ImpreciseDate("20151111")) );	
		System.out.println( "updated=" + d );
		assertNotNull("expected nonnull CV date",d);
	}
	public void testCollection() throws Exception {
		Person onFile = this.buildSimplePerson();
		CombatService cs = new CombatService();
		ImpreciseDate start = new ImpreciseDate("200112");
		ImpreciseDate end = new ImpreciseDate("200312");
		cs.setCombatPayType(this.getLookupService().getCombatPayTypeByCode(
				CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION));
		cs.setCombatServiceSource(this.getLookupService()
				.getCombatServiceSourceByCode(
						CombatServiceSource.CODE_WEBHINQ.getCode()));

		cs.setPayStartDate(start);
		cs.setPayEndDate(end);

		onFile.getMilitaryService().addCombatService(cs);
		onFile.getMilitaryService().removeCombatService(cs);
		assertTrue(onFile.getMilitaryService().getCombatServices().size() == 0);
		
		onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);
		ImpreciseDate id = new ImpreciseDate("20101112");
		Date cv = ImpreciseDateUtils.getDateWithDefault(new ImpreciseDate("20151111"));
		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()), 
				new ImpreciseDate("20001112"), id);
		
		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class, 
						MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		m.addMilitaryServiceEpisode(mse);	    		

		onFile.getMilitaryService().setCombatVeteranEligibilityEndDate(cv);
		CombatEpisode cee = new CombatEpisode();
		cee.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OEF.getCode()));
		cee.setStartDate(ImpreciseDateUtils.createImpreciseDate(2002,2,1));
		cee.setEndDate(ImpreciseDateUtils.createImpreciseDate(2008,11,1));
		onFile.getMilitaryService().addCombatEpisode(cee);        		
		Person incoming = this.savePerson(onFile);	
		m.removeMilitaryServiceEpisode(mse);
		
		assertTrue(m.getMilitaryServiceEpisodes().size() == 0);		
	}
	public void testCollectionEmpty() throws Exception {
		Person onFile = this.buildSimplePerson();
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);
		Person result = this.savePerson(onFile);
		
		assertTrue(result.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().isEmpty());		
	}	
	public void testUpdateMSEFromUIdelete1() throws Exception {
		
		Person onFile = this.buildSimplePerson();
		this.attachVerifiedEnrollment(onFile);
		MilitaryService ms = new MilitaryService();
		onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);


		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()), 
				new ImpreciseDate("20001112"), new ImpreciseDate("20091012"));
		
		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class, 
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);	    		

		onFile.getMilitaryService().setCombatVeteranEligibilityEndDate(ImpreciseDateUtils.getDateWithDefault(new ImpreciseDate("20151111")));
		CombatEpisode cee = new CombatEpisode();
		cee.setConflictLocation(this.getLookupService().getConflictByCode(ConflictLocation.CODE_OEF.getCode()));
		cee.setStartDate(ImpreciseDateUtils.createImpreciseDate(2002,2,1));
		cee.setEndDate(ImpreciseDateUtils.createImpreciseDate(2009,10,1));
		onFile.getMilitaryService().addCombatEpisode(cee);        		

		assertTrue(onFile.isVeteran());
		Person incoming = this.savePerson(onFile);		
		incoming.getMilitaryService().removeAllCombatEpisodes();
		incoming.getMilitaryService().getHECMilitaryServiceSiteRecord().removeAllMilitaryServiceEpisodes();		
		Person result = this.getMilitaryInfoService().updateMilitaryServiceInformation(incoming);

		Date d = result.getMilitaryService().getCombatVeteranEligibilityEndDate();
		System.out.println( "original=" + ImpreciseDateUtils.getDateWithDefault(new ImpreciseDate("20141111")) );	
		System.out.println( "updated=" + d );	
		
	}			
	
	public void testBuilders() throws Exception {
		
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(373971922).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		PeriodOfService periodOfService = this.createBirlsPeriodOfService("WAC", 
				"Z", this.getDate(2003, 1, 8), this.getDate(2004, 1, 8));
		Activation activationV = this.createVadirActivation(this.getDate(2002, 1, 8), this.getDate(2003, 1, 8), "D");
		Deployment deploymentV = this.createVadirDeployment(this.getDate(2002, 1, 8), 
				this.getDate(2003, 1, 8), "D", 
				SpecialOperation.OPERATION_IRAQI_FREEDOM.getCode(), "ZZ");		
		List periodOfServices = new ArrayList();		
		periodOfServices.add(periodOfService);
		birls.setPeriodOfService(periodOfServices);
		birls.setMedalOfHonorInd("Y");
		birls.setPurpleHeartInd("Y");
		mockMilitaryHistory.setBirls(birls);
		ServicePeriod servicePeriod = this.createVadirServicePeriod("WAC", "A", "A", this.getDate(2006, 1, 8), new Date());		
		// Deployments
		List deploymentsV = new ArrayList();
		deploymentsV.add(deploymentV);
		List activationsV = new ArrayList();
		activationsV.add(activationV);
		// Combat Service
		MilitaryPay payV = new MilitaryPay();
		payV.setPayType("01");
		payV.setStartDate(this.getDate(2002, 1, 1));
		payV.setEndDate(this.getDate(2005, 6, 8));
		payV.setCombatServiceLocation("ZZ"); // MSDS_CodeCR10606 disabled
		List pays = new ArrayList();
		pays.add(payV);
		servicePeriod.setActivations(activationsV);
		servicePeriod.setDeployments(deploymentsV);
		servicePeriod.setMilitaryPayments(pays);
		List servicePeriodsV = new ArrayList();
		servicePeriodsV.add(servicePeriod);
		vadir.setServicePeriods(servicePeriodsV);
		vadir.setOefOifIndicator("02"); // OEF
		mockMilitaryHistory.setVadir(vadir);
		wrapper.setResult(mockMilitaryHistory);
		
		///////////////////////////////////////////////
		// Do a build
		///////////////////////////////////////////////
		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS(); 
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(wrapper);
		MilitaryService ms = info.getVadirMilitaryService();
		assertNotNull(ms);
		assertNotNull(ms.getCombatServices());
		assertTrue("expected 1 combat pay",ms.getCombatServices().size() == 1);		
		assertTrue("expected 1 activation", ms.getActivations().size() == 1);
		CombatService cs = (CombatService)ms.getCombatServices().iterator().next();
		assertNotNull("expected combat pay source", cs.getCombatServiceSource());
		assertNotNull("expected combat pay start", cs.getPayStartDate());
		assertNotNull("expected combat pay end", cs.getPayEndDate());		
		
		gov.va.med.esr.common.model.ee.Activation a = 
			(gov.va.med.esr.common.model.ee.Activation)ms.getActivations().iterator().next();
		assertNotNull("expected activation date", a.getActivationBeginDate());
		assertNotNull("expected activation date", a.getActivationEndDate());
		assertNotNull("expected activation source", a.getDataSource());		
		assertNull("expected null activation spec op", a.getSpecialOperation());
		assertNotNull("expected activation term reason ", a.getTerminationReason());		
		assertTrue("expected 1 deployment", a.getDeployments().size() == 1);		
		gov.va.med.esr.common.model.ee.Deployment d = 
			(gov.va.med.esr.common.model.ee.Deployment)a.getDeployments().iterator().next();
		assertNotNull("expected a deployment", d);
		assertNotNull("expected a deployment date", d.getDeploymentBeginDate());
		assertNotNull("expected a deployment date", d.getDeploymentEndDate());		
		assertNotNull("expected a deployment spec op", d.getSpecialOperation());
		assertNotNull("expected a deployment term reason", d.getTerminationReason());		
		
		/////////////////////////////////////////////////////////////
		// Feed the build info to Process Person MSDS Data use case
		////////////////////////////////////////////////////////////
		
		Person result = this.getMilitaryInfoService().processMSDSData(info);		
		System.out.println( "done");		
	//	this.setComplete();
		
		
	}	
	public void testEs() throws Exception {
		Person onFile = buildSimplePerson(); // bare-bones person		
		this.getPersonHelperService().setVerificationSource("MSDS", onFile);

	}	
	public void createPerson() throws Exception {
		Person onFile = buildSimplePerson(); // bare-bones person
		this.attachApplication(onFile);
		onFile.getApplication().setApplicationDate(getDate(2006,1,1));
		this.attachVerifiedEnrollment(onFile);
		Person incoming = savePerson(onFile);
		this.setComplete();
		System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
	}
	public void createNonVeteran() throws Exception {
		Person onFile = this.buildSimpleNonVeteran(); // bare-bones person
		this.setEligibilityStatusToPendingVerification(onFile);
		this.attachVerifiedEnrollment(onFile);
		onFile.getEnrollmentDetermination().setEnrollmentStatus(
				this.getLookupService().getEnrollmentStatusByCode(
						EnrollmentStatus.CODE_NOT_APPLICABLE.getCode()));
		onFile.getEnrollmentDetermination().setPriorityGroup(null);
		onFile.getEnrollmentDetermination().setPrioritySubGroup(null);
		Person incoming = savePerson(onFile);
		this.setComplete();
		System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
	}	
	public void testProcessZ07ForNonVet() throws Exception {
		Person onFile = this.buildSimpleNonVeteran();
		Person incoming = this.savePerson(onFile);

		this.addPermanentAddress(incoming, Calendar.getInstance().getTime(),
				null);
		VerificationInfo vi = new VerificationInfo("x",
				MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode());
		
		vi.setSiteNumber(VAFacility.CODE_ALBUQUERQUE.getCode());
		Person updated = this.getMessagingService().processZ07(incoming,
				this.getRandomVAFacility(), vi);
		System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());      		
	}
	public void testProcessZ07() throws Exception {
		Person onFile = this.buildSimplePerson();
		Person incoming = this.savePerson(onFile);

		this.addPermanentAddress(incoming, Calendar.getInstance().getTime(),
				null);
		VerificationInfo vi = new VerificationInfo("x",
				MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode());
		
		vi.setSiteNumber(VAFacility.CODE_ALBUQUERQUE.getCode());
		Person updated = this.getMessagingService().processZ07(incoming,
				this.getRandomVAFacility(), vi);
		System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());      		
	}	
	//375296745 375297113 373971922
	public void testMimimalDataUpdate() throws Exception {
		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS(); 
		MsdsResponseInfo info = (MsdsResponseInfo)msdsBuilder.build(this.createMinimalWrapperGo2(373971922, 20));
		
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertNotNull(result);
		//this.setComplete();
	}
	public void testUpdateMSEFromMsg() throws Exception {
		// 8195  375296745 375297113
		//Person onFile = this.getPerson("375296745");
		//Person onFile = this.buildSimplePerson();
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("373971922"));        
		Person onFile = this.getPersonService().getPerson(personKey);			

		MilitaryService ms = onFile.getMilitaryService();
		//onFile.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_ALBUQUERQUE.getName()));
		onFile.getMilitaryService().addMilitaryServiceSiteRecord(m);
		ImpreciseDate id = new ImpreciseDate("20101112");
//		Date cv = ImpreciseDateUtils.getDateWithDefault(new ImpreciseDate("20151111"));
		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()), 
				new ImpreciseDate("20001112"), id);
		
		mse.setMilitaryServiceComponent(
				(MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class, 
						MilitaryServiceComponent.CODE_REGULAR.getCode()));
		m.addMilitaryServiceEpisode(mse);	    		


		Person incoming = this.savePerson(onFile);
		this.setComplete();
		
	}
	

	/*
	 * Criteria 1
	 * 
	 * Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = Yes
	 * 
	 * Length of Service for any HEC MSE = >than or = 24 continuous months
	 * 
	 * Component = Regular
	 * 
	 * Character of Service = Honorable (Hon)/Under Honorable Conditions
	 * (UHC)/General (GEN)
	 */
	public void testCriteria1MilParameter() throws Exception {
		MilitaryServiceInputParameter militaryServiceInput = buildMilitaryServiceInputParameter();
		
		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode()), 
				new ImpreciseDate("20001112"), new ImpreciseDate("20021112"));

		
		// Checks a specific MSE
		assertTrue("expected TRUE the specific MSE isMilitaryServiceEpisodeEQorGT24Months", 
				militaryServiceInput.isMilitaryServiceEpisodeEQorGT24Months(mse));
	}

	/*
	 * Criteria 2
	 * 
	 * Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = Yes
	 * 
	 * Length of Service for any HEC MSE = >than or = 24 continuous months
	 * 
	 * Component = NULL
	 * 
	 * Character of Service = Honorable (Hon)/Under Honorable Conditions
	 * (UHC)/General (GEN)
	 */
	public void testCriteria2MilParameter() throws Exception {
		// Covered by #1
		testCriteria1MilParameter();
	}	
	
	/*
	 * Criteria 3 Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = Yes
	 * 
	 * Length of Service for any HEC MSE = > than or = 24 continuous months in 1
	 * MSE or continuous MSE (non-breaking)
	 * 
	 * Component = Activated Reserve/Activated National Guard
	 * 
	 * Character of Service = Honorable(Hon)/Under Honoragle
	 * Conditions(UHC)/General (GEN)/Honorable-VA (HVA)
	 * 
	 * Note: If no service episode exceeds 24 months but multiples are used then
	 * use Character of Service for last episode
	 */
	public void testCriteria3MilParameter() throws Exception {
		MilitaryServiceInputParameter militaryServiceInput = buildMilitaryServiceInputParameter();
			Person onFile = militaryServiceInput.getResultPerson();
		Person incoming = militaryServiceInput.getIncomingPerson();
		Person pristine = militaryServiceInput.getPristinePerson();
		
		Date beginDate=ImpreciseDateUtils.getDateWithDefault(ImpreciseDateUtils.createImpreciseDate(2001,1,1));
		Date endDate=ImpreciseDateUtils.getDateWithDefault(ImpreciseDateUtils.createImpreciseDate(2005,1,1));
		
		
		MilitaryServiceEpisode anMse = this.createMilitaryServiceEpisode( 
				getDate(1946,1,2), 
				getDate(1947,1,2));
		anMse.setDischargeType(this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_HONORABLE_VA.getCode()));        
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(anMse);
		
		MilitaryServiceEpisode bnMse = this.createMilitaryServiceEpisode(
				getDate(1947,1,3),
				getDate(1948,2,1));
		bnMse.setDischargeType(this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_HONORABLE.getCode()));        
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(bnMse); 
 
		assertTrue("expected TRUE isCharacterOfDischargeOfLastNonbreakServiceEpisodeEqual", 
				militaryServiceInput.isCharacterOfDischargeOfLastNonbreakServiceEpisodeEqual(DischargeType.CODE_HONORABLE.getCode()));/*String code*/
		assertTrue("expected TRUE hasMultNonbreakServiceEpisodeEQorGT24ContinuousMonths", 
				militaryServiceInput.hasMultNonbreakServiceEpisodeEQorGT24ContinuousMonths());
		assertTrue("expected TRUE isCharacterOfDischargeOfFirstNonbreakServiceEpisodeEqual", 
				militaryServiceInput.isCharacterOfDischargeOfFirstNonbreakServiceEpisodeEqual(DischargeType.CODE_HONORABLE_VA.getCode()));/*String code*/
		assertTrue("expected TRUE hasMultNonbreakServiceEpisode", 
				militaryServiceInput.hasMultNonbreakServiceEpisode());
		assertFalse("expected FALSE hasSingleServiceEpisodeEQorGT24ContinuousMonths", 
				militaryServiceInput.hasSingleServiceEpisodeEQorGT24ContinuousMonths());		
		
		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				getDate(1947,1,3),
				getDate(1950,2,1));
		mse.setDischargeType(this.getLookupService().getDischargeTypeByCode(DischargeType.CODE_HONORABLE.getCode()));
		assertTrue("expected TRUE isMilitaryServiceEpisodeEQorGT24Months", 
				militaryServiceInput.isMilitaryServiceEpisodeEQorGT24Months(mse));
		assertFalse("expected FALSE isMilitaryServiceEpisodeEQorGT24Months", 
				militaryServiceInput.isMilitaryServiceEpisodeEQorGT24Months(null));

		
		// Length of Service for any HEC MSE = > than or = 24 continuous months in 1
		// MSE or continuous MSE (non-breaking)		
		Set mses = onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes();
		assertTrue("expected TRUE isAnyMilitaryServiceEpisodeEQorGT24Months", 
				militaryServiceInput.isAnyMilitaryServiceEpisodeEQorGT24Months(mses));
		assertTrue("expected TRUE isCharacterOfDischargeOfLastNonbreakServiceEpisodeEqual", 
				militaryServiceInput.isCharacterOfDischargeOfLastNonbreakServiceEpisodeEqual(DischargeType.CODE_HONORABLE.getCode(), mses));				
	}

	/*
	 * Criteria 4
	 * 
	 * Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = Yes
	 * 
	 * Length of Service for any HEC MSE = <than 24 continous months
	 * 
	 * Component = Activated Reserve/Activated National Guard
	 * 
	 * Character of Service = Honorable(Hon)/Honorable-VA (HVA)
	 */
	public void testCriteria4MilParameter() throws Exception {
		MilitaryServiceInputParameter militaryServiceInput = buildMilitaryServiceInputParameter();
		
		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				getDate(1947,1,3),
				getDate(1947,11,1));
		// Checks a specific MSE
		assertFalse("expected FALSE the specific MSE isMilitaryServiceEpisodeEQorGT24Months", 
				militaryServiceInput.isMilitaryServiceEpisodeEQorGT24Months(mse));
		// The ILOG rule uses this though:
		Set<MilitaryServiceEpisode> mses = new HashSet<MilitaryServiceEpisode>();
		mses.add(mse);
		assertFalse("expected FALSE isAnyMilitaryServiceEpisodeEQorGT24Months", 
				militaryServiceInput.isAnyMilitaryServiceEpisodeEQorGT24Months(mses));		
	}	


	/*
	 * Criteria 5
	 * 
	 * Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = No
	 * 
	 * Length of Service for any HEC MSE = any (1 day of service or more)
	 * 
	 * Component = Regular
	 * 
	 * Character of Service = Honorable(Hon)/Under Honoragle
	 * Conditions(UHC)/General (GEN)
	 */
	public void testCriteria5MilParameter() throws Exception {
		MilitaryServiceInputParameter militaryServiceInput = buildMilitaryServiceInputParameter();
		
		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				getDate(1947,1,3),
				getDate(1947,1,3));
		// Checks a specific MSE
		assertTrue("expected TRUE the specific MSE isPeriodOfServiceAtLeastOneDay", 
				militaryServiceInput.isPeriodOfServiceAtLeastOneDay(mse));
		mse.setEndDate(ImpreciseDateUtils.createImpreciseDate(1946,1,3));
		assertFalse("expected FALSE the specific MSE isPeriodOfServiceAtLeastOneDay", 
				militaryServiceInput.isPeriodOfServiceAtLeastOneDay(mse));
		mse.setEndDate(ImpreciseDateUtils.createImpreciseDate(1949,1,3));
		assertTrue("expected TRUE the specific MSE isPeriodOfServiceAtLeastOneDay", 
				militaryServiceInput.isPeriodOfServiceAtLeastOneDay(mse));
		mse.setEndDate(null);
		mse.setStartDate(null);		
		assertFalse("expected FALSE the specific MSE isPeriodOfServiceAtLeastOneDay", 
				militaryServiceInput.isPeriodOfServiceAtLeastOneDay(mse));		
	}	


	/*
	 * Criteria 6
	 * 
	 * Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = No
	 * 
	 * Length of Service for any HEC MSE = > than or = 24 continous months
	 * 
	 * Component = Activated Reserve/Activated National Guard
	 * 
	 * Character of Service = Honorable(Hon)/Under Honoragle
	 * Conditions(UHC)/General (GEN)/Honorable-VA (HVA))
	 */	
	public void testCriteria6MilParameter() throws Exception {
		
		// Length of Service Covered by #1
		testCriteria1MilParameter();		
	}	

	public void testFilteredMseSet() throws Exception {
		MilitaryServiceInputParameter militaryServiceInput = buildMilitaryServiceInputParameter();
		
		MilitaryServiceEpisode mse = this.createMilitaryServiceEpisode(
				getDate(1947,1,3),
				getDate(1947,11,1));

		militaryServiceInput.addFilteredMse(mse);
		assertTrue("expected count to be one", militaryServiceInput.getFilteredMseSet().size() == 1);
		militaryServiceInput.removeAllFilteredMse();
		assertTrue("expected count to be zero", militaryServiceInput.getFilteredMseSet().size() == 0);
		militaryServiceInput.addFilteredMse(null);
		assertTrue("expected count to be zero", militaryServiceInput.getFilteredMseSet().size() == 0);		
	}

	
	/*
	 * Criteria 5
	 * 
	 * Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = No
	 * 
	 * Length of Service for any HEC MSE = any (1 day of service or more)
	 * 
	 * Component = Regular
	 * 
	 * Character of Service = Honorable(Hon)/Under Honoragle
	 * Conditions(UHC)/General (GEN)
	 */	  
	public void testMsdsRuleServiceCriteria5() throws Exception {
		Person onFile = createQmsePerson();
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
							getDate(1947,1,3),	getDate(1947,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = createMinimalMsdsResponseInfo();
		this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		assertFalse(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}
	
	public void test11652RuleLayer() throws Exception {
		Person onFile = createQmsePerson();
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = createMsdsResponseInfoWithData(true);
		this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		assertFalse(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}

	public void test11652BusinessLayer() throws Exception {
		Person onFile = createQmsePerson();
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = createMsdsResponseInfoWithData(true);
		info.setPersonEntityKey(onFile.getPersonEntityKey());
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}
	public void test11652BusinessLayerWithOneMseCriteria1() throws Exception {
		Person onFile = createQmsePerson();
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = createMsdsResponseInfoWithData(false);
		info.setPersonEntityKey(onFile.getPersonEntityKey());
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}	
	public void test11664BusinessLayerC6() throws Exception {
		Person onFile = createQmsePerson();
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = createMsdsResponseInfoWithDataC6();
		info.setPersonEntityKey(onFile.getPersonEntityKey());
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertFalse(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}

	
	
	public void test11653BusinessLayer() throws Exception {
		Person onFile = createQmsePerson();
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = build11653Info(onFile);
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		assertFalse(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}
	
	public void test11653BusinessLayerQmseAsUpgrade() throws Exception {
		Person onFile = createQmsePerson();
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_PENDING.getName()));			
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = build11653Info(onFile);
		Person result = this.getMilitaryInfoService().processMSDSData(info);
		// Should remain since VBA query status is pending...
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}
	
	private MsdsResponseInfo build11653Info(Person person) throws Exception {
		/*
		  <VADIR>
		          <vaId>1013385382</vaId>
		          <OefOifIndicator>04</OefOifIndicator>
		          <RetirementStatusIndicator>N</RetirementStatusIndicator>
		          <ServicePeriods>
		            <StartDate>1960-06-27</StartDate>
		            <EndDate>1982-10-31</EndDate>
		            <BranchOfService>F</BranchOfService>
		            <PersonnelCategory>A</PersonnelCategory>
		            <CharacterOfService>A</CharacterOfService>
		          </ServicePeriods>
		          <ServicePeriods>
		            <StartDate>1982-11-01</StartDate>
		            <BranchOfService>F</BranchOfService>
		            <PersonnelCategory>R</PersonnelCategory>
		          </ServicePeriods>
		        </VADIR>
		        <BIRLS>
		          <VADSInd>Y</VADSInd>
		          <RecurServiceNumber>11372124</RecurServiceNumber>
		          <VerifiedSvcDataInd>Y</VerifiedSvcDataInd>
		          <PeriodOfService>
		            <EnteredOnDutyDate>1960-06-27</EnteredOnDutyDate>
		            <ReleasedActiveDutyDate>1982-10-31</ReleasedActiveDutyDate>
		            <BranchOfService>AF</BranchOfService>
		            <SeparationReason>SAT</SeparationReason>
		            <CharacterOfService>HON</CharacterOfService>
		          </PeriodOfService>
		        </BIRLS>
    	 */
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setPersonId(new Long(person.getPersonEntityKey().getKeyValueAsString()).longValue());
		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
		PeriodOfService periodOfService = this.createBirlsPeriodOfService(
				"AF", 
				"HON", 
				this.getDate(1960, 5, 27), 
				this.getDate(1982, 9, 31));
		List<PeriodOfService> periodOfServices = new ArrayList<PeriodOfService>();		
		periodOfServices.add(periodOfService);
		birls.setPeriodOfService(periodOfServices);
		mockMilitaryHistory.setBirls(birls);

		ServicePeriod servicePeriod1 = this.createVadirServicePeriod(
				"F", 
				"A", 
				"A", this.getDate(1960, 5, 27), this.getDate(1982, 9, 31));		
		ServicePeriod servicePeriod2 = this.createVadirServicePeriod(
				"F", 
				"A", 
				"R", this.getDate(1982, 10, 1), null);		
		List<ServicePeriod> servicePeriodsV = new ArrayList<ServicePeriod>();
		servicePeriodsV.add(servicePeriod1);
		servicePeriodsV.add(servicePeriod2);		
		vadir.setServicePeriods(servicePeriodsV);
		
		mockMilitaryHistory.setVadir(vadir);
		wrapper.setResult(mockMilitaryHistory);
		MilitaryServiceBuilderForMSDS msdsBuilder = this.getMilitaryServiceBuilderForMSDS(); 
		return (MsdsResponseInfo)msdsBuilder.build(wrapper);
	}	
	
	
	private Set createTestData() throws Exception {
		/*
		Army
		7/1/1999
		11/17/1999
		Activated Reserve
		Honorable
		Army
		2/3/2000
		2/3/2004
		Regular
		Honorable
		Army
		1/4/2006
		5/3/2007
		Activated NG
		Honorable
		Army
		10/1/2007
		1/23/2009
		Activated NG
		Honorable
		Army
		5/15/2009
		10/1/2009
		Activated NG
		Honorable
				 */
		//new ImpreciseDate("20151111")
		Set<MilitaryServiceEpisode> data = new HashSet<MilitaryServiceEpisode>();
		ServiceBranch branch = this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode());
		MilitaryServiceEpisode mse1 = createMilitaryServiceEpisode(branch,
				new ImpreciseDate("19990601"),
				new ImpreciseDate("19991017"));

		mse1.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_RESERVE.getCode()));
		data.add(mse1);
		
		MilitaryServiceEpisode mse2 = createMilitaryServiceEpisode(branch,
				new ImpreciseDate("20000203"),
				new ImpreciseDate("20040103"));
		mse2.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		data.add(mse2);		
		
		MilitaryServiceEpisode mse3 = createMilitaryServiceEpisode(branch,
				new ImpreciseDate("20060104"),
				new ImpreciseDate("20070503"));
		mse3.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		data.add(mse3);		
		
		MilitaryServiceEpisode mse4 = createMilitaryServiceEpisode(branch,
				new ImpreciseDate("20070901"),
				new ImpreciseDate("20090123"));
		mse4.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		data.add(mse4);		
		MilitaryServiceEpisode mse5 = createMilitaryServiceEpisode(branch,
				new ImpreciseDate("20090415"),
				new ImpreciseDate("20090901"));
		mse5.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));		
		data.add(mse5);		
		return data;
	}
	private Set createTestDataWithOneMse() throws Exception {
		/*
		Army
		2/3/2000
		2/3/2004
		Regular
		Honorable
				 */

		Set<MilitaryServiceEpisode> data = new HashSet<MilitaryServiceEpisode>();
		ServiceBranch branch = this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_ARMY.getCode());		
		MilitaryServiceEpisode mse2 = createMilitaryServiceEpisode(branch,
				new ImpreciseDate("20000203"),
				new ImpreciseDate("20040103"));
		mse2.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		data.add(mse2);		
		
		return data;
	}
	
	/*
	 * Criteria 1
	 * 
	 * Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = Yes
	 * 
	 * Length of Service for any HEC MSE = >than or = 24 continuous months
	 * 
	 * Component = Regular
	 * 
	 * Character of Service = Honorable (Hon)/Under Honorable Conditions
	 * (UHC)/General (GEN)
	 */	
	public void testMsdsRuleServiceCriteria1() throws Exception {
		/*
       <VADIR>
          <vaId>1119327837</vaId>
          <OefOifIndicator>04</OefOifIndicator>
          <RetirementStatusIndicator>N</RetirementStatusIndicator>
          <ServicePeriods>
            <StartDate>1998-11-05</StartDate>
            <EndDate>2001-07-03</EndDate>
            <BranchOfService>A</BranchOfService>
            <PersonnelCategory>A</PersonnelCategory>
            <CharacterOfService>B</CharacterOfService>
          </ServicePeriods>
        </VADIR>
		 */
		Person onFile = createQmsePerson();
		Person incoming = savePerson(onFile);
		MsdsResponseInfo info = new MsdsResponseInfo();		
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1998,10,53),
				getDate(2001,6,3));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		mse.setDischargeType(this.getLookupService().getDischargeTypeByCode(
				DischargeType.CODE_GENERAL.getCode()));
		
		MilitaryService msVadir = this.createMilitaryServiceWithHecSite();
		MilitaryService msBirls = this.createMilitaryServiceWithHecSite();
		msVadir.getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		info.setVadirMilitaryService(msVadir);
		info.setBirlsMilitaryService(msBirls);
		
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		assertFalse(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));				
	}
	private MilitaryService createMilitaryServiceWithHecSite() throws Exception {
		MilitaryService ms = new MilitaryService();
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		ms.addMilitaryServiceSiteRecord(m);
		return ms;
	}
	/*
	 * Criteria 2
	 * 
	 * Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = Yes
	 * 
	 * Length of Service for any HEC MSE = >than or = 24 continuous months
	 * 
	 * Component = NULL
	 * 
	 * Character of Service = Honorable (Hon)/Under Honorable Conditions
	 * (UHC)/General (GEN)
	 */	
	public void testMsdsRuleServiceCriteria2() throws Exception {
		Person onFile = createQmsePerson();
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1981,1,3),
				getDate(1983,11,1));
		mse.setMilitaryServiceComponent(null);
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = createMinimalMsdsResponseInfo();
		this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		assertFalse(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}		
	/*
	 * Criteria 3 Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = Yes
	 * 
	 * Length of Service for any HEC MSE = > than or = 24 continuous months in 1
	 * MSE or continuous MSE (non-breaking)
	 * 
	 * Component = Activated Reserve/Activated National Guard
	 * 
	 * Character of Service = Honorable(Hon)/Under Honoragle
	 * Conditions(UHC)/General (GEN)/Honorable-VA (HVA)
	 * 
	 * Note: If no service episode exceeds 24 months but multiples are used then
	 * use Character of Service for last episode
	 */	
	public void testMsdsRuleServiceCriteria3() throws Exception {
		Person onFile = createQmsePerson();

		MilitaryServiceEpisode mse1 = createMilitaryServiceEpisode(	getDate(1980,2,28),
				getDate(1981,11,1));
		
		mse1.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		MilitaryServiceEpisode mse2 = createMilitaryServiceEpisode(getDate(1981,11,2),
				getDate(1982,3,1));
		
		mse2.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));		
		
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse1);
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse2);		
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = createMinimalMsdsResponseInfo();
		this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		assertFalse(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}	
	/*
	 * Criteria 4
	 * 
	 * Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = Yes
	 * 
	 * Length of Service for any HEC MSE = <than 24 continous months
	 * 
	 * Component = Activated Reserve/Activated National Guard
	 * 
	 * Character of Service = Honorable(Hon)/Honorable-VA (HVA)
	 */	
	public void testMsdsRuleServiceCriteria4() throws Exception {
		Person onFile = createQmsePerson();
		MilitaryServiceEpisode mse1 = createMilitaryServiceEpisode(getDate(1981,2,28),
				getDate(1981,11,1));
		
		mse1.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		MilitaryServiceEpisode mse2 = createMilitaryServiceEpisode(getDate(1981,11,2),
				getDate(1982,3,1));
		
		mse2.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));		
		
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse1);
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse2);		
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = createMinimalMsdsResponseInfo();
		this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		assertFalse(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}
	
	/*
	 * Criteria 6
	 * 
	 * Branch of Service = Army, Navy, Air Force, Marine, Coast Guard
	 * 
	 * Entered Service after 9/07/1980 = No
	 * 
	 * Length of Service for any HEC MSE = > than or = 24 continous months
	 * 
	 * Component = Activated Reserve/Activated National Guard
	 * 
	 * Character of Service = Honorable(Hon)/Under Honoragle
	 * Conditions(UHC)/General (GEN)/Honorable-VA (HVA))
	 */		
	public void testMsdsRuleServiceCriteria6() throws Exception {
		Person onFile = createQmsePerson();
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));		
		MsdsResponseInfo info = createMinimalMsdsResponseInfo();
		this.getMilitaryRuleService().processMSDSData(incoming, onFile, info);
		assertFalse(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(onFile.getEligibilityVerification().getEligibilityStatus().getCode()));
		System.out.println("verification record ="+onFile.getEligibilityVerification());		
		//this.setComplete();
	}
	
	public void testVbaCheck() throws Exception {
		Person onFile = createQmsePerson();
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		VerificationInfo info = new VerificationInfo("01",
				MessageType.CODE_ORFZ11_TO_ESR.getCode(), "x");		
		boolean flag = this.getMilitaryRuleService().hasQualifyingMse(onFile, info);
		assertTrue("expected true for qmse", flag);
		String date =info.getMsdsMessageDate().getStandardFormat();
		System.out.println("info="+date);				
		
		info.setSiteNumber(VAFacility.CODE_ALBUQUERQUE.getCode());		
		info.setHasQualifyingMse(flag);
		this.getProcessVBARuleService().verifyEligibility(incoming, onFile, info);
	}
	public void testVbaResponseCrit6() throws Exception {
		Person onFile = createQmsePerson();
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		VerificationInfo vi = new VerificationInfo("0L","ORFZ11-E", "No Data on File");			
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_NO_DATA.getCode()));
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		//this.setComplete();
		System.out.println("verification record ="+result.getEligibilityVerification());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}	
	/*
	 * SUC103.11.17 - [4027] Scenario 6 - ESR receives VBA Data in which Total
	 * Check Amount > $0, Entitlement Code = NULL, and no Rated Disabilities
	 */
	protected VerificationInfo getScenario6Info() {
		return new VerificationInfo(null,"ORFZ11-E", "");			
	}
	/*
	 * SUC103.11.5 - [4010] Scenario 2 - ESR receives VBA Data in which the
	 * Entitlement Code is NOT 01, 0L, or NULL
	 */
	protected VerificationInfo getScenario2Info() {
		return new VerificationInfo("0","ORFZ11-E", "");
	}
	protected VerificationInfo getScenario3Info() {
		return new VerificationInfo("01","ORFZ11-E", "");	
	}
	/*
	 * SUC103.11.11 - [4020] Scenario 4 - ESR receives VBA Data with Entitlement
	 * Code is 0L, 01, or NULL and one or more invalid Disability Codes
	 */
	protected VerificationInfo getScenario4Info(Person incoming) throws Exception {
		return this.makeMockVerifiationInfoWithException(incoming, "01", 
				"ORFZ11-E", new Integer(0));
	}
	protected void setVbaQueryStatusNoData(Person person) throws Exception {
		if (person.getEligibilityVerification() == null) this.fail("need to set EligibilityVerification");
		person.getEligibilityVerification().setAacIndicator(this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_NO_DATA.getCode()));		
	}
	protected void setVbaQueryStatusDataAccepted(Person person) throws Exception {
		if (person.getEligibilityVerification() == null) this.fail("need to set EligibilityVerification");
		person.getEligibilityVerification().setAacIndicator(this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_DATA_ACCEPTED.getCode()));		
	}	
	public void testVbaResponseCrit6SC0noncomp() throws Exception {
		Person onFile = createQmsePerson();
		this.attachServiceConnectionAward(onFile, new Integer(0));

		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		VerificationInfo vi = new VerificationInfo("0L","ORFZ11-E", "No Data on File");			
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_NO_DATA.getCode()));
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		//this.setComplete();
		System.out.println("verification record ="+result.getEligibilityVerification());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}
	protected void confirmVerifiedStatus(Person person) {
		assertNotNull("expected not null elig verification", person.getEligibilityVerification());
		assertNotNull("expected not null elig status", person.getEligibilityVerification().getEligibilityStatus());
		assertTrue("expected Verified status",EligibilityStatus.CODE_VERIFIED.getCode().equals(person.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}
	public void testVbaResponseCrit6SC0noncompDataFound() throws Exception {
		Person onFile = createQmsePerson();
		this.attachServiceConnectionAward(onFile, new Integer(0));
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		// NOTICE CHANGED entitlement code to 2L
		VerificationInfo vi = new VerificationInfo("2L","ORFZ11-E", "");			
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_DATA_ACCEPTED.getCode()));
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		//this.setComplete();
		
		System.out.println("verification record ="+result.getEligibilityVerification());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
	}
	/**
	 * SUC103.11.5 - [4010] Scenario 2 - ESR receives VBA Data in which the
	 * Entitlement Code is NOT 01, 0L, or NULL
	 */
	public void testVbaResponseCrit6Scenario2() throws Exception {
		/*
(+) activate rule : isNoDataOnFile
(-) deactivate rule : isNoDataOnFile
(+) activate rule : isEntitlementCodeInvalid
(+) add rule instance : isEntitlementCodeInvalid@fbccad
(->) fire rule instance : isEntitlementCodeInvalid@fbccad
(-) deactivate rule : isEntitlementCodeInvalid
(+) activate rule : _011_isVerifiedSiteNSC
(+) add rule instance : _011_isVerifiedSiteNSC@dc700d
(->) fire rule instance : _011_isVerifiedSiteNSC@dc700d
(-) deactivate rule : _011_isVerifiedSiteNSC
(+) activate rule : _012_isVerifiedSiteNoncompensable
(+) add rule instance : _012_isVerifiedSiteNoncompensable@1754b26 
(->) fire rule instance : _012_isVerifiedSiteNoncompensable@1754b26
(-) deactivate rule : _012_isVerifiedSiteNoncompensable
(+) activate rule : _012_isPendingSiteAapWithQmse
(+) add rule instance : _012_isPendingSiteAapWithQmse@198dab2 
(->) fire rule instance : _012_isPendingSiteAapWithQmse@198dab2
(-) deactivate rule : _012_isPendingSiteAapWithQmse
(+) activate rule : updatePeriodOfService
		 */		
		Person onFile = createQmsePerson();
		//this.attachServiceConnectionAward(onFile, new Integer(0));
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		// NOTICE CHANGED entitlement code to 0
		VerificationInfo vi = new VerificationInfo("0","ORFZ11-E", "");			
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_DATA_ACCEPTED.getCode()));
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
		//this.setComplete();
		System.out.println("verification record ="+result.getEligibilityVerification());
	}	
	/*
	 * SUC103.11.8 - [4015] Scenario 3 - ESR receives VBA Data in which the
	 * Entitlement Code is "01" but there are no VBA Rated Disabilities present
	 */
	public void testVbaResponseCrit6Scenario3() throws Exception {
		/*
(+) add rule instance : isEntitlementCode01@1c2f62b
(->) fire rule instance : isEntitlementCode01@1c2f62b
(-) deactivate rule : isEntitlementCode01
(+) activate rule : _112_isVerifiedSiteNSC
(+) add rule instance : _112_isVerifiedSiteNSC@19670c4
(->) fire rule instance : _112_isVerifiedSiteNSC@19670c4
(-) deactivate rule : _112_isVerifiedSiteNSC
(+) activate rule : _016_isVerifiedSiteNoncompensable
(+) add rule instance : _016_isVerifiedSiteNoncompensable@f3e2f5
(->) fire rule instance : _016_isVerifiedSiteNoncompensable@f3e2f5
(-) deactivate rule : _016_isVerifiedSiteNoncompensable
(+) activate rule : _016_3_3_3isPendingWithQmse
(+) add rule instance : _016_3_3_3isPendingWithQmse@1b95cf5
(->) fire rule instance : _016_3_3_3isPendingWithQmse@1b95cf5
(-) deactivate rule : _016_3_3_3isPendingWithQmse

		 */		
		Person onFile = createQmsePerson();
		this.attachServiceConnectionAward(onFile, new Integer(0));
		
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		incoming.getServiceConnectionAward().removeAllRatedDisability();
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		// NOTICE CHANGED entitlement code to 01
		VerificationInfo vi = new VerificationInfo("01","ORFZ11-E", "");			
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_DATA_ACCEPTED.getCode()));
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
		System.out.println("verification record ="+result.getEligibilityVerification());
	}
	/**
	 * SUC103.11.11 - [4020] Scenario 4 - ESR receives VBA Data with Entitlement
	 * Code is 0L, 01, or NULL and one or more invalid Disability Codes
	 * 
	 */
	public void testVbaResponseCrit6Scenario4() throws Exception {
		/*
(+) activate rule : _021_4_3_3isPendingAapWithQmseSC0Noncomp
(+) add rule instance : _021_4_3_3isPendingAapWithQmseSC0Noncomp@1eae7d9 
(->) fire rule instance : _021_4_3_3isPendingAapWithQmseSC0Noncomp@1eae7d9
(-) deactivate rule : _021_4_3_3isPendingAapWithQmseSC0Noncomp
		 */		
		Person onFile = createQmsePerson();
		this.attachServiceConnectionAward(onFile, new Integer(0));
		
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);

		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		// NOTICE CHANGED entitlement code to 01
		VerificationInfo vi = this.makeMockVerifiationInfoWithException(incoming, "01", "ORFZ11-E", new Integer(0));//new VerificationInfo("01","ORFZ11-E", "");			
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_DATA_ACCEPTED.getCode()));

		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());
		System.out.println("verification info ="+vi.getMsdsMessageDate());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));	
		//this.setComplete();
	}
	/**
	 * SUC103.11.11 - [4020] Scenario 4 - ESR receives VBA Data with Entitlement
	 * Code is 0L, 01, or NULL and one or more invalid Disability Codes
	 * 
	 */
	public void testVbaC6S4VerifiedAap() throws Exception {
		/*
((->) fire rule instance : _021_4_2_1isVerifiedAapNSC
		 */		

		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375124624"));        
		Person onFile = this.getPersonService().getPerson(personKey);				

		Person incoming = savePerson(onFile);
		incoming.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_DATA_ACCEPTED.getCode()));
		
		this.attachServiceConnectionAward(incoming, new Integer(0));
		
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		// NOTICE CHANGED entitlement code to 01
		VerificationInfo vi = this.makeMockVerifiationInfoWithException(incoming, "01", "ORFZ11-E", new Integer(0));//new VerificationInfo("01","ORFZ11-E", "");			

		boolean flag = this.getMilitaryRuleService().hasQualifyingMse(onFile, vi);	
		assertFalse(flag);
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());
		System.out.println("verification info ="+vi.getMsdsMessageDate());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));	
	}
	
	/*
	 * If the most recent verified HEC (Add a Person) record shows no SC
	 * conditions, Total Check Amount is $0 or NULL and VA Pension is No or NULL
	 * then
	 * SUC103.11.5 - [4010] Scenario 2 - ESR receives VBA Data in which the
	 * Entitlement Code is NOT 01, 0L, or NULL
	 */
	public void test4011_2_1_1isVerifiedAapNSC() throws Exception {
		/*
(+) activate rule : _011_2_1_1isVerifiedAapNSC
(+) add rule instance : _011_2_1_1isVerifiedAapNSC
(->) fire rule instance : _011_2_1_1isVerifiedAapNSC
(-) deactivate rule : _011_2_1_1isVerifiedAapNSC
		 */
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375124624"));        
		Person onFile = this.getPersonService().getPerson(personKey);				
		Person incoming = savePerson(onFile);
		this.setVbaQueryStatusDataAccepted(incoming);
		this.attachServiceConnectionAward(incoming, new Integer(0));
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));

		VerificationInfo vi = this.getScenario2Info();			
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());
		System.out.println("verification info ="+vi.getMsdsMessageDate());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));			
	}
	
	/*
	 * If the most recent verified HEC (Add a Person) records shows SC rated
	 * conditions AND Combined SC % = 0% and Total Check Amount is $0 or NULL
	 * and VA Pension = No or NULL then
	 */
	public void test4012_2_2_2isVerifiedAapSC0Noncomp() throws Exception {
		/*
(+) add rule instance : _012_2_2_2isVerifiedAapSC0Noncomp
(->) fire rule instance : _012_2_2_2isVerifiedAapSC0Noncomp
(-) deactivate rule : _012_2_2_2isVerifiedAapSC0Noncomp
		 */
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375124624"));        
		Person onFile = this.getPersonService().getPerson(personKey);				
		Person incoming = savePerson(onFile);
		this.setVbaQueryStatusDataAccepted(incoming);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));

		VerificationInfo vi = this.getScenario2Info();			
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());
		System.out.println("verification info ="+vi.getMsdsMessageDate());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));			
	}
	/*
	 * If the most recent verified HEC (Add a Person) record shows no SC
	 * conditions, Total Check Amount is $0 or NULL and VA Pension is No or NULL
	 * then
	 */
	public void test5112_3_1_1isVerifiedAapNSC() throws Exception {
		/*
(+) activate rule : _112_3_1_1isVerifiedAapNSC
(+) add rule instance : _112_3_1_1isVerifiedAapNSC
(->) fire rule instance : _112_3_1_1isVerifiedAapNSC
(-) deactivate rule : _112_3_1_1isVerifiedAapNSC
		 */
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375124624"));        
		Person onFile = this.getPersonService().getPerson(personKey);				
		Person incoming = savePerson(onFile);
		incoming.getServiceConnectionAward().removeAllRatedDisability();	
		this.setVbaQueryStatusDataAccepted(incoming);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		VerificationInfo vi = this.getScenario3Info();			
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());
		System.out.println("verification info ="+vi.getMsdsMessageDate());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));				
	}
	/*
	 * If the most recent verified HEC (Add a Person) records shows SC rated
	 * conditions AND Combined SC % = 0% and Total Check Amount is $0 or NULL
	 * and VA Pension = No or NULL then
	 * 
	 * [4015] Scenario 3 - ESR receives VBA Data in which the Entitlement
	 * Code is "01" but there are no VBA Rated Disabilities present *
	 */
	public void test4016_3_2_2isVerifiedAapSC0Noncomp() throws Exception {
		/*
(+) activate rule : _016_3_2_2isVerifiedAapSC0Noncomp
(+) add rule instance : _016_3_2_2isVerifiedAapSC0Noncomp
(->) fire rule instance : _016_3_2_2isVerifiedAapSC0Noncomp
(-) deactivate rule : _016_3_2_2isVerifiedAapSC0Noncomp
		 */
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375124624"));        
		Person onFile = this.getPersonService().getPerson(personKey);				
		Person incoming = savePerson(onFile);
		incoming.getServiceConnectionAward().removeAllRatedDisability();	
		this.setVbaQueryStatusDataAccepted(incoming);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		VerificationInfo vi = this.getScenario3Info();			
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());
		System.out.println("verification info ="+vi.getMsdsMessageDate());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));					
	}
	/*
	 * If the most recent verified HEC (Add a Person) records shows SC rated
	 * conditions AND Combined SC % = 0% and Total Check Amount is $0 or NULL
	 * and VA Pension = No or NULL then
	 * 
	 * SUC103.11.11 - [4020] Scenario 4 - ESR receives VBA Data with Entitlement
	 * Code is 0L, 01, or NULL and one or more invalid Disability Codes 
	 */
	public void test4022_4_2_3isVerifiedAapSC0Noncomp() throws Exception {
		/*
(+) activate rule : _022_4_2_3isVerifiedAapSC0Noncomp
(+) add rule instance : _022_4_2_3isVerifiedAapSC0Noncomp
(->) fire rule instance : _022_4_2_3isVerifiedAapSC0Noncomp
(-) deactivate rule : _022_4_2_3isVerifiedAapSC0Noncomp
		 */		
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375124624"));        
		Person onFile = this.getPersonService().getPerson(personKey);				
		Person incoming = savePerson(onFile);
		this.setVbaQueryStatusDataAccepted(incoming);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));

		VerificationInfo vi = this.getScenario4Info(incoming);			
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());
		System.out.println("verification info ="+vi.getMsdsMessageDate());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));					
	}
	/*
	 * If the most recent verified HEC (Add a Person) record shows no SC
	 * conditions, Total Check Amount is $0 or NULL and VA Pension is No or NULL
	 * then...
	 * 
	 * SUC103.11.17 - [4027] Scenario 6 - ESR receives VBA Data in which Total
	 * Check Amount > $0, Entitlement Code = NULL, and no Rated Disabilities  
	 */
	public void test4028_6_2_1isVerifiedAapNSC() throws Exception {
		/*
(+) activate rule : _028_6_2_1isVerifiedAapNSC
(+) add rule instance : _028_6_2_1isVerifiedAapNSC
(->) fire rule instance : _028_6_2_1isVerifiedAapNSC
(-) deactivate rule : _028_6_2_1isVerifiedAapNSC
		 */
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375124624"));        
		Person onFile = this.getPersonService().getPerson(personKey);				
		Person incoming = savePerson(onFile);
		incoming.getServiceConnectionAward().removeAllRatedDisability();
	    this.attachMonetaryBenefitAward(incoming);
        incoming.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(10));		
		this.setVbaQueryStatusDataAccepted(incoming);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		VerificationInfo vi = this.getScenario6Info();			
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());
		System.out.println("verification info ="+vi.getMsdsMessageDate());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));				
	}
	/*
	 * If the most recent verified HEC (Add a Person) records shows SC rated
	 * conditions AND Combined SC % = 0% and Total Check Amount is $0 or NULL
	 * and VA Pension = No or NULL then
	 * 
	 * SUC103.11.17 - [4027] Scenario 6 - ESR receives VBA Data in which Total
	 * Check Amount > $0, Entitlement Code = NULL, and no Rated Disabilities 
	 */
	public void test4028_6_2_2isVerifiedAapSC0Noncomp() throws Exception {
		//373971922 375124624
		/*
(+) activate rule : _028_6_2_2isVerifiedAapSC0Noncomp
(+) add rule instance : _028_6_2_2isVerifiedAapSC0Noncomp
(->) fire rule instance : _028_6_2_2isVerifiedAapSC0Noncomp
(-) deactivate rule : _028_6_2_2isVerifiedAapSC0Noncomp
		 */
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("375124624"));        
		Person onFile = this.getPersonService().getPerson(personKey);				
		Person incoming = savePerson(onFile);
		incoming.getServiceConnectionAward().removeAllRatedDisability();
	    this.attachMonetaryBenefitAward(incoming);
        incoming.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(10));		
		this.setVbaQueryStatusDataAccepted(incoming);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		VerificationInfo vi = this.getScenario6Info();			
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());
		System.out.println("verification info ="+vi.getMsdsMessageDate());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));					
	}		

	public void testGetCompletePerson() throws Exception {
		//Person onFile = this.getPerson("375124624");
		//373971922 375124624
		Person onFile = this.getPerson("375124624");
		Person result = this.getApplicationInProcessService().getCompletedPersonByIcn(onFile.getVPIDEntityKey().getShortVPID());
		System.out.println("id ="+result.getEntityKey().getKeyValueAsString());
	}	
	/**
	 * SUC103.11.11 - [4020] Scenario 4 - ESR receives VBA Data with Entitlement
	 * Code is 0L, 01, or NULL and one or more invalid Disability Codes
	 * 
	 */
	public void testVbaResponseCrit6Scenario4SC1CHECK1() throws Exception {
		/*
(+) activate rule : _021_4_2_2isSiteOrAapHasSCorTotalCheckGreaterThan0
(+) add rule instance : _021_4_2_2isSiteOrAapHasSCorTotalCheckGreaterThan0@bb981e
(->) fire rule instance : _021_4_2_2isSiteOrAapHasSCorTotalCheckGreaterThan0@bb981e
(-) deactivate rule : _021_4_2_2isSiteOrAapHasSCorTotalCheckGreaterThan0

		 */		
		Person onFile = createQmsePerson();
		this.attachServiceConnectionAward(onFile, new Integer(1));
	    this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(1));		
		
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		// NOTICE CHANGED entitlement code to 01
		VerificationInfo vi = this.makeMockVerifiationInfoWithException(incoming, "01", "ORFZ11-E", new Integer(0));//new VerificationInfo("01","ORFZ11-E", "");			
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_DATA_ACCEPTED.getCode()));
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());		
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));	
	}			
	
	/*
	 * SUC103.11.17 - [4027] Scenario 6 - ESR receives VBA Data in which Total
	 * Check Amount > $0, Entitlement Code = NULL, and no Rated Disabilities
	 */
	public void testVbaResponseCrit6Scenario6() throws Exception {
		/*
(+) add rule instance : isTotalCheckAmountGreaterThanZero@18c7ddc
(->) fire rule instance : isTotalCheckAmountGreaterThanZero@18c7ddc
(-) deactivate rule : isTotalCheckAmountGreaterThanZero
(+) activate rule : _028_isVerifiedSiteNSC
(+) add rule instance : _028_isVerifiedSiteNSC@182fc0a
(->) fire rule instance : _028_isVerifiedSiteNSC@182fc0a
(-) deactivate rule : _028_isVerifiedSiteNSC
(+) activate rule : _029_isVerifiedSiteNoncompensable
(+) add rule instance : _029_isVerifiedSiteNoncompensable@82fd2
(->) fire rule instance : _029_isVerifiedSiteNoncompensable@82fd2
(-) deactivate rule : _029_isVerifiedSiteNoncompensable
(+) activate rule : _028_6_2_3SiteAppCompensable
(+) add rule instance : _028_6_2_3SiteAppCompensable@17b8d3d
(->) fire rule instance : _028_6_2_3SiteAppCompensable@17b8d3d
(-) deactivate rule : _028_6_2_3SiteAppCompensable
(+) activate rule : _028_6_3_1PendingNSCWithQmse
(+) add rule instance : _028_6_3_1PendingNSCWithQmse@75cca9
(->) fire rule instance : _028_6_3_1PendingNSCWithQmse@75cca9
(-) deactivate rule : _028_6_3_1PendingNSCWithQmse
(+) activate rule : _028_6_3_2PendingSiteWithQmseSC0Noncomp
(+) add rule instance : _028_6_3_2PendingSiteWithQmseSC0Noncomp@16d8f9b
(->) fire rule instance : _028_6_3_2PendingSiteWithQmseSC0Noncomp@16d8f9b
(-) deactivate rule : _028_6_3_2PendingSiteWithQmseSC0Noncomp
(+) activate rule : _028_6_3_3PendingAppWithQmseSC0Noncomp
(+) add rule instance : _028_6_3_3PendingAppWithQmseSC0Noncomp@157790
(->) fire rule instance : _028_6_3_3PendingAppWithQmseSC0Noncomp@157790
(-) deactivate rule : _028_6_3_3PendingAppWithQmseSC0Noncomp
(+) activate rule : updatePeriodOfService
 
		 */
		Person onFile = createQmsePerson();
		this.attachServiceConnectionAward(onFile, new Integer(0));
	    this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(0));
		
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		// To fire 028_6_3_3NoQmse just don't add an mse
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		// next line is critical if you want to test scenario 6
		incoming.setServiceConnectionAward(null);
        incoming.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(1));		
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		// Put Entitlement Code = NULL
		VerificationInfo vi =  new VerificationInfo(null,"ORFZ11-E", "");			
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_DATA_ACCEPTED.getCode()));
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());		
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));	
	
	}		
	
	public void testVbaResponseC6S1NoSiteorAap() throws Exception {
		
		Person onFile = createQmsePerson();
		this.attachServiceConnectionAward(onFile, new Integer(0));
		// next line is critical if you want to test scenario 6
		onFile.getServiceConnectionAward().removeAllRatedDisability();
	    this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(0));
		
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(				
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_ACTIVATED_NATIONAL_GUARD.getCode()));
		// To fire 028_6_3_3NoQmse just don't add an mse
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		Person incoming = savePerson(onFile);
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(incoming.getEligibilityVerification().getEligibilityStatus().getCode()));
		// Put Entitlement Code = NULL
		VerificationInfo vi =  new VerificationInfo(null,"ORFZ11-E", "");			
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_DATA_ACCEPTED.getCode()));
		
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		System.out.println("verification record ="+result.getEligibilityVerification());		
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));	
	
	}			
	
	protected VerificationInfo makeMockVerifiationInfoWithException( Person person, String entitlement, String type, Integer percent) throws ServiceException {
		// Found an UnknownLookupCodeException
		UnknownLookupCodeException unknownCode = new UnknownLookupCodeException("mock", "BAD", Disability.class);
		VerificationInfo info = new VerificationInfo( entitlement, type, "mock error text" );

		info.setCombinedSCPercentage(percent);
		info.setUnsolicitedType(type);

		// create workflow case object for potential usage by Rules
		WorkflowCaseInfo caseInfo = new WorkflowCaseInfo();
		caseInfo.setTransmissionSite(null);
		caseInfo.setMessageID("1234");
		info.setWorkflowCaseInfo( caseInfo );
		info.addException( unknownCode );
		return info;
	}	
	public void testVbaResponse005_isZeroSCnoncompensable() throws Exception {
		//373971922 375124624
		//Person onFile = this.getPerson("373971922");
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("373971922"));        
		Person onFile = this.getPersonService().getPerson(personKey);			
		VerificationInfo vi = new VerificationInfo("0L","ORFZ11-E", "No Data on File");			
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_NO_DATA.getCode()));
		this.attachServiceConnectionAward(onFile, new Integer(0));		
		Person incoming = savePerson(onFile);
		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		//this.setComplete();
		System.out.println("verification record ="+result.getEligibilityVerification());
	}
	public void testMsdsRuleServiceUpgradeCriteriaEligStatus() throws Exception {
		Person onFile = createQmsePerson();
		Person incoming = savePerson(onFile);
		Person temp = (Person)onFile.clone();
		MsdsResponseInfo info = this.getMilitaryServiceBuilderForMSDS().build(this.createMinimalWrapperGo2(373971922, 222));
		this.getMilitaryRuleService().processMSDSData(incoming, temp, info);
		boolean improved = this.getMilitaryRuleService().evaluateMSDSImprovement(incoming, temp, info);		
		assertTrue("expected true for improved", improved);
		
	}
	
	public void testORFZ11CCR11961IsZeroSCnoncompensable() throws Exception {
		Person onFile = createQmsePerson();
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_PENDING.getCode()));
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		
		Person incoming = savePerson(onFile);
		assertFalse(AACIndicator.CODE_AAC_QUERIED_NO_DATA.getCode().equals(onFile.getEligibilityVerification().getAacIndicator().getCode()));		
		this.attachServiceConnectionAward(incoming, new Integer(0));		
		VerificationInfo vi = new VerificationInfo("0L","ORFZ11-E", "No Data on File");			
		incoming.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_NO_DATA.getCode()));

		Person result = this.getMessagingService().processNonQueryZ11(incoming,vi);
		assertNotNull(result.getEligibilityVerification().getAacIndicator());
		assertTrue(AACIndicator.CODE_AAC_QUERIED_NO_DATA.getCode().equals(result.getEligibilityVerification().getAacIndicator().getCode()));
		
		//this.setComplete();
		System.out.println("verification record ="+result.getEligibilityVerification());
	}	
	
	



	/*
	 * Test the IsNSCNonCompensable rule to make sure it does NOT flip elig status to Pending
	 * 
	 *  
	 */
	public void testZ07CCR11961IsNSCNonCompensable() throws Exception {

		// PRECONDITIONS
		//		rule isNSCNonCompensable
//		when
//		{
//		?eligibilityVerificationInput: gov.va.med.esr.common.rule.EligibilityVerificationInput();
//		?personInput: gov.va.med.esr.common.rule.PersonInput();
//		?serviceConnectionInput: gov.va.med.esr.common.rule.ServiceConnectionInput();
//		?monetaryAwardInput: gov.va.med.esr.common.rule.MonetaryAwardInput();
//		?militaryServiceInput: gov.va.med.esr.common.rule.MilitaryServiceInput();
//		evaluate((?eligibilityVerificationInput.isEqual( ?eligibilityVerificationInput.getEligibilityStatus(), EligibilityStatus.CODE_VERIFIED.getCode() )) &&
//		(?personInput.isVeteran()) &&
//		(! (?serviceConnectionInput.getSize( ?serviceConnectionInput.getRatedDisabilities() ) > 0)) &&
//		(((?monetaryAwardInput.isEqual( ?monetaryAwardInput.toInteger( ?monetaryAwardInput.getTotalCheckAmount() ), ?monetaryAwardInput.toInteger(0) ) ||
//		?monetaryAwardInput.isEqual( ?monetaryAwardInput.getTotalCheckAmount(), null )))) &&
//		(((?monetaryAwardInput.isEqual( ?monetaryAwardInput.getVAPensionIndicator() , Boolean.FALSE) ||
//		?monetaryAwardInput.isEqual( ?monetaryAwardInput.getVAPensionIndicator(), null )))));

		Person onFile = createQmsePerson();
		// Simulate existing AAC Query Pending
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_PENDING.getCode()));
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		// Simulate existing Verified status
		this.setEligibilityStatusToVerified(onFile);
		Person incoming = savePerson(onFile);

		VerificationInfo vi = new VerificationInfo("x",
				MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode());

		vi.setSiteNumber(VAFacility.CODE_ALBUQUERQUE.getCode());
		Person result = this.getMessagingService().processZ07(incoming,	this.getRandomVAFacility(), vi);
		assertNotNull(result.getEligibilityVerification().getAacIndicator());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		

		System.out.println("verification record ="+result.getEligibilityVerification());
		
	}
	public void testZ07CCR11961SC100() throws Exception {

		Person onFile = createQmsePerson();
		// Simulate existing AAC Query Pending
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_PENDING.getCode()));
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		// Simulate existing Verified status
		this.setEligibilityStatusToVerified(onFile);
		this.attachServiceConnectionAward(onFile, new Integer(100));		
		Person incoming = savePerson(onFile);

		VerificationInfo vi = new VerificationInfo("x",
				MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode());

		vi.setSiteNumber(VAFacility.CODE_ALBUQUERQUE.getCode());
		Person result = this.getMessagingService().processZ07(incoming,	this.getRandomVAFacility(), vi);
		assertNotNull(result.getEligibilityVerification().getAacIndicator());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		

		System.out.println("verification record ="+result.getEligibilityVerification());
		
	}
	public void testZ07CCR11961MTCOPAYEXEMPT() throws Exception {

		Person onFile = createQmsePerson();
		// Simulate existing AAC Query Pending
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_PENDING.getCode()));
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		// Simulate existing Verified status
		this.setEligibilityStatusToVerified(onFile);
		IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST,
				MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT, new Integer(2011));
		incomeTest.getIncomeTestStatus().setDeterminedStatus(this.getLookupService().getMeansTestStatusByCode(
				MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode()));
		onFile.setIncomeTest(new Integer(2011), incomeTest);
		Person incoming = savePerson(onFile);

		VerificationInfo vi = new VerificationInfo("x",
				MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode());

		vi.setSiteNumber(VAFacility.CODE_ALBUQUERQUE.getCode());
		Person result = this.getMessagingService().processZ07(incoming,	this.getRandomVAFacility(), vi);
		assertNotNull(result.getEligibilityVerification().getAacIndicator());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		

		System.out.println("verification record ="+result.getEligibilityVerification());
		
	}
	public void testZ07CCR11961MTCOPAYEXEMPT_NODATA() throws Exception {

		Person onFile = createQmsePerson();
		// Simulate existing AAC Query Pending
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_NO_DATA.getCode()));
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		// Simulate existing Verified status
		this.setEligibilityStatusToVerified(onFile);
		IncomeTest incomeTest = this.createIncomeTest(IncomeTestType.CODE_MEANS_TEST,
				MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT, new Integer(2011));
		incomeTest.getIncomeTestStatus().setDeterminedStatus(this.getLookupService().getMeansTestStatusByCode(
				MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode()));
		onFile.setIncomeTest(new Integer(2011), incomeTest);
		Person incoming = savePerson(onFile);

		VerificationInfo vi = new VerificationInfo("x",
				MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode());

		vi.setSiteNumber(VAFacility.CODE_ALBUQUERQUE.getCode());
		Person result = this.getMessagingService().processZ07(incoming,	this.getRandomVAFacility(), vi);
		assertNotNull(result.getEligibilityVerification().getAacIndicator());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		

		System.out.println("verification record ="+result.getEligibilityVerification());
		
	}			
	public void testZ07CCR11961IsNSCNonCompensablePENDING() throws Exception {
		Person onFile = createQmsePerson();
		// Simulate existing AAC Query Pending
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_PENDING.getCode()));
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		// Simulate existing Pending status
		this.setEligibilityStatusToPendingVerification(onFile);
		Person incoming = savePerson(onFile);
		this.setEligibilityStatusToVerified(incoming);
		VerificationInfo vi = new VerificationInfo("x",
				MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode());

		vi.setSiteNumber(VAFacility.CODE_ALBUQUERQUE.getCode());
		Person result = this.getMessagingService().processZ07(incoming,	this.getRandomVAFacility(), vi);
		assertNotNull(result.getEligibilityVerification().getAacIndicator());
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		

		System.out.println("verification record ="+result.getEligibilityVerification());
		
	}		
	
	/**
	 * Test the VBA rule in processZ07 to make sure we don't reset elig status
	 * to Pending.
	 * 
	 * Rule is isZeroSCNonCompensable
	 * 
	 */
	public void testZ07CCR11961IsZeroSCNonCompensable() throws Exception {
		Person onFile = createQmsePerson();
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_PENDING.getCode()));
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		this.setEligibilityStatusToVerified(onFile);
		
		Person incoming = savePerson(onFile);
		
		this.attachServiceConnectionAward(incoming, new Integer(0));		
		VerificationInfo vi = new VerificationInfo("x",
				MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode());
		
		vi.setSiteNumber(VAFacility.CODE_ALBUQUERQUE.getCode());
		Person result = this.getMessagingService().processZ07(incoming,
				this.getRandomVAFacility(), vi);
		assertNotNull(result.getEligibilityVerification().getAacIndicator());
		assertTrue(EligibilityStatus.CODE_VERIFIED.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
		
		System.out.println("verification record ="+result.getEligibilityVerification());
	}		
	public void testZ07CCR11961IsZeroSCNonCompensablePENDING() throws Exception {
		Person onFile = createQmsePerson();
		onFile.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_AAC_QUERIED_PENDING.getCode()));
		MilitaryServiceEpisode mse = createMilitaryServiceEpisode(
				getDate(1976,1,3),
				getDate(1978,11,1));
		mse.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().addMilitaryServiceEpisode(mse);
		this.setEligibilityStatusToPendingVerification(onFile);
		Person incoming = savePerson(onFile);
		this.setEligibilityStatusToVerified(incoming);		
		this.attachServiceConnectionAward(incoming, new Integer(0));		
		VerificationInfo vi = new VerificationInfo("x",
				MessageType.CODE_ORUZ07_TO_ESR.getCode(), "x");
		this.getLookupService().getVaFacilityByCode(VAFacility.CODE_ALBUQUERQUE.getCode());
		
		vi.setSiteNumber(VAFacility.CODE_ALBUQUERQUE.getCode());
		Person result = this.getMessagingService().processZ07(incoming,
				this.getRandomVAFacility(), vi);
		assertNotNull(result.getEligibilityVerification().getAacIndicator());
		assertTrue(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode().equals(result.getEligibilityVerification().getEligibilityStatus().getCode()));		
		
		System.out.println("verification record ="+result.getEligibilityVerification());
	}			
	
	public VadirServiceResponseWrapper createMinimalWrapper(long person_id, long trans_id) {
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setResponseType(VadirServiceResponseType.NORMAL);		
		wrapper.setPersonId(person_id);
		wrapper.setRequestId(trans_id);

		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
	
		birls.setMedalOfHonorInd("Y");
		
		gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod servicePeriod1 = 
			new gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod();		
		gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod servicePeriod2 = 
			new gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod();		
		// BIRLS
		servicePeriod1.setBranchOfService("NAVY");
		servicePeriod1.setCharacterOfService("HON");
		servicePeriod1.setStartDate(this.getDate(1999, 1, 9));		
		servicePeriod1.setEndDate(this.getDate(2000, 3, 4));
		servicePeriod1.setPersonnelCategory("A");
		
		servicePeriod2.setBranchOfService("NAVY");
		servicePeriod2.setCharacterOfService("HON");
		servicePeriod2.setStartDate(this.getDate(2000, 3, 5));
		servicePeriod2.setEndDate(this.getDate(2006, 2, 11));		
		servicePeriod2.setPersonnelCategory("A");		
		
		List serviceperiods = new ArrayList();
		serviceperiods.add(servicePeriod1);
		serviceperiods.add(servicePeriod2);		
		
		vadir.setServicePeriods(serviceperiods);
		
		mockMilitaryHistory.setBirls(birls);
		mockMilitaryHistory.setVadir(vadir);
		wrapper.setResult(mockMilitaryHistory);
	
		return wrapper;
	}
	public void testInt() {
		long personId = Long.parseLong("11373971922");
		System.out.println("value="+personId);
	}
	public VadirServiceResponseWrapper createMinimalWrapperGo2(long person_id, long trans_id) {
		VadirServiceResponseWrapper wrapper = new VadirServiceResponseWrapper();
		wrapper.setResponseType(VadirServiceResponseType.NORMAL);		
		wrapper.setPersonId(person_id);
		wrapper.setRequestId(trans_id);

		MilitaryHistory mockMilitaryHistory = new MilitaryHistory();
		BIRLS birls = new BIRLS();
		VADIR vadir = new VADIR();
	
		//birls.setMedalOfHonorInd("Y");
		
		gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod servicePeriod1 = 
			new gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod();		
		gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod servicePeriod2 = 
			new gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod();		
		// BIRLS
		servicePeriod1.setBranchOfService("NAVY");
		servicePeriod1.setCharacterOfService("HON");
		servicePeriod1.setStartDate(this.getDate(1999, 1, 9));		
		servicePeriod1.setEndDate(this.getDate(2000, 3, 4));
		servicePeriod1.setPersonnelCategory("A");
		
		servicePeriod2.setBranchOfService("NAVY");
		servicePeriod2.setCharacterOfService("HON");
		servicePeriod2.setStartDate(this.getDate(2000, 3, 5));
		servicePeriod2.setEndDate(this.getDate(2006, 2, 11));		
		servicePeriod2.setPersonnelCategory("A");		
		
		List serviceperiods = new ArrayList();
		serviceperiods.add(servicePeriod1);
		serviceperiods.add(servicePeriod2);		
		
		vadir.setServicePeriods(serviceperiods);
		
		mockMilitaryHistory.setBirls(birls);
		mockMilitaryHistory.setVadir(vadir);
		wrapper.setResult(mockMilitaryHistory);
	
		return wrapper;
	}	
	protected ImpreciseDate createImpreciseDate(int year, int month, int day) {
		return ImpreciseDateUtils.createImpreciseDate(year,month,day);
	}
	
	protected MilitaryServiceComponent getMilitaryServiceComponent(String code) throws Exception {
		return (MilitaryServiceComponent)this.getLookupService().getByCode(MilitaryServiceComponent.class,code);
	}
	
	protected Person createQmsePerson() throws Exception {
		// Creates a person with a HEC record and with appropriate Eligibility Verification data 
		Person person = this.buildSimplePerson();
		this.attachVerifiedEnrollment(person);
		MilitaryService ms = new MilitaryService();
		this.setEligibilityStatusToPendingVerification(person);
		person.getEligibilityVerification().setAacIndicator(
				this.getLookupService().getAACIndicatorByCode(
						AACIndicator.CODE_DATA_ACCEPTED.getName()));		
		person.setMilitaryService(ms);
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		person.getMilitaryService().addMilitaryServiceSiteRecord(m);
		return person;
	}
	
	protected MsdsResponseInfo createMinimalMsdsResponseInfo() {
		// This provides an info object that will allow MSDS rules
		// to execute and not be skipped because of NO DATA
		MilitaryService vadirMilitaryService = new MilitaryService();
		MilitaryService birlsMilitaryService = new MilitaryService();		
		MsdsResponseInfo info = new MsdsResponseInfo();
		info.setHasPurpleHeart(Boolean.TRUE);
		info.setVadirMilitaryService(vadirMilitaryService);
		info.setBirlsMilitaryService(birlsMilitaryService);
		return info;
	}
	protected MsdsResponseInfo createMsdsResponseInfoWithData(boolean multiple) throws Exception {
		Set testData = null;
		if (multiple)
			testData = createTestData();
		else
			testData = this.createTestDataWithOneMse();
		MilitaryService vadirMilitaryService = new MilitaryService();
		MilitaryServiceSiteRecord m = this.createMilitaryServiceSireRecord();
		m.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		vadirMilitaryService.addMilitaryServiceSiteRecord(m);
		vadirMilitaryService.getHECMilitaryServiceSiteRecord().addAllMilitaryServiceEpisodes(testData);
		
		MilitaryService birlsMilitaryService = new MilitaryService();		
		MsdsResponseInfo info = new MsdsResponseInfo();
		info.setHasPurpleHeart(Boolean.TRUE);
		info.setVadirMilitaryService(vadirMilitaryService);
		info.setBirlsMilitaryService(birlsMilitaryService);
		return info;
	}
	protected MsdsResponseInfo createMsdsResponseInfoWithDataC6() throws Exception {
		/*
		<VADIR>
		          <vaId>1044337068</vaId>
		          <OefOifIndicator>04</OefOifIndicator>
		          <RetirementStatusIndicator>N</RetirementStatusIndicator>
		          <ServicePeriods>
		            <StartDate>1976-06-21</StartDate>
		            <EndDate>1994-08-31</EndDate>
		            <BranchOfService>N</BranchOfService>
		            <PersonnelCategory>A</PersonnelCategory>
		            <CharacterOfService>Z</CharacterOfService>
		          </ServicePeriods>
		          <ServicePeriods>
		            <StartDate>1994-09-01</StartDate>
		            <BranchOfService>N</BranchOfService>
		            <PersonnelCategory>R</PersonnelCategory>
		          </ServicePeriods>
		        </VADIR>
		        <BIRLS>
		          <PurpleHeartInd>N</PurpleHeartInd>
		          <DisabilityInd>N</DisabilityInd>
		          <VADSInd>Y</VADSInd>
		          <VerifiedSvcDataInd>Y</VerifiedSvcDataInd>
		          <PeriodOfService>
		            <EnteredOnDutyDate>1976-06-21</EnteredOnDutyDate>
		            <ReleasedActiveDutyDate>1994-08-31</ReleasedActiveDutyDate>
		            <BranchOfService>NAVY</BranchOfService>
		            <SeparationReason>SAT</SeparationReason>
		            <CharacterOfService>HON</CharacterOfService>
		          </PeriodOfService>
		        </BIRLS>
			 */
		
		MilitaryService vadirMilitaryService = new MilitaryService();
		MilitaryServiceSiteRecord m1 = this.createMilitaryServiceSireRecord();
		m1.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		vadirMilitaryService.addMilitaryServiceSiteRecord(m1);
		/*
      <BIRLS>
		          <PurpleHeartInd>N</PurpleHeartInd>
		          <DisabilityInd>N</DisabilityInd>
		          <VADSInd>Y</VADSInd>
		          <VerifiedSvcDataInd>Y</VerifiedSvcDataInd>
		          <PeriodOfService>
		            <EnteredOnDutyDate>1976-06-21</EnteredOnDutyDate>
		            <ReleasedActiveDutyDate>1994-08-31</ReleasedActiveDutyDate>
		            <BranchOfService>NAVY</BranchOfService>
		            <SeparationReason>SAT</SeparationReason>
		            <CharacterOfService>HON</CharacterOfService>
		          </PeriodOfService>
		        </BIRLS> 
		 */
		Set<MilitaryServiceEpisode> dataBirls = new HashSet<MilitaryServiceEpisode>();
		MilitaryServiceEpisode mse3 = this.createMilitaryServiceEpisode(
				this.getLookupService().getServiceBranchByCode(ServiceBranch.CODE_NAVY.getCode()),
				new ImpreciseDate("19760621"),	new ImpreciseDate("19940831"));
		mse3.setMilitaryServiceComponent(getMilitaryServiceComponent(MilitaryServiceComponent.CODE_REGULAR.getCode()));
		dataBirls.add(mse3);		
		MilitaryService birlsMilitaryService = new MilitaryService();
		MilitaryServiceSiteRecord m2 = this.createMilitaryServiceSireRecord();
		m2.setSite(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getName()));
		birlsMilitaryService.addMilitaryServiceSiteRecord(m2);
		birlsMilitaryService.getHECMilitaryServiceSiteRecord().addAllMilitaryServiceEpisodes(dataBirls);
		
		MsdsResponseInfo info = new MsdsResponseInfo();
		info.setVadirMilitaryService(vadirMilitaryService);
		info.setBirlsMilitaryService(birlsMilitaryService);
		return info;
	}
	public ApplicationInProcessService getApplicationInProcessService() {
		return applicationInProcessService;
	}

	public void setApplicationInProcessService(
			ApplicationInProcessService applicationInProcessService) {
		this.applicationInProcessService = applicationInProcessService;
	}
	
	public class MseDecorator {
		
		
	}
}
