package gov.va.med.esr.common.rule.service;

// Java classes

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.util.RuleAbstractTestCase;


public class ManageDemographicsTest extends RuleAbstractTestCase {

    private Person onFile = null;

    public ManageDemographicsTest(String testName) {
        super(testName);

    }

    /**
     * @see gov.va.med.fw.util.AbstractTestCase#customSetUp()
     */
    protected void customSetUp() throws Exception {
        super.customSetUp();
        onFile = this.buildSimplePerson();
    }

    /**
     * 3033[UC21.8.2] Send Update Message (Z05) If the Date of Death is modified
     * the system executes the Send Update Message (Z05) in order to share the
     * information with veterans site(s) of record.
     *
     */
    public void testDeathDateModified() throws Exception {
        Person incoming = (Person)onFile.clone();
        attachDeathRecord(onFile);
        this.getPersonService().save(onFile);
        DeathRecord modified = (DeathRecord)onFile.getDeathRecord().clone();
        modified.setDeathDate(ImpreciseDateUtils.createImpreciseDate(2004, 1, 1));
        incoming.setDeathRecord(modified);
        this.getDemographicRuleService().manageDemographicInfo(incoming, onFile);
        assertTrue(incoming.getDeathRecord().getDeathDate().equals(onFile.getDeathRecord().getDeathDate()));
    }

    /**
     * 3076[UC21.23.5] When the actor deletes the date of death the system
     * automatically nulls out the Death Notification Source, Date of Death
     * Entered By, and the Date on which Date of Death was Entered. The Date of
     * Death Update Date should be set to the current date.
     *
     */
    public void testDeathDateIsDeleted() throws Exception {
        Person incoming = (Person)onFile.clone();
        attachDeathRecord(onFile);
        this.getPersonService().save(onFile);
        this.getDemographicRuleService().manageDemographicInfo(incoming, onFile);
        // Should be null
        assertNull(onFile.getDeathRecord());
    }

    public void testProcessDemo() throws Exception {

    	onFile= this.getPersonByVPID("2000002330V397526");
        Person incoming = (Person)onFile.clone();
        this.getDemographicRuleService().processDemographicInfo(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode()), incoming, onFile,false, false);

    }
}
