/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.rule.service;

// Java classes
import java.util.Calendar;
import java.util.Set;

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.util.RuleAbstractTestCase;

public class ManageContactInformationTest extends RuleAbstractTestCase {

	Person onFilePerson = null;

	public ManageContactInformationTest(String testName) {
		super(testName);
	}

	/**
	 * @see gov.va.med.fw.util.AbstractTestCase#customSetUp()
	 */
	protected void customSetUp() throws Exception {
		super.customSetUp();
		onFilePerson = this.buildSimplePerson();
        // Adds one permanent address and one primary address
		addTwoAddresses(onFilePerson, this.getDate(1975, 3, 1));
		this.getPersonService().save(onFilePerson);
	}

    /**
     * If permanent address is modified then update the permanent address for
     * the veteran equal to the information collected from the GUI and generate
     * a z05 message to the original site that created the veteran record.
     */
    public void testIsAddressTypePermanent() throws Exception {
        Person incomingPerson = (Person) onFilePerson.clone();

        addPermanentAddress(incomingPerson, Calendar.getInstance().getTime(),
                null);
        assertEquals(onFilePerson.getAddresses().size(), 2);

        this.getContactInfoRuleService().manageAddresses(
                incomingPerson.getAddresses(), onFilePerson);

        assertEquals(onFilePerson.getAddresses().size(), 2);

        this.assessPermanentAddressUpdateResults(incomingPerson, onFilePerson);
    }

    /**
     * If guardian address and phone information are modified then set the
     * guardian address for the veteran equal to the information collected from
     * the GUI and generate a Z05 message to the original site that created the
     * guardian record.
     */
    public void testIsAddressTypeGuardian() throws Exception {
        onFilePerson = this.buildSimplePerson();
        // MUST save!!!
        this.getPersonService().save(onFilePerson);
        
        Person incomingPerson = (Person) onFilePerson.clone();
        
        this.addGuardianAddress(incomingPerson, Calendar.getInstance()
                .getTime(), null);
        
        // TEST BOTH SERVICES just for expediency
        Association assoc = (Association)incomingPerson.getAssociations().iterator().next();
        this.getAssociationRuleService().manageAssociation(assoc,onFilePerson);
        assertEquals(onFilePerson.getAssociations().size(), 1);
        
        this.getContactInfoRuleService().manageAssociationAddresses(
                incomingPerson.getAssociations(), onFilePerson);

        assertEquals(onFilePerson.getAssociations().size(), 1);

        this.assessGuardianAddressUpdateResults(incomingPerson, onFilePerson);
    }

    /**
     * This checks if we accept/merge data from insurance policy
     * 
     * @throws Exception
     */
	public void testAddressFromInsurance() throws Exception {
		onFilePerson = this.buildSimplePerson();
        Person incomingPerson = (Person) onFilePerson.clone();
        
		PrivateInsurance result = this.createPrivateInsurance();
		onFilePerson.addInsurance(result);
		this.getPersonService().save(onFilePerson);

		assertNull(result.getAddress());

        PrivateInsurance incoming = (PrivateInsurance)result.clone();
		AddressType type = this.getLookupService().getAddressTypeByCode(
				AddressType.CODE_BUSINESS_ADDRESS.getName());
		incoming.setAddress(this.createAddress(type));
		incomingPerson.addInsurance(incoming);

        this.getContactInfoRuleService().manageInsuranceAddresses(incomingPerson.getInsurances(), onFilePerson);        

		assertNotNull(result.getAddress());
	}

}
