package gov.va.med.esr.common.rule.service;

import java.util.Date;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.esr.service.IVMFinancialInfo;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class IvmFinalLetterTest extends RuleAbstractTestCase {

	public IvmFinalLetterTest(String name) {
		super(name);
	}
	
	public void testIVMFinalLetterIndicator() throws Exception {
		Boolean flag = null;
      	SystemParameterService systemParameterService =  (SystemParameterService)this.applicationContext.getBean("systemParameterService");
    	flag = systemParameterService.getIVMFinalLetterIndicator();
    	assertNotNull(flag);
	}	
	
	public void testTrigger683ALetter() throws Exception {
        Person onFile = buildSimplePerson();
        this.attachAgentOrangeExposure(onFile);
        this.attachDeathRecord(onFile);
        Person incoming = savePerson(onFile);
    	IVMFinancialInfo ivmFinancialInfo = this.createIVMFinancialInfo(new Integer(2012),
    			"N", ComLetterTemplateType.FORM_NUMBER_450.getCode());
        this.getFinancialsService().convertOrReverseESRIncomeTest(incoming, ivmFinancialInfo);
	}
	public void testTrigger400Letter() throws Exception {
        this.doTriggerFinalLetter("N", ComLetterTemplateType.FORM_NUMBER_400.getCode());
	}
	public void testTrigger450Letter() throws Exception {
        this.doTriggerFinalLetter("N", ComLetterTemplateType.FORM_NUMBER_450.getCode());
	}
	public void testTrigger451Letter() throws Exception {
        this.doTriggerFinalLetter("N", ComLetterTemplateType.FORM_NUMBER_451.getCode());
	}
	public void testTrigger452Letter() throws Exception {
        this.doTriggerFinalLetter("N", ComLetterTemplateType.FORM_NUMBER_452.getCode());
	}	
	public void testTrigger453Letter() throws Exception {
        this.doTriggerFinalLetter("N", ComLetterTemplateType.FORM_NUMBER_453.getCode());
	}
	public void testTrigger454Letter() throws Exception {
        this.doTriggerFinalLetter("N", ComLetterTemplateType.FORM_NUMBER_454.getCode());
	}
	public void testTrigger455Letter() throws Exception {
        this.doTriggerFinalLetter("N", ComLetterTemplateType.FORM_NUMBER_455.getCode());
	}	
	
	private void doTriggerFinalLetter(String action, String form) throws Exception {
        Person onFile = buildSimplePerson();
        this.attachVerifiedEnrollment(onFile);
        this.attachAgentOrangeExposure(onFile);
        Person incoming = savePerson(onFile);
    	IVMFinancialInfo ivmFinancialInfo = this.createIVMFinancialInfo(new Integer(2012),
    			action, form);
        this.getFinancialsService().convertOrReverseESRIncomeTest(incoming, ivmFinancialInfo);
	}	
	private IVMFinancialInfo createIVMFinancialInfo(Integer year, String actionCode, String letterCode) {
		IVMFinancialInfo ivmFinancialInfo = new IVMFinancialInfo();
		ivmFinancialInfo.setIncomeYear(year);
		ivmFinancialInfo.setIvmActionCode(actionCode);
		ivmFinancialInfo.setIvmLetterCode(letterCode);
		ivmFinancialInfo.setIvmCaseClosureDate(new Date());
		ivmFinancialInfo.setIvmCaseNumber("TESTTEST#");
		return ivmFinancialInfo;
	}
}
