/*
 * Created on Jan 10, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.rule.service;


import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.RuleAbstractTestCase;

/**
 * @author vhaivmDRESSK
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class EnrollmentValidationTest extends RuleAbstractTestCase {
    private Person person = null;

    public EnrollmentValidationTest(String testName) throws Exception {
        super(testName);
    }

    protected void customSetUp() throws Exception {
		super.customSetUp();
        this.person = this.buildPerson();
    }


    public void testExecuteIsEffectiveDateInFuture() throws Exception {
        // Setup Received Enrollment - Effective Date
        this.attachReceivedEnrollment(person);
        person.getReceivedEnrollment().setEffectiveDate(getDate(2007, 07, 07));
        this.validateEnrollment(person);
    }

    public void testExecuteIsEnrollmentApplicationInFuture() throws Exception {
        // Setting application date in the future
        this.attachApplication(person);
        person.getApplication().setApplicationDate(getDate(2007, 07, 07));
        this.validateEnrollment(person);
    }

    public void testExecuteIsEnrollmentDateInFuture() throws Exception {
        this.attachReceivedEnrollment(person);
        person.getReceivedEnrollment().setEnrollmentDate(getDate(2007, 07, 07));
        this.validateEnrollment(person);
    }

    public void testExecuteIsEnrollmentStatusDeceased() throws Exception {
        this.attachReceivedEnrollment(person);

        EnrollmentStatus enrollmentStatus = (EnrollmentStatus) this
                .getLookupService().getEnrollmentStatusByCode(
                		EnrollmentStatus.CODE_DECEASED.getName());
        person.getReceivedEnrollment().setEnrollmentStatus(enrollmentStatus);

        this.person.setDeathRecord(null);
        this.validateEnrollment(person);
    }

    public void testExecuteIsEnrollmentStatusEqualToIneligible()
            throws Exception {
        EnrollmentStatus enrollmentStatus = (EnrollmentStatus) this
                .getLookupService()
                .getEnrollmentStatusByCode(
                		EnrollmentStatus.CODE_NOT_ELIGIBLE_INELIGIBLE_DATE.getName());
        this.attachReceivedEnrollment(person);
        this.person.getReceivedEnrollment().setEnrollmentStatus(enrollmentStatus);
        this.validateEnrollment(person);
    }

    public void testExecuteIsPreferredFacilityTypeNotEqual() throws Exception {
        // FIXME structure change
//        VAFacility vaFacility = (VAFacility)this.getVAFacilityDAO().getByStationNumber("VAIP");
//        this.person.setPreferredFacility(vaFacility);
        this.validateEnrollment(person);
    }

    
	private void validateEnrollment(Person person) throws Exception {
        this.getRuleValidationService().validateReceivedEnrollment(person,(Person)person.clone(),(Person)person.clone(),false);
      
    }    
}
