package gov.va.med.esr.common.rule.service;

// Java classes
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.person.Person;

/**
 * Tests for Egt rule service
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class EgtRuleServiceTest extends RuleAbstractTestCase {

    public EgtRuleServiceTest(String testName) {
        super(testName);
        // TODO Auto-generated constructor stub
    }
    
    public void testManageEgt() throws Exception {
        EGTSetting egt = this.getEgtService().getCurrentEGTSetting();
        EGTSetting newEgt = new EGTSetting();
        this.getCopyService().copy(egt, newEgt);
        this.getEgtRuleService().manageEGT(newEgt, egt);
    }
    
    public void testProcessEgt() throws Exception {
        Person onFile = buildSimplePerson();
        Person saved = this.getPersonService().save(onFile);
        Person incoming = this.getEligibilityEnrollmentService().updateEnrollmentData(saved);
        
        List list = new ArrayList();
        list.add(incoming.getPersonEntityKey());
        EGTSetting egt = this.getEgtService().getCurrentEGTSetting();
        this.getEgtService().updateEnrollmentWithNewEGTSetting(list, egt, new HashMap());
    }
}
