package gov.va.med.esr.common.rule.service;


// Java classes
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityFactor;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentSource;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.PseudoSSNReason;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.rule.parameter.DemographicInputParameter;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.service.ServiceException;

/**
 * @author Carlos Ruiz
 * 
 * 
 */
public class DetermineEnrollmentCERulesTest extends RuleAbstractTestCase {
	private Integer                      INCOME_YEAR                  = new Integer("2009");

    public DetermineEnrollmentCERulesTest(String testName) throws Exception {
        super(testName);
    }

    /**
     * RULE 15 Veteran is enrolled due to MT status, and a subsequent Income
     * Years Means Test was edited or added that would place the veteran in a
     * priority group not being enrolled, UNLESS RULE 15A The Means test on the
     * first verified enrollment record is edited to a Means Test Status that
     * places the record in a priority group not being enrolled and the veteran
     * has no subsequent record that would qualify for enrollment THEN the
     * veteran is NOT continuously enrolled and is placed in a Rejected
     * Enrollment Status. OR RULE 15 B The Means Test on the first verified
     * enrollment record is converted by IVM to a Means Test Status that places
     * the record in a priority group not being enrolled and the veteran has no
     * subsequent record that would qualify for enrollment THEN the veteran is
     * NOT continuously enrolled and is placed in a Rejected Enrollment Status.
     */     
    public void testRule15() throws Exception {
        //Person onFile = this.getPerson("100824348");
    	Person onFile = this.getPerson("376777714");


        testRule15_Cases(onFile, true);    
     //   this.setComplete();
    }
    public void testRule15IVM() throws Exception {
        //Person onFile = this.getPerson("100824348");
    	Person onFile = this.getPerson("376778923");



        testRule15_Cases(onFile, true);    
    }
    public void testRule15IVMNoMedicaidTest() throws Exception {
    	// tests qualifiesFor8DFromIvm ILOG rule
        PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("376779064"));        
        Person onFile = this.getPersonService().getPerson(personKey);
    	Person incoming = this.savePerson(onFile);
    	incoming.getMedicaidFactor().setEligibleForMedicaid(Boolean.FALSE);
        testRule15_Cases(incoming, true);    
    }    
    public void testRule15IVMSC0() throws Exception {
    	// tests qualifiesFor8BFromIvm ILOG rule
        PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("376779064"));        
        Person onFile = this.getPersonService().getPerson(personKey);
    	Person incoming = this.savePerson(onFile);
    	this.attachServiceConnectionAward(incoming, new Integer(0));
    	incoming.getMedicaidFactor().setEligibleForMedicaid(Boolean.FALSE);
        testRule15_Cases(incoming, true);    
    }    
    
	public void createIvmPerson() throws Exception {
		// You have to override the EnrollmentInputParameter so it returns Verified Enrollment
		Person onFile = buildSimplePerson(); // bare-bones person
		Integer year = new Integer(2011);
		this.attachApplication(onFile);
		
		IncomeTest incomeTest = this.createIncomeTest(
				IncomeTestType.CODE_MEANS_TEST,
				MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, year);
		
		incomeTest.setGmtThresholdAmount(new BigDecimal(45000));
		incomeTest.setThresholdA(new BigDecimal(45000));
		onFile.setIncomeTest(year, incomeTest);		
		onFile.getIncomeTest(year).setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_IVM.getCode()));
		onFile.getIncomeTest(year).setAgreesToPayDeductible(Boolean.TRUE);
		onFile.getIncomeTest(year).setDiscloseFinancialInformation(Boolean.TRUE);		
		onFile.setFinancialStatement(year, this.createFinancialStatement());
		onFile.getFinancialStatement(year).setAsset(
				this.getLookupService().getAssetTypeByCode(AssetType.CODE_OTHER.getCode()), this.createAsset((double)458));
		onFile.getFinancialStatement(year).setDebt(this.createDebt((double)5));
		Income income = (Income) onFile.getFinancialStatement(year).getIncome().values().iterator().next();
		income.setAmount(new BigDecimal(145000));
		onFile.getIncomeTest(year).setPg8RelaxationIndicator(Boolean.FALSE); // notice that this one is false
		
		Integer oldYear = new Integer(2010);
		IncomeTest oldIncomeTest = this.createIncomeTest(
				IncomeTestType.CODE_MEANS_TEST,
				MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, oldYear);
		
		oldIncomeTest.setGmtThresholdAmount(new BigDecimal(45000));
		oldIncomeTest.setThresholdA(new BigDecimal(45000));
		oldIncomeTest.setEffectiveDate(this.getDate(2011, 0, 1));
		onFile.setIncomeTest(oldYear, oldIncomeTest);		
		onFile.getIncomeTest(oldYear).setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_IVM.getCode()));
		onFile.getIncomeTest(oldYear).setAgreesToPayDeductible(Boolean.TRUE);
		onFile.getIncomeTest(oldYear).setDiscloseFinancialInformation(Boolean.TRUE);		
		onFile.setFinancialStatement(oldYear, this.createFinancialStatement());
		onFile.getFinancialStatement(oldYear).setAsset(
				this.getLookupService().getAssetTypeByCode(AssetType.CODE_OTHER.getCode()), this.createAsset((double)458));
		onFile.getFinancialStatement(oldYear).setDebt(this.createDebt((double)5));
		Income incomeOld = (Income) onFile.getFinancialStatement(oldYear).getIncome().values().iterator().next();
		incomeOld.setAmount(new BigDecimal(145000));		
		onFile.getIncomeTest(oldYear).setPg8RelaxationIndicator(Boolean.TRUE); //older one is true			
		
		this.attachVerifiedEnrollment(onFile);
		this.setEligibilityStatusToVerified(onFile);
				
		Person incoming = savePerson(onFile);
		incoming.getEligibilityVerification().setVerificationMethod("test");
		incoming.setMedicaidFactor(this.createMedicaidFactor());
		Person result = this.getEligibilityEnrollmentService().updateEligibilityData(incoming);
		
		assertTrue(EnrollmentPriorityGroup.GROUP_5.getCode().equals(result.getEnrollmentDetermination().getPriorityGroup().getCode()));
		this.setComplete();
		System.out.println("Person id="  + result.getPersonEntityKey().getKeyValueAsString());		
		
	}
    
    public void testRule15_Neg() throws Exception {
        
        Person onFile = this.getPerson("100824348");
        this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(21), new BigDecimal(1));        
        testRule15_Cases(onFile, false);
    }    
    


    private void testRule15_Cases(Person onFile, boolean posneg) throws Exception {
        onFile.getEligibilityVerification().setVerificationMethod((new Date()).toString());
        Person result = this.getEligibilityEnrollmentService().updateEligibilityData(onFile);
        if (posneg)
            assertTrue(result.getEnrollmentDetermination().getEnrollmentStatus()
                .getEnrollmentCategory().getCode().equals(
                        EnrollmentCategory.CODE_ENROLLED.getCode()));
        else
            assertTrue(result.getEnrollmentDetermination().getEnrollmentStatus()
                .getEnrollmentCategory().getCode().equals(
                        EnrollmentCategory.CODE_NOT_ENROLLED.getCode()));        
        System.out.println("Person id="
                + result.getPersonEntityKey().getKeyValueAsString());
    }
    
    
    public void createRule15Data_2004Test_GMT_COPAY_REQ() throws Exception {
        createRule15TestData(new Integer(2004), this.getDate(2003,3,6), MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED, EnrollmentPriorityGroup.GROUP_7, EnrollmentPrioritySubGroup.SUBGROUP_A);
    }
    public void createRule21Data_GMT_COPAY_REQ() throws Exception {
        createRule21TestData(new Integer(2006), this.getDate(2006,3,6),
                MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT,
                MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED,
                EnrollmentPriorityGroup.GROUP_7,
                EnrollmentPrioritySubGroup.SUBGROUP_A);
    }
    
    public void createRule21Data_MT_COPAY_REQ() throws Exception {
        createRule21TestData(new Integer(2006), this.getDate(2006,3,6),
                MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED,
                EnrollmentPriorityGroup.GROUP_7,
                EnrollmentPrioritySubGroup.SUBGROUP_A);
    }        
    
    public void createRule15Data_2004Test_PEND_ADJ() throws Exception {
        createRule15TestData(new Integer(2004), this.getDate(2003,3,6), MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION, EnrollmentPriorityGroup.GROUP_7, EnrollmentPrioritySubGroup.SUBGROUP_C);
    }    
    
    public void createRule15Data_2005Test_MT_COPAY_EX() throws Exception {
        createRule15TestData(new Integer(2005), this.getDate(2006,1,1), MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT, EnrollmentPriorityGroup.GROUP_5, null);
    }    
    
    public void createRule151DATA_P8b_MTCOPAYREQUIRED() throws Exception {
    	createRule151_P8_Data(new Integer(2012), this.getDate(2009,1,1), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, EnrollmentPriorityGroup.GROUP_8, 
    			EnrollmentPrioritySubGroup.SUBGROUP_B);
    }    
    public void createRule15_P8b_IVM_MTCOPAYREQUIRED() throws Exception {
    	this.createRule15_P8_IVM_Data(new Integer(2012), this.getDate(2013,1,1), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, EnrollmentPriorityGroup.GROUP_8, 
    			EnrollmentPrioritySubGroup.SUBGROUP_B);
    }    
    
    
    public void createRule151DATA_P8null_MTCOPAYREQUIRED_negative1() throws Exception {
    	createRule151_P8_Data(new Integer(2007), this.getDate(2008,1,1), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, null, null);
    }    
    public void createRule151DATA_P8null_MTCOPAYREQUIRED_negative2() throws Exception {
    	createRule151_P8_Data(new Integer(2007), this.getDate(2008,1,1), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED,  EnrollmentPriorityGroup.GROUP_8, 
    			EnrollmentPrioritySubGroup.SUBGROUP_B);
    }        

    /*
1. originally:  vet was Hum Emer with a NULL app dt
2. I removed the Ineligible Dt and set the Veteran Indicator to YES and Accepted Changes -- Enrollment Status became Pending; MT Reqd
3. I added a MT Copay Reqd test (income = $87,000) via the UI and Accepted Changes -- Enrollment Status became VERIFIED with NO Priority Group
4. Im sure I only did a minor change to invoke the E/E recalc (usually, I change the Dt/Tm Medicaid Last Edited) --  Enr Status was VERIFIED 8C 
 */
    public void create8CPerson() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(getDate(2008,11,30));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1000));
        incomeTest.setThresholdA(new BigDecimal(1000));
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));        
        onFile.setIncomeTest(new Integer(2008), incomeTest);
                
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        it.setEffectiveDate(getDate(2009,5,1)); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setEnrollmentStatus(this.getLookupService().getEnrollmentStatusByCode(EnrollmentStatus.CODE_NOT_ELIGIBLE_INELIGIBLE_DATE.getCode()));
        onFile.getEnrollmentDetermination().setPriorityGroup(null);
        onFile.getEnrollmentDetermination().setPrioritySubGroup(null);
        onFile.getEnrollmentDetermination().setEffectiveDate(getDate(2008,11,30));
       
        this.attachIneligibleFactorFromSite(onFile);

        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.HUMANTARIAN_EMERGENCY.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);        
        
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }        
    
    
    private void createRule151_P8_Data(Integer year, Date enEffective,
            MeansTestStatus.Code mtStatus, EnrollmentPriorityGroup.Code group,
            EnrollmentPrioritySubGroup.Code sub)  throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        onFile.addAddress(this.createAddress(this.getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getCode())));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                mtStatus, year);
        incomeTest.setEffectiveDate(enEffective);
        IncomeTestStatus status = incomeTest.getIncomeTestStatus();
        status.setDeterminedStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));        
        incomeTest.setCompletedDate(enEffective);
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setModifiedOn(enEffective);
        incomeTest.setTotalIncome(new BigDecimal(20000));
        incomeTest.setDeductibleExpenses(new BigDecimal(0));
        incomeTest.setGmtThresholdAmount(new BigDecimal(20010));
        incomeTest.setThresholdA(new BigDecimal(19000));        
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        onFile.setIncomeTest(year, incomeTest);
        this.attachApplication(onFile);
        // NEW
        onFile.getApplication().setApplicationDate(null);
        this.attachVerifiedEnrollment(onFile);
        

        if (group != null) {
            onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(group.getCode()));
        }
        else {
            onFile.getEnrollmentDetermination().setPriorityGroup(null);        	
        }

        if (sub != null) {
            onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(sub.getCode()));
        }
        else {
            onFile.getEnrollmentDetermination().setPrioritySubGroup(null);        	
        }
        
        onFile.getEnrollmentDetermination().setEffectiveDate(enEffective);
        onFile.getEnrollmentDetermination().setModifiedOn(enEffective);
        this.setEligibilityStatusToVerified(onFile);        
        Person incoming = savePerson(onFile);
        

        this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());        
    }
    private void createRule15_P8_IVM_Data(Integer year, Date enEffective,
            MeansTestStatus.Code mtStatus, EnrollmentPriorityGroup.Code group,
            EnrollmentPrioritySubGroup.Code sub)  throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        onFile.addAddress(this.createAddress(this.getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getCode())));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                mtStatus, year);
        incomeTest.setEffectiveDate(enEffective);
        IncomeTestStatus status = incomeTest.getIncomeTestStatus();
        status.setDeterminedStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));        
        incomeTest.setCompletedDate(enEffective);
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setPg8RelaxationIndicator(Boolean.TRUE);
        incomeTest.setModifiedOn(enEffective);
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_IVM.getCode()));
        onFile.setIncomeTest(year, incomeTest);
        this.attachApplication(onFile);
        // NEW
        onFile.getApplication().setApplicationDate(null);
        this.attachVerifiedEnrollment(onFile);
        

        if (group != null) {
            onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(group.getCode()));
        }
        else {
            onFile.getEnrollmentDetermination().setPriorityGroup(null);        	
        }

        if (sub != null) {
            onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(sub.getCode()));
        }
        else {
            onFile.getEnrollmentDetermination().setPrioritySubGroup(null);        	
        }
        
        onFile.getEnrollmentDetermination().setEffectiveDate(enEffective);
        onFile.getEnrollmentDetermination().setModifiedOn(enEffective);
        this.setEligibilityStatusToVerified(onFile);        
        Person incoming = savePerson(onFile);
        

        this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());        
    }
    
    public void testRule15NewPerson()  throws Exception {
    	Person incoming = buildSimplePerson(); // bare-bones person
//    	incoming.setEnrollmentDetermination(new EnrollmentDetermination());
//    	  EGTSetting egt =  this.getEgtService().getCurrentEGTSetting();
//    	incoming.getEnrollmentDetermination().setEgtSetting(egt);
        Person onFile = savePerson(incoming);
//  	createRule151_P8_Data(new Integer(2008), this.getDate(2009,1,1), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, EnrollmentPriorityGroup.GROUP_8, 
    	//  			EnrollmentPrioritySubGroup.SUBGROUP_B);        

    	onFile.addAddress(this.createAddress(this.getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getCode())));
    	IncomeTest incomeTest = this.createIncomeTest(
    			IncomeTestType.CODE_MEANS_TEST, MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
    	Date enEffective = this.getDate(2009,1,1);
    	incomeTest.setEffectiveDate(enEffective);
    	IncomeTestStatus status = incomeTest.getIncomeTestStatus();
    	status.setDeterminedStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));        
    	incomeTest.setCompletedDate(enEffective);
    	incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
    	incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
    	incomeTest.setModifiedOn(enEffective);
    	incomeTest.setTotalIncome(new BigDecimal(20001));
    	incomeTest.setDeductibleExpenses(new BigDecimal(0));
    	incomeTest.setGmtThresholdAmount(new BigDecimal(20010));
    	incomeTest.setThresholdA(new BigDecimal(20000));        
    	incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
    	onFile.setIncomeTest(new Integer(2008), incomeTest);
    	this.attachApplication(onFile);
    	// NEW
    	onFile.getApplication().setApplicationDate(this.getDate(2009,1,1));
    	this.setEligibilityStatusToVerified(onFile);        

    	onFile.getEligibilityVerification().setAacIndicator(
    			this.getLookupService().getAACIndicatorByCode(
    					AACIndicator.CODE_DATA_ACCEPTED.getName()));

    	VAFacility fac = onFile.getIncomeTest(new Integer(2008)).getSiteConductingTest();   
    	onFile.getEligibilityVerification().setVerificationFacility(fac);
    	this.attachApplication(onFile);
    	onFile.getApplication().setApplicationDate(this.getDate(2010, 0, 1));

    	onFile.setFinancialStatement(new Integer(2008),this.createFinancialStatement());        
    	onFile.getEligibilityVerification().setVerificationMethod((new Date()).toString());        
    	VerificationInfo vi = new VerificationInfo();
    	vi.setSiteNumber(fac.getCode());

    	Person updated = this.getMessagingService().processZ07(onFile,fac, vi);
    	System.out.println("Person id="
    			+ updated.getPersonEntityKey().getKeyValueAsString());        
    }    
    
    public void updateRule15Data_2007Test_GMT_COPAY_REQ() throws Exception {
        updateRule15TestData("100824926", new Integer(2007), this.getDate(2008,3,6), MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED, EnrollmentPriorityGroup.GROUP_7, EnrollmentPrioritySubGroup.SUBGROUP_A);
    }    
    
    private void createRule15TestData(Integer year, Date enEffective,
            MeansTestStatus.Code mtStatus, EnrollmentPriorityGroup.Code group,
            EnrollmentPrioritySubGroup.Code sub)  throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        onFile.addAddress(this.createAddress(this.getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getCode())));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                mtStatus, year);
        incomeTest.setEffectiveDate(enEffective);
        IncomeTestStatus status = incomeTest.getIncomeTestStatus();
        status.setDeterminedStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));        
        incomeTest.setCompletedDate(enEffective);
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setModifiedOn(enEffective);
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        
        onFile.setIncomeTest(year, incomeTest);
        this.attachApplication(onFile);
        // NEW
        onFile.getApplication().setApplicationDate(null);
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(group.getCode()));
        if (sub != null) {
            onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(sub.getCode()));
        }
        
        onFile.getEnrollmentDetermination().setEffectiveDate(enEffective);
        onFile.getEnrollmentDetermination().setModifiedOn(enEffective);
        this.setEligibilityStatusToVerified(onFile);        
        Person incoming = savePerson(onFile);
        

        this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());        
    }

    private void updateRule15TestData(String id, Integer year, Date enEffective,
            MeansTestStatus.Code mtStatus, EnrollmentPriorityGroup.Code group,
            EnrollmentPrioritySubGroup.Code sub)  throws Exception {
        PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal(id));        
        Person onFile = this.getPersonService().getPerson(personKey); 
    	IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                mtStatus, year);
        incomeTest.setEffectiveDate(enEffective);
        IncomeTestStatus status = incomeTest.getIncomeTestStatus();
        status.setDeterminedStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));        
        incomeTest.setCompletedDate(enEffective);
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setModifiedOn(enEffective);
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        
        onFile.setIncomeTest(year, incomeTest);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(group.getCode()));
        if (sub != null) {
            onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(sub.getCode()));
        }
        
        onFile.getEnrollmentDetermination().setEffectiveDate(enEffective);
        onFile.getEnrollmentDetermination().setModifiedOn(enEffective);
        this.setEligibilityStatusToVerified(onFile);        
        Person incoming = savePerson(onFile);
        

        this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());        
    }
    
    
    private void createRule21TestData(Integer year, Date enEffective,
            MeansTestStatus.Code mtStatus, MeansTestStatus.Code testDeterminedStatus, EnrollmentPriorityGroup.Code group,
            EnrollmentPrioritySubGroup.Code sub)  throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        onFile.addAddress(this.createAddress(this.getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getCode())));
        IncomeTest incomeTest = this.createIncomeTest( IncomeTestType.CODE_MEANS_TEST, mtStatus, year);
        incomeTest.setEffectiveDate(enEffective);
        IncomeTestStatus status = incomeTest.getIncomeTestStatus();
        status.setDeterminedStatus(this.getLookupService().getMeansTestStatusByCode(testDeterminedStatus.getCode()));        
        incomeTest.setCompletedDate(enEffective);
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setModifiedOn(enEffective);
        Hardship hardship = this.createHardship("test1");
        hardship.setEffectiveDate(this.getDate(2008, 0, 1));
        hardship.setHardshipGranted(Boolean.TRUE);
        incomeTest.setHardship(hardship);
        onFile.setIncomeTest(year, incomeTest);
        this.attachApplication(onFile);
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(group.getCode()));
        if (sub != null) {
            onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(sub.getCode()));
        }
        
        onFile.getEnrollmentDetermination().setEffectiveDate(enEffective);
        onFile.getEnrollmentDetermination().setModifiedOn(enEffective);
        this.setEligibilityStatusToVerified(onFile);        
        Person incoming = savePerson(onFile);
        

        this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());        
    }    

    public void testRule21Pos() throws Exception {
        rule21("100007995");
    }
    public void testRule21Neg() throws Exception {
        rule21("100007942");
        rule21("100008024");
    }    
    private void rule21(String id) throws Exception {
        PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal(id));        
        Person onFile = this.getPersonService().getPerson(personKey);              
        this.attachMTWithMtCopayRequired(onFile, new BigDecimal(1), new BigDecimal(1));
        Person incoming = savePerson(onFile);
        Person updated = this.getEligibilityEnrollmentService().updateEligibilityData(incoming);
       
        System.out.println("Person id="
                + updated.getPersonEntityKey().getKeyValueAsString());
    }    

    private void attachMTWithMtCopayRequired(Person person,
            BigDecimal gmtThresholdAmount, BigDecimal thresholdA)
            throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer("2007"));
        incomeTest.setGmtThresholdAmount(gmtThresholdAmount);
        incomeTest.setThresholdA(thresholdA);
        person.setIncomeTest(new Integer("2007"), incomeTest);
    }    
    
    public void updateRule15Data_2005Test() throws Exception {
        PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("100824574"));        
        Person onFile = this.getPersonService().getPerson(personKey);              
       // this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(1), new BigDecimal(1));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setEffectiveDate(this.getDate(2009, 5, 5));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1));
        incomeTest.setThresholdA(new BigDecimal(1));
        onFile.setIncomeTest(new Integer(2008), incomeTest);        
        
        Person incoming = savePerson(onFile);
        incoming.getEligibilityVerification().setVerificationMethod((new Date()).toString());        
        this.getEligibilityEnrollmentService().updateEligibilityData(incoming);
this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    }
    
    public void updateRule15Data_Layer2() throws Exception {
        PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("100824890"));        
        Person onFile = this.getPersonService().getPerson(personKey);              
       // this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(1), new BigDecimal(1));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED, new Integer(2006));
        incomeTest.setEffectiveDate(this.getDate(2007, 1, 5));
        incomeTest.setGmtThresholdAmount(new BigDecimal(2));
        incomeTest.setThresholdA(new BigDecimal(1));
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        onFile.setIncomeTest(new Integer(2006), incomeTest);        
     
        
        Person incoming = savePerson(onFile);
        incoming.getEligibilityVerification().setVerificationMethod((new Date()).toString());        
        this.getEligibilityEnrollmentService().updateEligibilityData(incoming);
this.setComplete();        

        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    }
    
    public void updateRule15Data_Layer3() throws Exception {
    	 PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("100824867"));        
         Person onFile = this.getPersonService().getPerson(personKey);              

         onFile.getEnrollmentDetermination().setEnrollmentStatus(this.getLookupService().getEnrollmentStatusByCode(EnrollmentStatus.CODE_PENDING_MEANS_TEST_REQUIRED.getName()));         
         onFile.getEnrollmentDetermination().setPriorityGroup(null);
         onFile.getEnrollmentDetermination().setPrioritySubGroup(null);
         onFile.getEnrollmentDetermination().setEffectiveDate(null);
         
         Person incoming = savePerson(onFile);
this.setComplete();
         System.out.println("Person id="
                 + incoming.getPersonEntityKey().getKeyValueAsString());
    }
    
    protected void attachMeansTestWithMtCopayRequired(Person person,
            BigDecimal gmtThresholdAmount, BigDecimal thresholdA)
            throws Exception {
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, INCOME_YEAR);
        incomeTest.setGmtThresholdAmount(gmtThresholdAmount);
        incomeTest.setThresholdA(thresholdA);
        person.setIncomeTest(INCOME_YEAR, incomeTest);
    }
    
    public void testZ07() throws Exception {
    	Integer year = new Integer(2008);

        PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("100824926"));
    
        Person onFile = this.getPersonService().getPerson(personKey);              
   
        onFile.getEligibilityVerification().setAacIndicator(
                this.getLookupService().getAACIndicatorByCode(
                        AACIndicator.CODE_DATA_ACCEPTED.getName()));
    	VAFacility fac = onFile.getIncomeTest(new Integer(2007)).getSiteConductingTest();   
        onFile.getEligibilityVerification().setVerificationFacility(fac);
       
        Person incoming = savePerson(onFile);
       incoming.setFinancialStatement(year,this.createFinancialStatement());        
        incoming.removeAllIncomeTests();

        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, year);
        
        
        incomeTest.setEffectiveDate(this.getDate(2009, 6, 1));
        incomeTest.setLastEditedDate(this.getDate(2009, 6, 1));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1));
        incomeTest.setThresholdA(new BigDecimal(1));
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setPrimaryIncomeTest(Boolean.TRUE);
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        incoming.setIncomeTest(year, incomeTest);


        incoming.getIncomeTest(year).setSiteConductingTest(fac);
        
        incoming.getEligibilityVerification().setVerificationMethod((new Date()).toString());        
        VerificationInfo vi = new VerificationInfo();
     //   Iterator iter = incoming.getServiceConnectionAward().getRatedDisabilities().iterator();
        vi.setSiteNumber(fac.getCode());
        
        Person updated = this.getMessagingService().processZ07(incoming,fac, vi);
  //this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    	
    	
    }
    public void testZ07ForP8nullPositive() throws Exception {
    	testZ07ForP8null("224727", new Integer(2008));
    }
    
    /*
     * In order to make this test cause null pointer error, I had to hijack and remove these
     * lines from ProcessVBAFromZ07.irl:
     * ?eligibilityVerificationInput.setEligibilityStatus(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode());
     * ?eligibilityVerificationInput.setEligibilityStatusDate(null );
     * ?eligibilityVerificationInput.setEligibilityVerificationMethod( null );
     * ?eligibilityVerificationInput.setEligibilityVerificationSource( null );
     * 
     * Run and create a person using create8CPerson(), and use that ID below. The test below 
     * makes adjustments to person, executes processZ07, and Rules 1A/1B are passed through. 
     * Without the fix to those rules to use calculated Primary eligibility, 
     * the rules will cause null pointer exception.
     */
    public void testZ07ForNullPointer() throws Exception {
      	Integer year2008 = new Integer(2008);
    	Integer year2009 = new Integer(2009);    	

    	 PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("225151"));
        Person onFile = this.getPersonService().getPerson(personKey);              
   
        onFile.getEligibilityVerification().setAacIndicator(
                this.getLookupService().getAACIndicatorByCode(
                        AACIndicator.CODE_DATA_ACCEPTED.getName()));

    	VAFacility fac = onFile.getIncomeTest(year2008).getSiteConductingTest();   
        onFile.getEligibilityVerification().setVerificationFacility(fac);
       this.attachApplication(onFile);
       onFile.getApplication().setApplicationDate(this.getDate(2010, 0, 1));
       
//        Person incoming = savePerson(onFile);
       onFile.setFinancialStatement(year2008,this.createFinancialStatement());        
        onFile.setIneligibilityFactor(null);
        
        onFile.getEligibilityVerification().setVerificationMethod((new Date()).toString());        
        VerificationInfo vi = new VerificationInfo();

        vi.setSiteNumber(fac.getCode());
        onFile.setEnrollmentDetermination(null); 
        Person updated = this.getMessagingService().processZ07(onFile,fac, vi);

        System.out.println("Person id="
                + updated.getPersonEntityKey().getKeyValueAsString());
    }    
    
    public void testZ07ForP8nullNegative() throws Exception {
    	testZ07ForP8null("100825979", new Integer(2007));
    }
    //224914
    public void testZ07ForP8nullNegative1() throws Exception {
    	testZ07ForP8null("224914", new Integer(2007));
    }
    // 224942
    public void testZ07ForP8nullNegative2() throws Exception {
    	testZ07ForP8null("224942", new Integer(2007));
    }
    
    private void testZ07ForP8null(String id, Integer oldYear) throws Exception {
    	Integer year2008 = new Integer(2008);
    	Integer year2009 = new Integer(2009);    	

     //   PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("100824926"));
    	 // one to reject 100825563    	
    	// 100825819 no gmt threshold or income
    	// 100825934 has all $
    	 PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal(id));
        Person onFile = this.getPersonService().getPerson(personKey);              
   
        onFile.getEligibilityVerification().setAacIndicator(
                this.getLookupService().getAACIndicatorByCode(
                        AACIndicator.CODE_DATA_ACCEPTED.getName()));

    	VAFacility fac = onFile.getIncomeTest(oldYear).getSiteConductingTest();   
        onFile.getEligibilityVerification().setVerificationFacility(fac);
       this.attachApplication(onFile);
       onFile.getApplication().setApplicationDate(this.getDate(2010, 0, 1));
       
        Person incoming = savePerson(onFile);
       incoming.setFinancialStatement(year2008,this.createFinancialStatement());        
        incoming.removeAllIncomeTests();

        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, year2009);
        
        
        incomeTest.setEffectiveDate(this.getDate(2010, 0, 1));
        incomeTest.setLastEditedDate(this.getDate(2010, 0, 1));
        incomeTest.setGmtThresholdAmount(new BigDecimal(2));
        incomeTest.setThresholdA(new BigDecimal(1));
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incomeTest.setTotalIncome(new BigDecimal(8));
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setPrimaryIncomeTest(Boolean.TRUE);
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        incoming.setIncomeTest(year2009, incomeTest);


        incoming.getIncomeTest(year2009).setSiteConductingTest(fac);
        
        incoming.getEligibilityVerification().setVerificationMethod((new Date()).toString());        
        VerificationInfo vi = new VerificationInfo();

        vi.setSiteNumber(fac.getCode());
        
        Person updated = this.getMessagingService().processZ07(incoming,fac, vi);

        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    }
    
    
    public void testZ07ForP8() throws Exception {
    	Integer year2008 = new Integer(2008);
    	Integer year2009 = new Integer(2009);    	

     //   PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("100824926"));
    	 // one to reject 100825563    	
    	 PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("224561"));
    	 //100825795
    //	PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("100825795"));
        Person onFile = this.getPersonService().getPerson(personKey);              
   
        onFile.getEligibilityVerification().setAacIndicator(
                this.getLookupService().getAACIndicatorByCode(
                        AACIndicator.CODE_DATA_ACCEPTED.getName()));

    	VAFacility fac = onFile.getIncomeTest(year2008).getSiteConductingTest();   
        onFile.getEligibilityVerification().setVerificationFacility(fac);
       this.attachApplication(onFile);
       onFile.getApplication().setApplicationDate(this.getDate(2010, 0, 1));
       
        Person incoming = savePerson(onFile);
       incoming.setFinancialStatement(year2008,this.createFinancialStatement());        
        incoming.removeAllIncomeTests();

        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, year2009);
        
        
        incomeTest.setEffectiveDate(this.getDate(2010, 0, 1));
        incomeTest.setLastEditedDate(this.getDate(2010, 0, 1));
        incomeTest.setGmtThresholdAmount(new BigDecimal(2));
        incomeTest.setThresholdA(new BigDecimal(1));
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setPrimaryIncomeTest(Boolean.TRUE);
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        incoming.setIncomeTest(year2009, incomeTest);


        incoming.getIncomeTest(year2009).setSiteConductingTest(fac);
        
        incoming.getEligibilityVerification().setVerificationMethod((new Date()).toString());        
        VerificationInfo vi = new VerificationInfo();

        vi.setSiteNumber(fac.getCode());
        
        Person updated = this.getMessagingService().processZ07(incoming,fac, vi);

        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    	
    	
    }
    
    
    public void testZ07WithPendAdj() throws Exception {
    	Integer year = new Integer(2008);
 
        PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("224446"));        
        Person onFile = this.getPersonService().getPerson(personKey);              
   
        onFile.getEligibilityVerification().setAacIndicator(
                this.getLookupService().getAACIndicatorByCode(
                        AACIndicator.CODE_DATA_ACCEPTED.getName()));
    	VAFacility fac = onFile.getIncomeTest(new Integer(2005)).getSiteConductingTest();   
        onFile.getEligibilityVerification().setVerificationFacility(fac);
       
        Person incoming = savePerson(onFile);
       incoming.setFinancialStatement(year,this.createFinancialStatement());        
        incoming.removeAllIncomeTests();

        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION, year);
        
        
        incomeTest.setEffectiveDate(this.getDate(2009, 6, 1));
        incomeTest.setLastEditedDate(this.getDate(2009, 6, 1));
        incomeTest.setGmtThresholdAmount(new BigDecimal(3));
        incomeTest.setThresholdA(new BigDecimal(3));
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setPrimaryIncomeTest(Boolean.TRUE);
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        incoming.setIncomeTest(year, incomeTest);


        incoming.getIncomeTest(year).setSiteConductingTest(fac);
        
        incoming.getEligibilityVerification().setVerificationMethod((new Date()).toString());        
        VerificationInfo vi = new VerificationInfo();
     //   Iterator iter = incoming.getServiceConnectionAward().getRatedDisabilities().iterator();
        vi.setSiteNumber(fac.getCode());
        
        Person updated = this.getMessagingService().processZ07(incoming,fac, vi);

        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    	
    	
    }    
    
    public void updateRule15Data_2005TestStatus() throws Exception {
        PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("20459660"));        
        Person onFile = this.getPersonService().getPerson(personKey);
        onFile.getIncomeTest(new Integer(2005)).setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));
        Person incoming = savePerson(onFile);
        this.getEligibilityEnrollmentService().updateEligibilityData(incoming);
        this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    }           
    
    /**
     * RULE 16 If Eligible for Medicaid is = Yes and it is changed to = No after
     * 365 days of the Enrollment Application Date, then the veteran is
     * continuously enrolled. (use Date Time Medicaid Last Updated in the
     * absence of the application date. Exit Continuous Enrollment Processing if
     * any of the Rules 9-16 have been met.
     */
    public void testRule16() throws Exception {
        Person onFile = this.getPerson("20005192");
        onFile.setMedicaidFactor(null);
        Person result = calculate(onFile);
        assertTrue(result.getEnrollmentDetermination().getEnrollmentStatus()
                .getEnrollmentCategory().getCode().equals(
                        EnrollmentCategory.CODE_ENROLLED.getCode()));
        System.out.println("Person id="
                + result.getPersonEntityKey().getKeyValueAsString());
    }

    public void createRule16Data() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
        this.attachMedicaidFactor(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(21),
                new BigDecimal(1));
        Person incoming = savePerson(onFile);
        this.getEligibilityEnrollmentService().updateEligibilityData(incoming);
        this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    }    

    public void testAgentOrangeEnteredDate() throws Exception {
        Person onFile = this.getPerson("20751514");
        AgentOrangeExposure aoe = onFile.getAgentOrangeExposure();
        if (aoe != null && aoe.getAgentOrangeExposureIndicator().toBoolean().booleanValue()) {
            System.out.println("modified date="  + aoe.getModifiedOn());
        }
        
    }
    
    public void createAOData() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(21),
                new BigDecimal(1));
        Person incoming = savePerson(onFile);
        this.attachAgentOrangeExposure(incoming);
        incoming.getAgentOrangeExposure().setLocation(this.getLookupService().getAgentOrangeExposureLocationByCode(AgentOrangeExposureLocation.CODE_KOREAN_DMZ.getCode()));
        this.getEligibilityEnrollmentService().updateEligibilityData(incoming);
        this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    }      
    
    
    
}
