package gov.va.med.esr.common.rule.service;

// Java classes
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

// Library classes

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.fw.model.AbstractEntity;

public class DetermineEligibilityPriorityTest extends RuleAbstractTestCase {

    public DetermineEligibilityPriorityTest(String testName) {
        super(testName);
        // TODO Auto-generated constructor stub
    }
    
    public void createRule16Data() throws Exception {
    	Person onFile = buildSimplePerson(); // bare-bones person
    	
    	this.setEligibilityStatusToVerified(onFile);
    	this.attachVerifiedEnrollment(onFile);
    	onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
    	this.attachMedicaidFactor(onFile);
    	onFile.getMedicaidFactor().setLastUpdateDate(new Date());//getDate(2009,1,1));
   
    	this.attachApplication(onFile);
    	onFile.getApplication().setApplicationDate(getDate(2011,1,1));
    	Person p = this.getPersonService().save(onFile);
    	Person incoming = calculate(p);    	
    	this.setComplete();
    	System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    }        
    public void createMedicaidPerson() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.setEligibilityStatusToVerified(onFile);
        this.attachMedicaidFactor(onFile);
        Person incoming = savePerson(onFile);
        Person result = calculate(incoming);
        this.endTransaction();
        this.savePerson(result);
        this.setComplete();
        System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
        
                
    }      
    
    public void updateMedicaidForCe() throws Exception {
    	//PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("490924"));        
    	PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("491053"));
		Person onFile = this.getPersonService().getPerson(personKey);    	
        Person incoming = savePerson(onFile);
        incoming.getMedicaidFactor().setEligibleForMedicaid(Boolean.FALSE);
        incoming.getMedicaidFactor().setLastUpdateDate(new Date());
        Person result = this.getEligibilityEnrollmentService().updateEligibilityData(incoming);
        System.out.println("done");

        setComplete();    
    }             
    public void testMedicaidForCe() throws Exception {
    	// This test requires that Person have existing Medicaid with Y (and corresponding verified enrollment) 
    	// that was changed to No. This test checks that a gap is filled in the
    	// CE rules where person did not get second chance even though a qualifying income test
    	// was provided and they had previous Medicaid eligibility. See CCR 10517
    	//PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("490924"));        
    	PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("491053"));
		Person onFile = this.getPersonService().getPerson(personKey);    	
     
        Person incoming = savePerson(onFile);

        Integer incomeYear = new Integer(2010);
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, incomeYear);
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setThresholdA(new BigDecimal(1000));
        
        incomeTest.setEffectiveDate(getDate(2011,1,1));
        incomeTest.setTotalIncome(new BigDecimal(1011));
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        incoming.setIncomeTest(incomeYear, incomeTest);
		
        Person result = calculate(incoming);        
        System.out.println("done");
     //   this.getEligibilityEnrollmentService().updateEligibilityData(onFile);
        //setComplete();    
    }         
    
    public void testCommitP1() throws Exception {
        testIsEnrollmentPriorityEqualto1();
        this.setComplete();
    }
    public void testMatch() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachVerifiedEnrollment(onFile);
        Person incoming = savePerson(onFile);
        EnrollmentDetermination ed = incoming.getEnrollmentDetermination();
        ed.setEffectiveDate(getDate(2001,1,1));
      // ed.setEnrollmentDate(new Date());
    	if (!AbstractEntity.matchesDomainValues(ed, onFile.getEnrollmentDetermination())) {
            // Merge the results
    		System.out.println("don't match");
        } 	
    }
   
    public void testIsEnrollmentPriorityEqualto1() throws Exception {
        try {

            Person onFile = buildSimplePerson();

            // case 1: SC indicator is equal to YES and SC% is between 50 and
            // 100
            this.attachServiceConnectionAward(onFile, new Integer(75));
            this.setEligibilityStatusToVerified(onFile);
            onFile.getServiceConnectionAward().addRatedDisability(this.createRatedDisability());            
            Person incoming = savePerson(onFile);

            Person result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_1);
            assertTrue(result.getServiceConnectionAward().getServiceConnectedIndicator().booleanValue());            

            // case 2: SC indicator is YES and SC% is greater than zero and Aid
            // and
            // attendance is null or equal to NO and house bound indicator is
            // null or equal to "NO" and VA pension is NULL or equal to NO and
            // unemployable indicator is YES and total check amount is greater
            // than zero
            onFile = buildSimplePerson();            
            this.attachServiceConnectionAward(onFile, new Integer(1));
            this.setEligibilityStatusToVerified(onFile);            
            this.attachUnemployable(onFile);
            this.attachMonetaryBenefitAward(onFile);
            onFile.getMonetaryBenefitAward().setCheckAmount(
                    new BigDecimal(1));
            onFile.getServiceConnectionAward().addRatedDisability(this.createRatedDisability());                       
            incoming = savePerson(onFile);            

            result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_1);
            assertTrue(result.getServiceConnectionAward().getServiceConnectedIndicator().booleanValue());

            logger.info("Completed testIsEnrollmentPriorityEqualto1");
        } catch (Exception e) {
            this.logger.debug("Errors due to", e);
            fail("failed due to exception " + e);
        }
    }

    /**
     * If SC indicator is YES and SC % is between 30 and 49 then set the
     * enrollment priority equal to priority 2
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo2() throws Exception {
        try {
            Person onFile = buildSimplePerson();
     

            // case: SC indicator is YES and SC % is between 30 and 49
            this.attachServiceConnectionAward(onFile, new Integer(35));
            this.setEligibilityStatusToVerified(onFile);            
            Person incoming = savePerson(onFile);
            
            Person result = calculate(incoming);

            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_2);

            logger.info("Completed testIsEnrollmentPriorityEqualto2");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }

    /**
     * If POW indicator is YES or if Purple heart indicator is YES or if SC
     * indicator is YES and SC% is between 10 and 29 or if disability
     * retirement from military is equal to YES and Receiving Military
     * retirement in lieu of VA compensation is equal to yes or if discharge due
     * to disability is equal to YES then set enrollment priority equal to
     * Priority 3
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo3Case1() throws Exception {
        try {
            Person onFile = buildSimplePerson();
     
            // case 1: SC indicator is YES and SC% is between 10 and 29
            this.attachServiceConnectionAward(onFile, new Integer(20));
            this.setEligibilityStatusToVerified(onFile);            
            Person incoming = savePerson(onFile);            
            Person result = calculate(incoming);

            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_3);


            logger.info("Completed testIsEnrollmentPriorityEqualto3");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }
    
    public void testIsEnrollmentPriorityEqualTo3Case2() throws Exception {
        try {

            // Case 2: POW indicator is YES
            Person onFile = buildSimplePerson();
            this.attachServiceConnectionAward(onFile, new Integer(0));
            this.attachPOW(onFile);
            this.setEligibilityStatusToVerified(onFile);            
            Person incoming = savePerson(onFile);            
            Person result = calculate(incoming);
            
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_3);


            logger.info("Completed testIsEnrollmentPriorityEqualto3");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }    

    
    public void testIsEnrollmentPriorityEqualTo3Case3() throws Exception {
        try {

            // Case 3: Purple heart indicator is YES
            Person onFile = buildSimplePerson();
            attachPurpleHeartWithPHStatusPending(onFile);
            this.setEligibilityStatusToVerified(onFile);            
            Person incoming = savePerson(onFile);            
            Person result = calculate(incoming);
            
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_3);


            logger.info("Completed testIsEnrollmentPriorityEqualto3");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }
    
    public void testIsEnrollmentPriorityEqualTo3Case4() throws Exception {
        try {

            // Case 4: if disability retirement from military is equal to YES
            // and Receiving Military retirement in lieu of VA compensation is
            // equal to yes
            Person onFile = buildSimplePerson();
            this.attachReceivingMilitaryRetirement(onFile);
            
            this.setEligibilityStatusToVerified(onFile);            
            Person incoming = savePerson(onFile);
         
            Person result = calculate(incoming);

            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_3);


            logger.info("Completed testIsEnrollmentPriorityEqualto3");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }    
    
    public void testIsEnrollmentPriorityEqualTo3Case5() throws Exception {
        try {

            // Case 5: if discharge due to disability is equal to YES
            Person onFile = buildSimplePerson();
            this.attachDischargeDueToDisability(onFile);
            this.setEligibilityStatusToVerified(onFile);            
            Person incoming = savePerson(onFile);            
            Person result = calculate(incoming);

            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_3);

            logger.info("Completed testIsEnrollmentPriorityEqualto3");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }    
    
    /**
     * If aid and attendance indicator is equal to YES or if housebound
     * indicator is equal to YES or if catastrophically disability is equal to
     * YES then set the enrollment priority equal to priority 4
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo4() throws Exception {
        try {
            Person onFile = buildSimplePerson();
     
            onFile.setServiceConnectionAward(null);

            // case 1: housebound indicator is equal to YES
            this.attachHousebound(onFile);
            this.setEligibilityStatusToVerified(onFile);            
            Person incoming = savePerson(onFile);            
            
            Person result = calculate(incoming);

            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_4);

            // case 2: aid and attendance indicator is equal to YES
            onFile = buildSimplePerson();
            this.attachAidAndAttendance(onFile);
            this.setEligibilityStatusToVerified(onFile);            
            incoming = savePerson(onFile);
            
            result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_4);

            // case 3: if catastrophically disability is equal to YES
            // TODO does not appear to be possible to do this unless 
            onFile = buildSimplePerson();
            this.attachCatastrophicDisability(onFile);
            this.setEligibilityStatusToVerified(onFile);
            this.attachVerifiedEnrollment(onFile);
            this.attachMeansTestWithMtCopayExempt(onFile);            
            incoming = savePerson(onFile);
         
            result = calculate(incoming);

            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_4);

            logger.info("Completed testIsEnrollmentPriorityEqualto4");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }

    /**
     * If Means test status is MT Copay Exempt or if eligible for Medicaid is
     * equal to YES or if VA pension indicator is equal to YES then set
     * enrollment priority equal to priority 5
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo5() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person
     
            this.attachVaPension(onFile);
            this.setEligibilityStatusToVerified(onFile);            
            Person incoming = savePerson(onFile);
            
            // case 1: if VA pension indicator is equal to YES
            Person result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_5);

            
            // case 2: Means test status is MT Copay Exempt
            onFile = buildSimplePerson();            
            this.attachMeansTestWithMtCopayExempt(onFile);
            this.setEligibilityStatusToVerified(onFile);            
            incoming = savePerson(onFile);
            
            result = calculate(incoming);

            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_5);

            // case 3: if eligible for Medicaid is equal to YES
            onFile = buildSimplePerson();            
            this.attachMedicaidFactor(onFile);
            this.setEligibilityStatusToVerified(onFile);            
            incoming = savePerson(onFile);            

            result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_5);

            logger.info("Completed testIsEnrollmentPriorityEqualto5");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }

    /**
     * If primary eligibility code is world war I or eligibility code is
     * Mexican Border War or if secondary eligibility code is equal to world
     * war I or eligibility code is Mexican border war or if agent orange
     * indicator is YES or if environmental contaminants indicator is yes or
     * if radiation exposure indicator is yes' or if SC% is 0 and total check
     * amount is greater than zero or if combat veteran eligibility end date is
     * not expired (in the past) then set the enrollment priority equal to
     * priority 6
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo6Case1() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person
            this.setEligibilityStatusToVerified(onFile);
            this.attachWWIAsPrimary(onFile);
            this.attachMeansTestWithNoLongerRequired(onFile);
            Person incoming = savePerson(onFile);
            
            // case 1: primary eligibility code is world war I
            Person result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_6);

            logger.info("Completed testIsEnrollmentPriorityEqualto6");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }
    
    /**
     * If primary eligibility code is world war I or eligibility code is
     * Mexican Border War or if secondary eligibility code is equal to world
     * war I or eligibility code is Mexican border war or if agent orange
     * indicator is YES or if environmental contaminants indicator is yes or
     * if radiation exposure indicator is yes' or if SC% is 0 and total check
     * amount is greater than zero or if combat veteran eligibility end date is
     * not expired (in the past) then set the enrollment priority equal to
     * priority 6
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo6Case2() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person
            // case 2 eligibility code is Mexican Border War
            this.attachMexicanBorderWar(onFile);
            this.setEligibilityStatusToVerified(onFile);     
            this.attachMeansTestWithNoLongerRequired(onFile);            
            Person incoming = savePerson(onFile);
            
            Person result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_6);

            logger.info("Completed testIsEnrollmentPriorityEqualto6");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }
    
    
    public void testIsEnrollmentPriorityEqualTo6Case3() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person

            // case 3 if agent orange indicator is YES
         
            this.attachAgentOrangeExposure(onFile);
            this.setEligibilityStatusToVerified(onFile);
            this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(2),new BigDecimal(1));            
            Person incoming = savePerson(onFile);
            
            Person result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_6);

            logger.info("Completed testIsEnrollmentPriorityEqualto6");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }     

    public void testIsEnrollmentPriorityEqualTo6Case4() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person

            // case 4 if environmental contaminants indicator is yes
            this.attachEnvironmentalContaminationExposure(onFile);
            this.setEligibilityStatusToVerified(onFile);     
            this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(2),new BigDecimal(1));            
            Person incoming = savePerson(onFile);
            
            Person result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_6);

            logger.info("Completed testIsEnrollmentPriorityEqualto6");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }       
    
    /**
     * If primary eligibility code is world war I or eligibility code is
     * Mexican Border War or if secondary eligibility code is equal to world
     * war I or eligibility code is Mexican border war or if agent orange
     * indicator is YES or if environmental contaminants indicator is yes or
     * if radiation exposure indicator is yes' or if SC% is 0 and total check
     * amount is greater than zero or if combat veteran eligibility end date is
     * not expired (in the past) then set the enrollment priority equal to
     * priority 6
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo6Case5() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person

            // case 5 if radiation exposure indicator is yes'
            this.attachRadiationExposure(onFile);
            this.setEligibilityStatusToVerified(onFile);     
            this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(2),new BigDecimal(1));            
            Person incoming = savePerson(onFile);
            
            Person result = calculate(incoming);
            
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_6);

            logger.info("Completed testIsEnrollmentPriorityEqualto6");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }
    
    /**
     * If primary eligibility code is world war I or eligibility code is
     * Mexican Border War or if secondary eligibility code is equal to world
     * war I or eligibility code is Mexican border war or if agent orange
     * indicator is YES or if environmental contaminants indicator is yes or
     * if radiation exposure indicator is yes' or if SC% is 0 and total check
     * amount is greater than zero or if combat veteran eligibility end date is
     * not expired (in the past) then set the enrollment priority equal to
     * priority 6
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo6Case6() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person

            // case 6 if SC% is 0 and total check amount is greater than zero
            this.attachServiceConnectionAward(onFile, new Integer(0));
            this.attachMonetaryBenefitAward(onFile);
            this.setEligibilityStatusToVerified(onFile);            
            onFile.getMonetaryBenefitAward().setCheckAmount(
                    new BigDecimal(1));
            this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(2),new BigDecimal(1));            
            Person incoming = savePerson(onFile);            

            Person result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_6);


            logger.info("Completed testIsEnrollmentPriorityEqualto6");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }
    
    /**
     * If primary eligibility code is world war I or eligibility code is
     * Mexican Border War or if secondary eligibility code is equal to world
     * war I or eligibility code is Mexican border war or if agent orange
     * indicator is YES or if environmental contaminants indicator is yes or
     * if radiation exposure indicator is yes' or if SC% is 0 and total check
     * amount is greater than zero or if combat veteran eligibility end date is
     * not expired (in the past) then set the enrollment priority equal to
     * priority 6
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo6Case7() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person

            // case 7 if combat veteran eligibility end date is not expired (in
            // the past)
            //this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(2),new BigDecimal(1));
            this.attachConflictExperience(onFile, this.getDate(2007, 5, 23));
            this.setEligibilityStatusToVerified(onFile);            
            Person incoming = savePerson(onFile);            
            this.attachDeathRecord(incoming);
            Person result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_6);

            logger.info("Completed testIsEnrollmentPriorityEqualto6");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }    
    
    public void testIsEnrollmentPriorityEqualTo6Case8() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person

            onFile.setShad(new SHAD());
            onFile.getShad().setShadIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
            this.setEligibilityStatusToVerified(onFile);     
            this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(2),new BigDecimal(1));            
            Person incoming = savePerson(onFile);            
            
            Person result = calculate(incoming);
            assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_6);

            logger.info("Completed testIsEnrollmentPriorityEqualto6");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }
    
    public void testIsEnrollmentPriorityEqualTo6Case8_neg() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person

            onFile.setShad(new SHAD());
            this.setEligibilityStatusToVerified(onFile);     
            this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(2),new BigDecimal(1));            
            Person incoming = savePerson(onFile);            
            
            Person result = calculate(incoming);
            assertFalse(result.getEnrollmentDetermination().getPriorityGroup().getCode().equals(EnrollmentPriorityGroup.GROUP_6.getCode()));

            logger.info("Completed testIsEnrollmentPriorityEqualto6");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }
    
    public void testIsEnrollmentPriorityEqualTo6Case8_neg2() throws Exception {
        try {
            Person onFile = buildSimplePerson(); // bare-bones person

            onFile.setShad(new SHAD());
            onFile.getShad().setShadIndicator(this.getLookupService().getIndicatorByCode(Indicator.UNKNOWN));            
            this.setEligibilityStatusToVerified(onFile);     
            this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(2),new BigDecimal(1));            
            Person incoming = savePerson(onFile);            
            
            Person result = calculate(incoming);
            assertFalse(result.getEnrollmentDetermination().getPriorityGroup().getCode().equals(EnrollmentPriorityGroup.GROUP_6.getCode()));

            logger.info("Completed testIsEnrollmentPriorityEqualto6");
        } catch (Exception e) {
            fail("failed due to exception " + e);
        }
    }                
    
    
    /**
     * if the SC% is 0 and primary eligibility code is SC less than 50% and
     * means test status is equal GMT copay required and non compensable is
     * YES or if SC% is 0 and primary eligibility code is less than 50% and
     * means test status is equal to pending adjudication and GMT threshold is
     * is greater MT threshold and non compensable is equal to YES then set
     * the enrollment priority equal to priority 7a
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo7A_case1() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED, new Integer(2009));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1015));
        incomeTest.setTotalIncome(new BigDecimal(1010));
        incomeTest.setDeductibleExpenses(new BigDecimal(0));
        onFile.setIncomeTest(new Integer(2009), incomeTest);
        
        this.attachServiceConnectionAward(onFile, new Integer(0));
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        Person incoming = savePerson(onFile);        
        
        // case 1
        Person result = calculate(incoming);
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(result);  
        assertNotNull("enrollment determination s/b non-null",
                enrollmentDetermination);
        assertEquals(enrollmentDetermination.getPrimaryEligibility().getType()
                .getCode(), EligibilityType.SC_LESS_THAN_50_PERCENT.getName());
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_7);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_A);
    }
    
    //getFinancialsService().updateFinancialAssessment(incomeYear,person)
    public void testIsEnrollmentPriorityEqualTo7A_Financials() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED, new Integer(2009));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1015));
        incomeTest.setTotalIncome(new BigDecimal(1010));
        incomeTest.setDeductibleExpenses(new BigDecimal(0));
        onFile.setIncomeTest(new Integer(2009), incomeTest);
        
        FinancialStatement f = this.createFinancialStatement();
        f.setDebt(null);        
        onFile.setFinancialStatement(new Integer(2009), f, true);
        
        this.attachServiceConnectionAward(onFile, new Integer(0));
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        Person incoming = savePerson(onFile);        
        
        // case 1
        Person result = getFinancialsService().updateFinancialAssessment(new Integer(2009),incoming);
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(result);  
        assertNotNull("enrollment determination s/b non-null",
                enrollmentDetermination);
       
    }
    
    
    public void testIsEnrollmentPriorityEqualTo7A_CCR10238() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());        
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION, new Integer(2009));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1015));
        incomeTest.setTotalIncome(new BigDecimal(1009));
        incomeTest.setDeductibleExpenses(new BigDecimal(0));
        onFile.setIncomeTest(new Integer(2009), incomeTest);
        
        this.attachServiceConnectionAward(onFile, new Integer(0));
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        Person incoming = savePerson(onFile);        
        
        // case 1
        Person result = calculate(incoming);
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(result);  
        assertNotNull("enrollment determination s/b non-null",
                enrollmentDetermination);
        assertEquals(enrollmentDetermination.getPrimaryEligibility().getType()
                .getCode(), EligibilityType.SC_LESS_THAN_50_PERCENT.getName());
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_7);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_A);
    }    
    
    /**
     * if the SC% is 0 and primary eligibility code is SC less than 50% and
     * means test status is equal GMT copay required and non compensable is
     * YES or if SC% is 0 and primary eligibility code is less than 50% and
     * means test status is equal to pending adjudication and GMT threshold is
     * is greater MT threshold and non compensable is equal to YES then set
     * the enrollment priority equal to priority 7a
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo7A_case2() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        // case 2
        this.attachApplication(onFile);
        this.attachServiceConnectionAward(onFile, new Integer(0));        
        this.attachMeansTestWithMtStatusPendingAdjudication(onFile,
                new BigDecimal(1001), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);        
        Person incoming = savePerson(onFile);        
        
        Person result = calculate(incoming);
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(result);  
        assertNotNull("enrollment determination s/b non-null",
                enrollmentDetermination);
        assertEquals(enrollmentDetermination.getPrimaryEligibility().getType()
                .getCode(), EligibilityType.SC_LESS_THAN_50_PERCENT.getName());
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_7);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_A);
    }    

    /**
     * if primary eligibility code is equal to NSC and means test status is
     * equal to GMT copay required or if primary eligibility code is NSC and
     * means test of status is equal to pending adjudication and GMT threshold
     * is greater than MT threshold then set enrollment priority equal to
     * priority 7C
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo7C_case1() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        this.attachMeansTestWithGmtCopayRequired(onFile, new BigDecimal(
                2000), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);        
        Person incoming = savePerson(onFile);
        
        // case 1
        Person result = calculate(incoming);
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(result);  
        assertNotNull("enrollment determination s/b non-null",
                enrollmentDetermination);
        assertEquals(enrollmentDetermination.getPrimaryEligibility().getType()
                .getCode(), EligibilityType.NSC.getName());
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_7);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);
    }
    
    public void create7CPersonForCE() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION, new Integer(2009));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1015));
        incomeTest.setTotalIncome(new BigDecimal(1009));
        incomeTest.setDeductibleExpenses(new BigDecimal(0));
        onFile.setIncomeTest(new Integer(2009), incomeTest);
        this.attachVerifiedEnrollment(onFile);
        this.setEligibilityStatusToVerified(onFile);        
        Person incoming = savePerson(onFile);
        incoming.getEligibilityVerification().setVerificationMethod("etstss");
        // case 1
        Person result = this.getEligibilityEnrollmentService().updateEligibilityData(incoming);
        setComplete();
        System.out.println("Person id=" + result.getPersonEntityKey().getKeyValueAsString());        
    }
    public void testIsEnrollmentPriorityEqualTo7C_CCR10238() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION, new Integer(2009));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1015));
        incomeTest.setTotalIncome(new BigDecimal(1009));
        incomeTest.setDeductibleExpenses(new BigDecimal(0));
        onFile.setIncomeTest(new Integer(2009), incomeTest);
        this.attachVerifiedEnrollment(onFile);
        this.setEligibilityStatusToVerified(onFile);        
        Person incoming = savePerson(onFile);
        
        // case 1
        Person result = calculate(incoming);
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(result);  
        assertNotNull("enrollment determination s/b non-null",
                enrollmentDetermination);
        assertEquals(enrollmentDetermination.getPrimaryEligibility().getType()
                .getCode(), EligibilityType.NSC.getName());
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_7);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);
    }    
    
    /**
     * if primary eligibility code is equal to NSC and means test status is
     * equal to GMT copay required or if primary eligibility code is NSC and
     * means test of status is equal to pending adjudication and GMT threshold
     * is greater than MT threshold then set enrollment priority equal to
     * priority 7C
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo7C_case2() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        // case 2
        this.attachApplication(onFile);        
        this.attachMeansTestWithMtStatusPendingAdjudication(onFile,
                new BigDecimal(2000), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);        
        Person incoming = savePerson(onFile);
        
        Person result = calculate(incoming);
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(result);  
        assertNotNull("enrollment determination s/b non-null",
                enrollmentDetermination);
        assertEquals(enrollmentDetermination.getPrimaryEligibility().getType()
                .getCode(), EligibilityType.NSC.getName());
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_7);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);
    }    

    public void testIsEnrollmentPriorityEqualTo8B_Pass() throws Exception {
      	//Person onFile = this.getPerson("100764198");
    	Person onFile = this.getPerson("245058");
              Person result = calculate(onFile);

         assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
         assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_B);
     }        

    public void testCCR10311() throws Exception {

    	Person onFile = this.getPerson("245069");
      
         Person result = calculate(onFile);

         assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
         assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_E);
     }        

    /*
	 * 1010890459V257982 MTT = $29402 GMTT = $38750
	 * 
	 * 1. Veteran had Elig for Medicaid for > 365 days 
	 * 2. I set Elig for
	 * Medicaid to NO -- Pending; MT Reqd 
	 * 3. I added a 2009 MT Copay Reqd
	 * above the 10% ($61000)-- 8c (as it should be) 
	 * 4. Edited the test (adding
	 * some expense, but vet is still over the 10%) ($60591.50) -- 8c again
	 * (good) 
	 * 5. I edited again, making the net income within 10% of the thrhld
	 * and it now calculated to 8d ($40211.50)--- Should have remained 8c 
	 * 6.
	 * Edited the test to be above the 10% ($80091.50) -- remained 8d
	 * 
	 * 
	 */
    public void testRule16() throws Exception {
        //Person onFile = this.getPerson("245812");
        //245898
    	BigDecimal income = new BigDecimal("40211.50"); // Lowered income    	
    	Person onFile = this.getPerson("490909");
        Person result2 = calculate(onFile);
      // Person result2 = getFinancialsService().updateFinancialAssessment(new Integer(2009),onFile);
        assessPriorityResult(result2, EnrollmentPriorityGroup.GROUP_8);
        
  //      assessPrioritySubGroupResult(result2, EnrollmentPrioritySubGroup.SUBGROUP_C);    	
    }  
    
    public void testZ07DisclosureNo() throws Exception {
    	Person onFile = this.getPerson("246336"); // gets clone
    	BigDecimal income = new BigDecimal(1011); // Lowered income
      	IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
//    	test.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));      	
//    	test.setGmtThresholdAmount(new BigDecimal(1010));
//    	test.setThresholdA(new BigDecimal(1000));
    	test.setTotalIncome(income);     
//        test.setEffectiveDate(getDate(2010,4,11));    	
    	test.setDiscloseFinancialInformation(Boolean.TRUE);
	
    	
    	
//        test.setAgreesToPayDeductible(Boolean.TRUE);
    //    test.setNetIncome(new BigDecimal(80000));
   // 	test.setTotalIncome(new BigDecimal(80000));
        
//    	     test.setNetIncome(null);
//    	 	test.setTotalIncome(null);
    	
    	
        test.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
   //     test.setSiteConductingTest(this.getRandomVAFacility());
     //   test.setEffectiveDate(new Date());

        this.setEligibilityStatusToVerified(onFile);
        onFile.getEligibilityVerification().setAacIndicator(
                this.getLookupService().getAACIndicatorByCode(
                        AACIndicator.CODE_DATA_ACCEPTED.getName()));

        onFile.getEligibilityVerification().setVerificationFacility(test.getSiteConductingTest());
        this.addPermanentAddress(onFile, Calendar.getInstance().getTime(),
                null);
        VerificationInfo vi = new VerificationInfo();
      
        vi.setSiteNumber(onFile.getEligibilityVerification().getVerificationFacility().getCode());
        
        Person updated = this.getMessagingService().processZ07(onFile, test.getSiteConductingTest(), vi);
     //   setComplete();
        assertTrue(updated.getEligibilityVerification().getEligibilityStatus()
                .getCode().equals(EligibilityStatus.CODE_VERIFIED.getName()));
    
    }        
    //246136
    public void testRule16WithP8Test() throws Exception {
        //Person onFile = this.getPerson("245812");
        //245898
      	
    	Person onFile = this.getPerson("490924");
         
        Person result = calculate(onFile);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);
        
    }          
 
 
    
    /*
	 * 1010890459V257982 MTT = $29402 GMTT = $38750
	 * 
	 * 1. Veteran had Elig for Medicaid for > 365 days 
	 * 2. I set Elig for
	 * Medicaid to NO -- Pending; MT Reqd 
	 * 3. I added a 2009 MT Copay Reqd
	 * above the 10% ($61000)-- 8c (as it should be) 
	 * 4. Edited the test (adding
	 * some expense, but vet is still over the 10%) ($60591.50) -- 8c again
	 * (good) 
	 * 5. I edited again, making the net income within 10% of the thrhld
	 * and it now calculated to 8d ($40211.50)--- Should have remained 8c 
	 * 6.
	 * Edited the test to be above the 10% ($80091.50) -- remained 8d
	 * 
	 */    
    public void testRule16Update2() throws Exception {
        //Person onFile = this.getPerson("245812");
        //245898
    	Person onFile = this.getPerson("490909");
        onFile.getMedicaidFactor().setEligibleForMedicaid(Boolean.FALSE);
        onFile.getMedicaidFactor().setLastUpdateDate(new Date());
    
        
        this.getEligibilityEnrollmentService().updateEligibilityData(onFile);
        setComplete();    
    }          
 
    
    
    /*
	 * 3. I added a 2009 MT Copay Reqd
	 * above the 10% ($61000)-- 8c (as it should be)
	 * 
	 *  
  /*
	 * 1010890459V257982 MTT = $29402 GMTT = $38750
	 * 
	 * 1. Veteran had Elig for Medicaid for > 365 days 
	 * 2. I set Elig for
	 * Medicaid to NO -- Pending; MT Reqd 
	 * 3. I added a 2009 MT Copay Reqd
	 * above the 10% ($61000)-- 8c (as it should be) 
	 * 4. Edited the test (adding
	 * some expense, but vet is still over the 10%) ($60591.50) -- 8c again
	 * (good) 
	 * 5. I edited again, making the net income within 10% of the thrhld
	 * and it now calculated to 8d ($40211.50)--- Should have remained 8c 
	 * 6.
	 * Edited the test to be above the 10% ($80091.50) -- remained 8d
	 * 
	 * 
	 *  
	 */
    public void testRule16Update3() throws Exception {
        //Person onFile = this.getPerson("245812");
        //245898
    	BigDecimal incomeAmt = new BigDecimal(61000);    	
    	Person onFile = this.getPerson("248160");
   
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2009));
    	onFile.setIncomeTest(new Integer(2009), incomeTest);        
      	IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
    	test.setGmtThresholdAmount(new BigDecimal(38750));
    	test.setThresholdA(new BigDecimal(29402));
        test.setEffectiveDate(getDate(2010,5,1));    	
    	test.setDiscloseFinancialInformation(Boolean.TRUE);        
        test.setAgreesToPayDeductible(Boolean.TRUE);
        FinancialStatement f = this.createFinancialStatement();
        
        Map.Entry entry = (Map.Entry) f.getAssets().entrySet().iterator().next();
        Asset asset  = (Asset)entry.getValue();
        asset.setAmount(new BigDecimal(0));
        
        Map.Entry entry2 = (Map.Entry) f.getIncomes().entrySet().iterator().next();
        Income income  = (Income)entry2.getValue();
        income.setAmount(incomeAmt);

        Map.Entry entry3 = (Map.Entry) f.getExpenses().entrySet().iterator().next();
        Expense expense = (Expense)entry3.getValue();
        expense.setAmount(new BigDecimal(0));

        Debt debt = f.getDebt();
        debt.setAmount(new BigDecimal(0));        
        onFile.setFinancialStatement(new Integer(2009), f, true);
        
        this.addPermanentAddress(onFile, Calendar.getInstance().getTime(),          null);
        test.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_HEC.getCode()));
        Person result = getFinancialsService().updateFinancialAssessment(new Integer(2009),onFile);
        setComplete();    
    }              
    
    /*
	 * 4. Edited the test (adding
	 * some expense, but vet is still over the 10%) ($60591.50) -- 8c again
	 * (good) 
	 * 5. I edited again, making the net income within 10% of the thrhld
	 * and it now calculated to 8d ($40211.50)--- Should have remained 8c 
	 * 6.
	 * Edited the test to be above the 10% ($80091.50) -- remained 8d
	 */
    public void testRule16Update4() throws Exception {
        //Person onFile = this.getPerson("245812");
        //245898
    	
    	Person onFile = this.getPerson("248160");
        FinancialStatement f = onFile.getFinancialStatement(new Integer(2009));
        Map.Entry entry2 = (Map.Entry) f.getIncomes().entrySet().iterator().next();
        Income income  = (Income)entry2.getValue();
        income.setAmount(new BigDecimal(61001));        
        Map.Entry entry3 = (Map.Entry) f.getExpenses().entrySet().iterator().next();
        Expense expense = (Expense)entry3.getValue();
        expense.setAmount(new BigDecimal(200));

        Person result = getFinancialsService().updateFinancialAssessment(new Integer(2009),onFile);
        setComplete();    
    }              

    /*
	 * 5. I edited again, making the net income within 10% of the thrhld
	 * and it now calculated to 8d ($40211.50)--- Should have remained 8c 
	 * 6.
	 * Edited the test to be above the 10% ($80091.50) -- remained 8d
	 */
    
    public void testRule16Update5() throws Exception {
      	
      	Person onFile = this.getPerson("248160");
        FinancialStatement f = onFile.getFinancialStatement(new Integer(2009));
        Map.Entry entry2 = (Map.Entry) f.getIncomes().entrySet().iterator().next();
        Income income  = (Income)entry2.getValue();
        income.setAmount(new BigDecimal("40211.50"));        

        Person result = getFinancialsService().updateFinancialAssessment(new Integer(2009),onFile);
        setComplete();    
    }              

    /*
    * 6.
	 * Edited the test to be above the 10% ($80091.50) -- remained 8d
    */
    public void testRule16Update6() throws Exception {
       	Person onFile = this.getPerson("248160");
        FinancialStatement f = onFile.getFinancialStatement(new Integer(2009));
        Map.Entry entry2 = (Map.Entry) f.getIncomes().entrySet().iterator().next();
        Income income  = (Income)entry2.getValue();
        income.setAmount(new BigDecimal("80091.50"));        

        Person result = getFinancialsService().updateFinancialAssessment(new Integer(2009),onFile); 
    }              
    
    
  
    
    public void testCreateMedicaidDataWithP8Test() throws Exception {
    	Person onFile = buildSimplePerson(); // bare-bones person
    	
    	this.setEligibilityStatusToVerified(onFile);
    	this.attachVerifiedEnrollment(onFile);
    	onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
    	this.attachMedicaidFactor(onFile);
    	onFile.getMedicaidFactor().setLastUpdateDate(getDate(2009,1,1));
      	BigDecimal incomeAmt = new BigDecimal(1012);    	

        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2009));
    	onFile.setIncomeTest(new Integer(2009), incomeTest);        
      	IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
    	test.setGmtThresholdAmount(new BigDecimal(1010));
    	test.setThresholdA(new BigDecimal(1000));
    	test.setTotalIncome(incomeAmt);     
        test.setEffectiveDate(getDate(2010,5,1));    	
    	test.setDiscloseFinancialInformation(Boolean.TRUE);        
        test.setAgreesToPayDeductible(Boolean.TRUE);
        test.setNetIncome(incomeAmt);
        FinancialStatement f = this.createFinancialStatement();
         
        
        Map.Entry entry = (Map.Entry) f.getAssets().entrySet().iterator().next();
        Asset asset  = (Asset)entry.getValue();
        asset.setAmount(new BigDecimal(0));
        
        Map.Entry entry2 = (Map.Entry) f.getIncomes().entrySet().iterator().next();
        Income income  = (Income)entry2.getValue();
        income.setAmount(incomeAmt);

        Map.Entry entry3 = (Map.Entry) f.getExpenses().entrySet().iterator().next();
        Expense expense = (Expense)entry3.getValue();
        expense.setAmount(new BigDecimal(0));

        Debt debt = f.getDebt();
        debt.setAmount(new BigDecimal(0));        
        onFile.setFinancialStatement(new Integer(2009), f, true);
        
        this.addPermanentAddress(onFile, Calendar.getInstance().getTime(),          null);
        test.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_HEC.getCode()));
        
        //////////////////////
    	this.attachApplication(onFile);
    	onFile.getApplication().setApplicationDate(getDate(2009,1,1));
//    	Person incoming = savePerson(onFile);
    	Person p = this.getPersonService().save(onFile);
  	Person incoming = calculate(p);    	
    	//savePerson(result);

    	this.setComplete();
    	System.out.println("Person id="
                + incoming.getPersonEntityKey().getKeyValueAsString());
    }      
    public void testIsEnrollmentPriorityEqualTo8D_EditedTest() throws Exception {
		// check one transaction for making person 8b rather than keeping them 8a and subsequent reject, which would
		// require second transation to make CE.

    	Person onFile = this.getPerson("242130");
    	//Person onFile = this.getPerson("242138");
    	IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
    	test.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));
    	test.setGmtThresholdAmount(new BigDecimal(1000));
    	test.setThresholdA(new BigDecimal(1010));
    	test.setTotalIncome(new BigDecimal(1011));        
    	test.setDiscloseFinancialInformation(Boolean.TRUE);        
    	this.setEligibilityStatusToVerified(onFile);
    	if (onFile.getAgentOrangeExposure() != null) {
    	   onFile.getAgentOrangeExposure().setLocation(null);    	
       onFile.getAgentOrangeExposure().setSpecialFactorIndicator(null);
      onFile.getAgentOrangeExposure().setRemarks(null);
    	}
    	Person result = calculate(onFile);

    	assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
    	assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_D);
    }
    
    public void testIsEnrollmentPriorityEqualTo8B_EditedTest() throws Exception {

    			// check one transaction for making person 8b rather than keeping them 8a and subsequent reject, which would
    			// require second transation to make CE.
    	    	Person onFile = this.getPerson("242138");
    	    	IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
    	    	test.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode()));
    	    	test.setGmtThresholdAmount(new BigDecimal(1000));
    	    	test.setThresholdA(new BigDecimal(1010));
    	    	test.setTotalIncome(new BigDecimal(1011));        
    	    	test.setDiscloseFinancialInformation(Boolean.TRUE);        
    	    	this.setEligibilityStatusToVerified(onFile);
   	    	 	this.attachServiceConnectionAward(onFile, new Integer(0));    	    		

    	    	Person result = calculate(onFile);

    	    	assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
    	    	assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_B);
    	    }                
    
    //242101
    
 
    public void testIsEnrollmentPriorityEqualTo8A_R27() throws Exception {
        Person incoming = this.getPerson("245082");
//        this.attachCancelDecline(incoming);
 //       incoming.getCancelDecline().setCancelDeclineIndicator(Boolean.FALSE);
        Person result = calculate(incoming);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_A);
    }
    
  
         
  
    public void test9803To8B_P8ExpansionRow1() throws Exception {
        Person onFile = this.getPerson("376777727");        
        onFile.getApplication().setApplicationDate(new Date());
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_B);
    }

    public void test9803To8D_P8ExpansionRow2() throws Exception {
        Person onFile = this.getPerson("234461");        
        onFile.getApplication().setApplicationDate(new Date());
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_D);
    }
    
    public void test9803To8B_P8ExpansionRow3() throws Exception {
    	// Need to have disclosure=true
        Person onFile = this.getPerson("234469");        
        onFile.getApplication().setApplicationDate(new Date());
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_B);
    }

    public void test9803To8B_P8ExpansionRow3_4_WithOverride() throws Exception {
    	// Name of test is misleading on purpose. We don't want Row 3 to fire when override 
    	// is applied. Defect CCR 10282 fixes issue where it fired and gave person 8B.
        Person onFile = this.getPerson("243719");        
        onFile.getApplication().setApplicationDate(new Date());
        onFile.setEnrollmentOverride(new EnrollmentOverride());
        onFile.getEnrollmentOverride().setOverride(Boolean.TRUE);
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_A);
        
        
    	IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
    	test.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode()));
        test.setGmtThresholdAmount(new BigDecimal(1010));
        test.setThresholdA(new BigDecimal(1012));
        test.setTotalIncome(new BigDecimal(1015));       	
        result = calculate(onFile);        
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_A);        
    }
    
    public void test10284_7Anegative() throws Exception {
        Person onFile = this.getPerson("243719");        
        onFile.getApplication().setApplicationDate(new Date());
    	IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
    	test.setGmtThresholdAmount(new BigDecimal(1010));
    	test.setThresholdA(new BigDecimal(1012));
    	test.setTotalIncome(new BigDecimal(1009));        	
    	test.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode()));        
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_E);

    }    
    
    public void test10284_7Cnegative() throws Exception {
        Person onFile = this.getPerson("243746");        
        onFile.getApplication().setApplicationDate(new Date());
    	IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        test.setGmtThresholdAmount(new BigDecimal(1010));
        test.setThresholdA(new BigDecimal(1012));
        test.setTotalIncome(new BigDecimal(1009));       	
    	test.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode()));        
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);

    }        
    
    public void test9803To8B_P8ExpansionRow5_6_WithOverride() throws Exception {
    	// Name of test is misleading on purpose. We don't want Row 3 to fire when override 
    	// is applied. Defect CCR 10282 fixes issue where it fired and gave person 8B.
        Person onFile = this.getPerson("243746");        
        onFile.getApplication().setApplicationDate(new Date());
        onFile.setEnrollmentOverride(new EnrollmentOverride());
        onFile.getEnrollmentOverride().setOverride(Boolean.TRUE);
        Person result = calculate(onFile);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);

        
    	IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
    	test.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));
        result = calculate(onFile);        
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);
    }    
    
    public void test9803To8B_P8ExpansionRow3_AppDateNull() throws Exception {
    	// Need to have disclosure=true
        Person onFile = this.getPerson("242447");        
        onFile.getApplication().setApplicationDate(getDate(2002,1,1));
//        onFile.getEnrollmentDetermination().setEffectiveDate(getDate(2002,1,1));
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_E);
        
        
        onFile.getApplication().setApplicationDate(null);        
        result = calculate(onFile);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_B);        
    }    
    
    public void test9803To8B_P8ExpansionRow4() throws Exception {
    	// Need to have disclosure=true
        Person onFile = this.getPerson("234469");        
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        test.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode()));
        test.setGmtThresholdAmount(new BigDecimal(1000));
        test.setThresholdA(new BigDecimal(1010));
        test.setTotalIncome(new BigDecimal(1011));        
        test.setDiscloseFinancialInformation(Boolean.TRUE);
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_B);
    }
    

   
    public void test9803To8B_P8ExpansionRow5() throws Exception {
    	// Need to have disclosure=true
        Person onFile = this.getPerson("234502");        
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        test.setGmtThresholdAmount(new BigDecimal(1000));
        test.setThresholdA(new BigDecimal(1010));
        test.setTotalIncome(new BigDecimal(1011));        
        test.setDiscloseFinancialInformation(Boolean.TRUE);        
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_D);
    }

    public void test9803To8B_P8ExpansionRow6() throws Exception {
    	// Need to have disclosure=true
        Person onFile = this.getPerson("234502");        
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        test.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode()));        
        test.setGmtThresholdAmount(new BigDecimal(1000));
        test.setThresholdA(new BigDecimal(1010));
        test.setTotalIncome(new BigDecimal(1011));
        test.setDiscloseFinancialInformation(Boolean.TRUE);
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_D);
    }    
    
    public void testIsEnrollmentPriorityEqualTo8C_row29_Pass() throws Exception {
     
    	Person onFile = this.getPerson("234595");
        onFile.setServiceConnectionAward(null);
        onFile.setMonetaryBenefitAward(null);
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);
    }
    
    public void testIsEnrollmentPriorityEqualTo8C_row30_Pass() throws Exception {
        Person onFile = this.getPerson("233666");        
        // The app date is key to make person continuous enrolled so they can become 8C
        onFile.setServiceConnectionAward(null);
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1000));
        incomeTest.setThresholdA(new BigDecimal(1001));
        onFile.setIncomeTest(new Integer(2008), incomeTest);        
        
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);
    }
      
    
    public void testIsEnrollmentPriorityEqualTo8C_row29_Rejectg() throws Exception {
        Person onFile = this.getPerson("245100");        
  
        onFile.getApplication().setApplicationDate(this.getDate(2001, 1, 1));
        onFile.setServiceConnectionAward(null);
        
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }
    
    public void testIsEnrollmentPriorityEqualTo8C_row29_RejectRow192021() throws Exception {
    	// Use a person with "nothing"
        Person onFile = this.getPerson("233640");        
  
        onFile.getApplication().setApplicationDate(this.getDate(2001, 1, 1));
        onFile.setServiceConnectionAward(null);
        
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }    
    
    /**
     * Notice that in original DetermineEnrollment.irl that 8D was produced from 
     * the test below. 
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo8C_row30_Rejectg() throws Exception {
        Person onFile = this.getPerson("100764069");
        // The app date is key to make person continuous enrolled so they can become 8C        
        onFile.getApplication().setApplicationDate(this.getDate(1998, 1, 1));
        onFile.setServiceConnectionAward(null);
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1000));
        incomeTest.setThresholdA(new BigDecimal(1001));
        onFile.setIncomeTest(new Integer(2008), incomeTest);           
        
        Person result = calculate(onFile);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }           
    
      
    /**
	 * IF pristine=[SC 0% compensable (Total check amount is greater than $0)]
	 * AND calculated=[SC 0% noncompensable (Total check amount is 0 or Null)]
	 * THEN reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true ENDIF
	 * 
	 * @throws Exception
	 */
    public void test9803CERejectRule1() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachServiceConnectionAward(onFile, new Integer(0));
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(999));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile); // make existing person              
        Person incoming = savePerson(onFile); 
        incoming.setMonetaryBenefitAward(null);
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_E);
    }        
    
    /**
	 * 2 checkCERejectTable2
	 * 
	 * IF pristine=[SC 0% -100%] AND calculated=[SC is removed] THEN reject
	 * enrollment (sub priority e or g) recheckRejectionStatusFor8Band8D = true
	 * ENDIF
	 */
    public void test9803CERejectRule2() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachServiceConnectionAward(onFile, new Integer(60));
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile); // make existing person              
        Person incoming = savePerson(onFile); 
        incoming.getServiceConnectionAward().setServiceConnectedPercentage(null);
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }        
    
    


	/**
	 * 3 checkCERejectTable3
	 * 
	 * 
	 * IF pristine=[AO and Location = Vietnam] AND calculated=[AO Location is
	 * changed to DMZ after implementation of priority algorithm that considers
	 * AO Location] THEN reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true ENDIF
	 */    
    public void test9803CERejectRule3_qualifiesFor8D() throws Exception {
    	// Run testCERejectRule3CreatePerson8D() and use that person id here
    	//234335
    	Person onFile = this.getPerson("234535");
 
        onFile.getAgentOrangeExposure().setLocation(this.getLookupService().getAgentOrangeExposureLocationByCode(
        		AgentOrangeExposureLocation.CODE_KOREAN_DMZ.getCode()));
        Person result = calculate(onFile);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_D);
    }           
  
	/**
	 * 3 checkCERejectTable3
	 * 
	 * 
	 * IF pristine=[AO and Location = Vietnam] AND calculated=[AO Location is
	 * changed to DMZ after implementation of priority algorithm that considers
	 * AO Location] THEN reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true ENDIF
	 */    
    public void test9803CERejectRule3_qualifiesFor8B() throws Exception {
    	// Run testCERejectRule3CreatePerson8D() and use that person id here
    	//234335
    	Person onFile = this.getPerson("234543");
    	this.attachServiceConnectionAward(onFile, new Integer(0));
        onFile.getAgentOrangeExposure().setLocation(this.getLookupService().getAgentOrangeExposureLocationByCode(
        		AgentOrangeExposureLocation.CODE_KOREAN_DMZ.getCode()));
        Person result = calculate(onFile);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_B);
    }           

    public void test9803CleanupWithMedicaid() throws Exception {
    	  
    	Person onFile = this.getPerson("246136"); // This person meets Medicaid CE criteria
    
    	// This demonstrates what would happen if person with a MEdicaid CE that should be 8c is sent to batch job.
    	// Suppose this person has P8 test. The batch job would make person 8B/D, which is wrong.

        Person result = this.getEligibilityEnrollmentService().processCalculateEEForCleanup(onFile.getPersonEntityKey(), true, true);

    }    
    
    public void test9803Cleanup2() throws Exception {
  	  
    	Person onFile = this.getPerson("2343"); 
    

        Person result = this.getEligibilityEnrollmentService().processCalculateEEForCleanup(onFile.getPersonEntityKey(), true, true);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_D );
        System.out.println("Test 1 passed for " + onFile.getPersonEntityKey().getKeyValueAsString());        
        onFile = this.getPerson("9204"); 
        result = this.getEligibilityEnrollmentService().processCalculateEEForCleanup(onFile.getPersonEntityKey(), true, true);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_D );
        System.out.println("Test 2 passed for " + onFile.getPersonEntityKey().getKeyValueAsString());        
        onFile = this.getPerson("246070"); 
        result = this.getEligibilityEnrollmentService().processCalculateEEForCleanup(onFile.getPersonEntityKey(), true, true);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_B );
        System.out.println("Test 3 passed for " + onFile.getPersonEntityKey().getKeyValueAsString());        
    }    

    public void test9803Cleanup() throws Exception {
  
    	//Person onFile = this.getPerson("8924");
    	//"9204" 234562 5083
    	//Person onFile = this.getPerson("237078");
    	//Person onFile = this.getPerson("234574");
    	//245967
    	Person onFile = this.getPerson("245967");
    	   boolean qualifies = 
           	this.getEligibilityEnrollmentService().hasIncomeTestMeetingP8RecheckCriteria(onFile.getEntityKey(), Float.valueOf("10").floatValue());
           System.out.println("PRIOR qualifies=" + qualifies);
             /*  	
        onFile.getIncomeTest(new Integer(2008)).setTotalIncome(new BigDecimal(37000));        
        onFile.getIncomeTest(new Integer(2008)).setNetIncome(new BigDecimal(37000));
        
        onFile.getIncomeTest(new Integer(2008)).setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()));
        */        
        //Person result = calculate(onFile);
          Person result = this.getEligibilityEnrollmentService().processCalculateEEForCleanup(onFile.getPersonEntityKey(), true, true);
        System.out.println("Test 1");
        qualifies = 
        	this.getEligibilityEnrollmentService().hasIncomeTestMeetingP8RecheckCriteria(onFile.getEntityKey(), Float.valueOf("10").floatValue());
        System.out.println("POST qualifies=" + qualifies);
        
        Date eff = 
        	this.getEligibilityEnrollmentService().getEffectiveDateForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentThreshold(onFile.getEntityKey());
        System.out.println("effective date=" + ((eff != null) ? eff.toString() : "null"));
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_B);
        /*
        
     
        System.out.println("Test 2");        
    	onFile = this.getPerson("234562");
    	
    	IncomeTest test = this.getPersonHelperService().getCurrentIncomeTest(onFile);
    	test.setDiscloseFinancialInformation(Boolean.TRUE);
        result = calculate(onFile);
        
        qualifies = 
        	this.getEligibilityEnrollmentService().hasIncomeTestMeetingP8RecheckCriteria(onFile.getEntityKey(), Float.valueOf("10").floatValue());
        System.out.println("qualifies=" + qualifies);
        
        eff = 
        	this.getEligibilityEnrollmentService().getEffectiveDateForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentThreshold(onFile.getEntityKey());
        System.out.println("effective date=" + ((eff != null) ? eff.toString() : "null"));
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_B);
        
        // with pre2008
        System.out.println("Test 3");        
    	onFile = this.getPerson("234584");
        result = calculate(onFile);
        
        qualifies = 
        	this.getEligibilityEnrollmentService().hasIncomeTestMeetingP8RecheckCriteria(onFile.getEntityKey(), Float.valueOf("10").floatValue());
        System.out.println("qualifies=" + qualifies);
        
        eff = 
        	this.getEligibilityEnrollmentService().getEffectiveDateForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentThreshold(onFile.getEntityKey());
        System.out.println("effective date=" + ((eff != null) ? eff.toString() : "null"));
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_E);
        
        
        // with pre2008
        System.out.println("Test 4");        
    	onFile = this.getPerson("234677");
    
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        incomeTest.setTotalIncome(new BigDecimal(71011));
        // Current day        
        incomeTest.setEffectiveDate(new Date());     	
        incomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        onFile.setIncomeTest(new Integer(2008), incomeTest);
  	
        result = calculate(onFile);
        
        qualifies = 
        	this.getEligibilityEnrollmentService().hasIncomeTestMeetingP8RecheckCriteria(onFile.getEntityKey(), Float.valueOf("10").floatValue());
        System.out.println("qualifies=" + qualifies);
        
        eff = 
        	this.getEligibilityEnrollmentService().getEffectiveDateForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentThreshold(onFile.getEntityKey());
        System.out.println("effective date=" + ((eff != null) ? eff.toString() : "null"));
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);
    */         
    }           
    
    
    /**
	 * 4 checkCERejectTable4
	 * 
	 * IF pristine=[Agent Orange = Yes] AND calculated=[Agent Orange = Not Yes]
	 * THEN reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true ENDIF
	 */
    public void test9803CERejectRule4() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachAgentOrangeExposure(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        onFile.getAgentOrangeExposure().setLocation(this.getLookupService().getAgentOrangeExposureLocationByCode(
        		AgentOrangeExposureLocation.CODE_VIETNAM.getCode()));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        Person incoming = savePerson(onFile); 
        incoming.setAgentOrangeExposure(null);
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }         
    
    /**
	 * 5 checkCERejectTable5
	 * 
	 * IF pristine=[Radiation Exposure = Yes] AND calculated=[Radiation Exposure =
	 * Not Yes] THEN reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true ENDIF
	 */
    public void test9803CERejectRule5() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachRadiationExposure(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        Person incoming = savePerson(onFile); 
        incoming.setRadiationExposure(null);
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }             
 
	/**
	 * 6 checkCERejectTable6
	 * 
	 * IF pristine=[Radiation Exposure = Yes and Method = Hiroshima/Nagasaki]
	 * AND calculated=[IR = Yes and Method is changed to either Underground
	 * Nuclear Testing OR Exposure at Nuclear Facility OR Other] THEN reject
	 * enrollment (sub priority e or g) recheckRejectionStatusFor8Band8D = true
	 * ENDIF
	 */
    public void test9803CERejectRule6() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachRadiationExposure(onFile);
        onFile.getRadiationExposure().setExposureMethod(
        		this.getLookupService().getRadiationExposureMethodByCode(RadiationExposureMethod.CODE_NAGASAKI_HIROSHIMA.getCode()));
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        this.processCERejectRule6(onFile);
    }                
    
    /**
	 * 7 checkCERejectTable7
	 * 
	 * IF pristine=[Radiation Exposure = Yes and Method = Atmospheric Nuclear
	 * Testing] AND calculated=[IR = Yes and Method is changed to either
	 * Underground Nuclear Testing OR Exposure at Nuclear Facility OR Other]
	 * THEN 
	 * reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true 
	 * ENDIF
	 */
    public void test9803CERejectRule7() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachRadiationExposure(onFile);
        onFile.getRadiationExposure().setExposureMethod(
        		this.getLookupService().getRadiationExposureMethodByCode(RadiationExposureMethod.CODE_ATMOSPHERIC_NUCLEAR_TESTING.getCode()));
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        this.processCERejectRule6(onFile);
    }                    
    
    /**
	 * 8 
	 * checkCERejectTable8
	 * 
	 * IF pristine=[Radiation Exposure = Yes and Method = H/N and Atmospheric
	 * Testing] AND calculated=[IR = Yes and Method is changed to either
	 * Underground Nuclear Testing OR Exposure at Nuclear Facility OR Other]
	 * THEN 
	 * reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true 
	 * ENDIF
	 */
    public void test9803CERejectRule8() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachRadiationExposure(onFile);
        onFile.getRadiationExposure().setExposureMethod(
        		this.getLookupService().getRadiationExposureMethodByCode(RadiationExposureMethod.CODE_HN_ATMOSPHERIC_TESTING.getCode()));
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        this.processCERejectRule6(onFile);
    }                  
    
    /**
	 * 9 checkCERejectTable9
	 * 
	 * IF pristine=[SW Asia Conditions = Yes] AND calculated=[SW Asia Conditions =
	 * Not Yes] THEN reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true ENDIF
	 * 
	 * 
	 */
    public void test9803CERejectRule9() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachEnvironmentalContaminationExposure(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        Person incoming = savePerson(onFile); 
        incoming.setEnvironmentalContaminationExposure(null);
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }           
    
    
    /**
	 * 10 checkCERejectTable10
	 * 
	 * IF pristine=[SHAD = Yes] AND calculated=[SHAD = Not Yes] THEN 
	 * reject enrollment (sub priority e or g) 
	 * recheckRejectionStatusFor8Band8D = true
	 * ENDIF
	 */
    public void test9803CERejectRule10() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        
        onFile.setShad(new SHAD());
        onFile.getShad().setShadIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        Person incoming = savePerson(onFile); 
        incoming.setShad(null);
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }          
    
    /**
	 * 11 checkCERejectTable11
	 * 
	 * IF pristine=[WWI Eligibility Code] AND calculated=[WWI Eligibility Code
	 * is removed] THEN reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true ENDIF
	 */
    public void test9803CERejectRule11() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachWWIAsPrimary(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);       
        Eligibility e = new Eligibility();
        e.setPrimary();
        e.setType(getLookupService().getEligibilityTypeByCode(EligibilityType.WORLD_WAR_I.getCode()));
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);
        Person incoming = savePerson(onFile); 
        incoming.setReceivedPrimaryEligiblity(null);
        incoming.setReceivedEnrollment(null);
        incoming.getEnrollmentDetermination().setPrimaryEligiblity(null);        
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }             
    
    /**
	 * 12 checkCERejectTable12
	 * 
	 * IF pristine=[Mexican Border War Eligibility Code] AND calculated=[Mexican
	 * Border War Eligibility Code is removed] THEN 
	 * reject enrollment (sub * priority e or g) 
	 * recheckRejectionStatusFor8Band8D = true 
	 * ENDIF
	 */
    public void test9803CERejectRule12() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachMexicanBorderWar(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);       
        Eligibility e = new Eligibility();
        e.setPrimary();
        e.setType(getLookupService().getEligibilityTypeByCode(EligibilityType.MEXICAN_BORDER_WAR.getCode()));
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);
        Person incoming = savePerson(onFile); 
        incoming.setReceivedPrimaryEligiblity(null);
        incoming.removeAllReceivedSecondaryEligibilities();
        incoming.setReceivedEnrollment(null);
        incoming.getEnrollmentDetermination().setPrimaryEligiblity(null);        
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }           
    
    /**
	 * 13 checkCERejectTable13
	 * 
	 * IF pristine=[Purple Heart Indicator = Yes] AND calculated=[PH Indicator =
	 * No] THEN 
	 * reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true 
	 * ENDIF
	 * 
	 */
    public void test9803CERejectRule13() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        
        this.attachPurpleHeartWithPHStatusPending(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        Person incoming = savePerson(onFile); 
        incoming.getPurpleHeart().setPhIndicator(Boolean.FALSE);
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }              

    
    /**
	 * 14 checkCERejectTable14
	 * 
	 * IF pristine=[POW Indicator = Yes] AND calculated=[POW = Not Yes] THEN
	 * reject enrollment (sub priority e or g) recheckRejectionStatusFor8Band8D =
	 * true ENDIF
	 * 
	 * 
	 */
    public void test9803CERejectRule14() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        
        this.attachPrisonerOfWar(onFile, null, null);
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        Person incoming = savePerson(onFile); 
        incoming.getPrisonerOfWar().setPowIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }        
    

    /**
	 * 15 checkCERejectTable15
	 * 
	 * IF pristine=[CV End Date Populated] AND calculated=[CV End Date is
	 * Removed] THEN 
	 * reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true 
	 * ENDIF
	 * 
	 */
    public void test9803CERejectRule15() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        
        this.attachConflictExperience(onFile, this.getDate(2010, 5, 23));
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        Person incoming = savePerson(onFile); 
        incoming.getMilitaryService().setCombatVeteranEligibilityEndDate(null);
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }            
    /**
	 * 16 checkCERejectTable16
	 * 
	 * IF pristine=[Discharged due to Disability = Yes] AND
	 * calculated=[Discharged due to Disability = Not Yes] THEN 
	 * reject  * enrollment (sub priority e or g) 
	 * recheckRejectionStatusFor8Band8D = true
	 * ENDIF
	 */
    public void test9803CERejectRule16() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        
        this.attachDischargeDueToDisability(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        Person incoming = savePerson(onFile); 
        incoming.getMilitaryService().setDischargeDueToDisability(Boolean.FALSE);
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }        
    
    /**
	 * 17 checkCERejectTable17
	 * 
	 * IF pristine=[Military Disability Retirement = Yes] AND
	 * calculated=[Military Disability Retirement = No] THEN 
	 * reject enrollment
	 * (sub priority e or g) recheckRejectionStatusFor8Band8D = true 
	 * ENDIF
	 * 
	 */
    public void test9803CERejectRule17() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        
        this.attachMilitaryRetirementInLieuOfVaCompensation(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        Person incoming = savePerson(onFile); 
        incoming.getMilitaryService().setDisabilityRetirementIndicator(Boolean.FALSE);
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }         
    

    /**
	 * 18 checkCERejectTable18
	 * 
	 * IF pristine=[Catastrophic Disability = Yes] AND calculated=[Catastrophic
	 * Disability = Not Yes] THEN 
	 * reject enrollment (sub priority e or g)
	 * recheckRejectionStatusFor8Band8D = true 
	 * ENDIF
	 * 
	 */
    public void test9803CERejectRule18() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        
        this.attachCatastrophicDisability(onFile);
        this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);              
        Person incoming = savePerson(onFile); 
        incoming.removeAllClinicalDeterminations();
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
    }      
    
    
    private void processCERejectRule6(Person onFile) throws Exception {
        Person incoming = savePerson(onFile); 
        incoming.getRadiationExposure().setExposureMethod(
        		this.getLookupService().getRadiationExposureMethodByCode(RadiationExposureMethod.CODE_UNDERGROUND_NUCLEAR_TESTING.getCode()));
        Person result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);
        
        incoming.getRadiationExposure().setExposureMethod(
        		this.getLookupService().getRadiationExposureMethodByCode(RadiationExposureMethod.CODE_EXPOSURE_AT_NUCLEAR_FACILITY.getCode()));
        result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);        
        
        incoming.getRadiationExposure().setExposureMethod(
        		this.getLookupService().getRadiationExposureMethodByCode(RadiationExposureMethod.CODE_OTHER.getCode()));
        result = calculate(incoming);
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_G);        
    	
    }
    
    public void test9803CreatePerson8D_forRecheckRule() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachAgentOrangeExposure(onFile);
        onFile.getAgentOrangeExposure().setLocation(this.getLookupService().getAgentOrangeExposureLocationByCode(
        		AgentOrangeExposureLocation.CODE_VIETNAM.getCode()));
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(getDate(2010,1,1));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2009));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        onFile.setIncomeTest(new Integer(2009), incomeTest);
        incomeTest.setEffectiveDate(getDate(2009,8,1));
        incomeTest.setTotalIncome(new BigDecimal(1011));
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_6.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(null);        
        Person incoming = savePerson(onFile); 
        this.setComplete();        
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }               
    public void test9803CreatePerson8B_forRecheckRule() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachAgentOrangeExposure(onFile);
        onFile.getAgentOrangeExposure().setLocation(this.getLookupService().getAgentOrangeExposureLocationByCode(
        		AgentOrangeExposureLocation.CODE_VIETNAM.getCode()));
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(getDate(2010,1,1));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2009));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        onFile.setIncomeTest(new Integer(2009), incomeTest);
        incomeTest.setEffectiveDate(getDate(2009,8,1));
        incomeTest.setTotalIncome(new BigDecimal(1011));
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_6.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(null);
        this.attachServiceConnectionAward(onFile,new Integer(0));
        this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(0));        
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.SC_LESS_THAN_50_PERCENT.getCode()));
        e.setPrimary();    
   onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);        
        Person incoming = savePerson(onFile); 
        this.setComplete();        
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }               
    
    
    public void test9803CERejectRule3CreatePerson8B() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachAgentOrangeExposure(onFile);
        onFile.getAgentOrangeExposure().setLocation(this.getLookupService().getAgentOrangeExposureLocationByCode(
        		AgentOrangeExposureLocation.CODE_VIETNAM.getCode()));
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(getDate(2010,1,1));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2009));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1000));
        incomeTest.setThresholdA(new BigDecimal(1010));
        onFile.setIncomeTest(new Integer(2009), incomeTest);
        incomeTest.setEffectiveDate(getDate(2009,8,1));
        incomeTest.setTotalIncome(new BigDecimal(1011));
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);
        Person incoming = savePerson(onFile); 
        this.setComplete();        
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }               
    
    
    public void testIsEnrollmentPriorityEqualTo8A_ProducesNullPriority() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person

        // case 2
        this.attachApplication(onFile);        

        this.attachServiceConnectionAward(onFile, new Integer(0));
        this.attachMeansTestWithMtStatusPendingAdjudication(onFile,
                new BigDecimal(999), new BigDecimal(1000));       
        this.setEligibilityStatusToVerified(onFile);
        this.attachAidAndAttendance(onFile);
        this.attachVerifiedEnrollment(onFile); // make existing person              
        Person incoming = savePerson(onFile); 
        this.getPersonHelperService().removeAABenefit(incoming);        
        Person result = calculate(incoming);

        //Examine the log to see the 8A - gets made 8E since not CE (the AA was not really persisted to DB)
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_E);
    }    

    public void testEnrollmentPriority() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person

        // case 2
        this.attachApplication(onFile);        
        this.attachServiceConnectionAward(onFile, new Integer(0));
        this.attachMeansTestWithMtStatusPendingAdjudication(onFile,
                new BigDecimal(999), new BigDecimal(1000));       
        this.setEligibilityStatusToVerified(onFile);
        this.attachVerifiedEnrollment(onFile); // make existing person
        Eligibility e1 = new Eligibility();
        e1.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.NSC.getCode()));
        e1.setPrimary();
        Eligibility e2 = new Eligibility();
        e2.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.NSC.getCode()));
        e2.setPrimary();
        Eligibility e3 = new Eligibility();
        e3.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.NSC_VA_PENSION.getCode()));
        e3.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e1);        
        onFile.getEnrollmentDetermination().addSecondaryEligibility(e2);
        onFile.getEnrollmentDetermination().addSecondaryEligibility(e3);
        Person incoming = savePerson(onFile); 
   
        Person result = calculate(incoming);

        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_A);
    }        
    
    /**
     * if the primary eligibility code is NSC and means test status is MT copay
     * required or if primary eligibility code is NSC and Means test status is
     * equal to pending adjudication and GMT threshold is less than or equal
     * to MT threshold then set the enrollment priority equal to Priority 8C
     * 
     * @throws Exception
     */
    public void testIsEnrollmentPriorityEqualTo8C() throws Exception {
        //20001872
        Person incoming = this.getPerson("232296");
        this.attachMeansTestWithMtStatusPendingAdjudication(incoming,
                new BigDecimal(1000), new BigDecimal(1000));        
        incoming.setServiceConnectionAward(null);
        incoming.setMonetaryBenefitAward(null);        
        Person result = calculate(incoming);
        EnrollmentDetermination enrollmentDetermination = this.getEnrollmentDetermination(result);  

        assertNotNull("enrollment determination s/b non-null",
                enrollmentDetermination);
        assertEquals(enrollmentDetermination.getPrimaryEligibility().getType()
                .getCode(), EligibilityType.NSC.getName());
        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);
//
//        this.attachMeansTestWithMtStatusPendingAdjudication(onFile,
//                new BigDecimal(1000), new BigDecimal(1000));
//        incoming = savePerson(onFile);
//        this.getPersonHelperService().removeAABenefit(incoming);        
//        result = calculate(incoming);
//        enrollmentDetermination = this.getEnrollmentDetermination(result);  
//        assertNotNull("enrollment determination s/b non-null",
//                enrollmentDetermination);
//        assertEquals(enrollmentDetermination.getPrimaryEligibility().getType()
//                .getCode(), EligibilityType.NSC.getName());
//        assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_8);
//        assessPrioritySubGroupResult(result, EnrollmentPrioritySubGroup.SUBGROUP_C);
    }    
     

    
    public void testNotEligibleRefusedToPay() throws Exception {
    	Person onFile = buildSimplePerson(); // bare-bones person

    	IncomeTest it = createIncomeTest(IncomeTestType.CODE_MEANS_TEST,
    			MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
    	it.setAgreesToPayDeductible(Boolean.FALSE);
    	it.setDiscloseFinancialInformation(Boolean.FALSE);

    	onFile.setIncomeTest(new Integer(2008), it);
        this.attachMilitaryService(onFile);
        this.setEligibilityStatusToVerified(onFile);
        onFile.getEligibilityVerification().setAacIndicator(
                this.getLookupService().getAACIndicatorByCode(
                        AACIndicator.CODE_DATA_ACCEPTED.getName()));
        this.attachVerifiedEnrollment(onFile);

        Person incoming = this.savePerson(onFile);

        incoming.getEligibilityVerification().setVerificationFacility(
                this.getRandomVAFacility());
        this.addPermanentAddress(incoming, Calendar.getInstance().getTime(),
                null);
        VerificationInfo vi = new VerificationInfo();
      
        vi.setSiteNumber(incoming.getEligibilityVerification()
                .getVerificationFacility().getCode());
        Person updated = this.getMessagingService().processZ07(incoming,
                this.getRandomVAFacility(), vi);
        assertTrue(updated.getEligibilityVerification().getEligibilityStatus()
                .getCode().equals(EligibilityStatus.CODE_VERIFIED.getName()));
    
    }    

    
    protected Person calculate(Person person) throws Exception {
        return this.getEligibilityEnrollmentService().assessEEImpact(person, true);
    }
    
    public void createContinuousEnrolledPerson() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(getDate(2000,1,1));
        this.attachMeansTestWithMtCopayRequired(onFile, new BigDecimal(
                1000), new BigDecimal(1000));
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        it.setEffectiveDate(getDate(2000,12,1)); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }
    
    public void createP8Rule8dPerson() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(getDate(2010,1,1));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setThresholdA(new BigDecimal(1000));
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        incomeTest.setEffectiveDate(getDate(2009,8,1));
        incomeTest.setTotalIncome(new BigDecimal(1011));
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_D.getCode()));
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.NSC.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);        
        System.out.println("total income=" + it.getTotalIncome().toString() + " debt=" + it.getDeductibleExpenses() );   
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }
    
   
    
    public void createP8Rule8cPersonToG() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(getDate(2006,1,1));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(39000));
        incomeTest.setThresholdA(new BigDecimal(41000));
        incomeTest.setTotalIncome(new BigDecimal(60000));        
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        it.setEffectiveDate(getDate(2009,1,1)); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        this.attachServiceConnectionAward(onFile, new Integer(0));
 //       EnrollmentPriorityGroup
//        EnrollmentPrioritySubGroup
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_C.getCode()));
        onFile.getEnrollmentDetermination().setEffectiveDate(getDate(2006,1,1));
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }
    
    public void createP8Rule8cPersonToG_nothing() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(getDate(2006,1,1));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(39000));
        incomeTest.setThresholdA(new BigDecimal(41000));
        incomeTest.setTotalIncome(new BigDecimal(60000));        
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        it.setEffectiveDate(getDate(2009,1,1)); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);

        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_C.getCode()));
        onFile.getEnrollmentDetermination().setEffectiveDate(getDate(2006,1,1));
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }        
    
    public void createP8Rule8cPersonForRows30abWithCE() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1000));
        incomeTest.setThresholdA(new BigDecimal(1000));
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        it.setEffectiveDate(getDate(2009,1,1)); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_4.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(null);
        onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
        this.attachAidAndAttendance(onFile); // Need to remove this in 30ab so that 8c can be achieved. This allows case to be CE
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.AID_AND_ATTENDANCE.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }        
    
    public void createP8Rule8BPerson() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        Date useThisDate = getDate(2010,1,1);
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2009));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_HEC.getCode()));        
        incomeTest.setTotalIncome(new BigDecimal(1011));      
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        incomeTest.setPrimaryIncomeTest(Boolean.TRUE);
        onFile.setIncomeTest(new Integer(2009), incomeTest);
        this.attachServiceConnectionAward(onFile,new Integer(0));
        this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(0));        
  
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        // Current day        
        it.setEffectiveDate(useThisDate); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_B.getCode()));
        // Current day
        onFile.getEnrollmentDetermination().setEffectiveDate(useThisDate);
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.SC_LESS_THAN_50_PERCENT.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);
        Person incoming = savePerson(onFile);
        this.setComplete();
        
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }

    public void createP8Rule8BCleanupPerson() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        incomeTest.setTotalIncome(new BigDecimal(1011));      
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        this.attachServiceConnectionAward(onFile,new Integer(0));
        this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(0));        
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        // Current day        
        it.setEffectiveDate(new Date()); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_A.getCode()));
        // Current day
        onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.SC_LESS_THAN_50_PERCENT.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }
    
    
    public void createInvalid8BPerson() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        // KEY
        incomeTest.setTotalIncome(new BigDecimal(100011));      
        // KEY
        incomeTest.setDiscloseFinancialInformation(Boolean.FALSE);
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        this.attachServiceConnectionAward(onFile,new Integer(0));
        this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(0));        
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        // Current day        
        it.setEffectiveDate(new Date()); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_B.getCode()));
        // Current day
        onFile.getEnrollmentDetermination().setEffectiveDate(getDate(2009,1,1));
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.SC_LESS_THAN_50_PERCENT.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }
     
    
    public void createP8Rule8B_ForRecheck() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        incomeTest.setTotalIncome(new BigDecimal(1011));    
        incomeTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        this.attachServiceConnectionAward(onFile,new Integer(0));
        this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(0));        
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        // Current day        
        it.setEffectiveDate(new Date()); 
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_E.getCode()));
        onFile.getEnrollmentDetermination().setEnrollmentStatus(
        		this.getLookupService().getEnrollmentStatusByCode(EnrollmentStatus.CODE_REJECTED_BELOW_ENROLLMENT_GROUP_THRESHOLD.getCode()));
        // Current day
        onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }
    
    public void createP8RuleWithPre2008_ForRecheck() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2007));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        incomeTest.setTotalIncome(new BigDecimal(1011));        
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);        
        onFile.setIncomeTest(new Integer(2007), incomeTest);
        this.attachServiceConnectionAward(onFile,new Integer(0));
        this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(0));        
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        // Current day        
        it.setEffectiveDate(new Date()); 
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_E.getCode()));
        onFile.getEnrollmentDetermination().setEnrollmentStatus(
        		this.getLookupService().getEnrollmentStatusByCode(EnrollmentStatus.CODE_REJECTED_BELOW_ENROLLMENT_GROUP_THRESHOLD.getCode()));
        // Current day
        onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }        
    
    public void createP8RuleWithPre2008_ForRecheck2() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION, new Integer(2007));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1012));
        incomeTest.setTotalIncome(new BigDecimal(1015));        
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);        
        onFile.setIncomeTest(new Integer(2007), incomeTest);
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        // Current day        
        it.setEffectiveDate(new Date()); 
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_G.getCode()));
        onFile.getEnrollmentDetermination().setEnrollmentStatus(
        		this.getLookupService().getEnrollmentStatusByCode(EnrollmentStatus.CODE_REJECTED_BELOW_ENROLLMENT_GROUP_THRESHOLD.getCode()));
        // Current day
        onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }            
    
    public void createP8_8B_WithoutPriorEnrollment() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        incomeTest.setTotalIncome(new BigDecimal(1011));
        incomeTest.setDeductibleExpenses(new BigDecimal(0));        
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        this.attachServiceConnectionAward(onFile,new Integer(0));
        this.attachMonetaryBenefitAward(onFile);
        onFile.getMonetaryBenefitAward().setCheckAmount(new BigDecimal(0));        
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        // Current day        
        it.setEffectiveDate(new Date()); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);  
     
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setEnrollmentStatus(
        		this.getLookupService().getEnrollmentStatusByCode(EnrollmentStatus.CODE_VERIFIED.getCode()));
      //  onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
      //  onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_A.getCode()));
          onFile.getEnrollmentDetermination().setPriorityGroup(null);
          onFile.getEnrollmentDetermination().setPrioritySubGroup(null);

        // Current day
        onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.SC_LESS_THAN_50_PERCENT.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }                
    
    public void createP8_8D_WithoutPriorEnrollment() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        incomeTest.setTotalIncome(new BigDecimal(1011));
        incomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        // Current day        
        it.setEffectiveDate(new Date()); // KEY DATE!!!!

        this.setEligibilityStatusToVerified(onFile);  
     
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setEnrollmentStatus(
        		this.getLookupService().getEnrollmentStatusByCode(EnrollmentStatus.CODE_REJECTED_BELOW_ENROLLMENT_GROUP_THRESHOLD.getCode()));
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_8.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(this.getLookupService().getEnrollmentPrioritySubGroupByCode(EnrollmentPrioritySubGroup.SUBGROUP_G.getCode()));
        // Current day
        onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.NSC.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }                    
    
    public void createP8Rule8APersonCE() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        incomeTest.setTotalIncome(new BigDecimal(70000));
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        
        this.attachServiceConnectionAward(onFile,new Integer(0));
        onFile.getServiceConnectionAward().addRatedDisability(this.createRatedDisability());
        
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        
        // Current day        
        it.setEffectiveDate(new Date()); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_4.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(null);
        
        // Current day
        onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.AID_AND_ATTENDANCE.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }        
    
    public void createP8Rule15AndRule151() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        IncomeTest goodTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT, new Integer(2009));
        goodTest.setAgreesToPayDeductible(Boolean.TRUE);
        goodTest.setGmtThresholdAmount(new BigDecimal(1010));
        goodTest.setThresholdA(new BigDecimal(1000));
        goodTest.setTotalIncome(new BigDecimal(100011));
        goodTest.setDiscloseFinancialInformation(Boolean.TRUE);
        goodTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VAMC.getCode()));        
        onFile.setIncomeTest(new Integer(2009), goodTest);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_5.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(null);
        
        // Current day
        onFile.getEnrollmentDetermination().setEffectiveDate(new Date());
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.NSC.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }        
    
    public void createP8Rule8cPersonCE() throws Exception {
        Person onFile = buildSimplePerson(); // bare-bones person
        this.attachApplication(onFile);
        onFile.getApplication().setApplicationDate(new Date());
        onFile.getApplication().setApplicationDate(getDate(2008,11,30));
        IncomeTest incomeTest = this.createIncomeTest(
                IncomeTestType.CODE_MEANS_TEST,
                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, new Integer(2008));
        incomeTest.setGmtThresholdAmount(new BigDecimal(1010));
        incomeTest.setThresholdA(new BigDecimal(1000));
        incomeTest.setTotalIncome(new BigDecimal(60000));     
        onFile.setIncomeTest(new Integer(2008), incomeTest);
        
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(onFile);
        it.setEffectiveDate(getDate(2009,1,1)); // KEY DATE!!!!
        it.setAgreesToPayDeductible(Boolean.TRUE);
        this.setEligibilityStatusToVerified(onFile);        
        this.attachVerifiedEnrollment(onFile);
        onFile.getEnrollmentDetermination().setPriorityGroup(this.getLookupService().getEnrollmentPriorityGroupByCode(EnrollmentPriorityGroup.GROUP_4.getCode()));
        onFile.getEnrollmentDetermination().setPrioritySubGroup(null);
        onFile.getEnrollmentDetermination().setEffectiveDate(getDate(2008,11,30));
        
        this.attachAidAndAttendance(onFile); // Need to remove this in Test since allows case to be CE
        Eligibility e = new Eligibility();
        e.setType(this.getLookupService().getEligibilityTypeByCode(EligibilityType.AID_AND_ATTENDANCE.getCode()));
        e.setPrimary();        
        onFile.getEnrollmentDetermination().setPrimaryEligiblity(e);        
        
        Person incoming = savePerson(onFile);
        this.setComplete();
        System.out.println("Person id=" + incoming.getPersonEntityKey().getKeyValueAsString());        
    }    
   
}
