package gov.va.med.esr.common.rule.service;



// Java classes

// Library classes

// Framework classes

// ESR classes
import java.util.ArrayList;
import java.util.List;

import gov.va.med.fw.service.jms.QueueDescriptor;
import gov.va.med.fw.service.jms.QueueMessageProducerService;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.common.rule.parameter.CommunicationsInputParameter;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.esr.service.trigger.LetterTrigger;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;

public class CommsTriggersTest extends RuleAbstractTestCase {

    String server= "t3://localhost:7001";
    String context="weblogic.jndi.WLInitialContextFactory";
//    String factory="Edb.jms.connectionFactory.EdbConnFactory";
    String factory="esr.jms.connectionFactory.EventConnFactory";
    String queue="Edb.jms.queue.CommonEventQueue";

    public CommsTriggersTest(String testName) {
        super(testName);
        // TODO Auto-generated constructor stub
    }

    public void testLetterTriggers()throws Exception {
        CommunicationsInputParameter cip = new CommunicationsInputParameter();
        Person onFile = this.buildPerson();
        Person incoming = this.getPersonService().save(onFile);
        PersonInputData pid = new PersonInputData(incoming, incoming, true);
        cip.setRuleDataAware(pid);
        cip.trigger600CLetter();
       
        logger.info("Completed Test");
    }
    
    public void test290LetterPerformance() throws Exception {
        
        QueueMessageProducerService messageProducer = new QueueMessageProducerService();
        messageProducer.setDescriptor(getJMSDescriptor());

        ComLetterTemplateType type = this.getLookupService().getComLetterTemplateTypeByCode(
                ComLetterTemplateType.FORM_NUMBER_290.getName());
        
        for (int i =0; i< 200; i++)
        {
            LetterTriggerEvent lte = new LetterTriggerEvent(type,
                    LetterTrigger.CategoryType.VETERAN_LETTER);

            lte.setMailType(LetterTriggerEvent.AUTO_MAIL);
            lte.setPersonId(CommonEntityKeyFactory.createVPIDEntityKey(vpids[i]));
            messageProducer.send(lte,
                    lte.getRoutingProperties());
            
        }

    }
    private static final String[] vpids = new String[]
                                                     {   
              "0000000000000001V598038000000",
              "0000001000210017V228032000000",
              "0000002000000000V074812000000",
              "0000002000000001V143771000000",
              "0000002000000002V309600000000",
              "0000002000000003V488129000000",
              "0000002000000004V691444000000",
              "0000002000000005V727396000000",
              "0000002000000006V955288000000",
              "0000002000000007V830033000000",
              "0000002000000008V562565000000",
              "0000002000000009V216957000000",
              "0000002000000010V819288000000",
              "0000002000000011V578033000000",
              "0000002000000012V241565000000",
              "0000002000000013V007957000000",
              "0000002000000014V185812000000",
              "0000002000000015V390771000000",
              "0000002000000016V422600000000",
              "0000002000000017V656129000000",
              "0000002000000018V734444000000",
              "0000002000000019V963396000000",
              "0000002000000020V138124000000",
              "0000002000000021V361446000000",
              "0000002000000022V417398000000",
              "0000002000000023V675283000000",
              "0000002000000024V740035000000",
              "0000002000000025V902567000000",
              "0000002000000026V886952000000",
              "0000002000000027V594811000000",
              "0000002000000028V223770000000",
              "0000002000000029V059609000000",
              "0000002000000030V907370000000",
              "0000002000000031V885209000000",
              "0000002000000032V590024000000",
              "0000002000000033V222546000000",
              "0000002000000034V056998000000",
              "0000002000000035V134883000000",
              "0000002000000036V363735000000",
              "0000002000000037V419667000000",
              "0000002000000038V678152000000",
              "0000002000000039V741411000000",
              "0000002000000040V682531000000",
              "0000002000000041V796960000000",
              "0000002000000042V924859000000",
              "0000002000000043V853714000000",
              "0000002000000044V539676000000",
              "0000002000000045V268108000000",
              "0000002000000046V011423000000",
              "0000002000000047V177345000000",
              "0000002000000048V345297000000",
              "0000002000000049V400082000000",
              "0000002000000050V455945000000",
              "0000002000000051V630897000000",
              "0000002000000052V762782000000",
              "0000002000000053V916631000000",
              "0000002000000054V874160000000",
              "0000002000000055V543459000000",
              "0000002000000056V209314000000",
              "0000002000000057V088276000000",
              "0000002000000058V191008000000",
              "0000002000000059V327523000000",
              "0000002000000060V361496000000",
              "0000002000000061V417388000000",
              "0000002000000062V675233000000",
              "0000002000000063V740065000000",
              "0000002000000064V902557000000",
              "0000002000000065V886912000000",
              "0000002000000066V594871000000",
              "0000002000000067V223700000000",
              "0000002000000068V059629000000",
              "0000002000000069V138144000000",
              "0000002000000070V293003000000",
              "0000002000000071V029525000000",
              "0000002000000072V158947000000",
              "0000002000000073V331892000000",
              "0000002000000074V467781000000",
              "0000002000000075V615630000000",
              "0000002000000076V770169000000",
              "0000002000000077V942454000000",
              "0000002000000078V806316000000",
              "0000002000000079V584278000000",
              "0000002000000080V520769000000",
              "0000002000000081V252654000000",
              "0000002000000082V036116000000",
              "0000002000000083V164478000000",
              "0000002000000084V313303000000",
              "0000002000000085V479225000000",
              "0000002000000086V648047000000",
              "0000002000000087V701592000000",
              "0000002000000088V987981000000",
              "0000002000000089V895830000000",
              "0000002000000090V746657000000",
              "0000002000000091V904112000000",
              "0000002000000092V883471000000",
              "0000002000000093V599300000000",
              "0000002000000094V228229000000",
              "0000002000000095V051044000000",
              "0000002000000096V137596000000",
              "0000002000000097V365988000000",
              "0000002000000098V410833000000",
              "0000002000000099V672765000000",
              "0000002000000100V118794000000",
              "0000002000000101V371686000000",
              "0000002000000102V447138000000",
              "0000002000000103V605463000000",
              "0000002000000104V780355000000",
              "0000002000000105V992217000000",
              "0000002000000106V826072000000",
              "0000002000000107V554501000000",
              "0000002000000108V233920000000",
              "0000002000000109V069849000000",
              "0000002000000110V937600000000",
              "0000002000000111V865129000000",
              "0000002000000112V510444000000",
              "0000002000000113V272396000000",
              "0000002000000114V046288000000",
              "0000002000000115V104033000000",
              "0000002000000116V383565000000",
              "0000002000000117V499957000000",
              "0000002000000118V628812000000",
              "0000002000000119V751771000000",
              "0000002000000120V602861000000",
              "0000002000000121V786750000000",
              "0000002000000122V994619000000",
              "0000002000000123V823174000000",
              "0000002000000124V559406000000",
              "0000002000000125V238328000000",
              "0000002000000126V061243000000",
              "0000002000000127V117095000000",
              "0000002000000128V375587000000",
              "0000002000000129V440932000000",
              "0000002000000130V485255000000",
              "0000002000000131V690017000000",
              "0000002000000132V722572000000",
              "0000002000000133V956901000000",
              "0000002000000134V834820000000",
              "0000002000000135V563749000000",
              "0000002000000136V219694000000",
              "0000002000000137V078186000000",
              "0000002000000138V141438000000",
              "0000002000000139V307363000000",
              "0000002000000140V351116000000",
              "0000002000000141V437478000000",
              "0000002000000142V665303000000",
              "0000002000000143V710225000000",
              "0000002000000144V972047000000",
              "0000002000000145V846592000000",
              "0000002000000146V504981000000",
              "0000002000000147V283830000000",
              "0000002000000148V099769000000",
              "0000002000000149V128654000000",
              "0000002000000150V263383000000",
              "0000002000000151V019235000000",
              "0000002000000152V178067000000",
              "0000002000000153V341552000000",
              "0000002000000154V407911000000",
              "0000002000000155V685870000000",
              "0000002000000156V790709000000",
              "0000002000000157V922624000000",
              "0000002000000158V856146000000",
              "0000002000000159V534498000000",
              "0000002000000160V590529000000",
              "0000002000000161V222944000000",
              "0000002000000162V056896000000",
              "0000002000000163V134788000000",
              "0000002000000164V363633000000",
              "0000002000000165V419165000000",
              "0000002000000166V678457000000",
              "0000002000000167V741312000000",
              "0000002000000168V907271000000",
              "0000002000000169V885000000000",
              "0000002000000170V726977000000",
              "0000002000000171V954802000000",
              "0000002000000172V833721000000",
              "0000002000000173V569640000000",
              "0000002000000174V218199000000",
              "0000002000000175V071484000000",
              "0000002000000176V147336000000",
              "0000002000000177V305268000000",
              "0000002000000178V480053000000",
              "0000002000000179V692515000000",
              "0000002000000180V044432000000",
              "0000002000000181V103361000000",
              "0000002000000182V389250000000",
              "0000002000000183V498019000000",
              "0000002000000184V621574000000",
              "0000002000000185V757906000000",
              "0000002000000186V935828000000",
              "0000002000000187V860743000000",
              "0000002000000188V512695000000",
              "0000002000000189V276187000000",
              "0000002000000190V879048000000",
              "0000002000000191V548593000000",
              "0000002000000192V201985000000",
              "0000002000000193V087837000000",
              "0000002000000194V195762000000",
              "0000002000000195V320651000000",
              "0000002000000196V452110000000",
              "0000002000000197V636479000000"
              };

    private QueueDescriptor getJMSDescriptor() {

        QueueDescriptor jmsDescriptor = new QueueDescriptor();
        jmsDescriptor.setContextName(context);
        jmsDescriptor.setFactoryName(factory);
        List primary = new ArrayList();
        primary.add(server);
        jmsDescriptor.setProviderURLs(primary);
        jmsDescriptor.setQueueName(queue);
        return jmsDescriptor;
    }
    public void testBulletinTriggers()throws Exception {
        CommunicationsInputParameter cip = new CommunicationsInputParameter();
        Person onFile = this.buildPerson();
        this.attachPurpleHeartWithPHStatusPending(onFile);
        this.getPersonHelperService().getPurpleHeart(onFile).setPhIndicator(Boolean.FALSE);
        this.getPersonHelperService().getPurpleHeart(onFile).setRejectionRemark(this.getLookupService().getRejectionRemarkByCode("1"));
        Person incoming = this.getPersonService().save(onFile);
        PersonInputData pid = new PersonInputData(incoming, incoming, incoming, true);
        ((BaseParameter)cip).setHelperService(this.getPersonHelperService());
        ((BaseParameter)cip).setLookupService(this.getLookupService());        
        cip.setRuleDataAware(pid);
        cip.triggerHECReviewBulletin();
        cip.triggerDODDeletionBulletin();
        
        cip.triggerPurpleHeartIsNoBulletin();
        cip.triggerSendIneligibleInfoBulletin();
        cip.triggerVeteranNeedsVerificationBulletin();
        
        logger.info("Completed Test");
    }    
    
    
      
    
}
