/*
 * Created on Jan 9, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.rule.service;

import gov.va.med.esr.common.infra.TriState;
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDescriptor;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.lookup.CDDeterminationMethod;
import gov.va.med.esr.common.model.lookup.Condition;
import gov.va.med.esr.common.model.lookup.DescriptorType;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.MilitarySexualTraumaStatus;
import gov.va.med.esr.common.model.lookup.NTRVerificationMethod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.RuleAbstractTestCase;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.fw.service.ServiceException;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.math.BigDecimal;

/**
 * @author VHAIVMNgVS
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class ClinicalDeterminationRuleServiceTest extends
         RuleAbstractTestCase {
 



   public ClinicalDeterminationRuleServiceTest(String testName)
            throws Exception {
      super( testName );
   }
   
   
   public void testCDDescriptorFromDifferentDeterminingFacility() throws Exception {
       Person onFile = buildPerson();
       CatastrophicDisability oldCD = createCD();
       oldCD.setDecisionDate(this.getDate(2014,1,19));
       CDDeterminationMethod oldMethod= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW);
       oldCD.setDeterminationMethod(oldMethod);
       oldCD.setCatastrophicallyDisabled(Boolean.TRUE);
       VAFacility oldFacility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER);
       oldCD.setDeterminationFacility(oldFacility);
       onFile.addClinicalDetermination(oldCD);
       Person incoming = this.savePerson(onFile);

       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability cd = createCD();
       cd.setDecisionDate(this.getDate(2005,2,20));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);
       cd.setCatastrophicallyDisabled(Boolean.TRUE);
       VAFacility facility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_MICHAEL_E_DEBAKEY_VA_MEDICAL_CENTER);
       cd.setDeterminationFacility(facility);
       cd.addCDDescriptor(this.createCDDescriptor(DescriptorType.CODE_AMPUTATION_DISARTICULATION_DETACHMENT.getCode()));
       incoming.addClinicalDetermination(cd);
       
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,facility,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertTrue(veteranCD.isCatastrophicallyDisabled().booleanValue());
       assertNotSame(CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW,veteranCD.getDeterminationMethod().getCode());
       assertTrue(veteranCD.getCDDescriptors().size() > 0);
   }
   public void testCDDescriptorAfterConversionNoExistingCPD() throws Exception {
       Person onFile = buildPerson();
       Person incoming = this.savePerson(onFile);

       CatastrophicDisability cd = createCD();
       cd.setDecisionDate(this.getDate(2005,2,20));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);
       cd.setCatastrophicallyDisabled(Boolean.TRUE);
       VAFacility facility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_MICHAEL_E_DEBAKEY_VA_MEDICAL_CENTER);
       cd.setDeterminationFacility(facility);
       incoming.addClinicalDetermination(cd);
       this.getMessagingService().convertCDOnly(incoming);
       
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,facility,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertTrue(veteranCD.isCatastrophicallyDisabled().booleanValue());
       assertNotSame(CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW,veteranCD.getDeterminationMethod().getCode());
       assertTrue(veteranCD.getCDDescriptors().size() > 0);
       assertTrue(veteranCD.getConditions().size() > 0);
   }   
   
   
   public void testCCR10691WithMock() throws Exception {
		Person onFile = this.buildSimplePerson();
		
       this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
       this.setEligibilityStatusToVerified(onFile);
       this.attachCatastrophicDisability(onFile);        
       this.attachVerifiedEnrollment(onFile);              
       Person incoming = savePerson(onFile); 

       Person result = calculate(incoming);

	}
	
	public void testCCR10691BatchJob() throws Exception {
		// This data should have an expired income test and a CD=y that was created
		// by ESR release prior to ESR 3.5. This can be done by running 3.4 code.
		//PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("609"));
		//Person temp = this.getPerson("609");
		PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("3504"));
		Person temp = this.getPerson("3504");
		Person result = this.getClinicalDeterminationService().processCdForCleanup(personKey);
	//	assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_4);
	}	
	
	
	/*
	 * 
		MeansTestStatus meansTestStatus = incomeTest.getStatus();
					if (meansTestStatus != null &&
							!MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED.getName().equals(meansTestStatus.getCode()) &&
							!MeansTestStatus.MT_STATUS_NP_LONGER_APPLICABLE_RX_COPAY_ONLY.getName().equals(meansTestStatus.getCode()))  
	 */
	
	private Person runCCR10691BatchJob_FutureTest(Person onFile,MeansTestStatus.Code status, IncomeTestType.Code type) throws Exception {
		//Person onFile = this.buildSimplePerson();		   
		this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
		this.setEligibilityStatusToVerified(onFile);
		this.attachVerifiedEnrollment(onFile);
		this.attachCatastrophicDisability(onFile); // Key element
		onFile.setIncomeTest(new Integer(2010),	this.createIncomeTest(type,	status,new Integer(2010)));	
		
		IncomeTest test = onFile.getIncomeTest(new Integer(2010));
		test.setEffectiveDate(getDate(test.getIncomeYear().intValue()+1, 11, 23));
		test.setLastEditedDate(getDate(test.getIncomeYear().intValue()+1, 1, 25));
		test.setFutureTest(Boolean.TRUE);       
		Person incoming = savePerson(onFile);       
		return this.getClinicalDeterminationService().processCdForCleanup(incoming.getPersonEntityKey()); 
 	}
 			
	public void testCCR10691BatchJob_MT_future() throws Exception {
		Person onFile = this.buildSimplePerson();
		Person result = this.runCCR10691BatchJob_FutureTest(onFile, MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED,IncomeTestType.CODE_MEANS_TEST);
		assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_4);
		
		/*
		Person onFile = this.buildSimplePerson();		   
		this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
		this.setEligibilityStatusToVerified(onFile);
		this.attachVerifiedEnrollment(onFile);
		this.attachCatastrophicDisability(onFile);
		VAFacility fac= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER);
		attachIncomeTest(onFile, new Integer(2010), fac, MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED);
		IncomeTest test = onFile.getIncomeTest(new Integer(2010));
		test.setEffectiveDate(getDate(test.getIncomeYear().intValue()+1, 11, 23));
		test.setLastEditedDate(getDate(test.getIncomeYear().intValue()+1, 1, 25));
		test.setFutureTest(Boolean.TRUE);       
		Person incoming = savePerson(onFile);       
		Person result = this.getClinicalDeterminationService().processCdForCleanup(incoming.getPersonEntityKey()); 

		assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_4);
		*/
 	}
	public void testCCR10691BatchJob_MT_future_ignore() throws Exception {
		Person onFile = this.buildSimplePerson();
		Person result = this.runCCR10691BatchJob_FutureTest(onFile, MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED,IncomeTestType.CODE_MEANS_TEST);
		assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_4);
	}
	

	public void testCCR10691BatchJob_RX_future() throws Exception {
		Person onFile = this.buildSimplePerson();		   
		this.attachMeansTestWithMtCopayRequired(onFile,new BigDecimal(999), new BigDecimal(1000));
		
		this.setEligibilityStatusToVerified(onFile);
		this.attachVerifiedEnrollment(onFile);
		this.attachCatastrophicDisability(onFile);
		
		VAFacility fac= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER);
		
		// Future test
		onFile.setIncomeTest(new Integer(2010), this.createIncomeTest(
				IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST, 
				MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED, 
				new Integer(2010)));		
		IncomeTest test = onFile.getIncomeTest(new Integer(2010));
		test.setEffectiveDate(getDate(test.getIncomeYear().intValue()+1, 11, 23));
		test.setLastEditedDate(getDate(test.getIncomeYear().intValue()+1, 1, 25));
		test.setSiteConductingTest(fac);
		test.setFutureTest(Boolean.TRUE);       

		Person incoming = savePerson(onFile);       
		Person result = this.getClinicalDeterminationService().processCdForCleanup(incoming.getPersonEntityKey()); 

		assessPriorityResult(result, EnrollmentPriorityGroup.GROUP_4);
	}			
	
   /**
    * Incoming person has CD and person on file doesn't. The incoming person's CD will be 
    * added to the on file person.
    */
   public void testVeteranHasNoCatastrophicDisability() throws Exception 
   {
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(CatastrophicDisability.class);
       onFile = this.getPersonService().save(onFile);
            
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability cd = createCD();
       cd.setDecisionDate(this.getDate(2005,9,20));
       VAFacility facility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER);
       cd.setDeterminationFacility(facility);
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);
       incoming.addClinicalDetermination(cd);
       
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,facility,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertEquals(cd.isCatastrophicallyDisabled(),veteranCD.isCatastrophicallyDisabled());
       assertEquals(cd.getDeterminationMethod().getCode(),veteranCD.getDeterminationMethod().getCode());
   }
   
   public void testSavingCatastrophicDisabilityWithDescriptor() throws Exception {
	   //377143359
	   PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("377143359"));
	   Person onFile = this.getPersonService().getPerson(personKey);
	   CatastrophicDisability cdnew = createCatastrophicDisability(
				new Date(), new Date(), CDDeterminationMethod.CODE_AUTOMATED_RECORD_REVIEW.getCode(), "TESTER"); 	   
	   onFile.setCatastrophicDisability(cdnew);
	   this.attachVerifiedEnrollment(onFile);
	   CatastrophicDisability cd = onFile.getCatastrophicDisability();

	   cd.addCDDescriptor(createCDDescriptor(DescriptorType.CODE_AMPUTATION_DISARTICULATION_DETACHMENT.getCode()));
	   cd.addCDDescriptor(createCDDescriptor(DescriptorType.CODE_DEFICIENCIES_OF_PHYSICAL_OR_MENTAL_FUNCTION.getCode()));
	   cd.addCDDescriptor(createCDDescriptor(DescriptorType.CODE_DEAFNESS.getCode()));	   		       

	   Person result = savePerson(onFile);
	   CatastrophicDisability resultcd = result.getCatastrophicDisability();       
	   assertNotNull(resultcd);
	   assertTrue(resultcd.getCDDescriptors().size() == 3);
	   //setComplete();
   }   
   /**
    * Both incoming and on file person have CD. The Determining Site is same.
    */
   public void testOriginationSite() throws Exception 
   {
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(CatastrophicDisability.class);
       onFile.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability cd = createCD();
       VAFacility facility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER);
       cd.setDeterminationFacility(facility);
       cd.setDecisionDate(this.getDate(2005,9,20));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);
       onFile.addClinicalDetermination(cd);
       onFile = this.getPersonService().save(onFile);
            
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability newCD = createCD();
       VAFacility newFacility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER);
       newCD.setDeterminationFacility(newFacility);
       newCD.setDecisionDate(this.getDate(2005,9,10));
       CDDeterminationMethod newMethod= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW);
       newCD.setDeterminationMethod(newMethod);
       incoming.addClinicalDetermination(newCD);
       
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,facility,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertEquals(cd.isCatastrophicallyDisabled(),veteranCD.isCatastrophicallyDisabled());
       assertEquals(newCD.getDeterminationMethod().getCode(),veteranCD.getDeterminationMethod().getCode());
   }
   
   /**
    * Requirement 1710 #2
    * Conditions:
    * Incoming person has a CD with Indicator NO
    * On file person has a CD with Indicator YES
    * Determining facility is not same (not a Originating Site)
    * 
    * Result: Incoming data is ignored.
    */
   public void test1710ProcessCDDecisionTable_Rule2() throws Exception 
   {
       // Incoming person has CD and Veteran on file has no CD.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability oldCD = createCD();
       oldCD.setDecisionDate(this.getDate(2005,9,19));
       CDDeterminationMethod oldMethod= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW);
       oldCD.setDeterminationMethod(oldMethod);
       oldCD.setCatastrophicallyDisabled(Boolean.TRUE);
       VAFacility oldFacility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER);
       oldCD.setDeterminationFacility(oldFacility);
       onFile.addClinicalDetermination(oldCD);
       onFile = this.getPersonService().save(onFile);
            
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability cd = createCD();
       cd.setDecisionDate(this.getDate(2005,9,20));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);
       cd.setCatastrophicallyDisabled(Boolean.FALSE);
       VAFacility facility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_MICHAEL_E_DEBAKEY_VA_MEDICAL_CENTER);
       cd.setDeterminationFacility(facility);
       incoming.addClinicalDetermination(cd);
       
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,facility,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertTrue(veteranCD.isCatastrophicallyDisabled().booleanValue());
       assertNotSame(CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW,veteranCD.getDeterminationMethod().getCode());
   }
   
   public void test1710ProcessCDDecisionTable_Rule2_WithDescriptor() throws Exception {
       // Incoming person has CD and Veteran on file has no CD.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability oldCD = createCD();
       oldCD.setDecisionDate(this.getDate(2005,9,19));
       CDDeterminationMethod oldMethod= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW);
       oldCD.setDeterminationMethod(oldMethod);
       oldCD.setCatastrophicallyDisabled(Boolean.TRUE);
       VAFacility oldFacility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER);
       oldCD.setDeterminationFacility(oldFacility);
       onFile.addClinicalDetermination(oldCD);
       onFile = this.getPersonService().save(onFile);
            
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability cd = createCD();
       cd.setDecisionDate(this.getDate(2005,9,20));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);
       cd.setCatastrophicallyDisabled(Boolean.FALSE);
       VAFacility facility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_MICHAEL_E_DEBAKEY_VA_MEDICAL_CENTER);
       cd.setDeterminationFacility(facility);
       incoming.addClinicalDetermination(cd);
       // Add step to convert the CD data  
       this.getMessagingService().convertCDOnly(incoming);
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,facility,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertTrue(veteranCD.isCatastrophicallyDisabled().booleanValue());
       assertNotSame(CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW,veteranCD.getDeterminationMethod().getCode());
   }   
   
   /**
    * Conditions:
    * Incoming person has a CD with Indicator NO
    * On file person has a CD with Indicator YES
    * 
    * Result: Incoming data is ignored.
    */
   public void test1710ProcessCDDecisionTable_Rule3() throws Exception 
   {
       // Incoming person has CD and Veteran on file has no CD.
       Person onFile = buildPerson();
       CatastrophicDisability oldCD = createCD();
       oldCD.setDecisionDate(this.getDate(2005,9,19));
       CDDeterminationMethod oldMethod= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW);
       oldCD.setDeterminationMethod(oldMethod);
       onFile.addClinicalDetermination(oldCD);
       onFile = this.getPersonService().save(onFile);
            
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability cd = createCD();
       cd.setDecisionDate(this.getDate(2005,9,20));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);
       incoming.addClinicalDetermination(cd);
         
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,null,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertEquals(cd.isCatastrophicallyDisabled(),veteranCD.isCatastrophicallyDisabled());
       assertEquals(cd.getDeterminationMethod().getCode(),veteranCD.getDeterminationMethod().getCode());
   }
   public void test1710ProcessCDDecisionTable_Rule3_WithDescriptor() throws Exception {
       // Incoming person has CD and Veteran on file has no CD.
       Person onFile = buildPerson();
       CatastrophicDisability oldCD = createCD();
       oldCD.setDecisionDate(this.getDate(2005,9,19));
       CDDeterminationMethod oldMethod= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW);
       oldCD.setDeterminationMethod(oldMethod);
       onFile.addClinicalDetermination(oldCD);
       onFile = this.getPersonService().save(onFile);
            
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability cd = createCD();
       cd.setDecisionDate(this.getDate(2005,9,20));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);
       incoming.addClinicalDetermination(cd);
       // Add step to convert the CD data  
       this.getMessagingService().convertCDOnly(incoming);
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,cd.getDeterminationFacility(),null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertEquals(cd.isCatastrophicallyDisabled(),veteranCD.isCatastrophicallyDisabled());
       assertEquals(cd.getDeterminationMethod().getCode(),veteranCD.getDeterminationMethod().getCode());
   }
   public void test1710ProcessCDDecisionTable_Rule3_WithDescriptor_DifferentSite() throws Exception {
       // Incoming person has CD and Veteran on file has no CD.
       Person onFile = buildPerson();
       CatastrophicDisability oldCD = createCD();
       oldCD.setDecisionDate(this.getDate(2005,9,19));
       CDDeterminationMethod oldMethod= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW);
       oldCD.setDeterminationMethod(oldMethod);
       onFile.addClinicalDetermination(oldCD);
       onFile = this.getPersonService().save(onFile);
            
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       VAFacility facility = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_ALBUQUERQUE);
       CatastrophicDisability cd = createCD();
       cd.setDecisionDate(this.getDate(2005,9,20));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);
       incoming.addClinicalDetermination(cd);
       // Add step to convert the CD data  
       this.getMessagingService().convertCDOnly(incoming);
       
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile, facility, null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertEquals(cd.isCatastrophicallyDisabled(),veteranCD.isCatastrophicallyDisabled());
       // original should remain intact
       assertTrue(veteranCD.getDeterminationMethod().getCode().equals(CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW.getCode()));
   }
   public void test1710ProcessCDDecisionTable_Rule3_WithDescriptor_DifferentSite_NoChanges() throws Exception {
       // Incoming person has CD and Veteran on file has no CD.
       Person onFile = buildPerson();
       CatastrophicDisability oldCD = createCD();
       oldCD.setDecisionDate(this.getDate(2005,9,19));
       CDDeterminationMethod oldMethod= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW);
       oldCD.setDeterminationMethod(oldMethod);
       oldCD.addCDDescriptor(this.createCDDescriptor(DescriptorType.CODE_AMPUTATION_DISARTICULATION_DETACHMENT.getCode()));
       onFile.addClinicalDetermination(oldCD);
            
       Person incoming = savePerson(onFile);
       
       VAFacility facility = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_ALBUQUERQUE);
       CatastrophicDisability cd = incoming.getCatastrophicDisability();
       cd.setDecisionDate(this.getDate(2005,9,20));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);

       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile, facility, null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertEquals(cd.isCatastrophicallyDisabled(),veteranCD.isCatastrophicallyDisabled());
       // original should remain intact
       assertTrue(veteranCD.getDeterminationMethod().getCode().equals(CDDeterminationMethod.CODE_MEDICAL_RECORD_REVIEW.getCode()));
   }      
   /**
    * Incoming person has CD and person on file doesn't. A new CD is created with the incoming person's CD
    * and added to the on file person.
    */
   public void test1710ProcessCDDecisionTable_Rule4() throws Exception 
   {
       // Incoming person has CD and Veteran on file has no CD.
       Person onFile = buildPerson();
       CatastrophicDisability oldCD = createCD();
       oldCD.setDecisionDate(this.getDate(2005,9,19));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       oldCD.setDeterminationMethod(method);
       onFile.addClinicalDetermination(oldCD);
       onFile = this.getPersonService().save(onFile);
            
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability cd = createCD();
       cd.setDecisionDate(this.getDate(2005,9,20));
       cd.setDeterminationMethod(method);
       incoming.addClinicalDetermination(cd);
              
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,null,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertEquals(cd.isCatastrophicallyDisabled(),veteranCD.isCatastrophicallyDisabled());
       assertEquals(cd.getDeterminationMethod().getCode(),veteranCD.getDeterminationMethod().getCode());
   }
   
   /**
    * Incoming person has CD and person on file doesn't. A new CD is created with the incoming person's CD
    * and added to the on file person.
    */
   public void test1710ProcessCDDecisionTable_Rule4_WithDescriptor() throws Exception {
       // Incoming person has CD and Veteran on file has no CD.
       Person onFile = buildPerson();
       CatastrophicDisability oldCD = createCD();
       oldCD.setDecisionDate(this.getDate(2005,9,19));
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       oldCD.setDeterminationMethod(method);
       onFile.addClinicalDetermination(oldCD);
       onFile = this.getPersonService().save(onFile);
            
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       CatastrophicDisability cd = createCD();
       cd.setDecisionDate(this.getDate(2005,9,20));
       cd.setDeterminationMethod(method);
       incoming.addClinicalDetermination(cd);
       
       // Add step to convert the CD data  
       this.getMessagingService().convertCDOnly(incoming);
       
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,null,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertEquals(cd.isCatastrophicallyDisabled(),veteranCD.isCatastrophicallyDisabled());
       assertEquals(cd.getDeterminationMethod().getCode(),veteranCD.getDeterminationMethod().getCode());
   }   
   
   /**
    * Incoming person has CD and person on file doesn't. A new CD is created with the incoming person's CD
    * and added to the on file person.
    */
   public void test1710ProcessCDDecisionTable_Rule7() throws Exception 
   {
       // Incoming person has CD and Veteran on file has no CD.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(CatastrophicDisability.class);
       onFile = this.getPersonService().save(onFile);
       CatastrophicDisability onFileCD = createCD();
       VAFacility onFileFacility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER);
       onFileCD.setDeterminationFacility(onFileFacility);
       onFileCD.setCatastrophicallyDisabled(Boolean.FALSE);
       onFileCD.setDecisionDate(this.getDate(2005,9,20));
       onFile.addClinicalDetermination(onFileCD);
       
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       
       CatastrophicDisability cd = createCD();
       VAFacility facility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);
       onFileCD.setDeterminationFacility(facility);
       cd.setCatastrophicallyDisabled(Boolean.TRUE);
       cd.setDecisionDate(this.getDate(2005,9,20));
       incoming.addClinicalDetermination(cd);
       
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,facility,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertEquals(cd.getDeterminationMethod().getCode(),veteranCD.getDeterminationMethod().getCode());
   }
   
   public void test1710ProcessCDDecisionTable_Rule7_WithDescriptor() throws Exception {
       // Incoming person has CD and Veteran on file has no CD.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(CatastrophicDisability.class);
       onFile = this.getPersonService().save(onFile);
       CatastrophicDisability onFileCD = createCD();
       VAFacility onFileFacility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER);
       onFileCD.setDeterminationFacility(onFileFacility);
       onFileCD.setCatastrophicallyDisabled(Boolean.FALSE);
       onFileCD.setDecisionDate(this.getDate(2005,9,20));
       onFile.addClinicalDetermination(onFileCD);
       
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(CatastrophicDisability.class);
       
       CatastrophicDisability cd = createCD();
       VAFacility facility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);
       onFileCD.setDeterminationFacility(facility);
       cd.setCatastrophicallyDisabled(Boolean.TRUE);
       cd.setDecisionDate(this.getDate(2005,9,20));
       incoming.addClinicalDetermination(cd);
       // Add step to convert the CD data  
       this.getMessagingService().convertCDOnly(incoming);
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,facility,null);
       CatastrophicDisability veteranCD = (CatastrophicDisability)this.getPersonHelperService().getClinicalDetermination(CatastrophicDisability.class,updatedPerson);
       assertNotNull(veteranCD);
       assertEquals(cd.getDeterminationMethod().getCode(),veteranCD.getDeterminationMethod().getCode());
   }
   
   /**
    * Incoming person has MST and person on file doesn't. Incoming will be added to the on file person.
    */
   public void testHasMSTAndVeteranHasNoMST() throws Exception 
   {
       // Incoming person has MST and Veteran on file has no MST.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(MilitarySexualTrauma.class);
       onFile = this.getPersonService().save(onFile);
       
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(MilitarySexualTrauma.class);
       
       MilitarySexualTrauma mst = createMST();
       mst.setStatusChangeDate(this.getDate(2003,5,16));
       incoming.addClinicalDetermination(mst);
     
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,null,null);
       MilitarySexualTrauma veteranMST = (MilitarySexualTrauma)this.getPersonHelperService().getClinicalDetermination(MilitarySexualTrauma.class,updatedPerson);
       assertNotNull(veteranMST);
   }
   
   /**
    * Both the incoming and on file person has MST but the on file person's verification date is older. 
    * The on file person's MST will be updated with the incoming person's NTR.
    */
   public void testHasMSTAndVeteranHasOldMST() throws Exception 
   {
       // Incoming person has MST and Veteran on file has no MST.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(MilitarySexualTrauma.class);
       onFile = this.getPersonService().save(onFile);
       
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(MilitarySexualTrauma.class);
       
       MilitarySexualTrauma mst = createMST();
       mst.setStatusChangeDate(this.getDate(2002,5,16));
       incoming.addClinicalDetermination(mst);
       
       MilitarySexualTrauma oldMST = createMST();
       oldMST.setStatusChangeDate(this.getDate(2002,5,15));
       onFile.addClinicalDetermination(oldMST);
 
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,null,null);
       MilitarySexualTrauma veteranMST = (MilitarySexualTrauma)this.getPersonHelperService().getClinicalDetermination(MilitarySexualTrauma.class,updatedPerson);
       assertNotNull(veteranMST);
       assertEquals(mst,veteranMST);
   }
   
   /**
    * Both the incoming and on file person has MST but the on file person's verification date is newer. 
    * The on file person's MST will not be updated with the incoming person's MST.
    */
   public void testIsMSTVerificationDateGreaterThanVeteran() throws Exception 
   {
       // Incoming person has MST(older status change date date) and Veteran on file has an MST.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(MilitarySexualTrauma.class);
       onFile = this.getPersonService().save(onFile);
       
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(MilitarySexualTrauma.class);
       
       MilitarySexualTrauma mst = createMST();
       mst.setStatusChangeDate(this.getDate(1980,5,15));
       incoming.addClinicalDetermination(mst);
       
       MilitarySexualTrauma oldMST = createMST();
       oldMST.setStatusChangeDate(this.getDate(1980,5,16));
       onFile.addClinicalDetermination(oldMST);
        
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,null,null);
       MilitarySexualTrauma veteranMST = (MilitarySexualTrauma)this.getPersonHelperService().getClinicalDetermination(MilitarySexualTrauma.class,updatedPerson);
       assertEquals(oldMST,veteranMST);
   }
   
   /**
    * Incoming person has no MST but the person on file has an MST. The existing should not be removed.
    */
   public void testHasVeteranMSTAndNoHasMST() throws Exception 
   {
       // Incoming person has no MST and Veteran on file has an old MST.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(MilitarySexualTrauma.class);
       onFile = this.getPersonService().save(onFile);
       
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(MilitarySexualTrauma.class);
       
       MilitarySexualTrauma oldMST = createMST();
       oldMST.setStatusChangeDate(this.getDate(1999,5,16));
       onFile.addClinicalDetermination(oldMST);
        
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,null,null);
       MilitarySexualTrauma veteranMST = (MilitarySexualTrauma)this.getPersonHelperService().getClinicalDetermination(MilitarySexualTrauma.class,updatedPerson);
       assertNotNull(veteranMST);
   }
   
   /**
    * Incoming person has NTR and person on file doesn't. A new NTR is created with the incoming person's NTR 
    * and added to the on file person.
    */
   public void testHasNTRAndVeteranHasNoNTR() throws Exception 
   {
       // Incoming person has NTR and Veteran on file has no NTR.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(NoseThroatRadium.class);
       onFile = this.getPersonService().save(onFile);
       
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(NoseThroatRadium.class);
       
       incoming.addClinicalDetermination(createNTR());
        
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,null,null);
       NoseThroatRadium veteranNTR = (NoseThroatRadium)this.getPersonHelperService().getClinicalDetermination(NoseThroatRadium.class,updatedPerson);
       assertNotNull(veteranNTR);
   }
   
   /**
    * Both the incoming and on file person has NTR but the on file person's verification date is older. 
    * The on file person's NTR will be updated with the incoming person's NTR.
    */
   public void testHasNTRAndVeteranHasOldNTR() throws Exception 
   {
       // Incoming person has NTR and Veteran on file has an old NTR.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(NoseThroatRadium.class);
       onFile = this.getPersonService().save(onFile);
       
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(NoseThroatRadium.class);
       
       NoseThroatRadium ntr = createNTR();
       ntr.setVerificationDate(this.getDate(1970,5,16));
       incoming.addClinicalDetermination(ntr);
       
       NoseThroatRadium oldNTR = createNTR();
       oldNTR.setVerificationDate(this.getDate(1969,5,16));
       onFile.addClinicalDetermination(oldNTR);
       
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,null,null);
       NoseThroatRadium veteranNTR = (NoseThroatRadium)this.getPersonHelperService().getClinicalDetermination(NoseThroatRadium.class,updatedPerson);
       assertNotNull(veteranNTR);
       assertEquals(ntr,veteranNTR);
   }
   
   /**
    * Both the incoming and on file person has NTR but the on file person's verification date is newer. 
    * The on file person's NTR will not be updated with the incoming person's NTR.
    */
   public void testIsNTRVerificationDateGreaterThanVeteran() throws Exception 
   {
       // Incoming person has NTR(older verification date) and Veteran on file has an NTR.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(NoseThroatRadium.class);
       onFile = this.getPersonService().save(onFile);
       
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(NoseThroatRadium.class);
       
       NoseThroatRadium ntr = createNTR();
       ntr.setVerificationDate(this.getDate(1980,5,15));
       incoming.addClinicalDetermination(ntr);
       
       NoseThroatRadium oldNTR = createNTR();
       oldNTR.setVerificationDate(this.getDate(1980,5,16));
       onFile.addClinicalDetermination(oldNTR);
       VAFacility facility= (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_MICHAEL_E_DEBAKEY_VA_MEDICAL_CENTER);
       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,facility,null);
       NoseThroatRadium veteranNTR = (NoseThroatRadium)this.getPersonHelperService().getClinicalDetermination(NoseThroatRadium.class,updatedPerson);
       assertEquals(oldNTR,veteranNTR);
   }
   
   /**
    * Incoming person has no NTR but the person on file has an NTR. The existing will be removed.
    */
   public void testHasVeteranNTRAndNoHasNTR() throws Exception 
   {
       // Incoming person has no NTR and Veteran on file has an old NTR.
       Person onFile = buildPerson();
       onFile.removeClinicalDeterminationByType(NoseThroatRadium.class);
       NoseThroatRadium oldNTR = createNTR();
       oldNTR.setVerificationDate(this.getDate(1969,5,16));
       onFile.addClinicalDetermination(oldNTR);
       onFile = this.getPersonService().save(onFile);
       
       Person incoming = (Person)onFile.clone();
       incoming.removeClinicalDeterminationByType(NoseThroatRadium.class);

       Person updatedPerson = this.getClinicalDeterminationRuleService().processClinicalDetermination(incoming,onFile,null,null);
       NoseThroatRadium veteranNTR = (NoseThroatRadium)this.getPersonHelperService().getClinicalDetermination(NoseThroatRadium.class,updatedPerson);
       assertNull(veteranNTR);
   }

   protected void customSetUp() throws Exception 
   {
      super.customSetUp();
   }
   
   private void checkNTRinfo(Person personOnFile, String stationnumber,String verificationMethodCode) 
   {
     Set set = personOnFile.getClinicalDeterminations();
     assertEquals( set.size(), 1 );
     Iterator iter = set.iterator();
     Object obj = iter.next();
     if( obj instanceof NoseThroatRadium ) 
     {
        NoseThroatRadium ntr = (NoseThroatRadium) obj;
        assertEquals( ntr.getDeterminationFacility().getStationNumber(),stationnumber );
        assertEquals( ntr.getVerificationMethod().getCode(),verificationMethodCode );
        assertEquals( ntr.isFromAviatorServiceBefore1955().booleanValue(),true );
        assertEquals( ntr.isFromSubmarinerServiceBefore1965().booleanValue(),true );
     }
  }
   
   private CatastrophicDisability createCD() throws Exception {
       CatastrophicDisability cd = new CatastrophicDisability();
       cd.setCatastrophicallyDisabled(Boolean.TRUE);
       cd.setDecisionDate(this.getDate(2005,5,16));
       VAFacility facility = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);
       cd.setDeterminationFacility(facility);
       CDDeterminationMethod method= (CDDeterminationMethod)this.getLookupService().getByCode(CDDeterminationMethod.class,CDDeterminationMethod.CODE_PHYSICAL_EXAMINATION);
       cd.setDeterminationMethod(method);
       cd.setDeterminedBy("Tester");
       cd.setVeteranRequestedCDReviewDate(this.getDate(2005,6,10));
       cd.setFacilityInitiatedCDReviewDate(this.getDate(2005,6,11));
       cd.setReviewDate(this.getDate(2005,6,16));
       CDCondition c = new CDCondition(); 
       c.setCondition(this.getLookupService().getConditionByCode(Condition.CODE_FIM.getCode()));
       cd.addCondition(c);
       return cd;
   }
   
   private MilitarySexualTrauma createMST()
   throws Exception
   {
       MilitarySexualTrauma mst = new MilitarySexualTrauma();
       
       MilitarySexualTraumaStatus status = (MilitarySexualTraumaStatus)this.getLookupService().getByCode(MilitarySexualTraumaStatus.class,MilitarySexualTraumaStatus.CODE_SCREENED_REPORTS_MST);
       mst.setStatus(status);
       mst.setStatusChangeDate(this.getDate(1980,5,16));
       VAFacility facility = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);
       mst.setDeterminationFacility(facility);
      
       return mst;
   }
   
   private NoseThroatRadium createNTR()
   throws Exception
   {
       NoseThroatRadium ntr = new NoseThroatRadium();
       
       ntr.setVerificationDate(this.getDate(1970,5,16));
       
       NTRVerificationMethod method = (NTRVerificationMethod)this.getLookupService().getByCode(NTRVerificationMethod.class,NTRVerificationMethod.CODE_MILITARY_RECORD);
       ntr.setVerificationMethod(method);
       
       VAFacility facility = (VAFacility)this.getLookupService().getByCode(VAFacility.class,VAFacility.CODE_CONNECTICUT_HCS);
       ntr.setVerificationFacility(facility);
       
       ntr.setReceivingTreatment(TriState.TRUE);
       ntr.setFromAviatorServiceBefore1955(Boolean.TRUE);
       ntr.setFromSubmarinerServiceBefore1965(Boolean.FALSE);
       ntr.setDiagnosedWithCancer(Boolean.TRUE);
       ntr.setDiagnosisVerifiedDate(getDate(2000,1,20));
       
       return ntr;
   }

   private Person getPerson()
   throws Exception
   {
       Person person  = buildPerson();
       return this.getPersonService().save(person);
   }

}