package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase;
import gov.va.med.esr.common.rule.data.FinancialInputData;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.rule.SimpleRuleMethod;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.support.GenericApplicationContext;

public class FinancialInputParameterTest extends AbstractKeyedEntityDAOTestCase {

    private static final String TRANSACTION_TIMESTAMP_MANAGER_BEAN_NAME = "TransactionTimestampManager";

    private static final Integer CURRENT_INCOME_YEAR = new Integer(2007);

    private static final Integer FUTURE_INCOME_YEAR = new Integer(2008);

    private static final Date NOW = new Date();

    public void testIfConditionsMetMakeFutureTestEffectiveImmediately()
            throws Exception {
        // assert failure when no FDT found
        Person pristine = new Person();
        IncomeTest pristineIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        Person incomingPerson = new Person();
        IncomeTest incomingIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        incomingIncomeTest.setIncomeYear(CURRENT_INCOME_YEAR);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        Person resultPerson = new Person();
        IncomeTest resultIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        FinancialInputParameter financialInputParameter = createFinancialInputParameter(
                incomingPerson, resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        /*
         * Tests each individual IF statement in the method
         * IfConditionsMetMakeFutureTestEffectiveImmediately(). Attempting to
         * create method names that self documented the if statement being
         * tested produced extremely long method names with very low
         * readability. As a result, method names were numbered with comments
         * describing the if statement being tested. This is also not an ideal
         * scenario. No ordering is implied by numbering.
         * 
         */
        ifStmt1Test();
        ifStmt2Test();
        ifStmt3Test();
        ifStmt4Test();
        ifStmt5Test();
        ifStmt6Test();
        ifStmt7Test();
    }

    /*
     * else if the result test is of type Pharmacy Copay Test AND result test is <=
     * 365 days old AND result test Rx copay status is Non-Exempt AND the FDT is
     * of type Pharmacy Copay Test AND FDT Rx copay status is Exempt
     */
    private void ifStmt7Test() throws Exception {

        // assert success
        Person pristine = new Person();
        IncomeTest pristineIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        Person incomingPerson = new Person();
        IncomeTest incomingIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        Person resultPerson = new Person();
        IncomeTest resultIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST
                                        .getCode()), this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()), null);
        Calendar resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        FinancialInputParameter financialInputParameter = createFinancialInputParameter(
                incomingPerson, resultPerson, pristine);
        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());
        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());

        // assert failure due to the result test is not of type Pharmacy Copay
        // Test
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR,
                this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST
                                        .getCode()), this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test is not <= 365 days old
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, -390);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test Rx copay status is not Non-Exempt
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_CATEGORY_B
                                        .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT is of not type Pharmacy Copay Test
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR,
                this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST
                                        .getCode()), this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT Rx copay status not is Exempt
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_CATEGORY_B
                                        .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());
    }

    /*
     * Tests: else if the result test is of type means test AND result test is <=
     * 365 days old AND result test status is the same as FDT status AND result
     * test Rx copy status is Incomplete AND the FDT is of type means test AND
     * (FDT Rx copy status is Exempt OR FDT Rx copy status is NonExempt)
     */
    private void ifStmt6Test() throws Exception {

        // assert success FDT Rx copy status isExempt
        Person pristine = new Person();
        IncomeTest pristineIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        Person incomingPerson = new Person();
        IncomeTest incomingIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        Person resultPerson = new Person();
        IncomeTest resultIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        Calendar resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);

        FinancialInputParameter financialInputParameter = createFinancialInputParameter(
                incomingPerson, resultPerson, pristine);

        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());
        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());

        // assert success FDT Rx copy status is NonExempt

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());
        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());

        // assert failure due to result test is not of type means test

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_LTC_CO_PAY_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test not <=365

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, -390);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test status != FDT status

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_CATEGORY_B.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test Rx copay status not Incomplete

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_CATEGORY_B.getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT test is not of type means test

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_LTC_CO_PAY_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT Rx copay status not Exempt or Non Exempt

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_CATEGORY_B.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());
    }

    /*
     * Tests: else if the result test is of type means test AND result test is <=
     * 365 days old AND result test status is GMT copay required AND the FDT is
     * of type means test AND FDT status is MT Copay Exempt
     */
    private void ifStmt5Test() throws Exception {

        // assert success

        Person pristine = new Person();
        IncomeTest pristineIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        Person incomingPerson = new Person();
        IncomeTest incomingIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        Person resultPerson = new Person();
        IncomeTest resultIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED
                                        .getCode()), null);
        Calendar resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        FinancialInputParameter financialInputParameter = createFinancialInputParameter(
                incomingPerson, resultPerson, pristine);

        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());
        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());

        // assert failure due to result test not of type means test

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this
                .createIncomeTest(CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_LTC_CO_PAY_TEST.getCode()),
                        this.getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()),
                        this.getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED
                                        .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test not <= 365

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this
                .createIncomeTest(CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED
                                        .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, -390);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test status is GMT copay required

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_CATEGORY_B.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT is not of type means test

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR,
                this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST
                                        .getCode()), this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT
                                        .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this
                .createIncomeTest(CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED
                                        .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT status is not MT Copay Exempt

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_CATEGORY_B.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this
                .createIncomeTest(CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED
                                        .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

    }

    /*
     * Tests: else if the result test is of type means test AND result test is <=
     * 365 days old AND result test status is the same as FDT status AND result
     * test Rx copay status is Non-Exempt AND the FDT is of type means test AND
     * FDT Rx copay status is Exempt
     */
    private void ifStmt4Test() throws Exception {

        // assert success

        Person pristine = new Person();
        IncomeTest pristineIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        Person incomingPerson = new Person();
        IncomeTest incomingIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        Person resultPerson = new Person();
        IncomeTest resultIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        Calendar resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        FinancialInputParameter financialInputParameter = createFinancialInputParameter(
                incomingPerson, resultPerson, pristine);

        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());
        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());

        // assert failure due to result test not of type means test

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_LTC_CO_PAY_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test not <= 365

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, -400);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test status != FDT status

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_CATEGORY_B.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test Rx copay status is not Non-Exempt

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_CATEGORY_B.getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT not of type means test

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_LTC_CO_PAY_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_EXEMPT.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT Rx copay status is not Exempt

        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristineIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_CATEGORY_B.getCode()));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY
                                .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultIncomeTest.setIncomeTestStatus(this.getLookupService()
                .getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode()));
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

    }

    /*
     * Tests: else if the result test is of type means test AND result test is <=
     * 365 365 days old AND result test status is MT copay required AND the FDT
     * is of type means test AND (FDT status is MT Copay Exempt OR FDT status is
     * GMT Copay Required OR (FDT GMTT > MTT AND FDT status is pending
     * adjudication))
     */
    private void ifStmt3Test() throws Exception {

        // assert success, future test status is MT copay exempt
        Person pristine = new Person();
        IncomeTest pristineIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        Person incomingPerson = new Person();
        IncomeTest incomingIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        Person resultPerson = new Person();
        IncomeTest resultIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED
                                        .getCode()), null);
        Calendar resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);

        FinancialInputParameter financialInputParameter = createFinancialInputParameter(
                incomingPerson, resultPerson, pristine);

        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());
        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());

        // assert success, future test status is GMT Copay Required

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this
                .createIncomeTest(FUTURE_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED
                                        .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());
        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());

        // assert success, GMTT > MTT AND FDT status is pending adjudication

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());
        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());

        // assert failure due to result test not of type means test

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR,
                this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST
                                        .getCode()), this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED
                                        .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure result due to test is not <= 365 days old

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, -390);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);

        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test status is not MT copay required

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_CATEGORY_B.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT not of type means test

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR,
                this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST
                                        .getCode()), this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT
                                        .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT status is not MT Copay Exempt OR
        // GMT Copay Required AND GMTT < MTT

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(100));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT status is not MT Copay Exempt OR
        // GMT Copay Required OR pending adjudication

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this
                .createIncomeTest(
                        FUTURE_INCOME_YEAR,
                        this.getLookupService().getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()),
                        this.getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()),
                        this
                                .getLookupService()
                                .getMeansTestStatusByCode(
                                        MeansTestStatus.MT_STATUS_NP_LONGER_APPLICABLE_RX_COPAY_ONLY
                                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

    }

    /*
     * Tests: if the result test is of type means test AND result test is <= 365
     * days old AND result test status is MT copay required AND the FDT is of
     * type means test AND FDT MTT > GMTT AND FDT status is FDT pending
     * adjudication AND FDT income <= MTT+110%
     */
    private void ifStmt2Test() throws Exception {

        // assert success
        Person pristine = new Person();
        IncomeTest pristineIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        Person incomingPerson = new Person();
        IncomeTest incomingIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        Person resultPerson = new Person();
        IncomeTest resultIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED
                                        .getCode()), null);
        Calendar resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        FinancialInputParameter financialInputParameter = createFinancialInputParameter(
                incomingPerson, resultPerson, pristine);
        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());
        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());

        // assert failure due to result test not of type means test

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED
                                        .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result test not <= 365

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, -390);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to result status is MT copay required

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this
                .createIncomeTest(CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED
                                        .getCode()), null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT is not of type means test

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION
                                        .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to FDT status is not pending adjudication

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this
                .createIncomeTest(FUTURE_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED
                                        .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure due to income > MTT+110%

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION
                                .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(10000));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultPerson = new Person();
        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());
    }

    private FinancialInputParameter createFinancialInputParameter(
            Person incomingPerson, Person resultPerson, Person pristine)
            throws Exception {
        FinancialInputParameter financialInputParameter = new FinancialInputParameter();
        financialInputParameter.setRuleMethod(new SimpleRuleMethod());
        MergeRuleServiceStub mockMergeRuleService = new MergeRuleServiceStub();
        financialInputParameter.setMergeRuleService(mockMergeRuleService);
        FinancialInputData financialInputData = new FinancialInputData(
                incomingPerson, resultPerson, pristine, CURRENT_INCOME_YEAR,
                this.getLookupService().getVaFacilityByCode(
                        VAFacility.CODE_ALBUQUERQUE.getCode()));
        financialInputParameter.setRuleDataAware(financialInputData);
        FinancialsHelperServiceStub mockFinancialsHelperService = new FinancialsHelperServiceStub();
        financialInputParameter
                .setFinancialsHelperService(mockFinancialsHelperService);
        GenericApplicationContext genericApplicationContext = new GenericApplicationContext();
        RootBeanDefinition transactionTimestampManagerBeanDefinition = new RootBeanDefinition(
                TransactionTimestampManagerStub.class);
        genericApplicationContext.registerBeanDefinition(
                TRANSACTION_TIMESTAMP_MANAGER_BEAN_NAME,
                transactionTimestampManagerBeanDefinition);
        financialInputParameter
                .setTimestampManagerName(TRANSACTION_TIMESTAMP_MANAGER_BEAN_NAME);
        genericApplicationContext.refresh();
        financialInputParameter
                .setApplicationContext(genericApplicationContext);
        return financialInputParameter;
    }

    /*
     * Tests: if the result test is of type means test AND result test is <= 365
     * days old AND result test status is MT copay required AND the FDT is of
     * type means test AND FDT status is MT copay required AND (FDT income < MTT
     * OR (FDT MTT < GMTT AND FDT income <= GMTT*110%) OR (FDT income <=
     * MTT*110%) ) (
     */
    private void ifStmt1Test() throws Exception {

        // assert success when FDT found with income < MTT
        // verify beneficiary travel, visit summary, and financial statements
        // are copied from incoming person to result person
        // and pristine person to incoming person.
        // verify various dates of the FDT test are being set when made
        // effective immedia
        Person pristine = new Person();
        IncomeTest pristineIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(20));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        BeneficiaryTravel pristineBeneficiaryTravel = this
                .createBeneficiaryTravel(FUTURE_INCOME_YEAR, this
                        .getLookupService().getVaFacilityByCode(
                                VAFacility.CODE_HEC.getCode()));
        pristineBeneficiaryTravel.setEligible(new Boolean(true));
        pristine.setBeneficiaryTravel(FUTURE_INCOME_YEAR, this
                .getLookupService().getVaFacilityByCode(
                        VAFacility.CODE_HEC.getCode()),
                pristineBeneficiaryTravel);
        PatientVisitSummary pristineVisitSummary = new PatientVisitSummary();
        pristine.setPatientVisitSummary(FUTURE_INCOME_YEAR, this
                .getLookupService().getVaFacilityByCode(
                        VAFacility.CODE_HEC.getCode()), pristineVisitSummary);
        FinancialStatement pristineStmt = new FinancialStatement();
        pristine.setFinancialStatement(FUTURE_INCOME_YEAR, pristineStmt);

        Person incomingPerson = new Person();
        IncomeTest incomingIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, null, this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), null,
                null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);
        BeneficiaryTravel incomingBeneficiaryTravel = new BeneficiaryTravel();
        incomingBeneficiaryTravel.setEligible(new Boolean(true));
        incomingBeneficiaryTravel.setClaimDate(NOW);
        incomingPerson.setBeneficiaryTravel(CURRENT_INCOME_YEAR, this
                .getLookupService().getVaFacilityByCode(
                        VAFacility.CODE_ALBUQUERQUE.getCode()),
                incomingBeneficiaryTravel);
        PatientVisitSummary incomingVisitSummary = new PatientVisitSummary();
        incomingPerson.setPatientVisitSummary(CURRENT_INCOME_YEAR, this
                .getLookupService().getVaFacilityByCode(
                        VAFacility.CODE_ALBUQUERQUE.getCode()),
                incomingVisitSummary);
        FinancialStatement incomingStmt = new FinancialStatement();
        incomingPerson.setFinancialStatement(CURRENT_INCOME_YEAR, incomingStmt);

        Person resultPerson = new Person();
        IncomeTest resultIncomeTest = this.createIncomeTest(
                CURRENT_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED
                                        .getCode()), null);
        Calendar resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);

        FinancialInputParameter financialInputParameter = createFinancialInputParameter(
                incomingPerson, resultPerson, pristine);

        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertNotNull(resultPerson.getBeneficiaryTravel(CURRENT_INCOME_YEAR,
                this.getLookupService().getVaFacilityByCode(
                        VAFacility.CODE_ALBUQUERQUE.getCode())));
        assertNotNull(incomingPerson.getBeneficiaryTravel(FUTURE_INCOME_YEAR,
                this.getLookupService().getVaFacilityByCode(
                        VAFacility.CODE_HEC.getCode())));
        assertNotNull(resultPerson.getPatientVisitSummary(CURRENT_INCOME_YEAR,
                this.getLookupService().getVaFacilityByCode(
                        VAFacility.CODE_ALBUQUERQUE.getCode())));
        assertNotNull(incomingPerson.getPatientVisitSummary(FUTURE_INCOME_YEAR,
                this.getLookupService().getVaFacilityByCode(
                        VAFacility.CODE_HEC.getCode())));
        assertNotNull(resultPerson.getFinancialStatement(CURRENT_INCOME_YEAR));
        assertNotNull(incomingPerson.getFinancialStatement(FUTURE_INCOME_YEAR));
        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());
        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getCompletedDate());
        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getLastEditedDate());
        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getEffectiveDate());
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());

        // assert success when FDT found with MTT < GMTT AND income <= GMTT*110%
        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());
        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());

        // assert success when FDT found with income <= MTT*110%

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(30));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(25));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        incomingPerson = new Person();
        incomingIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        incomingPerson.setIncomeTest(CURRENT_INCOME_YEAR, incomingIncomeTest);

        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertTrue(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        assertEquals(FUTURE_INCOME_YEAR, financialInputParameter
                .getFinancialInputData().getIncomingIncomeYear());
        assertNotNull(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR));
        assertFalse(incomingPerson.getIncomeTest(FUTURE_INCOME_YEAR)
                .getFutureTest().booleanValue());

        // assert failure when result test not of type means test

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR,
                this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST
                                        .getCode()), this.getLookupService()
                        .getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED
                                        .getCode()), null);
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure when result test not <= 365 days

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, -370);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);
        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure when FDT not of type MT

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode()),
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED
                                        .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // assert failure when FDT not of status MT Copay required

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristineIncomeTest.setNetIncome(new BigDecimal(31));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this
                .createIncomeTest(FUTURE_INCOME_YEAR, this.getLookupService()
                        .getIncomeTestTypeByCode(
                                IncomeTestType.CODE_MEANS_TEST.getCode()), this
                        .getLookupService().getIncomeTestSourceByCode(
                                IncomeTestSource.CODE_IVM.getCode()), this
                        .getLookupService().getMeansTestStatusByCode(
                                MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED
                                        .getCode()), null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());

        // fail income > %110 MT

        pristine = new Person();
        pristineIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, null,
                this.getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), null, null);
        pristineIncomeTest.setFutureTest(new Boolean(false));
        pristineIncomeTest.setNetIncome(new BigDecimal(100000));
        pristineIncomeTest.setThresholdA(new BigDecimal(25));
        pristineIncomeTest.setGmtThresholdAmount(new BigDecimal(30));
        pristine.setIncomeTest(CURRENT_INCOME_YEAR, pristineIncomeTest);
        pristineIncomeTest = this.createIncomeTest(FUTURE_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        pristineIncomeTest.setFutureTest(new Boolean(true));
        pristine.setIncomeTest(FUTURE_INCOME_YEAR, pristineIncomeTest);

        resultIncomeTest = this.createIncomeTest(CURRENT_INCOME_YEAR, this
                .getLookupService().getIncomeTestTypeByCode(
                        IncomeTestType.CODE_MEANS_TEST.getCode()), this
                .getLookupService().getIncomeTestSourceByCode(
                        IncomeTestSource.CODE_IVM.getCode()), this
                .getLookupService().getMeansTestStatusByCode(
                        MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode()),
                null);
        resultTestEffectiveDate = new GregorianCalendar();
        resultTestEffectiveDate.add(Calendar.DATE, 320);
        resultIncomeTest.setEffectiveDate(resultTestEffectiveDate.getTime());
        resultPerson.setIncomeTest(CURRENT_INCOME_YEAR, resultIncomeTest);
        financialInputParameter = createFinancialInputParameter(incomingPerson,
                resultPerson, pristine);

        assertFalse(financialInputParameter
                .ifConditionsMetMakeFutureTestEffectiveImmediately());
    }

    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        // TODO Auto-generated method stub

    }

    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        return null;
    }

}
