package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.fw.model.AbstractKeyedEntity;

public class DemographicInputParameterTest extends
        AbstractKeyedEntityDAOTestCase {

    /**
     * 
     * 
     * @throws Exception
     */
    public void testIsPreferredFacilityChanged() throws Exception {
        DemographicInputParameter demographicInputParameter = new DemographicInputParameter();

        // no enrollment determinations
        Person pristinPerson = this.buildSimplePerson();
        Person resultPerson = this.buildSimplePerson();
        Person incomingPerson = resultPerson;
        
        PersonInputData personInputData = new PersonInputData(
        		incomingPerson, resultPerson, pristinPerson);
        demographicInputParameter.setRuleDataAware(personInputData);
        demographicInputParameter.setLookupService(this.getLookupService());

        pristinPerson.setMostRecentPreferredFacility(this.getLookupService()
				.getVaFacilityByCode("568A4"));
        resultPerson.setMostRecentPreferredFacility(this.getLookupService()
				.getVaFacilityByCode("528GN"));
        assertTrue(demographicInputParameter.isPreferredFacilityChanged());
    
        pristinPerson.setMostRecentPreferredFacility(this.getLookupService()
				.getVaFacilityByCode("740GA"));
        resultPerson.setMostRecentPreferredFacility(this.getLookupService()
				.getVaFacilityByCode("740GB"));
        assertFalse(demographicInputParameter.isPreferredFacilityChanged());

        pristinPerson.setMostRecentPreferredFacility(null);
        assertTrue(demographicInputParameter.isPreferredFacilityChanged());
        
        resultPerson.setMostRecentPreferredFacility(null);
        assertFalse(demographicInputParameter.isPreferredFacilityChanged());    
        
    }

   

    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        // TODO Auto-generated method stub

    }

    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        // TODO Auto-generated method stub
        return null;
    }
}
